/*
 * Decompiled with CFR 0.152.
 */
package parser.methods;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import parser.TYPE;
import parser.methods.BasicNumericalMethod;
import parser.methods.ext.AvgN;
import parser.methods.ext.GeomN;

public class Declarations {
    public static final String SIN = "sin";
    public static final String COS = "cos";
    public static final String TAN = "tan";
    public static final String SINH = "sinh";
    public static final String COSH = "cosh";
    public static final String TANH = "tanh";
    public static final String ARC_SIN = "sin-\u00b9";
    public static final String ARC_COS = "cos-\u00b9";
    public static final String ARC_TAN = "tan-\u00b9";
    public static final String ARC_SINH = "sinh-\u00b9";
    public static final String ARC_COSH = "cosh-\u00b9";
    public static final String ARC_TANH = "tanh-\u00b9";
    public static final String SEC = "sec";
    public static final String COSEC = "csc";
    public static final String COT = "cot";
    public static final String SECH = "sech";
    public static final String COSECH = "csch";
    public static final String COTH = "coth";
    public static final String ARC_SEC = "sec-\u00b9";
    public static final String ARC_COSEC = "csc-\u00b9";
    public static final String ARC_COT = "cot-\u00b9";
    public static final String ARC_SECH = "sech-\u00b9";
    public static final String ARC_COSECH = "csch-\u00b9";
    public static final String ARC_COTH = "coth-\u00b9";
    public static final String EXP = "exp";
    public static final String LN = "ln";
    public static final String LG = "lg";
    public static final String LOG = "log";
    public static final String LN_INV = "ln-\u00b9";
    public static final String LG_INV = "lg-\u00b9";
    public static final String LOG_INV = "log-\u00b9";
    public static final String ARC_SIN_ALT = "asin";
    public static final String ARC_COS_ALT = "acos";
    public static final String ARC_TAN_ALT = "atan";
    public static final String ARC_SINH_ALT = "asinh";
    public static final String ARC_COSH_ALT = "acosh";
    public static final String ARC_TANH_ALT = "atanh";
    public static final String ARC_SEC_ALT = "asec";
    public static final String ARC_COSEC_ALT = "acsc";
    public static final String ARC_COT_ALT = "acot";
    public static final String ARC_SECH_ALT = "asech";
    public static final String ARC_COSECH_ALT = "acsch";
    public static final String ARC_COTH_ALT = "acoth";
    public static final String LN_INV_ALT = "aln";
    public static final String LG_INV_ALT = "alg";
    public static final String LOG_INV_ALT = "alog";
    public static final String FLOOR = "floor";
    public static final String CEIL = "ceil";
    public static final String SQRT = "sqrt";
    public static final String CBRT = "cbrt";
    public static final String INVERSE = "inverse";
    public static final String SQUARE = "square";
    public static final String CUBE = "cube";
    public static final String POW = "pow";
    public static final String FACT = "fact";
    public static final String COMBINATION = "comb";
    public static final String PERMUTATION = "perm";
    public static final String SUM = "sum";
    public static final String PROD = "prod";
    public static final String GEOM = "geom";
    public static final String GSUM = "gsum";
    public static final String COUNT = "count";
    public static final String AVG = "avg";
    public static final String MEDIAN = "med";
    public static final String MODE = "mode";
    public static final String RANGE = "rng";
    public static final String MID_RANGE = "mrng";
    public static final String ROOT_MEAN_SQUARED = "rms";
    public static final String COEFFICIENT_OF_VARIATION = "cov";
    public static final String MIN = "min";
    public static final String MAX = "max";
    public static final String STD_DEV = "s_d";
    public static final String VARIANCE = "variance";
    public static final String STD_ERR = "st_err";
    public static final String RANDOM = "rnd";
    public static final String SORT = "sort";
    public static final String PLOT = "plot";
    public static final String PRINT = "print";
    public static final String DIFFERENTIATION = "diff";
    public static final String INTEGRATION = "intg";
    public static final String QUADRATIC = "quad";
    public static final String TARTAGLIA_ROOTS = "t_root";
    public static final String GENERAL_ROOT = "root";
    public static final String LINEAR_SYSTEM = "linear_sys";
    public static final String DETERMINANT = "det";
    public static final String INVERSE_MATRIX = "invert";
    public static final String TRIANGULAR_MATRIX = "tri_mat";
    public static final String ECHELON_MATRIX = "echelon";
    public static final String MATRIX_MULTIPLY = "matrix_mul";
    public static final String MATRIX_DIVIDE = "matrix_div";
    public static final String MATRIX_ADD = "matrix_add";
    public static final String MATRIX_SUBTRACT = "matrix_sub";
    public static final String MATRIX_POWER = "matrix_pow";
    public static final String MATRIX_TRANSPOSE = "transpose";
    public static final String MATRIX_EDIT = "matrix_edit";
    public static final String MATRIX_COFACTORS = "cofactor";
    public static final String MATRIX_ADJOINT = "adjoint";
    public static final String MATRIX_EIGENVEC = "eigvec";
    public static final String MATRIX_EIGENPOLY = "eigpoly";
    public static final String HELP = "help";
    private static final List<BasicNumericalMethod> BASIC_NUMERICAL_METHODS = new ArrayList<BasicNumericalMethod>();

    static List<BasicNumericalMethod> getBasicNumericalMethods() {
        return Collections.unmodifiableList(BASIC_NUMERICAL_METHODS);
    }

    public static void registerBasicNumericalMethod(BasicNumericalMethod basicNumericalMethod) {
        Declarations.unregisterBasicNumericalMethod(basicNumericalMethod.getClass());
        BASIC_NUMERICAL_METHODS.add(basicNumericalMethod);
    }

    public static void unregisterBasicNumericalMethod(Class clazz) {
        for (int i = BASIC_NUMERICAL_METHODS.size() - 1; i >= 0; --i) {
            if (!BASIC_NUMERICAL_METHODS.get(i).getClass().equals(clazz)) continue;
            BASIC_NUMERICAL_METHODS.remove(i);
        }
    }

    public static String[] getInbuiltMethods() {
        return Declarations.createInBuiltMethods();
    }

    public static String[] createInBuiltMethods() {
        List<String> stats = Arrays.asList(Declarations.getStatsMethods());
        List<String> rest = Arrays.asList(HELP, SIN, COS, TAN, SINH, COSH, TANH, ARC_SIN, ARC_COS, ARC_TAN, ARC_SINH, ARC_COSH, ARC_TANH, SEC, COSEC, COT, SECH, COSECH, COTH, ARC_SEC, ARC_COSEC, ARC_COT, ARC_SECH, ARC_COSECH, ARC_COTH, EXP, LN, LG, LOG, LN_INV, LG_INV, LOG_INV, ARC_SIN_ALT, ARC_COS_ALT, ARC_TAN_ALT, ARC_SINH_ALT, ARC_COSH_ALT, ARC_TANH_ALT, ARC_SEC_ALT, ARC_COSEC_ALT, ARC_COT_ALT, ARC_SECH_ALT, ARC_COSECH_ALT, ARC_COTH_ALT, LN_INV_ALT, LG_INV_ALT, LOG_INV_ALT, FLOOR, CEIL, SQRT, CBRT, INVERSE, SQUARE, CUBE, POW, FACT, PRINT, COMBINATION, PERMUTATION, PLOT, DIFFERENTIATION, INTEGRATION, QUADRATIC, TARTAGLIA_ROOTS, GENERAL_ROOT, LINEAR_SYSTEM, DETERMINANT, INVERSE_MATRIX, TRIANGULAR_MATRIX, ECHELON_MATRIX, MATRIX_MULTIPLY, MATRIX_DIVIDE, MATRIX_ADD, MATRIX_SUBTRACT, MATRIX_POWER, MATRIX_TRANSPOSE, MATRIX_EDIT, MATRIX_COFACTORS, MATRIX_ADJOINT, MATRIX_EIGENVEC, MATRIX_EIGENPOLY);
        ArrayList<String> r = new ArrayList<String>(stats.size() + rest.size());
        r.addAll(stats);
        r.addAll(rest);
        r.addAll(Declarations.methodsToNames(BASIC_NUMERICAL_METHODS));
        Collections.sort(r);
        return r.toArray(new String[r.size()]);
    }

    private static Collection<String> methodsToNames(List<BasicNumericalMethod> basicNumericalMethods) {
        ArrayList<String> result = new ArrayList<String>(basicNumericalMethods.size());
        for (BasicNumericalMethod method : basicNumericalMethods) {
            result.add(method.getName());
        }
        return result;
    }

    public static String returnTypeDef(String typeName) {
        for (BasicNumericalMethod basicNumericalMethod : BASIC_NUMERICAL_METHODS) {
            if (!typeName.equals(basicNumericalMethod.getName())) continue;
            return basicNumericalMethod.getType();
        }
        switch (typeName) {
            case "sin": {
                return TYPE.NUMBER.toString();
            }
            case "cos": {
                return TYPE.NUMBER.toString();
            }
            case "tan": {
                return TYPE.NUMBER.toString();
            }
            case "sinh": {
                return TYPE.NUMBER.toString();
            }
            case "cosh": {
                return TYPE.NUMBER.toString();
            }
            case "tanh": {
                return TYPE.NUMBER.toString();
            }
            case "sin-\u00b9": {
                return TYPE.NUMBER.toString();
            }
            case "cos-\u00b9": {
                return TYPE.NUMBER.toString();
            }
            case "tan-\u00b9": {
                return TYPE.NUMBER.toString();
            }
            case "sinh-\u00b9": {
                return TYPE.NUMBER.toString();
            }
            case "cosh-\u00b9": {
                return TYPE.NUMBER.toString();
            }
            case "tanh-\u00b9": {
                return TYPE.NUMBER.toString();
            }
            case "sec": {
                return TYPE.NUMBER.toString();
            }
            case "csc": {
                return TYPE.NUMBER.toString();
            }
            case "cot": {
                return TYPE.NUMBER.toString();
            }
            case "sech": {
                return TYPE.NUMBER.toString();
            }
            case "csch": {
                return TYPE.NUMBER.toString();
            }
            case "coth": {
                return TYPE.NUMBER.toString();
            }
            case "sec-\u00b9": {
                return TYPE.NUMBER.toString();
            }
            case "csc-\u00b9": {
                return TYPE.NUMBER.toString();
            }
            case "cot-\u00b9": {
                return TYPE.NUMBER.toString();
            }
            case "sech-\u00b9": {
                return TYPE.NUMBER.toString();
            }
            case "csch-\u00b9": {
                return TYPE.NUMBER.toString();
            }
            case "coth-\u00b9": {
                return TYPE.NUMBER.toString();
            }
            case "exp": {
                return TYPE.NUMBER.toString();
            }
            case "ln": {
                return TYPE.NUMBER.toString();
            }
            case "lg": {
                return TYPE.NUMBER.toString();
            }
            case "log": {
                return TYPE.NUMBER.toString();
            }
            case "ln-\u00b9": {
                return TYPE.NUMBER.toString();
            }
            case "lg-\u00b9": {
                return TYPE.NUMBER.toString();
            }
            case "log-\u00b9": {
                return TYPE.NUMBER.toString();
            }
            case "asin": {
                return TYPE.NUMBER.toString();
            }
            case "acos": {
                return TYPE.NUMBER.toString();
            }
            case "atan": {
                return TYPE.NUMBER.toString();
            }
            case "asinh": {
                return TYPE.NUMBER.toString();
            }
            case "acosh": {
                return TYPE.NUMBER.toString();
            }
            case "atanh": {
                return TYPE.NUMBER.toString();
            }
            case "asec": {
                return TYPE.NUMBER.toString();
            }
            case "acsc": {
                return TYPE.NUMBER.toString();
            }
            case "acot": {
                return TYPE.NUMBER.toString();
            }
            case "asech": {
                return TYPE.NUMBER.toString();
            }
            case "acsch": {
                return TYPE.NUMBER.toString();
            }
            case "acoth": {
                return TYPE.NUMBER.toString();
            }
            case "aln": {
                return TYPE.NUMBER.toString();
            }
            case "alg": {
                return TYPE.NUMBER.toString();
            }
            case "alog": {
                return TYPE.NUMBER.toString();
            }
            case "floor": {
                return TYPE.NUMBER.toString();
            }
            case "ceil": {
                return TYPE.NUMBER.toString();
            }
            case "sqrt": {
                return TYPE.NUMBER.toString();
            }
            case "cbrt": {
                return TYPE.NUMBER.toString();
            }
            case "inverse": {
                return TYPE.NUMBER.toString();
            }
            case "square": {
                return TYPE.NUMBER.toString();
            }
            case "cube": {
                return TYPE.NUMBER.toString();
            }
            case "pow": {
                return TYPE.NUMBER.toString();
            }
            case "fact": {
                return TYPE.NUMBER.toString();
            }
            case "print": {
                return TYPE.VOID.toString();
            }
            case "comb": {
                return TYPE.NUMBER.toString();
            }
            case "perm": {
                return TYPE.NUMBER.toString();
            }
            case "sum": {
                return TYPE.NUMBER.toString();
            }
            case "prod": {
                return TYPE.NUMBER.toString();
            }
            case "geom": {
                return TYPE.NUMBER.toString();
            }
            case "gsum": {
                return TYPE.NUMBER.toString();
            }
            case "count": {
                return TYPE.NUMBER.toString();
            }
            case "avg": {
                return TYPE.NUMBER.toString();
            }
            case "med": {
                return TYPE.NUMBER.toString();
            }
            case "mode": {
                return TYPE.LIST.toString();
            }
            case "rng": {
                return TYPE.NUMBER.toString();
            }
            case "mrng": {
                return TYPE.NUMBER.toString();
            }
            case "rms": {
                return TYPE.NUMBER.toString();
            }
            case "cov": {
                return TYPE.NUMBER.toString();
            }
            case "min": {
                return TYPE.NUMBER.toString();
            }
            case "max": {
                return TYPE.NUMBER.toString();
            }
            case "s_d": {
                return TYPE.NUMBER.toString();
            }
            case "variance": {
                return TYPE.NUMBER.toString();
            }
            case "st_err": {
                return TYPE.NUMBER.toString();
            }
            case "rnd": {
                return TYPE.LIST.toString();
            }
            case "sort": {
                return TYPE.NUMBER.toString();
            }
            case "plot": {
                return TYPE.VOID.toString();
            }
            case "diff": {
                return TYPE.NUMBER.toString();
            }
            case "intg": {
                return TYPE.NUMBER.toString();
            }
            case "quad": {
                return TYPE.LIST.toString();
            }
            case "t_root": {
                return TYPE.LIST.toString();
            }
            case "root": {
                return TYPE.NUMBER.toString();
            }
            case "linear_sys": {
                return TYPE.LIST.toString();
            }
            case "det": {
                return TYPE.NUMBER.toString();
            }
            case "invert": {
                return TYPE.MATRIX.toString();
            }
            case "tri_mat": {
                return TYPE.MATRIX.toString();
            }
            case "echelon": {
                return TYPE.MATRIX.toString();
            }
            case "matrix_mul": {
                return TYPE.MATRIX.toString();
            }
            case "matrix_div": {
                return TYPE.MATRIX.toString();
            }
            case "matrix_add": {
                return TYPE.MATRIX.toString();
            }
            case "matrix_sub": {
                return TYPE.MATRIX.toString();
            }
            case "matrix_pow": {
                return TYPE.MATRIX.toString();
            }
            case "transpose": {
                return TYPE.MATRIX.toString();
            }
            case "matrix_edit": {
                return TYPE.VOID.toString();
            }
            case "adjoint": {
                return TYPE.MATRIX.toString();
            }
            case "cofactor": {
                return TYPE.MATRIX.toString();
            }
            case "eigpoly": {
                return TYPE.ALGEBRAIC_EXPRESSION.toString();
            }
            case "eigvec": {
                return TYPE.MATRIX.toString();
            }
        }
        return TYPE.NUMBER.toString();
    }

    static String[] getStatsMethods() {
        return new String[]{SUM, PROD, AVG, MEDIAN, MODE, RANGE, MID_RANGE, ROOT_MEAN_SQUARED, COEFFICIENT_OF_VARIATION, MIN, MAX, STD_DEV, VARIANCE, STD_ERR, RANDOM, SORT, GEOM, GSUM, COUNT};
    }

    public static boolean isBasicNumericalFunction(String op) {
        for (BasicNumericalMethod basicNumericalMethod : Declarations.getBasicNumericalMethods()) {
            if (!op.equals(basicNumericalMethod.getName())) continue;
            return true;
        }
        return false;
    }

    static {
        Declarations.registerBasicNumericalMethod(new AvgN());
        Declarations.registerBasicNumericalMethod(new GeomN());
    }
}

