/*
 * Decompiled with CFR 0.152.
 */
package parser;

import java.util.ArrayList;
import parser.Number;
import parser.Operator;
import parser.Precedence;
import parser.Validatable;
import parser.Variable;
import parser.methods.Method;
import util.Utils;

public class LogicOperator
extends Operator
implements Validatable {
    private final Precedence precedence;
    private int index;

    public LogicOperator(String name, int index, ArrayList<String> scan) {
        super(LogicOperator.isLogicOperator(name) ? name : "");
        if (this.getName().equals("")) {
            throw new IndexOutOfBoundsException("Invalid Name For Binary Operator.");
        }
        this.index = index >= 0 && scan.get(index).equals(name) ? index : -1;
        this.precedence = LogicOperator.getPrecedence(name);
        if (this.index == -1) {
            throw new IndexOutOfBoundsException("Invalid Index");
        }
    }

    public Precedence getPrecedence() {
        return this.precedence;
    }

    public void setIndex(int index, ArrayList<String> scan) {
        int n = this.index = index >= 0 && scan.get(index).equals(this.getName()) ? index : -1;
        if (this.index == -1) {
            throw new IndexOutOfBoundsException("Invalid Index");
        }
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public boolean validate(ArrayList<String> scan) {
        boolean correct = true;
        try {
            if (!(Number.isNumber(scan.get(this.index - 1)) || Variable.isVariableString(scan.get(this.index - 1)) || LogicOperator.isUnaryPostOperator(scan.get(this.index - 1)) || LogicOperator.isClosingBracket(scan.get(this.index - 1)))) {
                Utils.logError("ParserNG Does Not Allow " + this.getName() + " To Combine The Function Members \"" + scan.get(this.index - 1) + "\" And \"" + scan.get(this.index) + "\" As You Have Done.ParserNG Error Detector For Logic operators!");
                correct = false;
                scan.clear();
            }
            if (!(Number.isNumber(scan.get(this.index + 1)) || Variable.isVariableString(scan.get(this.index + 1)) || LogicOperator.isOpeningBracket(scan.get(this.index + 1)) || Method.isUnaryPreOperatorORDefinedMethod(scan.get(this.index + 1)) || Method.isNumberReturningStatsMethod(scan.get(this.index + 1)) || Method.isLogToAnyBase(scan.get(this.index + 1)) || Method.isAntiLogToAnyBase(scan.get(this.index + 1)))) {
                Utils.logError("ParserNG Does Not Allow " + this.getName() + " To Combine The Function Members \"" + scan.get(this.index) + "\" And \"" + scan.get(this.index + 1) + "\" As You Have Done.ParserNG Error Detector For Logic operators!");
                correct = false;
                scan.clear();
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return correct;
    }
}

