/*
 * Decompiled with CFR 0.152.
 */
package parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.InputMismatchException;
import java.util.List;
import parser.Bracket;

public class GenericBracket {
    private int bracketType = 3;
    public static final int CURLY_BRACE = 1;
    public static final int SQUARE_BRACE = 2;
    public static final int CIRCULAR_BRACE = 3;
    public static final int ANGULAR_BRACE = 4;
    private boolean open;
    private int index;
    private GenericBracket complement;
    private boolean evaluated = false;

    public GenericBracket(int bracketType, boolean open) {
        this.bracketType = bracketType;
        this.open = open;
    }

    public GenericBracket(String name) {
        switch (name) {
            case "{": {
                this.bracketType = 1;
                this.open = true;
                break;
            }
            case "[": {
                this.bracketType = 2;
                this.open = true;
                break;
            }
            case "(": {
                this.bracketType = 3;
                this.open = true;
                break;
            }
            case "<": {
                this.bracketType = 4;
                this.open = true;
                break;
            }
            case "}": {
                this.bracketType = 1;
                this.open = false;
                break;
            }
            case "]": {
                this.bracketType = 2;
                this.open = false;
                break;
            }
            case ")": {
                this.bracketType = 3;
                this.open = false;
                break;
            }
            case ">": {
                this.bracketType = 4;
                this.open = false;
                break;
            }
            default: {
                throw new InputMismatchException("Bad bracket");
            }
        }
    }

    public void setEvaluated(boolean evaluated) {
        this.evaluated = evaluated;
    }

    public boolean isEvaluated() {
        return this.evaluated;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public String getBracketString() {
        switch (this.bracketType) {
            case 1: {
                return this.open ? "{" : "}";
            }
            case 2: {
                return this.open ? "[" : "]";
            }
            case 3: {
                return this.open ? "(" : ")";
            }
            case 4: {
                return this.open ? "<" : ">";
            }
        }
        return null;
    }

    public String getComplementBracketString() {
        switch (this.bracketType) {
            case 1: {
                return this.open ? "}" : "{";
            }
            case 2: {
                return this.open ? "]" : "[";
            }
            case 3: {
                return this.open ? ")" : "(";
            }
            case 4: {
                return this.open ? ">" : "<";
            }
        }
        return null;
    }

    public GenericBracket getComplement() {
        return this.complement;
    }

    public void setComplement(GenericBracket complement) {
        this.complement = complement;
    }

    public boolean isComplement(GenericBracket brac) {
        return brac == this.getComplement();
    }

    public void setBracketType(int bracketType) {
        this.bracketType = bracketType;
    }

    public int getBracketType() {
        return this.bracketType;
    }

    public boolean isOpen() {
        return this.open;
    }

    public void setOpen(boolean open) {
        this.open = open;
    }

    public boolean encloses(Bracket brac) {
        boolean truth = false;
        if (this.getIndex() < brac.getIndex() && this.getComplement().getIndex() > brac.getIndex()) {
            truth = true;
        } else if (this.getIndex() > brac.getIndex() && this.getComplement().getIndex() < brac.getIndex()) {
            truth = true;
        }
        return truth;
    }

    public int getNumberOfInternalBrackets(ArrayList<Bracket> brac) {
        int num = 0;
        for (int i = 0; i < brac.size(); ++i) {
            if (!this.encloses(brac.get(i))) continue;
            ++num;
        }
        return num / 2;
    }

    public boolean isSBP(ArrayList<String> scan) {
        int i = this.index;
        int j = this.complement.index;
        if (i < j) {
            ++i;
            while (i < j) {
                if (GenericBracket.isBracket(scan.get(i))) {
                    return false;
                }
                ++i;
            }
        } else if (i > j) {
            ++j;
            while (j < i) {
                if (GenericBracket.isBracket(scan.get(j))) {
                    return false;
                }
                ++j;
            }
        } else if (i == j) {
            throw new InputMismatchException("Open MBracket Cannot Be On The Same Index As Closing MBracket");
        }
        return true;
    }

    public static int getComplementIndex(GenericBracket brac, int start, ArrayList<String> scan) {
        int open = 0;
        int close = 0;
        int stop = 0;
        if (brac.isOpen()) {
            try {
                for (int i = start; i < scan.size(); ++i) {
                    if (scan.get(i).equals(brac.getBracketString())) {
                        ++open;
                    } else if (scan.get(i).equals(brac.getComplementBracketString())) {
                        ++close;
                    }
                    if (open != close) continue;
                    stop = i;
                }
            }
            catch (IndexOutOfBoundsException i) {}
        } else {
            try {
                for (int i = start; i >= 0; --i) {
                    try {
                        if (scan.get(i).equals(brac.getBracketString())) {
                            ++open;
                        } else if (scan.get(i).equals(brac.getComplementBracketString())) {
                            ++close;
                        }
                        if (open != close) continue;
                        stop = i;
                        break;
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        return stop;
    }

    public static int getComplementIndex(GenericBracket brac, int start, List<String> scan) {
        int open = 0;
        int close = 0;
        int stop = 0;
        if (brac.isOpen()) {
            try {
                for (int i = start; i < scan.size(); ++i) {
                    if (scan.get(i).equals(brac.getBracketString())) {
                        ++open;
                    } else if (scan.get(i).equals(brac.getComplementBracketString())) {
                        ++close;
                    }
                    if (open != close) continue;
                    stop = i;
                }
            }
            catch (IndexOutOfBoundsException i) {}
        } else {
            try {
                for (int i = start; i >= 0; --i) {
                    try {
                        if (scan.get(i).equals(brac.getBracketString())) {
                            ++open;
                        } else if (scan.get(i).equals(brac.getComplementBracketString())) {
                            ++close;
                        }
                        if (open != close) continue;
                        stop = i;
                        break;
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        return stop;
    }

    public static int getComplementIndex(GenericBracket bracket, boolean isOpenBracket, int start, String expr) {
        int open = 0;
        int close = 0;
        int stop = 0;
        int size = expr.length();
        if (bracket.isOpen()) {
            try {
                for (int i = start; i < size; ++i) {
                    if (expr.substring(i, i + 1).equals(bracket.getBracketString())) {
                        ++open;
                    } else if (expr.substring(i, i + 1).equals(bracket.getComplementBracketString())) {
                        ++close;
                    }
                    if (open != close) continue;
                    stop = i;
                }
            }
            catch (IndexOutOfBoundsException i) {}
        } else if (!isOpenBracket) {
            try {
                for (int i = start; i >= 0; --i) {
                    try {
                        if (expr.substring(i, i + 1).equals(bracket.getBracketString())) {
                            ++open;
                        } else if (expr.substring(i, i + 1).equals(bracket.getComplementBracketString())) {
                            ++close;
                        }
                        if (open != close) continue;
                        stop = i;
                        break;
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        return stop;
    }

    public static boolean checkBracketStructure(List<String> list, int start, int end) {
        return GenericBracket.validateBracketStructure(list.subList(start, end + 1));
    }

    public static boolean hasBracketsInRange(List<String> list, int start, int end) {
        int sz = list.size();
        if (start >= 0 && end < sz) {
            for (int i = start; i <= end; ++i) {
                if (!GenericBracket.isBracket(list.get(i))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isOpenBracket(String bracket) {
        return bracket.equals("{") || bracket.equals("[") || bracket.equals("(") || bracket.equals("<");
    }

    public static boolean isCloseBracket(String bracket) {
        return bracket.equals("}") || bracket.equals("]") || bracket.equals(")") || bracket.equals(">");
    }

    public String getDomainContents(ArrayList<String> scan) {
        String contents = "";
        if (this.open) {
            int j = this.complement.index;
            for (int i = this.index; i <= j; ++i) {
                contents = contents + scan.get(i);
            }
        } else {
            int i = this.index;
            for (int j = this.complement.index; j <= i; ++j) {
                contents = contents.concat(scan.get(j));
            }
        }
        return contents;
    }

    public ArrayList<String> getBracketDomainContents(ArrayList<String> scan) {
        if (this.open) {
            return (ArrayList)scan.subList(this.getIndex(), this.getComplement().getIndex() + 1);
        }
        return (ArrayList)scan.subList(this.getComplement().getIndex(), this.getIndex() + 1);
    }

    private static boolean validateBracketStructure(List<String> scanner) {
        ArrayList<String> scan = new ArrayList<String>();
        scan.addAll(scanner);
        int open = 0;
        int close = -1;
        int i = 0;
        while ((close = scan.indexOf("}")) != -1 || (close = scan.indexOf("]")) != -1 || (close = scan.indexOf(")")) != -1 || (close = scan.indexOf(">")) != -1) {
            try {
                String val = (String)scan.get(close);
                GenericBracket b = new GenericBracket(val);
                GenericBracket bComp = new GenericBracket(b.getComplementBracketString());
                GenericBracket openBrac = b.isOpen() ? b : bComp;
                GenericBracket closeBrac = !b.isOpen() ? b : bComp;
                open = GenericBracket.prevIndexOf(scan, close, openBrac.getBracketString());
                openBrac.setIndex(open);
                closeBrac.setIndex(close);
                openBrac.setComplement(closeBrac);
                closeBrac.setComplement(openBrac);
                scan.set(open, "");
                scan.set(close, "");
                ++i;
            }
            catch (IndexOutOfBoundsException ind) {
                // empty catch block
                break;
            }
        }
        return scan.indexOf("{") == -1 && scan.indexOf("}") == -1 && scan.indexOf("[") == -1 && scan.indexOf("]") == -1 && scan.indexOf("(") == -1 && scan.indexOf(")") == -1 && scan.indexOf("<") == -1 && scan.indexOf(">") == -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int prevIndexOf(List list, int start, Object sought) {
        int index = -1;
        if (sought.getClass() != list.get(0).getClass()) throw new ClassCastException("The object types must be the same for the list and the object been searched for in the list");
        if (start < 0) throw new IndexOutOfBoundsException("Attempt to access index less than 0");
        int i = start - 1;
        while (i >= 0) {
            if (list.get(i).equals(sought)) {
                return i;
            }
            --i;
        }
        return index;
    }

    private static boolean isBracket(String get) {
        return get.equals("{") || get.equals("}") || get.equals("[") || get.equals("]") || get.equals("(") || get.equals(")") || get.equals("<") || get.equals(">");
    }

    public static void main(String[] args) {
        String str = "(3+(2-90/4)*{5*{8+2(9)-29<2+4>}})";
        System.err.println("valid: " + GenericBracket.validateBracketStructure(Arrays.asList(str.split(""))));
    }
}

