/*
 * Decompiled with CFR 0.152.
 */
package math.numericalmethods;

import java.util.Arrays;
import java.util.InputMismatchException;
import java.util.List;
import math.numericalmethods.FunctionExpander;
import math.numericalmethods.Integration;
import parser.Bracket;
import parser.Function;
import parser.LISTS;
import parser.MathExpression;
import parser.Number;
import parser.Operator;
import parser.Variable;
import util.FunctionManager;
import util.VariableManager;

public class NumericalIntegral {
    public static final int SYMBOLIC_INTEGRATION = 1;
    public static final int FUNCTIONAL_INTEGRATION = 2;
    private double xUpper;
    private double xLower;
    private Function function;
    private int iterations = 0;

    public NumericalIntegral(double xLower, double xUpper, int iterations, String function) {
        this.xLower = xLower;
        this.xUpper = xUpper;
        try {
            this.function = FunctionManager.lookUp(function);
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
            this.function = new Function(function);
        }
        if (iterations == 0) {
            int trialValue = Math.abs((int)((xUpper - xLower) / 0.01));
            this.setIterations(trialValue < 10 ? 15 : (trialValue > 30 ? 30 : trialValue));
        } else {
            this.setIterations(iterations);
        }
    }

    public NumericalIntegral(String expression, int chooseExpressionType) {
        if (chooseExpressionType == 1) {
            new Parser(expression, chooseExpressionType);
            if (this.iterations == 0) {
                this.setIterations(20);
            }
        } else if (chooseExpressionType == 2) {
            new Parser(expression, chooseExpressionType);
            if (this.iterations == 0) {
                this.setIterations(20);
            }
        } else {
            throw new InputMismatchException("Input Type Error");
        }
    }

    public void setIterations(int iterations) {
        this.iterations = (iterations = Math.abs(iterations)) % 2 == 0 ? iterations : iterations + 1;
    }

    public int getIterations() {
        return this.iterations;
    }

    public Function getFunction() {
        return this.function;
    }

    public void setFunction(Function function) {
        this.function = function;
    }

    public double getxLower() {
        return this.xLower;
    }

    public void setxLower(double xLower) {
        this.xLower = xLower;
    }

    public double getxUpper() {
        return this.xUpper;
    }

    public void setxUpper(double xUpper) {
        this.xUpper = xUpper;
    }

    public String findSimpsonIntegral() {
        double m = 20000.0;
        double h = (this.xUpper - this.xLower) / (2.0 * m);
        MathExpression fun = this.function.getMathExpression();
        fun.setDRG(1);
        String variable = this.function.getIndependentVariables().get(0).getName();
        fun.setValue(variable, String.valueOf(this.xLower));
        double first = Double.parseDouble(fun.solve());
        fun.setValue(variable, String.valueOf(this.xUpper));
        double last = Double.parseDouble(fun.solve());
        double count = 1.0;
        double sumFirstAndLast = first + last;
        double sumEven = 0.0;
        double sumOdd = 0.0;
        double x = 0.0;
        while (x < this.xUpper - h) {
            x = this.xLower + count * h;
            try {
                if (count % 2.0 == 0.0) {
                    fun.setValue(variable, String.valueOf(x));
                    sumEven += Double.parseDouble(fun.solve());
                } else if (count % 2.0 == 1.0) {
                    fun.setValue(variable, String.valueOf(x));
                    sumOdd += Double.parseDouble(fun.solve());
                }
                count += 1.0;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        double sum = h / 3.0 * (sumFirstAndLast + 4.0 * sumOdd + 2.0 * sumEven);
        return String.valueOf(sum);
    }

    public String findSimpsonIntegral(double h) {
        double n = (this.xUpper - this.xLower) / h;
        double xLower = this.xLower;
        double xUpper = xLower + Math.floor(n) * h;
        MathExpression fun = this.function.getMathExpression();
        fun.setDRG(1);
        String variable = this.function.getIndependentVariables().get(0).getName();
        fun.setValue(variable, String.valueOf(xLower));
        double first = Double.parseDouble(fun.solve());
        fun.setValue(variable, String.valueOf(xUpper));
        double last = Double.parseDouble(fun.solve());
        double count = 1.0;
        double sumFirstAndLast = first + last;
        double sumEven = 0.0;
        double sumOdd = 0.0;
        double x = 0.0;
        while (x < xUpper - h) {
            x = xLower + count * h;
            try {
                if (count % 2.0 == 0.0) {
                    fun.setValue(variable, String.valueOf(x));
                    sumEven += Double.parseDouble(fun.solve());
                } else if (count % 2.0 == 1.0) {
                    fun.setValue(variable, String.valueOf(x));
                    sumOdd += Double.parseDouble(fun.solve());
                }
                count += 1.0;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        double mainSum = h / 3.0 * (sumFirstAndLast + 4.0 * sumOdd + 2.0 * sumEven);
        if (xUpper == this.xUpper) {
            return String.valueOf(mainSum);
        }
        xLower = xUpper;
        xUpper = this.xUpper;
        h = (xUpper - xLower) / 10.0;
        fun.setValue(variable, String.valueOf(xLower));
        first = Double.parseDouble(fun.solve());
        fun.setValue(variable, String.valueOf(xUpper));
        last = Double.parseDouble(fun.solve());
        count = 1.0;
        sumFirstAndLast = first + last;
        sumEven = 0.0;
        sumOdd = 0.0;
        x = 0.0;
        while (x < xUpper - h) {
            x = xLower + count * h;
            try {
                if (count % 2.0 == 0.0) {
                    fun.setValue(variable, String.valueOf(x));
                    sumEven += Double.parseDouble(fun.solve());
                } else if (count % 2.0 == 1.0) {
                    fun.setValue(variable, String.valueOf(x));
                    sumOdd += Double.parseDouble(fun.solve());
                }
                count += 1.0;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        double sum = h / 3.0 * (sumFirstAndLast + 4.0 * sumOdd + 2.0 * sumEven);
        return String.valueOf(sum + mainSum);
    }

    public String findTrapezoidalIntegral() {
        double dx = (this.xUpper - this.xLower) / 10000.0;
        MathExpression fun = this.function.getMathExpression();
        fun.setDRG(1);
        String variable = this.function.getIndependentVariables().get(0).getName();
        fun.setValue(variable, String.valueOf(this.xLower));
        double first = Double.parseDouble(fun.solve());
        fun.setValue(variable, String.valueOf(this.xUpper));
        double last = Double.parseDouble(fun.solve());
        fun.setValue(variable, String.valueOf(this.xLower + dx));
        double y = 0.0;
        double count = 0.0;
        double sum = 0.0;
        double x = this.xLower + dx;
        while (x < this.xUpper) {
            try {
                fun.setValue(variable, String.valueOf(x));
                sum += Double.parseDouble(fun.solve());
                x = this.xLower + (count += 1.0) * dx;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return String.valueOf((sum += 0.5 * (first + last)) * dx);
    }

    public String findTrapezoidalIntegral(double h) {
        double n = (this.xUpper - this.xLower) / h;
        double xLower = this.xLower;
        double xUpper = xLower + Math.floor(n) * h;
        MathExpression fun = this.function.getMathExpression();
        fun.setDRG(1);
        String variable = this.function.getIndependentVariables().get(0).getName();
        fun.setValue(variable, String.valueOf(xLower));
        double first = Double.parseDouble(fun.solve());
        fun.setValue(variable, String.valueOf(xUpper));
        double last = Double.parseDouble(fun.solve());
        double count = 1.0;
        double mainSum = 0.0;
        double x = xLower + h;
        while (x < xUpper) {
            try {
                fun.setValue(variable, String.valueOf(x));
                mainSum += Double.parseDouble(fun.solve());
                x = xLower + (count += 1.0) * h;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        mainSum += 0.5 * (first + last);
        if (xUpper == this.xUpper) {
            return String.valueOf(mainSum * h);
        }
        xLower = xUpper;
        xUpper = this.xUpper;
        fun.setValue(variable, String.valueOf(xLower));
        first = Double.parseDouble(fun.solve());
        fun.setValue(variable, String.valueOf(xUpper));
        last = Double.parseDouble(fun.solve());
        double sum = 0.5 * (xUpper - xLower) * (first + last);
        return String.valueOf(h * mainSum + sum);
    }

    public double findPolynomialIntegral() {
        FunctionExpander expander = new FunctionExpander(this.xLower, this.xUpper, this.iterations, 1, this.function);
        MathExpression approxFunction = new MathExpression(expander.getPolynomialIntegral());
        String variable = this.function.getIndependentVariables().get(0).getName();
        approxFunction.setValue(variable, String.valueOf(this.xLower));
        double lower = Double.parseDouble(approxFunction.solve());
        approxFunction.setValue(variable, String.valueOf(this.xUpper));
        double upper = Double.parseDouble(approxFunction.solve());
        return upper - lower;
    }

    public double findHighRangeIntegralWithAdvancedPolynomial() {
        double dx = 0.5;
        String fName = this.function.getName();
        if (Math.abs(this.xUpper - this.xLower) < dx) {
            return this.findAdvancedPolynomialIntegral();
        }
        double sum = 0.0;
        if (this.xLower <= this.xUpper) {
            NumericalIntegral integral;
            double x;
            for (x = this.xLower; x < this.xUpper - dx; x += dx) {
                integral = new NumericalIntegral(x, x + dx, this.iterations, fName);
                sum += integral.findAdvancedPolynomialIntegral();
            }
            if (x < this.xUpper) {
                try {
                    integral = new NumericalIntegral(x, this.xUpper, this.iterations, fName);
                    sum += integral.findAdvancedPolynomialIntegral();
                }
                catch (Exception integral2) {}
            }
        } else if (this.xUpper < this.xLower) {
            NumericalIntegral integral;
            double x;
            for (x = this.xLower; x > this.xUpper + dx; x -= dx) {
                integral = new NumericalIntegral(x, x - dx, this.iterations, fName);
                sum += integral.findAdvancedPolynomialIntegral();
            }
            if (x > this.xUpper) {
                try {
                    integral = new NumericalIntegral(x, this.xUpper, this.iterations, fName);
                    sum += integral.findAdvancedPolynomialIntegral();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return sum;
    }

    public double findHighRangeIntegral() {
        double dx = 0.2;
        String fName = this.function.getName();
        try {
            if (Math.abs(this.xUpper - this.xLower) < dx) {
                return this.findGaussianQuadrature();
            }
            double sum = 0.0;
            if (this.xLower <= this.xUpper) {
                NumericalIntegral integral;
                double x;
                for (x = this.xLower; x < this.xUpper - dx; x += dx) {
                    integral = new NumericalIntegral(x, x + dx, this.iterations, fName);
                    sum += integral.findGaussianQuadrature();
                }
                if (x < this.xUpper) {
                    try {
                        integral = new NumericalIntegral(x, this.xUpper, this.iterations, fName);
                        sum += integral.findGaussianQuadrature();
                    }
                    catch (Exception integral2) {}
                }
            } else if (this.xUpper < this.xLower) {
                NumericalIntegral integral;
                double x;
                for (x = this.xLower; x > this.xUpper + dx; x -= dx) {
                    integral = new NumericalIntegral(x, x - dx, this.iterations, fName);
                    sum += integral.findGaussianQuadrature();
                }
                if (x > this.xUpper) {
                    try {
                        integral = new NumericalIntegral(x, this.xUpper, this.iterations, fName);
                        sum += integral.findGaussianQuadrature();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (sum == Double.POSITIVE_INFINITY || sum == Double.NEGATIVE_INFINITY || sum == Double.NaN) {
                return this.findHighRangeIntegralWithAdvancedPolynomial();
            }
            return sum;
        }
        catch (Exception e) {
            return this.findHighRangeIntegralWithAdvancedPolynomial();
        }
    }

    public double findGaussianQuadrature() {
        return Integration.gaussQuad(this.function, this.xLower, this.xUpper, 8);
    }

    public double findAdvancedPolynomialIntegral() {
        double dx = (this.xUpper - this.xLower) / (double)this.iterations;
        FunctionExpander expander = new FunctionExpander(this.xLower, this.xUpper, this.iterations, 1, this.function);
        MathExpression approxFunction = new MathExpression(expander.getPolynomial());
        MathExpression fun = new MathExpression(this.function.getMathExpression().getExpression());
        fun.setDRG(1);
        String variable = this.function.getIndependentVariables().get(0).getName();
        double sum1 = this.findPolynomialIntegral();
        double sum2 = 0.0;
        for (double x = this.xLower; x < this.xUpper; x += dx) {
            double x1 = (x + (x + dx)) / 2.0;
            fun.setValue(variable, String.valueOf(x1));
            approxFunction.setValue(variable, String.valueOf(x1));
            try {
                sum2 += Double.parseDouble(approxFunction.solve()) - Double.parseDouble(fun.solve());
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return sum1 -= 0.6666666666666666 * sum2 * dx;
    }

    public static void extractFunctionStringFromExpression(List<String> list) {
        list.removeAll(Arrays.asList(","));
        if (list.get(0).equals("quad")) {
            list.set(0, "intg");
        }
        if (list.get(0).equals("intg") && list.get(1).equals("(") && list.get(list.size() - 1).equals(")")) {
            String args1;
            boolean exists;
            String functionName = list.get(2);
            if (Variable.isVariableString(functionName) && (exists = FunctionManager.contains(functionName))) {
                for (int i = 3; i < list.size(); ++i) {
                    if (Operator.isOpeningBracket(list.get(i))) {
                        int closeBracket = Bracket.getComplementIndex(true, i, list);
                        args1 = new MathExpression(LISTS.createStringFrom(list, i, closeBracket + 1)).solve();
                        List<String> l = list.subList(i, closeBracket + 1);
                        l.clear();
                        l.add(args1);
                        continue;
                    }
                    if (!Variable.isVariableString(list.get(i))) continue;
                    String val = VariableManager.getVariable(list.get(i)).getValue();
                    list.set(i, val);
                }
            }
            args1 = list.get(3);
            String args2 = list.get(4);
            String args3 = list.get(5);
            if (Number.validNumber(args1) && Number.validNumber(args2) && !Number.validNumber(args3) && !Operator.isClosingBracket(args3)) {
                list.clear();
            }
        }
    }

    public String getVariable() {
        return this.function.getIndependentVariables().get(0).getName();
    }

    public static void main(String[] args) {
        FunctionManager.add("F=@(x)2*x+3");
        FunctionManager.add("P=@(x)ln(x)");
        FunctionManager.add("G=@(x)x*ln(x)-x");
        FunctionManager.add("H=@(x)(x^2+1)^-1");
        FunctionManager.add("I=@(x)atan(x)");
        System.out.println(FunctionManager.FUNCTIONS);
        double x1 = -10.0;
        double x2 = 10.0;
        NumericalIntegral numericalIntegral = new NumericalIntegral("intg(H," + x1 + "," + x2 + ")", 2);
        double numericalValue = numericalIntegral.findHighRangeIntegralWithAdvancedPolynomial();
        Function f = FunctionManager.lookUp("I");
        double realValue = f.calc(x2) - f.calc(x1);
        System.out.println("Numerical value: " + numericalValue);
        System.out.println("Real value: " + realValue);
        System.out.println("%Error: " + 100.0 * (realValue - numericalValue) / realValue);
    }

    class Parser {
        public Parser(String expression, int mode) {
            if (mode == 2) {
                NumericalIntegral.this.setFunction(this.getFunctionFromIntegralCommand(expression));
            } else if (mode == 1) {
                NumericalIntegral.this.setFunction(this.getFunctionFromSymbolicIntegralCommand(expression));
            } else {
                throw new InputMismatchException("SYNTAX ERROR FOUND IN INTEGRAL EXPRESSION");
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Function getFunctionFromIntegralCommand(String expression) {
            if ((expression = expression.trim()).startsWith("quad")) {
                expression = "intg" + expression.substring(4);
            }
            if (expression.startsWith("intg(") && expression.endsWith(")")) {
                expression = expression.substring(expression.indexOf("(") + 1);
                expression = expression.substring(0, expression.length() - 1);
                double[] args = new double[3];
                args[0] = Double.NaN;
                int lastCommaIndex = expression.lastIndexOf(",");
                try {
                    args[2] = Double.parseDouble(expression.substring(lastCommaIndex + 1).trim());
                    expression = expression.substring(0, lastCommaIndex).trim();
                }
                catch (NumberFormatException numErr) {
                    throw new InputMismatchException("SYNTAX ERROR!");
                }
                lastCommaIndex = expression.lastIndexOf(",");
                try {
                    args[1] = Double.parseDouble(expression.substring(lastCommaIndex + 1).trim());
                    expression = expression.substring(0, lastCommaIndex).trim();
                }
                catch (NumberFormatException numErr) {
                    throw new InputMismatchException("SYNTAX ERROR!");
                }
                lastCommaIndex = expression.lastIndexOf(",");
                try {
                    args[0] = Double.parseDouble(expression.substring(lastCommaIndex + 1).trim());
                    expression = expression.substring(0, lastCommaIndex).trim();
                }
                catch (NumberFormatException numErr) {
                }
                catch (IndexOutOfBoundsException indErr) {
                    throw new InputMismatchException("SYNTAX ERROR!");
                }
                lastCommaIndex = expression.lastIndexOf(",");
                try {
                    args[0] = Double.parseDouble(expression.substring(lastCommaIndex + 1).trim());
                    expression = expression.substring(0, lastCommaIndex).trim();
                    throw new InputMismatchException(" Max of 3 args allowed! ");
                }
                catch (NumberFormatException numberFormatException) {
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
                if (new Double(args[0]).isNaN()) {
                    NumericalIntegral.this.setxLower(args[1]);
                    NumericalIntegral.this.setxUpper(args[2]);
                    try {
                        if (expression.startsWith("@")) {
                            return new Function(expression);
                        }
                        if (!Variable.isVariableString(expression)) throw new InputMismatchException("ALGEBRAIC_EXPRESSION SYNTAX ERROR");
                        return FunctionManager.lookUp(expression);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        throw new InputMismatchException("INVALID ALGEBRAIC_EXPRESSION");
                    }
                } else {
                    if (new Double(args[0]).isNaN()) throw new InputMismatchException("Invalid Integral Expression!");
                    NumericalIntegral.this.setxLower(args[0]);
                    NumericalIntegral.this.setxUpper(args[1]);
                    NumericalIntegral.this.setIterations((int)args[2]);
                    try {
                        if (expression.startsWith("@")) {
                            return new Function(expression);
                        }
                        if (!Variable.isVariableString(expression)) throw new InputMismatchException("ALGEBRAIC_EXPRESSION SYNTAX ERROR");
                        return FunctionManager.lookUp(expression);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        throw new InputMismatchException("INVALID ALGEBRAIC_EXPRESSION");
                    }
                }
            }
            if (!expression.startsWith("intg(")) {
                throw new InputMismatchException("Invalid Integral Expression!");
            }
            if (expression.endsWith(")")) throw new InputMismatchException("INVALID ALGEBRAIC_EXPRESSION");
            throw new InputMismatchException("Missing Closing Parenthesis");
        }

        public Function getFunctionFromSymbolicIntegralCommand(String expression) {
            expression = expression.trim();
            double[] args = new double[3];
            args[0] = Double.NaN;
            if (expression.startsWith("\u222b(")) {
                String differential = expression.substring(expression.indexOf(")") + 1).trim();
                if (differential.startsWith("d")) {
                    String variable = differential.substring(1);
                    expression = expression.replace("\u222b", "intg");
                    Function f = this.getFunctionFromIntegralCommand(expression = expression.substring(0, expression.lastIndexOf(")") + 1));
                    if (f.hasIndependentVariable(variable)) {
                        return f;
                    }
                    throw new InputMismatchException("Function " + f + " has no independent variable like " + variable);
                }
                throw new InputMismatchException("Invalid differential!");
            }
            throw new InputMismatchException("Invalid Integral Expression!");
        }
    }
}

