/*
 * Decompiled with CFR 0.152.
 */
package math.matrix;

import java.util.ArrayList;
import math.matrix.expressParser.MatrixValueParser;
import math.matrix.expressParser.MatrixVariable;
import parser.STRING;
import util.Utils;

public class MatrixVariableManager {
    private final ArrayList<MatrixVariable> varStore = new ArrayList(100);
    private int interval;
    private boolean intervalChanged = false;
    private static boolean validCommandString = true;

    public MatrixVariableManager() {
    }

    public MatrixVariableManager(int interval) {
        this.interval = interval;
    }

    public int getInterval() {
        return this.interval;
    }

    public void setInterval(int interval) {
        if (interval != this.interval) {
            this.setIntervalChanged(true);
        }
        this.interval = interval;
    }

    public boolean isIntervalChanged() {
        return this.intervalChanged;
    }

    public void setIntervalChanged(boolean intervalChanged) {
        this.intervalChanged = intervalChanged;
    }

    public static boolean isValidCommandString() {
        return validCommandString;
    }

    public static void setValidCommandString(boolean validCommandString) {
        MatrixVariableManager.validCommandString = validCommandString;
    }

    public MatrixVariable getVarFromIndex(int index) {
        return this.varStore.get(index);
    }

    public int getVarIndexFromVarName(String name) {
        int index = -1;
        for (int i = 0; i < this.varStore.size(); ++i) {
            if (!this.varStore.get(i).getName().equals(name)) continue;
            index = i;
            break;
        }
        return index;
    }

    public boolean contains(String name) {
        return this.getVarIndexFromVarName(name) != -1;
    }

    private MatrixVariable createMatrixVariable(String cmd) throws NullPointerException {
        cmd = STRING.purifier(cmd);
        MatrixValueParser parser = new MatrixValueParser(cmd.substring(cmd.indexOf("[")));
        return new MatrixVariable(cmd.substring(0, cmd.indexOf("=")), parser.getMatrix());
    }

    public void storeVariable(String cmd) {
        try {
            MatrixVariable var = this.createMatrixVariable(cmd);
            this.varStore.add(0, var);
            this.removeDuplicates();
        }
        catch (NullPointerException nolian) {
            Utils.logError("Variable Creation Syntax Error. ERROR IN SYNTAX");
        }
    }

    public void removeDuplicates() {
        ArrayList<MatrixVariable> constCleaner = new ArrayList<MatrixVariable>();
        for (int j = 0; j < this.varStore.size(); ++j) {
            for (int i = j; i < this.varStore.size(); ++i) {
                MatrixVariable var1 = this.varStore.get(j);
                MatrixVariable var2 = this.varStore.get(i);
                if (!var1.getName().equals(var2.getName()) || j >= i) continue;
                constCleaner.add(this.varStore.get(i));
            }
        }
        this.varStore.removeAll(constCleaner);
    }

    public ArrayList<MatrixVariable> getVarStore() {
        return this.varStore;
    }

    public void setVarStore(ArrayList<MatrixVariable> varStore) {
        this.varStore.clear();
        this.varStore.addAll(varStore);
    }

    public void deleteVar(String varName) {
        try {
            for (int i = 0; i < this.varStore.size(); ++i) {
                if (!this.varStore.get(i).getName().equals(varName)) continue;
                this.varStore.remove(i);
                break;
            }
        }
        catch (IndexOutOfBoundsException indErr) {
            Utils.logError("Variable " + varName + " Does Not Exist.");
        }
    }

    public void deleteVar(int index) {
        try {
            this.varStore.remove(index);
        }
        catch (IndexOutOfBoundsException indErr) {
            Utils.logError("No Variable Exists At Location " + index);
        }
    }

    public void clearVariables() {
        ArrayList<MatrixVariable> varDeleter = new ArrayList<MatrixVariable>();
        for (int i = 0; i < this.varStore.size(); ++i) {
            varDeleter.add(this.varStore.get(i));
        }
        varDeleter.clear();
    }

    public void clearVariablesAndConstants() {
        this.varStore.clear();
    }

    public static void main(String[] args) {
        MatrixVariableManager mgr = new MatrixVariableManager(5);
        mgr.storeVariable("#dc=[-90,-20,23,12,3.0:2,1,3,4,12:,12,34,56,32,12:12,23,1,25,98:12,21,3,1,4:]");
        System.out.println(mgr.getVarStore());
    }
}

