/*
 * Decompiled with CFR 0.152.
 */
package math.fractions;

public class FractionalNumber {
    private long numerator;
    private long denominator;

    public FractionalNumber(long numerator, long denominator) {
        this.numerator = numerator;
        this.denominator = denominator;
        this.reduce();
    }

    public FractionalNumber() {
        this.numerator = 1L;
        this.denominator = 1L;
    }

    public long getDenominator() {
        return this.denominator;
    }

    public void setDenominator(int denominator) {
        this.denominator = denominator;
    }

    public long getNumerator() {
        return this.numerator;
    }

    public void setNumerator(int numerator) {
        this.numerator = numerator;
    }

    public void reduce() {
        double den = this.numerator >= this.denominator ? (double)this.numerator : (double)this.denominator;
        int i = 2;
        while ((double)i < den) {
            if (this.numerator % (long)i == 0L && this.denominator % (long)i == 0L) {
                this.numerator /= (long)i;
                this.denominator /= (long)i;
                while (this.numerator % (long)i == 0L && this.denominator % (long)i == 0L) {
                    this.numerator /= (long)i;
                    this.denominator /= (long)i;
                }
            }
            if (this.numerator == 1L || this.denominator == 1L || FractionalNumber.isEven(this.numerator) && FractionalNumber.isPowerOf2(this.numerator) && !FractionalNumber.isEven(this.denominator) || FractionalNumber.isEven(this.denominator) && FractionalNumber.isPowerOf2(this.denominator) && !FractionalNumber.isEven(this.numerator)) break;
            ++i;
        }
    }

    public static boolean isPowerOf2(long num) {
        double x = Math.log(num) / Math.log(2.0);
        return x % 2.0 == 0.0 || x % 2.0 == 1.0;
    }

    public static boolean isEven(long num) {
        return num % 2L == 0L;
    }

    public FractionalNumber add(FractionalNumber rationale) {
        return new FractionalNumber(this.numerator * rationale.denominator + this.denominator * rationale.numerator, this.denominator * rationale.denominator);
    }

    public FractionalNumber minus(FractionalNumber rationale) {
        return new FractionalNumber(this.numerator * rationale.denominator - this.denominator * rationale.numerator, this.denominator * rationale.denominator);
    }

    public FractionalNumber multiply(FractionalNumber rationale) {
        return new FractionalNumber(this.numerator * rationale.numerator, this.denominator * rationale.denominator);
    }

    public FractionalNumber divide(FractionalNumber rationale) {
        return new FractionalNumber(this.numerator * rationale.denominator, rationale.denominator * rationale.numerator);
    }

    public String toString() {
        return String.valueOf(this.numerator) + "/" + String.valueOf(this.denominator);
    }
}

