/*
 * Decompiled with CFR 0.152.
 */
package math.differentialcalculus;

import java.util.ArrayList;
import java.util.List;
import math.differentialcalculus.DerivativeScanner;
import math.differentialcalculus.Utilities;
import parser.Bracket;
import parser.Number;
import parser.Operator;
import parser.PowerOperator;
import parser.UnaryPostOperator;
import parser.Variable;
import parser.methods.Method;

public class SemanticAnalyzer {
    private Bracket[] brackets;
    private ArrayList<String> scanner;
    private StringBuilder utility = new StringBuilder("");

    public SemanticAnalyzer(String expression) throws Exception {
        DerivativeScanner ds = new DerivativeScanner(expression);
        if (!ds.getScanner().isEmpty()) {
            int i;
            this.scanner = ds.getScanner();
            for (i = this.scanner.size() - 1; i >= 0; --i) {
                String operator = this.scanner.get(i);
                if (i + 1 >= this.scanner.size()) continue;
                String token = this.scanner.get(i + 1);
                if (!Bracket.isUnaryPreOperator(operator)) continue;
                this.scanner.set(i, Bracket.isSquareRoot(operator) ? "sqrt" : "cbrt");
                if (!Variable.isVariableString(token) && !Number.isNumber(token) || i + 2 >= this.scanner.size()) continue;
                if (!Bracket.isOpenBracket(this.scanner.get(i + 2))) {
                    this.scanner.add(i + 2, ")");
                    this.scanner.add(i + 1, "(");
                    continue;
                }
                int close = Bracket.getComplementIndex(true, i + 2, this.scanner);
                this.scanner.add(close + 1, ")");
                this.scanner.add(i + 1, "(");
            }
            for (i = 0; i < this.scanner.size(); ++i) {
                try {
                    if (!this.scanner.get(i).equals("-") || !Bracket.isOpeningBracket(this.scanner.get(i - 1)) && !Bracket.isPower(this.scanner.get(i - 1)) && !Bracket.isMulOrDiv(this.scanner.get(i - 1)) || !Variable.isVariableString(this.scanner.get(i + 1)) && !Number.isNumber(this.scanner.get(i + 1))) continue;
                    if (Number.isNumber(this.scanner.get(i + 1))) {
                        this.scanner.set(i + 1, "" + Double.parseDouble(this.scanner.get(i + 1)) * -1.0);
                        this.scanner.remove(i);
                        continue;
                    }
                    this.scanner.set(i, "-1");
                    this.scanner.add(i + 1, "*");
                    continue;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        } else {
            throw new Exception("Bad Math Expression");
        }
        this.checkOperatorSemantics();
    }

    public Bracket[] getBrackets() {
        return this.brackets;
    }

    boolean checkBracketStructure() {
        int close = 0;
        ArrayList<String> scan = new ArrayList<String>();
        ArrayList<String> scanner = this.getScanner();
        scan.addAll(scanner);
        ArrayList<Bracket> brackets = new ArrayList<Bracket>();
        int open = 0;
        int i = 0;
        while ((close = scan.indexOf(")")) != -1) {
            try {
                open = scan.subList(0, close + 1).lastIndexOf("(");
                Bracket opening = new Bracket("(");
                Bracket closing = new Bracket(")");
                opening.setIndex(open);
                closing.setIndex(close);
                opening.setComplement(closing);
                closing.setComplement(opening);
                brackets.add(opening);
                brackets.add(closing);
                scan.set(open, "");
                scan.set(close, "");
                ++i;
            }
            catch (IndexOutOfBoundsException ind) {
                scanner.clear();
                break;
            }
        }
        if (scan.indexOf("(") == -1 && scan.indexOf(")") == -1) {
            int size = brackets.size();
            this.brackets = new Bracket[size];
            this.brackets = brackets.toArray(this.brackets);
            return true;
        }
        scanner.clear();
        return false;
    }

    private boolean checkOperatorSemantics() {
        this.checkBracketStructure();
        this.functionComponentsAssociation();
        return !this.getScanner().isEmpty();
    }

    private void functionComponentsAssociation() {
        boolean valid;
        ArrayList<String> scanner = this.getScanner();
        for (int i = 0; i < scanner.size(); ++i) {
            if (!Variable.isVariableString(scanner.get(i))) continue;
            try {
                if (!(Bracket.isOpeningBracket(scanner.get(i - 1)) || Bracket.isLogicOperator(scanner.get(i - 1)) || Method.isUnaryPreOperatorORDefinedMethod(scanner.get(i - 1)) || Bracket.isBinaryOperator(scanner.get(i - 1)) || Bracket.isAssignmentOperator(scanner.get(i - 1)) || Number.isNumber(scanner.get(i - 1)) || Variable.isVariableString(scanner.get(i - 1)))) {
                    scanner.clear();
                    break;
                }
                if (Bracket.isBracket(scanner.get(i + 1)) || Bracket.isBinaryOperator(scanner.get(i + 1)) || Bracket.isUnaryPostOperator(scanner.get(i + 1)) || Method.isNumberReturningStatsMethod(scanner.get(i + 1)) || Bracket.isLogicOperator(scanner.get(i + 1)) || Bracket.isAssignmentOperator(scanner.get(i + 1)) || Method.isUnaryPreOperatorORDefinedMethod(scanner.get(i + 1)) || Method.isLogToAnyBase(scanner.get(i + 1)) || Method.isAntiLogToAnyBase(scanner.get(i + 1)) || Number.isNumber(scanner.get(i + 1)) || Variable.isVariableString(scanner.get(i + 1))) continue;
                scanner.clear();
                break;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        if (!(valid = Bracket.validateAll(scanner))) {
            scanner.clear();
            this.brackets = null;
        }
    }

    private void codeModifier() {
        int i;
        ArrayList<String> scanner = this.getScanner();
        UnaryPostOperator.assignCompoundTokens(scanner);
        PowerOperator.assignCompoundTokens(scanner);
        for (i = 0; i < scanner.size(); ++i) {
            try {
                if (!Bracket.isBinaryOperator(scanner.get(i)) && !Method.isUnaryPreOperatorORDefinedMethod(scanner.get(i)) && !Bracket.isOpeningBracket(scanner.get(i)) && !Bracket.isLogicOperator(scanner.get(i)) && !Bracket.isAssignmentOperator(scanner.get(i)) && !Bracket.isComma(scanner.get(i)) && !Method.isStatsMethod(scanner.get(i)) || !Operator.isPlusOrMinus(scanner.get(i + 1)) || !Number.isNumber(scanner.get(i + 2))) continue;
                this.utility.append(scanner.get(i + 1));
                this.utility.append(scanner.get(i + 2));
                scanner.set(i + 1, this.utility.toString());
                scanner.set(i + 2, "");
                this.utility.delete(0, this.utility.length());
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        Utilities.freeSpaces(scanner);
        for (i = 0; i < scanner.size(); ++i) {
            try {
                if ((Number.isNumber(scanner.get(i)) || Variable.isVariableString(scanner.get(i))) && (Method.isUnaryPreOperatorORDefinedMethod(scanner.get(i + 1)) || Method.isNumberReturningStatsMethod(scanner.get(i + 1)) || Method.isLogOrAntiLogToAnyBase(scanner.get(i + 1)))) {
                    int j = i + 1;
                    while (Method.isUnaryPreOperatorORDefinedMethod(scanner.get(j)) || Method.isNumberReturningStatsMethod(scanner.get(j)) || Method.isLogOrAntiLogToAnyBase(scanner.get(j))) {
                        ++j;
                    }
                    if (Number.isNumber(scanner.get(j)) || Variable.isVariableString(scanner.get(j))) {
                        scanner.add(j + 1, ")");
                        scanner.add(i, "(");
                        scanner.add(i + 2, "*");
                    } else if (Bracket.isOpeningBracket(scanner.get(j))) {
                        int ind = Bracket.getComplementIndex(true, j, scanner);
                        scanner.add(ind + 1, ")");
                        scanner.add(i, "(");
                        scanner.add(i + 2, "*");
                    }
                }
            }
            catch (IndexOutOfBoundsException j) {
                // empty catch block
            }
            try {
                if (Method.isUnaryPreOperatorORDefinedMethod(scanner.get(i - 1)) && Operator.isPlusOrMinus(scanner.get(i)) && Bracket.isOpeningBracket(scanner.get(i + 1))) {
                    if (scanner.get(i).equals("-")) {
                        List<String> subList = scanner.subList(i - 1, Bracket.getComplementIndex(true, i + 1, scanner) + 1);
                        subList.set(1, "(");
                        subList.add(2, "-1");
                        subList.add(3, "*");
                        subList.add(")");
                    } else if (scanner.get(i).equals("+")) {
                        scanner.set(i, "");
                    }
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            try {
                if (!Bracket.isOpeningBracket(scanner.get(i - 1)) || !Operator.isPlusOrMinus(scanner.get(i)) || !Method.isUnaryPreOperatorORDefinedMethod(scanner.get(i + 1))) continue;
                if (scanner.get(i).equals("-")) {
                    scanner.set(i, "-1");
                    scanner.add(i + 1, "*");
                    continue;
                }
                if (!scanner.get(i).equals("+")) continue;
                scanner.set(i, "");
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        Utilities.freeSpaces(this.getScanner());
    }

    public ArrayList<String> getScanner() {
        return this.scanner;
    }

    public static void main(String[] args) {
        try {
            String expression = "2+3*(2*x*x*2*x*x*8*x*7*x*4*y*(3*x)-\u00b9*3*x*x^2*2*3*4^x-5*1/x)";
            SemanticAnalyzer analyzer = new SemanticAnalyzer(expression);
            System.out.println(analyzer.getScanner());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

