/*
 * Decompiled with CFR 0.152.
 */
package math.differentialcalculus;

import java.util.ArrayList;
import java.util.List;
import math.differentialcalculus.SemanticAnalyzer;
import math.differentialcalculus.Utilities;
import parser.Bracket;
import parser.Number;
import parser.Operator;
import parser.STRING;
import parser.Variable;
import parser.methods.Method;

public class CodeGenerator {
    private ArrayList<String> scanner;

    public CodeGenerator(String expression) throws Exception {
        try {
            SemanticAnalyzer semanticAnalyzer = new SemanticAnalyzer(expression.startsWith("(") && expression.endsWith(")") ? expression : "(" + expression + ")");
            this.scanner = semanticAnalyzer.getScanner();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new Exception("Bad Input!---" + expression);
        }
    }

    public ArrayList<String> getScanner() {
        return this.scanner;
    }

    public static void simplifyTokens(ArrayList<String> scan) {
        int i;
        CodeGenerator.openUpUnnecessaryBrackets(scan);
        CodeGenerator.bracketVariableProductsAndQuotients(scan);
        CodeGenerator.tokenRearranger(scan);
        CodeGenerator.quicksimplify(scan);
        for (i = 0; i < scan.size(); ++i) {
            try {
                boolean endsWithDiv;
                boolean endsWithMul;
                boolean startsWithDiv;
                boolean startsWithMul;
                List<String> view;
                ArrayList vars;
                int start;
                if (Operator.isOpeningBracket(scan.get(i))) {
                    while (Operator.isOpeningBracket(scan.get(i))) {
                        ++i;
                    }
                    start = i;
                    Object[] obj = CodeGenerator.utilitySimplifier(scan, start);
                    i = Integer.parseInt(obj[0].toString());
                    vars = (ArrayList)obj[1];
                    view = scan.subList(start, i);
                    int size = view.size();
                    if (size > 0 && !vars.isEmpty()) {
                        startsWithMul = view.get(0).equals("*");
                        startsWithDiv = view.get(0).equals("/");
                        endsWithMul = view.get(size - 1).equals("*");
                        endsWithDiv = view.get(size - 1).equals("/");
                        view.clear();
                        view.addAll(vars);
                        if (startsWithMul) {
                            view.add(0, "*");
                        } else if (startsWithDiv) {
                            view.add(0, "/");
                        }
                        if (endsWithMul) {
                            view.add("*");
                        } else if (endsWithDiv) {
                            view.add("/");
                        }
                    }
                    i = start + vars.size() - 1;
                    continue;
                }
                if (Operator.isPlusOrMinus(scan.get(i))) {
                    start = ++i;
                    Object[] obj = CodeGenerator.utilitySimplifier(scan, start);
                    i = Integer.parseInt(obj[0].toString());
                    vars = (ArrayList)obj[1];
                    view = scan.subList(start, i);
                    int size = view.size();
                    if (size > 0 && !vars.isEmpty()) {
                        startsWithMul = view.get(0).equals("*");
                        startsWithDiv = view.get(0).equals("/");
                        endsWithMul = view.get(size - 1).equals("*");
                        endsWithDiv = view.get(size - 1).equals("/");
                        view.clear();
                        view.addAll(vars);
                        if (startsWithMul) {
                            view.add(0, "*");
                        } else if (startsWithDiv) {
                            view.add(0, "/");
                        }
                        if (endsWithMul) {
                            view.add("*");
                        } else if (endsWithDiv) {
                            view.add("/");
                        }
                    }
                    i = start + vars.size() - 1;
                    continue;
                }
                if (!Operator.isClosingBracket(scan.get(i))) continue;
                int siz = scan.size();
                while (i < siz && Operator.isClosingBracket(scan.get(i))) {
                    ++i;
                }
                if (!Operator.isMulOrDiv(scan.get(i)) && !Operator.isPlusOrMinus(scan.get(i))) continue;
                int start2 = i;
                Object[] obj = CodeGenerator.utilitySimplifier(scan, start2 + 1);
                i = Integer.parseInt(obj[0].toString());
                ArrayList vars2 = (ArrayList)obj[1];
                List<String> view2 = scan.subList(start2 + 1, i);
                int size = view2.size();
                if (size > 0 && !vars2.isEmpty()) {
                    boolean startsWithMul2 = view2.get(0).equals("*");
                    boolean startsWithDiv2 = view2.get(0).equals("/");
                    boolean endsWithMul2 = view2.get(size - 1).equals("*");
                    boolean endsWithDiv2 = view2.get(size - 1).equals("/");
                    view2.clear();
                    view2.addAll(vars2);
                    if (startsWithMul2) {
                        view2.add(0, "*");
                    } else if (startsWithDiv2) {
                        view2.add(0, "/");
                    }
                    if (endsWithMul2) {
                        view2.add("*");
                    } else if (endsWithDiv2) {
                        view2.add("/");
                    }
                }
                i = start2 + vars2.size() - 1;
                continue;
            }
            catch (IndexOutOfBoundsException boundsException) {
                break;
            }
        }
        CodeGenerator.unbracketNumbers(scan);
        CodeGenerator.tokenRearranger(scan);
        CodeGenerator.quicksimplify(scan);
        CodeGenerator.multiplyOutProductBrackets(scan);
        for (i = 0; i < scan.size(); ++i) {
            try {
                if (!Method.isMethodName(scan.get(i)) || !Operator.isOpeningBracket(scan.get(i + 1))) continue;
                int initialCloseIndex = Bracket.getComplementIndex(true, i + 1, scan);
                if (Operator.isOpeningBracket(scan.get(i + 2))) {
                    int closeIndex = Bracket.getComplementIndex(true, i + 2, scan);
                    if (closeIndex + 1 == initialCloseIndex) continue;
                    scan.add(initialCloseIndex, ")");
                    scan.add(i + 1, "(");
                    continue;
                }
                scan.add(initialCloseIndex, ")");
                scan.add(i + 1, "(");
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        Utilities.freeSpaces(scan);
        CodeGenerator.cleanUp(scan);
    }

    private static void unbracketNumbers(ArrayList<String> scan) {
        for (int i = 0; i < scan.size(); ++i) {
            try {
                if (!Number.isNumber(scan.get(i)) || !Operator.isOpeningBracket(scan.get(i - 1)) || Method.isMethodName(scan.get(i - 2)) || !Operator.isClosingBracket(scan.get(i + 1))) continue;
                scan.remove(i + 1);
                scan.remove(i - 1);
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    public static void openUpUnnecessaryBrackets(ArrayList<String> scan) {
        for (int i = 0; i < scan.size(); ++i) {
            int outerOpen;
            int outerClose;
            int close;
            int open;
            if (!Operator.isClosingBracket(scan.get(i)) || (open = Bracket.getComplementIndex(false, close = i, scan)) <= 0 || !Operator.isOpeningBracket(scan.get(open - 1)) || (outerClose = Bracket.getComplementIndex(true, outerOpen = open - 1, scan)) != close + 1) continue;
            scan.remove(outerClose);
            scan.remove(outerOpen);
            i -= 2;
        }
    }

    private static void bracketVariableProductsAndQuotients(ArrayList<String> scan) {
        for (int i = 0; i < scan.size(); ++i) {
            try {
                if (!Operator.isMulOrDiv(scan.get(i))) continue;
                String previousToken = scan.get(i - 1);
                String token = scan.get(i);
                String nextToken = scan.get(i + 1);
                int start = i;
                while (Number.isNumber(token) || Operator.isMulOrDiv(token) || Variable.isVariableString(token)) {
                    if (Variable.isVariableString(token) && Operator.isOpeningBracket(nextToken)) {
                        i = Bracket.getComplementIndex(true, i + 1, scan);
                    }
                    ++i;
                    try {
                        previousToken = scan.get(i - 1);
                        token = scan.get(i);
                        nextToken = scan.get(i + 1);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
                }
                if (Operator.isOpeningBracket(scan.get(start - 2)) && scan.subList(start, i).size() < 4 || scan.subList(start, i).size() == 1) continue;
                if (Operator.isMulOrDiv(scan.get(i - 1))) {
                    scan.add(i - 1, ")");
                } else {
                    scan.add(i, ")");
                }
                if (Number.isNumber(scan.get(start - 1)) || Variable.isVariableString(scan.get(start - 1))) {
                    scan.add(start - 1, "(");
                } else {
                    scan.add(start + 1, "(");
                }
                i += 2;
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    private static void quicksimplify(ArrayList<String> scan) {
        int i;
        for (i = 0; i < scan.size(); ++i) {
            try {
                if (!Operator.isPower(scan.get(i)) || !Number.isNumber(scan.get(i - 1)) || !Number.isNumber(scan.get(i + 1))) continue;
                scan.set(i + 1, "" + Math.pow(Double.parseDouble(scan.get(i - 1)), Double.parseDouble(scan.get(i + 1))));
                scan.set(i - 1, "");
                scan.set(i, "");
                if (!Operator.isOpeningBracket(scan.get(i - 2)) || !Operator.isClosingBracket(scan.get(i + 2)) || i - 3 < 0 || Method.isMethodName(scan.get(i - 3))) continue;
                scan.set(i - 2, "");
                scan.set(i + 2, "");
                i += 2;
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        Utilities.freeSpaces(scan);
        for (i = 0; i < scan.size(); ++i) {
            try {
                if (scan.get(i).equals("*") && Number.isNumber(scan.get(i - 1)) && Number.isNumber(scan.get(i + 1))) {
                    scan.set(i + 1, "" + Double.parseDouble(scan.get(i - 1)) * Double.parseDouble(scan.get(i + 1)));
                    scan.set(i - 1, "");
                    scan.set(i, "");
                    if (!Operator.isOpeningBracket(scan.get(i - 2)) || !Operator.isClosingBracket(scan.get(i + 2)) || i - 3 < 0 || Method.isMethodName(scan.get(i - 3))) continue;
                    scan.set(i - 2, "");
                    scan.set(i + 2, "");
                    i += 2;
                    continue;
                }
                if (!scan.get(i).equals("/") || !Number.isNumber(scan.get(i - 1)) || !Number.isNumber(scan.get(i + 1))) continue;
                scan.set(i + 1, "" + Double.parseDouble(scan.get(i - 1)) / Double.parseDouble(scan.get(i + 1)));
                scan.set(i - 1, "");
                scan.set(i, "");
                if (!Operator.isOpeningBracket(scan.get(i - 2)) || !Operator.isClosingBracket(scan.get(i + 2)) || i - 3 < 0 || Method.isMethodName(scan.get(i - 3))) continue;
                scan.set(i - 2, "");
                scan.set(i + 2, "");
                i += 2;
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        Utilities.freeSpaces(scan);
        for (i = 0; i < scan.size(); ++i) {
            try {
                if (scan.get(i).equals("+") && Number.isNumber(scan.get(i - 1)) && Number.isNumber(scan.get(i + 1))) {
                    scan.set(i + 1, "" + (Double.parseDouble(scan.get(i - 1)) + Double.parseDouble(scan.get(i + 1))));
                    scan.set(i - 1, "");
                    scan.set(i, "");
                    if (!Operator.isOpeningBracket(scan.get(i - 2)) || !Operator.isClosingBracket(scan.get(i + 2)) || i - 3 < 0 || Method.isMethodName(scan.get(i - 3))) continue;
                    scan.set(i - 2, "");
                    scan.set(i + 2, "");
                    continue;
                }
                if (!scan.get(i).equals("-") || !Number.isNumber(scan.get(i - 1)) || !Number.isNumber(scan.get(i + 1))) continue;
                scan.set(i + 1, "" + (Double.parseDouble(scan.get(i - 1)) - Double.parseDouble(scan.get(i + 1))));
                scan.set(i - 1, "");
                scan.set(i, "");
                if (!Operator.isOpeningBracket(scan.get(i - 2)) || !Operator.isClosingBracket(scan.get(i + 2)) || i - 3 < 0 || Method.isMethodName(scan.get(i - 3))) continue;
                scan.set(i - 2, "");
                scan.set(i + 2, "");
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        Utilities.freeSpaces(scan);
    }

    private static void multiplyOutProductBrackets(ArrayList<String> scan) {
        for (int i = 0; i < scan.size(); ++i) {
            try {
                int k;
                String str;
                int j;
                if (!Operator.isClosingBracket(scan.get(i - 1)) || !scan.get(i).equals("*") || !Operator.isOpeningBracket(scan.get(i + 1))) continue;
                int start = Bracket.getComplementIndex(false, i - 1, scan);
                int end = Bracket.getComplementIndex(true, i + 1, scan);
                ArrayList<String> leftBrac = new ArrayList<String>(scan.subList(start, i));
                ArrayList<String> rightBrac = new ArrayList<String>(scan.subList(i + 1, end + 1));
                boolean canReduce = true;
                if (Method.isMethodName(scan.get(start - 1))) {
                    canReduce = false;
                }
                for (j = 0; j < leftBrac.size() && canReduce; ++j) {
                    try {
                        str = (String)leftBrac.get(j);
                        if (j > 0 && Operator.isClosingBracket((String)leftBrac.get(j - 1)) && Operator.isPower((String)leftBrac.get(j)) && Operator.isOpeningBracket((String)leftBrac.get(j + 1))) {
                            canReduce = false;
                            break;
                        }
                        if (j > 0 && Operator.isClosingBracket((String)leftBrac.get(j - 1)) && Operator.isPower((String)leftBrac.get(j)) && Operator.isOpeningBracket((String)leftBrac.get(j + 1))) {
                            canReduce = false;
                            break;
                        }
                        if (Number.isNumber(str) || Variable.isVariableString(str) && !Operator.isOpeningBracket((String)leftBrac.get(j + 1)) || Operator.isMulOrDiv(str) || Operator.isBracket(str) || Operator.isPower(str)) {
                            canReduce = true;
                            continue;
                        }
                        canReduce = false;
                        break;
                    }
                    catch (IndexOutOfBoundsException boundsException) {
                        boundsException.printStackTrace();
                    }
                }
                if (canReduce) {
                    for (j = 0; j < rightBrac.size() && canReduce; ++j) {
                        try {
                            str = (String)rightBrac.get(j);
                            if (j > 0 && Operator.isClosingBracket((String)rightBrac.get(j - 1)) && Operator.isPower((String)rightBrac.get(j)) && Operator.isOpeningBracket((String)rightBrac.get(j + 1))) {
                                canReduce = false;
                                break;
                            }
                            if (Number.isNumber(str) || Variable.isVariableString(str) && !Operator.isOpeningBracket((String)rightBrac.get(j + 1)) || Operator.isMulOrDiv(str) || Operator.isBracket(str) || Operator.isPower(str)) {
                                canReduce = true;
                                continue;
                            }
                            canReduce = false;
                            break;
                        }
                        catch (IndexOutOfBoundsException boundsException) {
                            boundsException.printStackTrace();
                        }
                    }
                }
                if (!canReduce) continue;
                ArrayList vars = new ArrayList();
                for (k = 0; k < leftBrac.size(); ++k) {
                    try {
                        if (Number.isNumber((String)leftBrac.get(k)) && ((String)leftBrac.get(k + 1)).equals("*")) {
                            if (vars.isEmpty()) {
                                vars.add(leftBrac.get(k));
                                continue;
                            }
                            if (Number.isNumber((String)vars.get(0))) {
                                vars.set(0, "" + Double.parseDouble((String)vars.get(0)) * Double.parseDouble((String)leftBrac.get(k)));
                                continue;
                            }
                            vars.add(0, "" + Double.parseDouble((String)leftBrac.get(k)));
                            continue;
                        }
                        if (!Operator.isPower((String)leftBrac.get(k)) || !Variable.isVariableString((String)leftBrac.get(k - 1)) || !Number.isNumber((String)leftBrac.get(k + 1))) continue;
                        int index = vars.indexOf(leftBrac.get(k - 1));
                        if (index == -1) {
                            if (vars.isEmpty()) {
                                vars.add("(");
                                vars.add(leftBrac.get(k - 1));
                                vars.add("^");
                                vars.add(leftBrac.get(k + 1));
                                vars.add(")");
                                continue;
                            }
                            vars.add("*");
                            vars.add("(");
                            vars.add(leftBrac.get(k - 1));
                            vars.add("^");
                            vars.add(leftBrac.get(k + 1));
                            vars.add(")");
                            continue;
                        }
                        vars.set(index + 2, "" + (Double.parseDouble((String)vars.get(index + 2)) + Double.parseDouble((String)leftBrac.get(k + 1))));
                        continue;
                    }
                    catch (IndexOutOfBoundsException index) {
                        // empty catch block
                    }
                }
                for (k = 0; k < rightBrac.size(); ++k) {
                    try {
                        if (Number.isNumber((String)rightBrac.get(k)) && ((String)rightBrac.get(k + 1)).equals("*")) {
                            if (vars.isEmpty()) {
                                vars.add(rightBrac.get(k));
                                continue;
                            }
                            if (Number.isNumber((String)vars.get(0))) {
                                vars.set(0, "" + Double.parseDouble((String)vars.get(0)) * Double.parseDouble((String)rightBrac.get(k)));
                                continue;
                            }
                            vars.add(0, "" + Double.parseDouble((String)rightBrac.get(k)));
                            continue;
                        }
                        if (!Operator.isPower((String)rightBrac.get(k)) || !Variable.isVariableString((String)rightBrac.get(k - 1)) || !Number.isNumber((String)rightBrac.get(k + 1))) continue;
                        int index = vars.indexOf(rightBrac.get(k - 1));
                        if (index == -1) {
                            if (vars.isEmpty()) {
                                vars.add("(");
                                vars.add(rightBrac.get(k - 1));
                                vars.add("^");
                                vars.add(rightBrac.get(k + 1));
                                vars.add(")");
                                continue;
                            }
                            vars.add("*");
                            vars.add("(");
                            vars.add(rightBrac.get(k - 1));
                            vars.add("^");
                            vars.add(rightBrac.get(k + 1));
                            vars.add(")");
                            continue;
                        }
                        vars.set(index + 2, "" + (Double.parseDouble((String)vars.get(index + 2)) + Double.parseDouble((String)rightBrac.get(k + 1))));
                        continue;
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                }
                List<String> temp = scan.subList(start, end + 1);
                temp.clear();
                temp.addAll(vars);
                i = start + vars.size() - 1;
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    private static void tokenRearranger(ArrayList<String> scan) {
        for (int i = 0; i < scan.size(); ++i) {
            try {
                if (!Operator.isClosingBracket(scan.get(i))) continue;
                int close = i;
                int open = Bracket.getComplementIndex(false, close, scan);
                ArrayList<String> temp = new ArrayList<String>();
                for (int j = open + 1; j < close; ++j) {
                    if (Operator.isOpeningBracket(scan.get(j))) {
                        int closeIndex;
                        j = closeIndex = Bracket.getComplementIndex(true, j, scan);
                        continue;
                    }
                    if (Number.isNumber(scan.get(j)) && Operator.isPlusOrMinus(scan.get(j - 1)) && Operator.isPlusOrMinus(scan.get(j + 1))) {
                        temp.add(scan.get(j - 1));
                        temp.add(scan.get(j));
                        scan.set(j - 1, "");
                        scan.set(j, "");
                        continue;
                    }
                    if (!Number.isNumber(scan.get(j)) || !Operator.isOpeningBracket(scan.get(j - 1)) || !Operator.isPlusOrMinus(scan.get(j + 1))) continue;
                    temp.add("+");
                    temp.add(scan.get(j));
                    scan.set(j, "");
                }
                scan.addAll(close, temp);
                Utilities.freeSpaces(scan.subList(open, Bracket.getComplementIndex(true, open, scan)));
                if (!scan.get(open + 1).equals("+")) continue;
                scan.set(open + 1, "");
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void cleanUp(ArrayList<String> scan) {
        for (int i = 1; i < scan.size(); ++i) {
            try {
                if (Operator.isOpeningBracket(scan.get(i - 1)) && Operator.isPlusOrMinus(scan.get(i)) && Operator.isOpeningBracket(scan.get(i + 1))) {
                    if (scan.get(i).equals("+")) {
                        scan.remove(i);
                        continue;
                    }
                    if (!scan.get(i).equals("-")) continue;
                    scan.set(i, "-1");
                    scan.add(i + 1, "*");
                    continue;
                }
                if (!Operator.isOpeningBracket(scan.get(i)) || !Operator.isPlusOrMinus(scan.get(i + 1))) continue;
                if (scan.get(i + 1).equals("+")) {
                    scan.remove(i + 1);
                    continue;
                }
                if (!scan.get(i + 1).equals("-")) continue;
                scan.set(i + 1, "-1");
                scan.add(i + 2, "*");
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    private static Object[] utilitySimplifier(ArrayList<String> scan, int i) {
        int start = i;
        ArrayList<String> vars = new ArrayList<String>();
        while (i + 1 <= scan.size() && (Number.isNumber(scan.get(i)) || Variable.isVariableString(scan.get(i)) && !Operator.isOpeningBracket(scan.get(i + 1)) || Operator.isMulOrDiv(scan.get(i)) || STRING.purifier(scan.get(i)).isEmpty())) {
            int index;
            if (Number.isNumber(scan.get(i)) && scan.get(i - 1).equals("/")) {
                if (vars.isEmpty()) {
                    vars.add("" + 1.0 / Double.parseDouble(scan.get(i)));
                } else if (!Number.isNumber((String)vars.get(0))) {
                    vars.add(0, "" + 1.0 / Double.parseDouble(scan.get(i)));
                    vars.add(1, "*");
                } else if (Number.isNumber((String)vars.get(0))) {
                    vars.set(0, "" + Double.parseDouble((String)vars.get(0)) / Double.parseDouble(scan.get(i)));
                }
            } else if (Number.isNumber(scan.get(i)) && scan.get(i - 1).equals("*")) {
                if (vars.isEmpty()) {
                    vars.add(scan.get(i));
                } else if (!Number.isNumber((String)vars.get(0))) {
                    vars.add(0, scan.get(i));
                    vars.add(1, "*");
                } else if (Number.isNumber((String)vars.get(0))) {
                    vars.set(0, "" + Double.parseDouble((String)vars.get(0)) * Double.parseDouble(scan.get(i)));
                }
            } else if (Number.isNumber(scan.get(i)) && scan.get(i + 1).equals("*")) {
                if (vars.isEmpty()) {
                    vars.add(scan.get(i));
                } else if (!Number.isNumber((String)vars.get(0))) {
                    vars.add(0, scan.get(i));
                    vars.add(1, "*");
                } else if (Number.isNumber((String)vars.get(0))) {
                    vars.set(0, "" + Double.parseDouble((String)vars.get(0)) * Double.parseDouble(scan.get(i)));
                }
            } else if (Number.isNumber(scan.get(i)) && Operator.isPlusOrMinus(scan.get(i - 1))) {
                if (vars.isEmpty()) {
                    vars.add(scan.get(i));
                } else if (!Number.isNumber((String)vars.get(0))) {
                    vars.add(0, scan.get(i));
                    vars.add(1, "*");
                } else if (Number.isNumber((String)vars.get(0))) {
                    vars.set(0, "" + Double.parseDouble((String)vars.get(0)) * Double.parseDouble(scan.get(i)));
                }
            } else if (Number.isNumber(scan.get(i)) && Operator.isPlusOrMinus(scan.get(i + 1))) {
                if (vars.isEmpty()) {
                    vars.add(scan.get(i));
                } else if (!Number.isNumber((String)vars.get(0))) {
                    vars.add(0, scan.get(i));
                    vars.add(1, "*");
                } else if (Number.isNumber((String)vars.get(0))) {
                    vars.set(0, "" + Double.parseDouble((String)vars.get(0)) * Double.parseDouble(scan.get(i)));
                }
            } else if (Variable.isVariableString(scan.get(i)) && scan.get(i - 1).equals("/")) {
                index = vars.indexOf(scan.get(i));
                if (index == -1) {
                    if (!vars.isEmpty() && !((String)vars.get(vars.size() - 1)).equals("*")) {
                        vars.add("*");
                    }
                    vars.add("(");
                    vars.add(scan.get(i));
                    vars.add("^");
                    vars.add("-1");
                    vars.add(")");
                } else {
                    vars.set(index + 2, "" + (Integer.parseInt((String)vars.get(index + 2)) - 1));
                }
                scan.set(i, "");
            } else if (Variable.isVariableString(scan.get(i)) && (scan.get(i - 1).equals("*") || scan.get(i + 1).equals("*"))) {
                index = vars.indexOf(scan.get(i));
                if (index == -1) {
                    if (!vars.isEmpty() && !((String)vars.get(vars.size() - 1)).equals("*")) {
                        vars.add("*");
                    }
                    vars.add("(");
                    vars.add(scan.get(i));
                    vars.add("^");
                    vars.add("1");
                    vars.add(")");
                } else {
                    vars.set(index + 2, "" + (Integer.parseInt((String)vars.get(index + 2)) + 1));
                }
                scan.set(i, "");
            }
            ++i;
        }
        return new Object[]{i, vars};
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("");
        ArrayList<String> scan = this.getScanner();
        for (String token : scan) {
            sb.append(token);
        }
        return sb.substring(0, sb.length());
    }

    public static void main(String[] args) {
        try {
            String expression = "2^(3+2)-sin(2)+((((7))))-3*x/(5-sin(4*x^2-7))";
            CodeGenerator dsb = new CodeGenerator(expression);
            System.out.println("Initially: " + expression);
            System.out.println("Finally: " + dsb.getScanner());
            System.out.println("Generated expression =  " + dsb);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

