/*
 * Decompiled with CFR 0.152.
 */
package math;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;

public final class BigDecimalNthRootCalculation {
    private static MathContext default_mode = new MathContext(10, RoundingMode.HALF_DOWN);

    private BigDecimalNthRootCalculation() {
    }

    public static BigDecimal nthRoot(int n, BigDecimal a) {
        return BigDecimalNthRootCalculation.nthRoot(n, a, default_mode);
    }

    public static BigDecimal nthRoot(int n, BigDecimal a, MathContext mc) {
        return BigDecimalNthRootCalculation.nthRoot(n, a, BigDecimal.valueOf(0.1).movePointLeft(mc.getPrecision()), mc);
    }

    private static BigDecimal nthRoot(int n, BigDecimal a, BigDecimal p, MathContext mc) {
        if (a.compareTo(BigDecimal.ZERO) < 0) {
            throw new IllegalArgumentException("nth root can only be calculated for positive numbers");
        }
        if (a.equals(BigDecimal.ZERO)) {
            return BigDecimal.ZERO;
        }
        BigDecimal xPrev = a;
        BigDecimal x = a.divide(new BigDecimal(n), mc);
        while (x.subtract(xPrev).abs().compareTo(p) > 0) {
            xPrev = x;
            x = BigDecimal.valueOf((double)n - 1.0).multiply(x).add(a.divide(x.pow(n - 1), mc)).divide(new BigDecimal(n), mc);
        }
        return x;
    }
}

