/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import parser.Function;
import parser.Variable;
import util.VariableManager;

public class FunctionManager {
    public static final Map<String, Function> FUNCTIONS = Collections.synchronizedMap(new HashMap());

    public static boolean contains(String fName) {
        return FunctionManager.lookUp(fName) != null;
    }

    public static Function getFunction(String fName) {
        return FUNCTIONS.get(fName);
    }

    public static Function lookUp(String functionName) {
        return FUNCTIONS.get(functionName);
    }

    public static void add(String expression) {
        FunctionManager.add(new Function(expression));
    }

    public static void add(Function f) {
        String fName = f.getName();
        Function oldFunc = FUNCTIONS.get(fName);
        if (oldFunc == null) {
            Variable v = VariableManager.lookUp(fName);
            if (v != null) {
                VariableManager.delete(fName);
            }
            FUNCTIONS.put(fName, f);
        } else {
            FunctionManager.update(f.toString());
        }
        FunctionManager.update();
    }

    public static void load(Map<String, Function> functions) {
        FunctionManager.load(functions, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load(Map<String, Function> functions, boolean clearFirst) {
        Map<String, Function> map = FUNCTIONS;
        synchronized (map) {
            if (clearFirst) {
                FUNCTIONS.clear();
            }
            FUNCTIONS.putAll(functions);
        }
    }

    public static void delete(String fName) {
        FUNCTIONS.remove(fName);
        FunctionManager.update();
    }

    public static void update(String expression) {
        try {
            Function f = new Function(expression);
            String name = f.getName();
            FUNCTIONS.put(name, f);
        }
        catch (Exception ex) {
            Logger.getLogger(FunctionManager.class.getName()).log(Level.SEVERE, null, ex);
        }
        FunctionManager.update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearAnonymousFunctions() {
        Set<Map.Entry<String, Function>> entrySet;
        ArrayList<String> anonKeys = new ArrayList<String>();
        Set<Map.Entry<String, Function>> set = entrySet = FUNCTIONS.entrySet();
        synchronized (set) {
            for (Map.Entry<String, Function> entry : entrySet) {
                Function function = entry.getValue();
                if (!function.isAnonymous()) continue;
                anonKeys.add(entry.getKey());
            }
            FUNCTIONS.keySet().removeAll(anonKeys);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int countAnonymousFunctions() {
        int count = 0;
        Map<String, Function> map = FUNCTIONS;
        synchronized (map) {
            for (Map.Entry<String, Function> entry : FUNCTIONS.entrySet()) {
                Function function = entry.getValue();
                if (!function.getName().startsWith("anon")) continue;
                ++count;
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final ArrayList<Function> getDefinedFunctions() {
        ArrayList<Function> functions = new ArrayList<Function>();
        Map<String, Function> map = FUNCTIONS;
        synchronized (map) {
            for (Map.Entry<String, Function> entry : FUNCTIONS.entrySet()) {
                Function function = entry.getValue();
                if (function == null || function.isAnonymous()) continue;
                functions.add(function);
            }
        }
        return functions;
    }

    public static void update() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initializeFunctionVars() {
        Set<Map.Entry<String, Function>> entrySet = FUNCTIONS.entrySet();
        Map<String, Function> map = FUNCTIONS;
        synchronized (map) {
            for (Map.Entry<String, Function> entry : entrySet) {
                Function f = entry.getValue();
                VariableManager.add(f.getIndependentVariables().toArray(new Variable[0]));
            }
        }
    }
}

