/*
 * Decompiled with CFR 0.152.
 */
package parser;

import java.util.ArrayList;
import java.util.InputMismatchException;
import java.util.List;
import math.Maths;
import parser.Bracket;
import parser.CustomScanner;
import parser.Function;
import parser.LISTS;
import parser.ListReturningStatsOperator;
import parser.MathScanner;
import parser.Number;
import parser.Operator;
import parser.Parser_Result;
import parser.PowerOperator;
import parser.STRING;
import parser.TYPE;
import parser.UnaryPostOperator;
import parser.Variable;
import parser.methods.Method;
import util.FunctionManager;
import util.VariableManager;

public class MathExpression {
    public Parser_Result parser_Result = Parser_Result.VALID;
    protected int DRG = 1;
    public static String lastResult = "0.0";
    private ArrayList<String> whitespaceremover = new ArrayList();
    private String expression;
    protected boolean correctFunction = true;
    protected int noOfListReturningOperators;
    protected ArrayList<String> scanner = new ArrayList();
    private boolean optimizable;
    private Bracket[] bracket;
    protected boolean hasListReturningOperators;
    private boolean hasNumberReturningStatsOperators;
    private boolean hasPlusOrMinusOperators;
    private boolean hasMulOrDivOperators;
    private boolean hasPowerOperators;
    private boolean hasPostNumberOperators;
    private boolean hasPreNumberOperators;
    private boolean hasRemainderOperators;
    private boolean hasPermOrCombOperators;
    private boolean hasLogicOperators;
    private static boolean autoInitOn;
    private boolean hasFunctionOrVariableInitStatement;
    private VariableManager variableManager;
    StringBuilder utility = new StringBuilder("");
    private TYPE returnType = TYPE.NUMBER;
    private String returnObjectName;

    public MathExpression() {
        this("(0.0)");
    }

    public MathExpression(String input) {
        MathExpression.setAutoInitOn(false);
        this.variableManager = new VariableManager();
        CustomScanner cs = new CustomScanner(STRING.purifier(input), false, ";");
        List<String> scanned = cs.scan();
        String mathExpr = null;
        int exprCount = 0;
        for (String code : scanned) {
            if (code.contains("=")) {
                boolean success = Function.assignObject(code + ";");
                if (success) continue;
                this.correctFunction = success;
                this.parser_Result = Parser_Result.SYNTAX_ERROR;
                input = null;
                return;
            }
            mathExpr = "(" + code + ")";
            ++exprCount;
        }
        if (mathExpr != null && !mathExpr.isEmpty() && exprCount == 1) {
            this.setExpression(mathExpr);
        } else {
            this.setExpression("(0.0)");
        }
    }

    public String getExpression() {
        return this.expression;
    }

    public final void setExpression(String expression) {
        if (!expression.equals(this.expression)) {
            this.scanner.clear();
            this.setCorrectFunction(true);
            this.expression = expression;
            this.initializing(expression);
        } else {
            this.expression = expression;
        }
    }

    public boolean isScannedAndOptimized() {
        try {
            return !this.scanner.isEmpty() && this.correctFunction && this != null;
        }
        catch (NullPointerException nol) {
            return false;
        }
    }

    public static void setAutoInitOn(boolean autoInitOn) {
        MathExpression.autoInitOn = autoInitOn;
    }

    public static boolean isAutoInitOn() {
        return autoInitOn;
    }

    private void initializing(String expression) {
        this.setCorrectFunction(true);
        this.setHasListReturningOperators(false);
        this.setNoOfListReturningOperators(0);
        this.whitespaceremover.add("");
        MathScanner opScanner = new MathScanner(expression);
        this.scanner = opScanner.scanner(this.variableManager);
        this.correctFunction = opScanner.isRunnable();
        this.parser_Result = opScanner.parser_Result;
        if (this.parser_Result == Parser_Result.VALID) {
            this.bracket = null;
            this.codeModifier();
            this.removeCommas();
            this.mapBrackets();
            this.functionComponentsAssociation();
        }
    }

    private void removeCommas() {
        ArrayList<String> commaList = new ArrayList<String>();
        commaList.add(",");
        commaList.add("");
        this.scanner.removeAll(commaList);
    }

    public int getDRG() {
        return this.DRG;
    }

    public void setDRG(int DRG) {
        this.DRG = DRG == 0 || DRG == 1 || DRG == 2 ? DRG : 0;
    }

    public Bracket[] getBracket() {
        return this.bracket;
    }

    public void setBracket(Bracket[] bracket) {
        this.bracket = bracket;
    }

    public boolean isCorrectFunction() {
        return this.correctFunction;
    }

    public void setCorrectFunction(boolean correctFunction) {
        this.correctFunction = correctFunction;
    }

    public int getNoOfListReturningOperators() {
        return this.noOfListReturningOperators;
    }

    public void setNoOfListReturningOperators(int noOfListReturningOperators) {
        this.noOfListReturningOperators = noOfListReturningOperators;
    }

    public ArrayList<String> getScanner() {
        return this.scanner;
    }

    public void setScanner(ArrayList<String> scanner) {
        this.scanner = scanner;
    }

    public ArrayList<String> getWhitespaceremover() {
        return this.whitespaceremover;
    }

    public void setWhitespaceremover(ArrayList<String> whitespaceremover) {
        this.whitespaceremover = whitespaceremover;
    }

    public boolean isHasListReturningOperators() {
        return this.hasListReturningOperators;
    }

    public void setHasListReturningOperators(boolean hasListReturningOperators) {
        this.hasListReturningOperators = hasListReturningOperators;
    }

    public void setOptimizable(boolean optimizable) {
        this.optimizable = optimizable;
    }

    public boolean isOptimizable() {
        return this.optimizable;
    }

    public static void setLastResult(String lastResult) {
        MathExpression.lastResult = lastResult;
    }

    public static String getLastResult() {
        return lastResult;
    }

    public void setHasPreNumberOperators(boolean hasPreNumberOperators) {
        this.hasPreNumberOperators = hasPreNumberOperators;
    }

    public boolean isHasPreNumberOperators() {
        return this.hasPreNumberOperators;
    }

    public void setHasLogicOperators(boolean hasLogicOperators) {
        this.hasLogicOperators = hasLogicOperators;
    }

    public boolean isHasLogicOperators() {
        return this.hasLogicOperators;
    }

    public void setHasPostNumberOperators(boolean hasPostNumberOperators) {
        this.hasPostNumberOperators = hasPostNumberOperators;
    }

    public boolean isHasPostNumberOperators() {
        return this.hasPostNumberOperators;
    }

    public void setHasPowerOperators(boolean hasPowerOperators) {
        this.hasPowerOperators = hasPowerOperators;
    }

    public boolean isHasPowerOperators() {
        return this.hasPowerOperators;
    }

    public void setHasMulOrDivOperators(boolean hasMulOrDivOperators) {
        this.hasMulOrDivOperators = hasMulOrDivOperators;
    }

    public boolean isHasMulOrDivOperators() {
        return this.hasMulOrDivOperators;
    }

    public String getReturnObjectName() {
        return this.returnObjectName;
    }

    public void setHasPlusOrMinusOperators(boolean hasPlusOrMinusOperators) {
        this.hasPlusOrMinusOperators = hasPlusOrMinusOperators;
    }

    public boolean isHasPlusOrMinusOperators() {
        return this.hasPlusOrMinusOperators;
    }

    public void setHasRemainderOperators(boolean hasRemainderOperators) {
        this.hasRemainderOperators = hasRemainderOperators;
    }

    public boolean isHasRemainderOperators() {
        return this.hasRemainderOperators;
    }

    public void setHasPermOrCombOperators(boolean hasPermOrCombOperators) {
        this.hasPermOrCombOperators = hasPermOrCombOperators;
    }

    public boolean isHasPermOrCombOperators() {
        return this.hasPermOrCombOperators;
    }

    public void setHasNumberReturningStatsOperators(boolean hasNumberReturningStatsOperators) {
        this.hasNumberReturningStatsOperators = hasNumberReturningStatsOperators;
    }

    public boolean isHasNumberReturningStatsOperators() {
        return this.hasNumberReturningStatsOperators;
    }

    public void setVariableHandlerOnly(boolean variableHandlerOnly) {
        this.hasFunctionOrVariableInitStatement = variableHandlerOnly;
    }

    public boolean isVariableHandlerOnly() {
        return this.hasFunctionOrVariableInitStatement;
    }

    public VariableManager getVariableManager() {
        return this.variableManager;
    }

    public void setVariableManager(VariableManager variableManager) {
        this.variableManager = variableManager;
    }

    public ArrayList<Variable> getVars() {
        ArrayList<Variable> usedVars = new ArrayList<Variable>();
        for (int i = 0; i < this.scanner.size(); ++i) {
            if (!Variable.isVariableString(this.scanner.get(i)) || Operator.isOpeningBracket(this.scanner.get(i + 1))) continue;
            String str = this.scanner.get(i);
            Variable v = VariableManager.lookUp(str);
            if (v == null) {
                this.setCorrectFunction(false);
                throw new NullPointerException("Variable " + str + " Was Never Initialized!!");
            }
            if (usedVars.contains(v)) continue;
            usedVars.add(v);
        }
        return usedVars;
    }

    public void unBracketDataSetReturningStatsOperators() {
        for (int i = 0; i < this.scanner.size(); ++i) {
            boolean exitForLoop = false;
            if (Method.isListReturningStatsMethod(this.scanner.get(i))) {
                int I = i - 1;
                while (Operator.isOpeningBracket(this.scanner.get(I))) {
                    int closeBracIndex = Bracket.getComplementIndex(true, I, this.scanner);
                    if (I > 0 && !Method.isListReturningStatsMethod(this.scanner.get(I - 1))) {
                        this.scanner.set(closeBracIndex, "");
                        this.scanner.set(I, "");
                        --I;
                        exitForLoop = closeBracIndex <= this.scanner.size();
                        continue;
                    }
                    if (I != 0 || !Operator.isOpeningBracket(this.scanner.get(0))) continue;
                    this.scanner.set(closeBracIndex, "");
                    this.scanner.set(0, "");
                    exitForLoop = closeBracIndex <= this.scanner.size();
                    break;
                }
            }
            if (exitForLoop) break;
        }
        this.scanner.removeAll(this.whitespaceremover);
    }

    public void statsVerifier() {
        int i;
        this.scanner.removeAll(this.whitespaceremover);
        for (i = 0; i < this.scanner.size(); ++i) {
            if (!Method.isListReturningStatsMethod(this.scanner.get(i)) || !Operator.isOpeningBracket(this.scanner.get(i + 1))) continue;
            ++this.noOfListReturningOperators;
        }
        this.correctFunction = ListReturningStatsOperator.validateFunction(this.scanner);
        Parser_Result parser_Result = this.parser_Result = this.correctFunction ? Parser_Result.VALID : Parser_Result.SYNTAX_ERROR;
        if (this.noOfListReturningOperators > 0 && this.correctFunction) {
            this.setHasListReturningOperators(true);
            if (this.isHasListReturningOperators()) {
                this.scanner.remove(0);
                this.scanner.remove(this.scanner.size() - 1);
                for (i = 0; i < this.scanner.size(); ++i) {
                    try {
                        if (!Method.isListReturningStatsMethod(this.scanner.get(i)) || !Operator.isOpeningBracket(this.scanner.get(i + 1))) continue;
                        if (Operator.isBinaryOperator(this.scanner.get(i - 1))) {
                            this.correctFunction = false;
                            break;
                        }
                        if (!Operator.isBracket(this.scanner.get(i - 1)) || Method.isNumberReturningStatsMethod(this.scanner.get(i - 2)) || Method.isListReturningStatsMethod(this.scanner.get(i - 2))) continue;
                        this.correctFunction = false;
                        break;
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                }
                this.scanner.add(0, "(");
                this.scanner.add(")");
                if (!this.correctFunction) {
                    this.parser_Result = Parser_Result.SYNTAX_ERROR;
                }
            }
        }
    }

    private void evaluateCompoundStructuresInStatisticalInput() {
        if (this.hasListReturningOperators || this.hasNumberReturningStatsOperators) {
            for (int i = 0; i < this.scanner.size(); ++i) {
                try {
                    if (!Operator.isClosingBracket(this.scanner.get(i))) continue;
                    int open = Bracket.getComplementIndex(false, i, this.scanner);
                    if (!Method.isMethodName(this.scanner.get(open - 1))) {
                        Bracket opener = new Bracket("(");
                        opener.setIndex(open);
                        Bracket closer = new Bracket(")");
                        closer.setIndex(i);
                        opener.setComplement(closer);
                        closer.setComplement(opener);
                        if (opener.simpleBracketPairHasVariables(this.scanner)) continue;
                        String fun = opener.getDomainContents(this.scanner);
                        while (fun.startsWith("(") && fun.endsWith(")")) {
                            fun = fun.substring(1);
                            fun = fun.substring(0, fun.length() - 1);
                            fun = fun.trim();
                        }
                        MathExpression f = new MathExpression(fun);
                        String val = f.solve();
                        this.scanner.add(open, val);
                        this.scanner.subList(open + 1, i + 2).clear();
                        continue;
                    }
                    if (!Method.isDefinedMethod(this.scanner.get(open - 1))) continue;
                    int ind = open - 2;
                    while (Operator.isOpeningBracket(this.scanner.get(ind))) {
                        --ind;
                    }
                    if (!this.scanner.get(ind).equals("intg") && !this.scanner.get(ind).equals("quad") && !this.scanner.get(ind).equals("diff") && !this.scanner.get(ind).equals("root")) continue;
                    Bracket opener = new Bracket("(");
                    opener.setIndex(open);
                    Bracket closer = new Bracket(")");
                    closer.setIndex(i);
                    opener.setComplement(closer);
                    closer.setComplement(opener);
                    if (opener.simpleBracketPairHasVariables(this.scanner)) continue;
                    String fun = opener.getDomainContents(this.scanner);
                    while (fun.startsWith("(") && fun.endsWith(")")) {
                        fun = fun.substring(1);
                        fun = fun.substring(0, fun.length() - 1);
                        fun = fun.trim();
                    }
                    MathExpression f = new MathExpression(fun);
                    String val = f.solve();
                    this.scanner.add(open, val);
                    this.scanner.subList(open + 1, i + 2).clear();
                    continue;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }
    }

    public void codeModifier() {
        this.detectKeyOperators();
        this.statsVerifier();
        this.evaluateCompoundStructuresInStatisticalInput();
        this.unBracketDataSetReturningStatsOperators();
        UnaryPostOperator.assignCompoundTokens(this.scanner);
        PowerOperator.assignCompoundTokens(this.scanner);
        if (this.correctFunction) {
            int i;
            for (i = 0; i < this.scanner.size(); ++i) {
                try {
                    if (!Operator.isBinaryOperator(this.scanner.get(i)) && !Method.isUnaryPreOperatorORDefinedMethod(this.scanner.get(i)) && !Operator.isOpeningBracket(this.scanner.get(i)) && !Operator.isLogicOperator(this.scanner.get(i)) && !Operator.isAssignmentOperator(this.scanner.get(i)) && !Operator.isComma(this.scanner.get(i)) && !Method.isStatsMethod(this.scanner.get(i)) || !Operator.isPlusOrMinus(this.scanner.get(i + 1)) || !Number.isNumber(this.scanner.get(i + 2))) continue;
                    this.utility.append(this.scanner.get(i + 1));
                    this.utility.append(this.scanner.get(i + 2));
                    this.scanner.set(i + 1, this.utility.toString());
                    this.scanner.set(i + 2, "");
                    this.utility.delete(0, this.utility.length());
                    continue;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
            this.scanner.removeAll(this.whitespaceremover);
            for (i = 0; i < this.scanner.size(); ++i) {
                try {
                    if ((Number.isNumber(this.scanner.get(i)) || Variable.isVariableString(this.scanner.get(i)) && !Method.isDefinedMethod(this.scanner.get(i))) && (Method.isUnaryPreOperatorORDefinedMethod(this.scanner.get(i + 1)) || Method.isNumberReturningStatsMethod(this.scanner.get(i + 1)) || Method.isLogOrAntiLogToAnyBase(this.scanner.get(i + 1)))) {
                        int j = i + 1;
                        while (Method.isUnaryPreOperatorORDefinedMethod(this.scanner.get(j)) || Method.isNumberReturningStatsMethod(this.scanner.get(j)) || Method.isLogOrAntiLogToAnyBase(this.scanner.get(j))) {
                            ++j;
                        }
                        if (Number.isNumber(this.scanner.get(j)) || Variable.isVariableString(this.scanner.get(j))) {
                            this.scanner.add(j + 1, ")");
                            this.scanner.add(i, "(");
                            this.scanner.add(i + 2, "*");
                        } else if (Operator.isOpeningBracket(this.scanner.get(j))) {
                            int ind = Bracket.getComplementIndex(true, j, this.scanner);
                            this.scanner.add(ind + 1, ")");
                            this.scanner.add(i, "(");
                            this.scanner.add(i + 2, "*");
                        }
                    }
                }
                catch (IndexOutOfBoundsException j) {
                    // empty catch block
                }
                try {
                    if (Method.isUnaryPreOperatorORDefinedMethod(this.scanner.get(i - 1)) && Operator.isPlusOrMinus(this.scanner.get(i)) && Operator.isOpeningBracket(this.scanner.get(i + 1))) {
                        if (this.scanner.get(i).equals("-")) {
                            List<String> subList = this.scanner.subList(i - 1, Bracket.getComplementIndex(true, i + 1, this.scanner) + 1);
                            subList.set(1, "(");
                            subList.add(2, "-1");
                            subList.add(3, "*");
                            subList.add(")");
                        } else if (this.scanner.get(i).equals("+")) {
                            this.scanner.set(i, "");
                        }
                    }
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
                try {
                    if (!Operator.isOpeningBracket(this.scanner.get(i - 1)) || !Operator.isPlusOrMinus(this.scanner.get(i)) || !Method.isUnaryPreOperatorORDefinedMethod(this.scanner.get(i + 1))) continue;
                    if (this.scanner.get(i).equals("-")) {
                        this.scanner.set(i, "-1");
                        this.scanner.add(i + 1, "*");
                        continue;
                    }
                    if (!this.scanner.get(i).equals("+")) continue;
                    this.scanner.set(i, "");
                    continue;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
            this.scanner.removeAll(this.whitespaceremover);
        } else if (!this.correctFunction) {
            // empty if block
        }
        this.detectKeyOperators();
    }

    public void detectKeyOperators() {
        for (int i = 0; i < this.scanner.size(); ++i) {
            if (Operator.isPlusOrMinus(this.scanner.get(i))) {
                this.setHasPlusOrMinusOperators(true);
                continue;
            }
            if (Operator.isUnaryPreOperator(this.scanner.get(i))) {
                this.setHasPreNumberOperators(true);
                continue;
            }
            if (Operator.isUnaryPostOperator(this.scanner.get(i))) {
                this.setHasPostNumberOperators(true);
                continue;
            }
            if (Operator.isMulOrDiv(this.scanner.get(i))) {
                this.setHasMulOrDivOperators(true);
                continue;
            }
            if (Operator.isPermOrComb(this.scanner.get(i))) {
                this.setHasPermOrCombOperators(true);
                continue;
            }
            if (Operator.isRemainder(this.scanner.get(i))) {
                this.setHasRemainderOperators(true);
                continue;
            }
            if (Method.isNumberReturningStatsMethod(this.scanner.get(i))) {
                this.setHasNumberReturningStatsOperators(true);
                continue;
            }
            if (Operator.isPower(this.scanner.get(i))) {
                this.setHasPowerOperators(true);
                continue;
            }
            if (!Operator.isLogicOperator(this.scanner.get(i))) continue;
            this.setHasLogicOperators(true);
        }
    }

    public static Bracket[] mapBrackets(ArrayList<String> scanner) {
        ArrayList<String> whiteSpaceRemover = new ArrayList<String>();
        whiteSpaceRemover.add(" ");
        scanner.removeAll(whiteSpaceRemover);
        ArrayList<Bracket> bracs = new ArrayList<Bracket>();
        ArrayList<String> scan = new ArrayList<String>();
        scan.addAll(scanner);
        int open = 0;
        int close = scan.indexOf(")");
        int i = 0;
        while (close != -1) {
            try {
                open = LISTS.prevIndexOf(scan, close, "(");
                Bracket openBrac = new Bracket("(");
                Bracket closeBrac = new Bracket(")");
                openBrac.setIndex(open);
                closeBrac.setIndex(close);
                openBrac.setComplement(closeBrac);
                closeBrac.setComplement(openBrac);
                bracs.add(openBrac);
                bracs.add(closeBrac);
                scan.set(open, "");
                scan.set(close, "");
                close = scan.indexOf(")");
                ++i;
            }
            catch (IndexOutOfBoundsException ind) {
                // empty catch block
                break;
            }
        }
        if (scan.indexOf("(") == -1 && scan.indexOf(")") == -1) {
            int size = bracs.size();
            Bracket[] bracket = new Bracket[size];
            return bracs.toArray(bracket);
        }
        throw new InputMismatchException("SYNTAX ERROR!");
    }

    public void mapBrackets() {
        try {
            this.setBracket(MathExpression.mapBrackets(this.scanner));
        }
        catch (InputMismatchException ime) {
            this.parser_Result = Parser_Result.PARENTHESES_ERROR;
            this.setCorrectFunction(false);
            this.scanner.clear();
        }
    }

    public void functionComponentsAssociation() {
        if (this.correctFunction) {
            this.scanner.removeAll(this.whitespaceremover);
            for (int i = 0; i < this.scanner.size(); ++i) {
                String token = this.scanner.get(i);
                if (!Variable.isVariableString(this.scanner.get(i)) || Method.isUserDefinedFunction(token)) continue;
                try {
                    if (!(Operator.isOpeningBracket(this.scanner.get(i - 1)) || Operator.isLogicOperator(this.scanner.get(i - 1)) || Operator.isUnaryPreOperator(this.scanner.get(i - 1)) || Operator.isBinaryOperator(this.scanner.get(i - 1)) || Operator.isAssignmentOperator(this.scanner.get(i - 1)) || Number.isNumber(this.scanner.get(i - 1)) || Variable.isVariableString(this.scanner.get(i - 1)))) {
                        this.correctFunction = false;
                        this.scanner.clear();
                        break;
                    }
                    if (Operator.isBracket(this.scanner.get(i + 1)) || Operator.isBinaryOperator(this.scanner.get(i + 1)) || Operator.isUnaryPostOperator(this.scanner.get(i + 1)) || Method.isNumberReturningStatsMethod(this.scanner.get(i + 1)) || Operator.isLogicOperator(this.scanner.get(i + 1)) || Operator.isAssignmentOperator(this.scanner.get(i + 1)) || Operator.isUnaryPreOperator(this.scanner.get(i + 1)) || Method.isNumberReturningStatsMethod(this.scanner.get(i + 1)) || Method.isLogToAnyBase(this.scanner.get(i + 1)) || Method.isAntiLogToAnyBase(this.scanner.get(i + 1)) || Number.isNumber(this.scanner.get(i + 1)) || Variable.isVariableString(this.scanner.get(i + 1))) continue;
                    this.correctFunction = false;
                    this.scanner.clear();
                    break;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
            if (this.correctFunction) {
                this.setCorrectFunction(Operator.validateAll(this.scanner));
            }
            if (this.correctFunction) {
                this.scanner.removeAll(this.whitespaceremover);
            } else {
                this.scanner.clear();
                this.bracket = null;
                this.parser_Result = Parser_Result.SYNTAX_ERROR;
            }
        } else {
            this.scanner.clear();
            this.bracket = null;
            this.parser_Result = Parser_Result.SYNTAX_ERROR;
        }
    }

    public void setVariableValuesInFunction(ArrayList<String> scan) {
        int sz = scan.size();
        for (int i = 0; i < sz; ++i) {
            String varName = scan.get(i);
            try {
                Variable v;
                if (i + 1 < sz) {
                    if (!Variable.isVariableString(scan.get(i)) || Operator.isOpeningBracket(scan.get(i + 1)) || (v = VariableManager.lookUp(varName)) == null) continue;
                    scan.set(i, v.getValue());
                    continue;
                }
                if (!Variable.isVariableString(scan.get(i)) || (v = VariableManager.lookUp(varName)) == null) continue;
                scan.set(i, v.getValue());
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    public String getValue(String name) throws NullPointerException {
        Variable var = VariableManager.lookUp(name);
        return var == null ? null : var.getValue();
    }

    public void setValue(String name, String value) throws NullPointerException, NumberFormatException {
        Variable v = VariableManager.lookUp(name);
        if (v != null) {
            v.setValue(value);
        }
    }

    protected void modifyBracketIndices(Bracket[] brac, int startPosition, int increment, boolean run) {
        if (run) {
            int valAtBracIndex = 0;
            int valAtLastEvaluatedBracIndex = 0;
            if (startPosition > 0) {
                valAtLastEvaluatedBracIndex = brac[startPosition - 2].getIndex();
                for (int i = startPosition; i < brac.length; ++i) {
                    valAtBracIndex = brac[i].getIndex();
                    try {
                        if (valAtBracIndex <= valAtLastEvaluatedBracIndex) continue;
                        brac[i].setIndex(brac[i].getIndex() + increment);
                        continue;
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                }
                ArrayList<Integer> arr = new ArrayList<Integer>();
                for (int i = 0; i < brac.length; ++i) {
                    arr.add(brac[i].getIndex());
                }
            }
        }
    }

    private void displayIndicesStoredInBrackets() {
        ArrayList<Integer> arr = new ArrayList<Integer>();
        int size = this.bracket.length;
        for (int i = 0; i < size; ++i) {
            arr.add(this.bracket[i].getIndex());
        }
    }

    protected String listToString(ArrayList<String> scan) {
        String str = String.valueOf(scan);
        str = str.substring(1);
        str = str.substring(0, str.length() - 1);
        return str;
    }

    protected Bracket[] copyArrayToArray() {
        int size = this.bracket.length;
        Bracket[] obj = new Bracket[size];
        if (this.bracket != null) {
            for (int i = 0; i < size; ++i) {
                obj[i] = this.bracket[i].createTwinBracket();
            }
        } else {
            throw new NullPointerException("Null List Cannot Be Copied");
        }
        return obj;
    }

    public void setReturnType(TYPE returnType) {
        this.returnType = returnType;
    }

    public TYPE getReturnType() {
        return this.returnType;
    }

    public String solve() {
        if (this.correctFunction && !this.hasFunctionOrVariableInitStatement) {
            ArrayList<String> myScan = new ArrayList<String>();
            myScan.addAll(this.scanner);
            Bracket[] brac = MathExpression.mapBrackets(myScan);
            int indexOpenInMyScan = 0;
            int indexCloseInMyScan = 0;
            this.setVariableValuesInFunction(myScan);
            String listAppender = "";
            while (brac.length > 0 && this.correctFunction) {
                try {
                    block36: {
                        indexOpenInMyScan = brac[0].getIndex();
                        indexCloseInMyScan = brac[1].getIndex();
                        boolean isMethod = false;
                        List<String> executable = null;
                        try {
                            isMethod = Method.isMethodName(myScan.get(indexOpenInMyScan - 1));
                        }
                        catch (IndexOutOfBoundsException indexErr) {
                            isMethod = false;
                        }
                        try {
                            executable = myScan.subList(indexOpenInMyScan, indexCloseInMyScan + 1);
                        }
                        catch (IndexOutOfBoundsException indexErr) {
                            // empty catch block
                        }
                        if (!isMethod) {
                            this.solve(executable);
                        } else if (isMethod) {
                            try {
                                executable = myScan.subList(indexOpenInMyScan - 1, indexCloseInMyScan + 1);
                                if (Method.isStatsMethod(executable.get(0))) {
                                    if (!Method.isUserDefinedFunction(executable.get(0))) {
                                        Method.run(executable, this.DRG);
                                        break block36;
                                    }
                                    if (!Method.isUserDefinedFunction(executable.get(0))) break block36;
                                    Function f = FunctionManager.lookUp(executable.get(0));
                                    if (f.getIndependentVariables().size() <= 1) {
                                        this.solve(executable.subList(1, executable.size()));
                                        executable.add(")");
                                        executable.add(1, "(");
                                        Method.run(executable, this.DRG);
                                    } else {
                                        Method.run(executable, this.DRG);
                                    }
                                    break block36;
                                }
                                this.solve(executable.subList(1, executable.size()));
                                executable.add(")");
                                executable.add(1, "(");
                                Method.run(executable, this.DRG);
                            }
                            catch (IndexOutOfBoundsException indexErr) {
                                break;
                            }
                            catch (IllegalArgumentException ill) {
                                return "SYNTAX ERROR";
                            }
                            catch (NullPointerException nolException) {
                                break;
                            }
                        }
                    }
                    brac = MathExpression.mapBrackets(myScan);
                }
                catch (IndexOutOfBoundsException indexErr) {
                    indexErr.printStackTrace();
                    return "SYNTAX ERROR";
                }
                catch (NumberFormatException numErr) {
                    numErr.printStackTrace();
                    return "SYNTAX ERROR";
                }
                catch (InputMismatchException exception) {
                    exception.printStackTrace();
                    return "SYNTAX ERROR";
                }
            }
            if ((listAppender = this.listToString(myScan)).startsWith("(")) {
                listAppender = listAppender.substring(1);
                if (Operator.isComma((listAppender = listAppender.substring(0, listAppender.length() - 1)).substring(0, 1))) {
                    listAppender = listAppender.replace(",", "");
                }
            }
            if (Number.validNumber(listAppender)) {
                this.returnType = TYPE.NUMBER;
            } else if (listAppender.contains(",")) {
                this.returnType = TYPE.STRING;
            }
            Function f = FunctionManager.lookUp(listAppender);
            if (f != null) {
                if (f.getType() == 2) {
                    listAppender = f.getMatrix().toString();
                    this.returnType = TYPE.MATRIX;
                } else if (f.getType() == 3) {
                    listAppender = f.toString();
                    this.returnType = TYPE.LIST;
                } else if (f.getType() == 1) {
                    this.returnType = TYPE.ALGEBRAIC_EXPRESSION;
                    listAppender = f.toString();
                }
            }
            if (this.correctFunction) {
                lastResult = listAppender;
            } else {
                listAppender = "A SYNTAX ERROR OCCURED";
                this.correctFunction = true;
            }
            if (myScan.size() == 1) {
                this.returnObjectName = myScan.get(0);
            }
            return listAppender;
        }
        if (this.hasFunctionOrVariableInitStatement) {
            return "Variable Storage Process Finished!";
        }
        return "SYNTAX ERROR";
    }

    public List<String> solve(List<String> list) {
        int i;
        if (list.get(0).equals("(") && list.get(1).equals("-") && Number.isNumber(list.get(2))) {
            list.set(1, "");
            if (list.get(2).substring(0, 1).equals("-")) {
                list.set(2, list.get(2).substring(1));
            } else {
                list.set(2, "-" + list.get(2));
            }
        }
        ArrayList<String> real = new ArrayList<String>();
        real.add("");
        real.add("(");
        real.add(")");
        list.removeAll(real);
        if (this.isHasPostNumberOperators()) {
            for (i = 0; i < list.size(); ++i) {
                try {
                    if (Operator.isFactorial(list.get(i + 1))) {
                        if (Number.isNumber(list.get(i))) {
                            list.set(i + 1, Maths.fact(list.get(i)));
                            list.set(i, "");
                            continue;
                        }
                        if (!list.get(i).equals("Infinity")) continue;
                        list.set(i + 1, "Infinity");
                        list.set(i, "");
                        continue;
                    }
                    if (Operator.isSquare(list.get(i + 1))) {
                        if (Number.isNumber(list.get(i))) {
                            list.set(i + 1, String.valueOf(Math.pow(Double.valueOf(list.get(i)), 2.0)));
                            list.set(i, "");
                            continue;
                        }
                        if (!list.get(i).equals("Infinity")) continue;
                        list.set(i + 1, "Infinity");
                        list.set(i, "");
                        continue;
                    }
                    if (Operator.isCube(list.get(i + 1))) {
                        if (Number.isNumber(list.get(i))) {
                            list.set(i + 1, String.valueOf(Math.pow(Double.valueOf(list.get(i)), 3.0)));
                            list.set(i, "");
                            continue;
                        }
                        if (!list.get(i).equals("Infinity")) continue;
                        list.set(i + 1, "Infinity");
                        list.set(i, "");
                        continue;
                    }
                    if (!Operator.isInverse(list.get(i + 1))) continue;
                    if (Number.isNumber(list.get(i))) {
                        list.set(i + 1, String.valueOf(1.0 / Double.valueOf(list.get(i))));
                        list.set(i, "");
                        continue;
                    }
                    if (!list.get(i).equals("Infinity")) continue;
                    list.set(i + 1, "0.0");
                    list.set(i, "");
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    continue;
                }
                catch (NullPointerException nullPointerException) {
                    continue;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
            list.removeAll(real);
        }
        if (this.isHasPowerOperators()) {
            for (i = 0; i < list.size(); ++i) {
                try {
                    if (!list.get(i - 1).equals("Infinity") && !list.get(i + 1).equals("Infinity")) {
                        if (!list.get(i).equals("^") || !Number.isNumber(list.get(i - 1)) || !Number.isNumber(list.get(i + 1))) continue;
                        list.set(i + 1, String.valueOf(Math.pow(Double.valueOf(list.get(i - 1)), Double.valueOf(list.get(i + 1)))));
                        list.set(i - 1, "");
                        list.set(i, "");
                        continue;
                    }
                    if (list.get(i - 1).equals("Infinity") && !list.get(i + 1).equals("Infinity")) {
                        if (Double.valueOf(list.get(i + 1)) > 1.0) {
                            list.set(i + 1, "Infinity");
                            list.set(i - 1, "");
                            list.set(i, "");
                            continue;
                        }
                        if (Double.valueOf(list.get(i + 1)) == 1.0) {
                            list.set(i + 1, "Infinity");
                            list.set(i - 1, "");
                            list.set(i, "");
                            continue;
                        }
                        if (Double.valueOf(list.get(i + 1)) < 1.0 && Double.valueOf(list.get(i + 1)) > 0.0) {
                            list.set(i + 1, "Infinity");
                            list.set(i - 1, "");
                            list.set(i, "");
                            continue;
                        }
                        if (Double.valueOf(list.get(i + 1)) < 1.0 && Double.valueOf(list.get(i + 1)) == 0.0) {
                            list.set(i + 1, "1.0");
                            list.set(i - 1, "");
                            list.set(i, "");
                            continue;
                        }
                        if (!(Double.valueOf(list.get(i + 1)) < 1.0) || !(Double.valueOf(list.get(i + 1)) < 0.0)) continue;
                        list.set(i + 1, "0.0");
                        list.set(i - 1, "");
                        list.set(i, "");
                        continue;
                    }
                    if (!list.get(i - 1).equals("Infinity") && list.get(i + 1).equals("Infinity")) {
                        if (Double.valueOf(list.get(i - 1)) > 1.0) {
                            list.set(i + 1, "Infinity");
                            list.set(i - 1, "");
                            list.set(i, "");
                            continue;
                        }
                        if (Double.valueOf(list.get(i - 1)) == 1.0) {
                            list.set(i + 1, "1.0");
                            list.set(i - 1, "");
                            list.set(i, "");
                            continue;
                        }
                        if (Double.valueOf(list.get(i - 1)) < 1.0 && Double.valueOf(list.get(i - 1)) > 0.0) {
                            list.set(i + 1, "0.0");
                            list.set(i - 1, "");
                            list.set(i, "");
                            continue;
                        }
                        if (Double.valueOf(list.get(i - 1)) < 1.0 && Double.valueOf(list.get(i - 1)) == 0.0) {
                            list.set(i + 1, "0.0");
                            list.set(i - 1, "");
                            list.set(i, "");
                            continue;
                        }
                        if (!(Double.valueOf(list.get(i - 1)) < 1.0) || !(Double.valueOf(list.get(i - 1)) < 0.0)) continue;
                        list.set(i + 1, "Infinity");
                        list.set(i - 1, "");
                        list.set(i, "");
                        continue;
                    }
                    if (!list.get(i - 1).equals("Infinity") || !list.get(i + 1).equals("Infinity")) continue;
                    list.set(i + 1, "Infinity");
                    list.set(i - 1, "");
                    list.set(i, "");
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    continue;
                }
                catch (NullPointerException nullPointerException) {
                    continue;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
            list.removeAll(real);
        }
        if (this.isHasPreNumberOperators()) {
            for (i = list.size() - 1; i >= 0; --i) {
                try {
                    if (!list.get(i + 1).equals("Infinity") && Number.isNumber(list.get(i + 1))) {
                        if (list.get(i).equals("\u221a")) {
                            list.set(i, String.valueOf(Math.sqrt(Double.valueOf(list.get(i + 1)))));
                            list.set(i + 1, "");
                        }
                        if (!list.get(i).equals("\u00b3\u221a")) continue;
                        list.set(i, String.valueOf(Math.cbrt(Double.valueOf(list.get(i + 1)))));
                        list.set(i + 1, "");
                        continue;
                    }
                    if (!list.get(i + 1).equals("Infinity")) continue;
                    list.set(i, "Infinity");
                    list.set(i + 1, "");
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    continue;
                }
                catch (NullPointerException nullPointerException) {
                    continue;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }
        list.removeAll(real);
        if (this.isHasPowerOperators()) {
            for (i = 0; i < list.size(); ++i) {
                try {
                    if (!list.get(i - 1).equals("Infinity") && !list.get(i + 1).equals("Infinity")) {
                        if (!list.get(i).equals("^") || !Number.isNumber(list.get(i - 1)) || !Number.isNumber(list.get(i + 1))) continue;
                        list.set(i + 1, String.valueOf(Math.pow(Double.valueOf(list.get(i - 1)), Double.valueOf(list.get(i + 1)))));
                        list.set(i - 1, "");
                        list.set(i, "");
                        continue;
                    }
                    if (list.get(i - 1).equals("Infinity") && !list.get(i + 1).equals("Infinity")) {
                        if (Double.valueOf(list.get(i + 1)) > 1.0) {
                            list.set(i + 1, "Infinity");
                            list.set(i - 1, "");
                            list.set(i, "");
                            continue;
                        }
                        if (Double.valueOf(list.get(i + 1)) == 1.0) {
                            list.set(i + 1, "Infinity");
                            list.set(i - 1, "");
                            list.set(i, "");
                            continue;
                        }
                        if (Double.valueOf(list.get(i + 1)) < 1.0 && Double.valueOf(list.get(i + 1)) > 0.0) {
                            list.set(i + 1, "Infinity");
                            list.set(i - 1, "");
                            list.set(i, "");
                            continue;
                        }
                        if (Double.valueOf(list.get(i + 1)) < 1.0 && Double.valueOf(list.get(i + 1)) == 0.0) {
                            list.set(i + 1, "1.0");
                            list.set(i - 1, "");
                            list.set(i, "");
                            continue;
                        }
                        if (!(Double.valueOf(list.get(i + 1)) < 1.0) || !(Double.valueOf(list.get(i + 1)) < 0.0)) continue;
                        list.set(i + 1, "0.0");
                        list.set(i - 1, "");
                        list.set(i, "");
                        continue;
                    }
                    if (!list.get(i - 1).equals("Infinity") && list.get(i + 1).equals("Infinity")) {
                        if (Double.valueOf(list.get(i - 1)) > 1.0) {
                            list.set(i + 1, "Infinity");
                            list.set(i - 1, "");
                            list.set(i, "");
                            continue;
                        }
                        if (Double.valueOf(list.get(i - 1)) == 1.0) {
                            list.set(i + 1, "1.0");
                            list.set(i - 1, "");
                            list.set(i, "");
                            continue;
                        }
                        if (Double.valueOf(list.get(i - 1)) < 1.0 && Double.valueOf(list.get(i - 1)) > 0.0) {
                            list.set(i + 1, "0.0");
                            list.set(i - 1, "");
                            list.set(i, "");
                            continue;
                        }
                        if (Double.valueOf(list.get(i - 1)) < 1.0 && Double.valueOf(list.get(i - 1)) == 0.0) {
                            list.set(i + 1, "0.0");
                            list.set(i - 1, "");
                            list.set(i, "");
                            continue;
                        }
                        if (!(Double.valueOf(list.get(i - 1)) < 1.0) || !(Double.valueOf(list.get(i - 1)) < 0.0)) continue;
                        list.set(i + 1, "Infinity");
                        list.set(i - 1, "");
                        list.set(i, "");
                        continue;
                    }
                    if (!list.get(i - 1).equals("Infinity") || !list.get(i + 1).equals("Infinity")) continue;
                    list.set(i + 1, "Infinity");
                    list.set(i - 1, "");
                    list.set(i, "");
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    continue;
                }
                catch (NullPointerException nullPointerException) {
                    continue;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
            list.removeAll(real);
        }
        list.removeAll(real);
        if (this.isHasPermOrCombOperators()) {
            for (i = 0; i < list.size(); ++i) {
                try {
                    if (list.get(i).equals("\u0420")) {
                        if (!list.get(i - 1).equals("Infinity") && !list.get(i + 1).equals("Infinity")) {
                            list.set(i + 1, String.valueOf(Double.valueOf(Maths.fact(list.get(i - 1))) / Double.valueOf(Maths.fact(String.valueOf(Double.valueOf(list.get(i - 1)) - Double.valueOf(list.get(i + 1)))))));
                            list.set(i - 1, "");
                            list.set(i, "");
                            continue;
                        }
                        if (list.get(i - 1).equals("Infinity") && !list.get(i + 1).equals("Infinity")) {
                            list.set(i + 1, "Infinity");
                            list.set(i - 1, "");
                            list.set(i, "");
                            continue;
                        }
                        if (!list.get(i - 1).equals("Infinity") && list.get(i + 1).equals("Infinity")) {
                            list.set(i + 1, "Infinity");
                            list.set(i - 1, "");
                            list.set(i, "");
                            continue;
                        }
                        if (!list.get(i - 1).equals("Infinity") || !list.get(i + 1).equals("Infinity")) continue;
                        list.set(i + 1, "Infinity");
                        list.set(i - 1, "");
                        list.set(i, "");
                        continue;
                    }
                    if (!list.get(i).equals("\u010c")) continue;
                    if (!list.get(i - 1).equals("Infinity") && !list.get(i + 1).equals("Infinity")) {
                        list.set(i + 1, String.valueOf(Double.valueOf(Maths.fact(list.get(i - 1))) / (Double.valueOf(Maths.fact(String.valueOf(Double.valueOf(list.get(i - 1)) - Double.valueOf(list.get(i + 1))))) * Double.valueOf(Maths.fact(list.get(i + 1))))));
                        list.set(i - 1, "");
                        list.set(i, "");
                        continue;
                    }
                    if (list.get(i - 1).equals("Infinity") && !list.get(i + 1).equals("Infinity")) {
                        list.set(i + 1, "Infinity");
                        list.set(i - 1, "");
                        list.set(i, "");
                        continue;
                    }
                    if (!list.get(i - 1).equals("Infinity") && list.get(i + 1).equals("Infinity")) {
                        list.set(i + 1, "Infinity");
                        list.set(i - 1, "");
                        list.set(i, "");
                        continue;
                    }
                    if (!list.get(i - 1).equals("Infinity") || !list.get(i + 1).equals("Infinity")) continue;
                    list.set(i + 1, "Infinity");
                    list.set(i - 1, "");
                    list.set(i, "");
                    continue;
                }
                catch (NullPointerException nullPointerException) {
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    continue;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
            list.removeAll(real);
        }
        boolean skip = false;
        if (this.isHasMulOrDivOperators() || this.isHasRemainderOperators() || this.isHasLogicOperators()) {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                try {
                    if (list.get(i2).equals("*")) {
                        if (!list.get(i2 - 1).equals("Infinity") && !list.get(i2 + 1).equals("Infinity")) {
                            list.set(i2 + 1, String.valueOf(Double.valueOf(list.get(i2 - 1)) * Double.valueOf(list.get(i2 + 1))));
                            list.set(i2 - 1, "");
                            list.set(i2, "");
                            skip = true;
                        } else if (list.get(i2 - 1).equals("Infinity") && !list.get(i2 + 1).equals("Infinity")) {
                            list.set(i2 + 1, "Infinity");
                            list.set(i2 - 1, "");
                            list.set(i2, "");
                            skip = true;
                        } else if (!list.get(i2 - 1).equals("Infinity") && list.get(i2 + 1).equals("Infinity")) {
                            list.set(i2 + 1, "Infinity");
                            list.set(i2 - 1, "");
                            list.set(i2, "");
                            skip = true;
                        } else if (list.get(i2 - 1).equals("Infinity") && list.get(i2 + 1).equals("Infinity")) {
                            list.set(i2 + 1, "Infinity");
                            list.set(i2 - 1, "");
                            list.set(i2, "");
                            skip = true;
                        }
                    } else if (list.get(i2).equals("/")) {
                        if (!list.get(i2 - 1).equals("Infinity") && !list.get(i2 + 1).equals("Infinity")) {
                            list.set(i2 + 1, String.valueOf(Double.valueOf(list.get(i2 - 1)) / Double.valueOf(list.get(i2 + 1))));
                            list.set(i2 - 1, "");
                            list.set(i2, "");
                            skip = true;
                        } else if (list.get(i2 - 1).equals("Infinity") && !list.get(i2 + 1).equals("Infinity")) {
                            list.set(i2 + 1, "Infinity");
                            list.set(i2 - 1, "");
                            list.set(i2, "");
                            skip = true;
                        } else if (!list.get(i2 - 1).equals("Infinity") && list.get(i2 + 1).equals("Infinity")) {
                            list.set(i2 + 1, "0.0");
                            list.set(i2 - 1, "");
                            list.set(i2, "");
                            skip = true;
                        } else if (list.get(i2 - 1).equals("Infinity") && list.get(i2 + 1).equals("Infinity")) {
                            list.set(i2 + 1, "Infinity");
                            list.set(i2 - 1, "");
                            list.set(i2, "");
                            skip = true;
                        }
                    } else if (list.get(i2).equals("%")) {
                        if (!list.get(i2 - 1).equals("Infinity") && !list.get(i2 + 1).equals("Infinity")) {
                            list.set(i2 + 1, String.valueOf(Double.valueOf(list.get(i2 - 1)) % Double.valueOf(list.get(i2 + 1))));
                            list.set(i2 - 1, "");
                            list.set(i2, "");
                            skip = true;
                        } else if (list.get(i2 - 1).equals("Infinity") && !list.get(i2 + 1).equals("Infinity")) {
                            list.set(i2 + 1, "Infinity");
                            list.set(i2 - 1, "");
                            list.set(i2, "");
                            skip = true;
                        } else if (!list.get(i2 - 1).equals("Infinity") && list.get(i2 + 1).equals("Infinity")) {
                            list.set(i2 + 1, list.get(i2 - 1));
                            list.set(i2 - 1, "");
                            list.set(i2, "");
                            skip = true;
                        } else if (list.get(i2 - 1).equals("Infinity") && list.get(i2 + 1).equals("Infinity")) {
                            list.set(i2 + 1, "Infinity");
                            list.set(i2 - 1, "");
                            list.set(i2, "");
                            skip = true;
                        }
                    }
                }
                catch (NullPointerException nullPointerException) {
                }
                catch (NumberFormatException numberFormatException) {
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
                if (skip) continue;
                try {
                    if (list.get(i2).equals("==")) {
                        if (!list.get(i2 - 1).equals("Infinity") && !list.get(i2 + 1).equals("Infinity")) {
                            list.set(i2 + 1, String.valueOf(Double.valueOf(list.get(i2 - 1)) - Double.valueOf(list.get(i2 + 1)) == 0.0));
                            list.set(i2 - 1, "");
                            list.set(i2, "");
                        } else if (list.get(i2 - 1).equals("Infinity") && !list.get(i2 + 1).equals("Infinity")) {
                            list.set(i2 + 1, "false");
                            list.set(i2 - 1, "");
                            list.set(i2, "");
                        } else if (!list.get(i2 - 1).equals("Infinity") && list.get(i2 + 1).equals("Infinity")) {
                            list.set(i2 + 1, "false");
                            list.set(i2 - 1, "");
                            list.set(i2, "");
                        } else if (list.get(i2 - 1).equals("Infinity") && list.get(i2 + 1).equals("Infinity")) {
                            list.set(i2 + 1, "true");
                            list.set(i2 - 1, "");
                            list.set(i2, "");
                        }
                    }
                }
                catch (NullPointerException nullPointerException) {
                }
                catch (NumberFormatException numberFormatException) {
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
                try {
                    if (list.get(i2).equals(">")) {
                        if (!list.get(i2 - 1).equals("Infinity") && !list.get(i2 + 1).equals("Infinity")) {
                            list.set(i2 + 1, String.valueOf(Double.valueOf(list.get(i2 - 1)) - Double.valueOf(list.get(i2 + 1)) > 0.0));
                            list.set(i2 - 1, "");
                            list.set(i2, "");
                        } else if (list.get(i2 - 1).equals("Infinity") && !list.get(i2 + 1).equals("Infinity")) {
                            list.set(i2 + 1, "true");
                            list.set(i2 - 1, "");
                            list.set(i2, "");
                        } else if (!list.get(i2 - 1).equals("Infinity") && list.get(i2 + 1).equals("Infinity")) {
                            list.set(i2 + 1, "false");
                            list.set(i2 - 1, "");
                            list.set(i2, "");
                        } else if (list.get(i2 - 1).equals("Infinity") && list.get(i2 + 1).equals("Infinity")) {
                            list.set(i2 + 1, "true");
                            list.set(i2 - 1, "");
                            list.set(i2, "");
                        }
                    }
                }
                catch (NullPointerException nullPointerException) {
                }
                catch (NumberFormatException numberFormatException) {
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
                try {
                    if (list.get(i2).equals("\u2265")) {
                        if (!list.get(i2 - 1).equals("Infinity") && !list.get(i2 + 1).equals("Infinity")) {
                            list.set(i2 + 1, String.valueOf(Double.valueOf(list.get(i2 - 1)) - Double.valueOf(list.get(i2 + 1)) >= 0.0));
                            list.set(i2 - 1, "");
                            list.set(i2, "");
                        } else if (list.get(i2 - 1).equals("Infinity") && !list.get(i2 + 1).equals("Infinity")) {
                            list.set(i2 + 1, "true");
                            list.set(i2 - 1, "");
                            list.set(i2, "");
                        } else if (!list.get(i2 - 1).equals("Infinity") && list.get(i2 + 1).equals("Infinity")) {
                            list.set(i2 + 1, "false");
                            list.set(i2 - 1, "");
                            list.set(i2, "");
                        } else if (list.get(i2 - 1).equals("Infinity") && list.get(i2 + 1).equals("Infinity")) {
                            list.set(i2 + 1, "true");
                            list.set(i2 - 1, "");
                            list.set(i2, "");
                        }
                    }
                }
                catch (NullPointerException nullPointerException) {
                }
                catch (NumberFormatException numberFormatException) {
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
                try {
                    if (list.get(i2).equals("<")) {
                        if (!list.get(i2 - 1).equals("Infinity") && !list.get(i2 + 1).equals("Infinity")) {
                            list.set(i2 + 1, String.valueOf(Double.valueOf(list.get(i2 - 1)) - Double.valueOf(list.get(i2 + 1)) < 0.0));
                            list.set(i2 - 1, "");
                            list.set(i2, "");
                        } else if (list.get(i2 - 1).equals("Infinity") && !list.get(i2 + 1).equals("Infinity")) {
                            list.set(i2 + 1, "false");
                            list.set(i2 - 1, "");
                            list.set(i2, "");
                        } else if (!list.get(i2 - 1).equals("Infinity") && list.get(i2 + 1).equals("Infinity")) {
                            list.set(i2 + 1, "true");
                            list.set(i2 - 1, "");
                            list.set(i2, "");
                        } else if (list.get(i2 - 1).equals("Infinity") && list.get(i2 + 1).equals("Infinity")) {
                            list.set(i2 + 1, "true");
                            list.set(i2 - 1, "");
                            list.set(i2, "");
                        }
                    }
                }
                catch (NullPointerException nullPointerException) {
                }
                catch (NumberFormatException numberFormatException) {
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
                try {
                    if (!list.get(i2).equals("\u2264")) continue;
                    if (!list.get(i2 - 1).equals("Infinity") && !list.get(i2 + 1).equals("Infinity")) {
                        list.set(i2 + 1, String.valueOf(Double.valueOf(list.get(i2 - 1)) - Double.valueOf(list.get(i2 + 1)) <= 0.0));
                        list.set(i2 - 1, "");
                        list.set(i2, "");
                        continue;
                    }
                    if (list.get(i2 - 1).equals("Infinity") && !list.get(i2 + 1).equals("Infinity")) {
                        list.set(i2 + 1, "false");
                        list.set(i2 - 1, "");
                        list.set(i2, "");
                        continue;
                    }
                    if (!list.get(i2 - 1).equals("Infinity") && list.get(i2 + 1).equals("Infinity")) {
                        list.set(i2 + 1, "true");
                        list.set(i2 - 1, "");
                        list.set(i2, "");
                        continue;
                    }
                    if (!list.get(i2 - 1).equals("Infinity") || !list.get(i2 + 1).equals("Infinity")) continue;
                    list.set(i2 + 1, "true");
                    list.set(i2 - 1, "");
                    list.set(i2, "");
                    continue;
                }
                catch (NullPointerException nullPointerException) {
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    continue;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
            list.removeAll(real);
        }
        if (this.isHasPlusOrMinusOperators()) {
            for (int i3 = 0; i3 < list.size(); ++i3) {
                try {
                    if (!list.get(i3).equals("+") && !list.get(i3).equals("-")) continue;
                    if (!list.get(i3 - 1).equals("Infinity") && !list.get(i3 + 1).equals("Infinity")) {
                        if (list.get(i3).equals("+") && Number.isNumber(list.get(i3 - 1)) && Number.isNumber(list.get(i3 + 1))) {
                            list.set(i3 + 1, String.valueOf(Double.valueOf(list.get(i3 - 1)) + Double.valueOf(list.get(i3 + 1))));
                            list.set(i3 - 1, "");
                            list.set(i3, "");
                            continue;
                        }
                        if (!list.get(i3).equals("-") || !Number.isNumber(list.get(i3 - 1)) || !Number.isNumber(list.get(i3 + 1))) continue;
                        list.set(i3 + 1, String.valueOf(Double.valueOf(list.get(i3 - 1)) - Double.valueOf(list.get(i3 + 1))));
                        list.set(i3 - 1, "");
                        list.set(i3, "");
                        continue;
                    }
                    list.set(i3 + 1, "Infinity");
                    list.set(i3 - 1, "");
                    list.set(i3, "");
                    continue;
                }
                catch (NullPointerException nullPointerException) {
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    continue;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }
        real.add("(");
        real.add(")");
        list.removeAll(real);
        if (list.size() != 1) {
            this.parser_Result = this.parser_Result == Parser_Result.VALID ? Parser_Result.SYNTAX_ERROR : this.parser_Result;
            this.correctFunction = false;
            list.clear();
            list.add(this.parser_Result.name());
        }
        return list;
    }

    public List<String> solveSubPortions(List<String> scanner) {
        scanner.add(0, "(");
        scanner.add(")");
        int passes = 0;
        int i = 0;
        int j = 0;
        while (scanner.size() > 1) {
            ++passes;
            try {
                i = scanner.indexOf(")");
                j = LISTS.prevIndexOf(scanner, i, "(");
                List<String> sub = scanner.subList(j, i + 1);
                this.solve(sub);
            }
            catch (IndexOutOfBoundsException indexerr) {
                break;
            }
        }
        return scanner;
    }

    private static void junkExamples() {
        FunctionManager.add("M=@(3,3)(3,4,1,2,4,7,9,1,-2)");
        FunctionManager.add("M1=@(2,2)(3,4,1,2)");
        FunctionManager.add("M2=@(2,2)(3,4,1,2)");
        FunctionManager.add("N=@(x)(sin(x))");
        FunctionManager.add("r=@(x)(ln(sin(x)))");
        System.out.println("lookup M: " + FunctionManager.lookUp("M"));
        MathExpression expr = new MathExpression("r1=4;r1*5");
        System.out.println("scanner: " + expr.scanner);
        System.out.println("solution: " + expr.solve());
        expr.setExpression("44+22*(3)");
        System.out.println("solution--: " + expr.solve());
        System.out.println("return type: " + (Object)((Object)expr.returnType));
        System.out.println("FunctionManager: " + FunctionManager.FUNCTIONS);
        System.out.println("VariableManager: " + VariableManager.VARIABLES);
        MathExpression expression = new MathExpression("x=0;sin(ln(x))");
        for (int i = 0; i < 100000; ++i) {
            expression.setValue("x", i + "");
            System.out.println(expression.solve());
        }
        System.out.println(">>> Finished.");
        Function f = FunctionManager.lookUp("N");
        double start = System.nanoTime();
        double iterations = 100.0;
        int i = 0;
        while ((double)i < iterations) {
            f.calc(i + 3);
            ++i;
        }
        double elapsedNanos = ((double)System.nanoTime() - start) / iterations;
        System.out.println("DONE: " + elapsedNanos / 1000000.0 + " ms");
        MathExpression ex = new MathExpression("det(1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5)");
        System.out.println(ex.solve());
    }

    public static void main(String[] args) {
        MathExpression.junkExamples();
    }
}

