/*
 * Decompiled with CFR 0.152.
 */
package math.tartaglia;

import java.util.ArrayList;
import math.differentialcalculus.Formula;
import parser.CustomScanner;
import parser.LISTS;
import parser.MathScanner;
import parser.Number;
import parser.Operator;
import parser.STRING;
import parser.Variable;

public class TartagliaExpressionParser {
    private String expression = "";
    private ArrayList<String> scanner = new ArrayList();
    private boolean valid = true;
    private ArrayList<String> vars = new ArrayList();
    private final ArrayList<Double> coefficients = new ArrayList();

    public TartagliaExpressionParser(String expression) {
        int i;
        expression = STRING.purifier(expression);
        String LHS = expression.substring(0, expression.indexOf("="));
        String RHS = expression.substring(1 + expression.indexOf("="));
        ArrayList<String> scanLHS = new MathScanner(LHS).scanner();
        Formula.simplify(scanLHS);
        ArrayList<String> scanRHS = new MathScanner(RHS).scanner();
        Formula.simplify(scanRHS);
        scanLHS.add("=");
        scanLHS.addAll(scanRHS);
        expression = LISTS.createStringFrom(scanLHS, 0, scanLHS.size());
        expression = expression.replace("*", "");
        if (Variable.isVariableString(expression.substring(0, 1))) {
            expression = "1.0" + expression;
        }
        for (i = 0; i < expression.length(); ++i) {
            String s = expression.substring(i, i + 1);
            if (s.equals(" ") || s.equals("\n")) continue;
            this.expression = this.expression + s;
        }
        this.plusAndMinusStringHandler();
        this.scan();
        for (i = 0; i < this.scanner.size(); ++i) {
            try {
                MathScanner scan;
                ArrayList<String> split;
                if (this.scanner.get(i).equals("+") || this.scanner.get(i).equals("-") || this.scanner.get(i).equals("=") || this.scanner.get(i).equals(";") || Number.validNumber(this.scanner.get(i)) || Variable.isVariableString(this.scanner.get(i)) || !Number.validNumber((split = (scan = new MathScanner(this.scanner.get(i))).splitStringAtFirstNumber(this.scanner.get(i))).get(0)) || !Variable.isVariableString(split.get(1))) continue;
                this.scanner.remove(i);
                this.scanner.addAll(i, split);
                i += 2;
                continue;
            }
            catch (IndexOutOfBoundsException indexErr) {
                break;
            }
        }
        for (i = 0; i < this.scanner.size(); ++i) {
            try {
                if (!Variable.isVariableString(this.scanner.get(i - 1)) && Operator.isPower(this.scanner.get(i)) && !Number.validNumber(this.scanner.get(i + 1))) {
                    this.setValid(false);
                    break;
                }
                if (Variable.isVariableString(this.scanner.get(i - 1)) && Operator.isPower(this.scanner.get(i)) && !Number.validNumber(this.scanner.get(i + 1))) {
                    this.setValid(false);
                    break;
                }
                if (!Variable.isVariableString(this.scanner.get(i - 1)) && Operator.isPower(this.scanner.get(i)) && Number.validNumber(this.scanner.get(i + 1))) {
                    this.setValid(false);
                    break;
                }
                if (Variable.isVariableString(this.scanner.get(i - 1)) && Operator.isPower(this.scanner.get(i)) && Number.validNumber(this.scanner.get(i + 1)) && Double.valueOf(this.scanner.get(i + 1)) != 0.0 && Double.valueOf(this.scanner.get(i + 1)) != 1.0 && Double.valueOf(this.scanner.get(i + 1)) != 3.0) {
                    this.setValid(false);
                    break;
                }
                if (!Variable.isVariableString(this.scanner.get(i - 1)) || !Operator.isPower(this.scanner.get(i)) || !Number.validNumber(this.scanner.get(i + 1)) || Double.valueOf(this.scanner.get(i + 1)) != 0.0 && Double.valueOf(this.scanner.get(i + 1)) != 1.0 && Double.valueOf(this.scanner.get(i + 1)) != 3.0) continue;
                if (Double.valueOf(this.scanner.get(i + 1)) == 0.0) {
                    this.scanner.set(i - 1, "");
                    this.scanner.set(i, "");
                    this.scanner.set(i + 1, "");
                    continue;
                }
                if (Double.valueOf(this.scanner.get(i + 1)) == 1.0) {
                    this.scanner.set(i, "");
                    this.scanner.set(i + 1, "");
                    continue;
                }
                if (Double.valueOf(this.scanner.get(i + 1)) != 3.0) continue;
                this.scanner.set(i, "\u00b3");
                this.scanner.set(i + 1, "");
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        this.freeWhiteSpaces();
        this.appendOneToStartOfFreeVariables();
        this.validateAll();
        this.recognizeNegativesAndPositives();
        this.recognizeCompoundVariables();
        try {
            this.scanner.add(0, "+");
            this.scanner.add(0, "0");
            this.scanner.add(0, "+");
            this.scanner.add(0, this.vars.get(1));
            this.scanner.add(0, "0");
            this.scanner.add(0, "+");
            this.scanner.add(0, this.vars.get(0));
            this.scanner.add(0, "0");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.doArithmetic();
    }

    public ArrayList<Double> getCoefficients() {
        return this.coefficients;
    }

    public void freeWhiteSpaces() {
        ArrayList<String> purify = new ArrayList<String>();
        purify.add("");
        purify.add(" ");
        this.scanner.removeAll(purify);
    }

    public void setValid(boolean valid) {
        this.valid = valid;
        if (!valid) {
            this.scanner.clear();
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setScanner(ArrayList<String> scanner) {
        this.scanner = scanner;
    }

    public ArrayList<String> getScanner() {
        return this.scanner;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public String getExpression() {
        return this.expression;
    }

    private void plusAndMinusStringHandler() {
        int size = this.expression.length();
        for (int i = 0; i < size; ++i) {
            try {
                if (this.expression.substring(i, i + 1).equals("-") && this.expression.substring(i + 1, i + 2).equals("+")) {
                    this.expression = STRING.replace(this.expression, " -", i, i + 2);
                    continue;
                }
                if (this.expression.substring(i, i + 1).equals("+") && this.expression.substring(i + 1, i + 2).equals("-")) {
                    this.expression = STRING.replace(this.expression, " -", i, i + 2);
                    continue;
                }
                if (this.expression.substring(i, i + 1).equals("+") && this.expression.substring(i + 1, i + 2).equals("+")) {
                    this.expression = STRING.replace(this.expression, " +", i, i + 2);
                    continue;
                }
                if (!this.expression.substring(i, i + 1).equals("-") || !this.expression.substring(i + 1, i + 2).equals("-")) continue;
                this.expression = STRING.replace(this.expression, " +", i, i + 2);
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    private int indexOfLetter(String input) {
        int sz = input.length();
        for (int i = 0; i < sz; ++i) {
            if (!STRING.isLetter(input.substring(i, i + 1))) continue;
            return i;
        }
        return -1;
    }

    private boolean startsWithDigitOrPoint(String input) {
        String st = input.substring(0, 1);
        return STRING.isDigit(st) || st.equals(".");
    }

    private boolean startsWithLetter(String input) {
        String st = input.substring(0, 1);
        return STRING.isLetter(st);
    }

    private void scan() {
        String st;
        int i;
        ArrayList<String> remover = new ArrayList<String>();
        remover.add("");
        CustomScanner cs = new CustomScanner(this.expression, true, "*", "+", "-", "^", "=");
        this.scanner = (ArrayList)cs.scan();
        for (i = 0; i < this.scanner.size(); ++i) {
            String part2;
            String part12;
            st = this.scanner.get(i);
            int ind = this.indexOfLetter(this.scanner.get(i));
            if (ind == -1) continue;
            if (this.startsWithDigitOrPoint(st)) {
                try {
                    part12 = st.substring(0, ind);
                    part2 = st.substring(ind);
                    this.scanner.set(i, part12);
                    this.scanner.add(i + 1, part2);
                }
                catch (IndexOutOfBoundsException part12) {}
                continue;
            }
            if (!this.startsWithLetter(st) || !st.substring(0, 1).equalsIgnoreCase("E")) continue;
            try {
                part12 = st.substring(0, 1);
                part2 = st.substring(1);
                this.scanner.set(i, part12);
                this.scanner.add(i + 1, part2);
                continue;
            }
            catch (IndexOutOfBoundsException part13) {
                // empty catch block
            }
        }
        this.scanner.removeAll(remover);
        for (i = 0; i < this.scanner.size(); ++i) {
            try {
                st = this.scanner.get(i);
                if (!st.equalsIgnoreCase("E")) continue;
                String st1 = this.scanner.get(i - 1);
                String st2 = this.scanner.get(i + 1);
                String st3 = this.scanner.get(i + 2);
                String st4 = this.scanner.get(i + 3);
                String st5 = this.scanner.get(i + 4);
                if (Number.validNumber(st1) && Operator.isPlusOrMinus(st2) && Number.validNumber(st3) && Variable.isVariableString(st4) && (Operator.isPlusOrMinus(st5) || st5.equals("="))) {
                    st = st1.concat(st);
                    st = st.concat(st2);
                    st = st.concat(st3);
                    this.scanner.set(i - 1, st);
                    this.scanner.subList(i, i + 3).clear();
                    continue;
                }
                if (!Number.validNumber(st1) || !Number.validNumber(st2) || !Variable.isVariableString(st3) || !Operator.isPlusOrMinus(st4) && !st4.equals("=")) continue;
                st = st1.concat(st + "+");
                st = st.concat(st2);
                this.scanner.set(i - 1, st);
                this.scanner.subList(i, i + 2).clear();
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        remover.add("");
        remover.add("(");
        remover.add(")");
        remover.add("*");
        this.scanner.removeAll(remover);
    }

    public void appendOneToStartOfFreeVariables() {
        for (int i = 0; i < this.scanner.size(); ++i) {
            try {
                if (!Variable.isVariableString(this.scanner.get(i)) || Number.validNumber(this.scanner.get(i - 1))) continue;
                this.scanner.add(i, "1.0");
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    public void validateEqualsSymbol() {
        int count = 0;
        for (int i = 0; i < this.scanner.size(); ++i) {
            if (Operator.isAssignmentOperator(this.scanner.get(i))) {
                ++count;
            }
            if (count <= 1) continue;
            this.setValid(false);
            break;
        }
        if (count < 1) {
            this.setValid(false);
        }
    }

    public void validateChars() {
        for (int i = 0; i < this.scanner.size(); ++i) {
            try {
                if (Operator.isCube(this.scanner.get(i)) || Number.validNumber(this.scanner.get(i)) || Variable.isVariableString(this.scanner.get(i)) || Operator.isAssignmentOperator(this.scanner.get(i)) || this.scanner.get(i).equals("+") || this.scanner.get(i).equals("-")) continue;
                this.setValid(false);
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    public void validateVars() {
        for (int i = 0; i < this.scanner.size(); ++i) {
            try {
                if (!Variable.isVariableString(this.scanner.get(i))) continue;
                if (!Number.validNumber(this.scanner.get(i - 1))) {
                    this.setValid(false);
                }
                if (Operator.isCube(this.scanner.get(i + 1)) || this.scanner.get(i + 1).equals("+") || this.scanner.get(i + 1).equals("-") || Operator.isAssignmentOperator(this.scanner.get(i + 1))) continue;
                this.setValid(false);
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    public void validateNumbers() {
        for (int i = 0; i < this.scanner.size(); ++i) {
            try {
                if (!Number.validNumber(this.scanner.get(i))) continue;
                if (!(this.scanner.get(i - 1).equals("+") || this.scanner.get(i - 1).equals("-") || this.scanner.get(i - 1).equals("="))) {
                    this.setValid(false);
                }
                if (Variable.isVariableString(this.scanner.get(i + 1)) || Operator.isAssignmentOperator(this.scanner.get(i + 1)) || this.scanner.get(i + 1).equals("+") || this.scanner.get(i + 1).equals("-")) continue;
                this.setValid(false);
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    private void validateAll() {
        this.validateEqualsSymbol();
        this.validateChars();
        this.validateVars();
        this.validateNumbers();
    }

    public void recognizeNegativesAndPositives() {
        for (int i = 0; i < this.scanner.size(); ++i) {
            try {
                if (!this.scanner.get(i).equals("-") && !this.scanner.get(i).equals("+")) continue;
                if (i == 0 && Number.validNumber(this.scanner.get(i + 1))) {
                    this.scanner.set(i + 1, this.scanner.get(i) + this.scanner.get(i + 1));
                    this.scanner.set(i, "");
                    continue;
                }
                if (!Operator.isAssignmentOperator(this.scanner.get(i - 1))) continue;
                this.scanner.set(i + 1, this.scanner.get(i) + this.scanner.get(i + 1));
                this.scanner.set(i, "");
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        this.freeWhiteSpaces();
    }

    public void recognizeCompoundVariables() {
        for (int i = 0; i < this.scanner.size(); ++i) {
            try {
                if (!Variable.isVariableString(this.scanner.get(i)) || !Operator.isCube(this.scanner.get(i + 1))) continue;
                if (!this.vars.contains(this.scanner.get(i))) {
                    this.vars.add(this.scanner.get(i) + "\u00b3");
                    this.vars.add(this.scanner.get(i));
                }
                this.scanner.set(i, this.scanner.get(i) + this.scanner.get(i + 1));
                this.scanner.set(i + 1, "");
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        this.freeWhiteSpaces();
    }

    public String getUnknown() {
        return this.vars.get(1);
    }

    public void doArithmetic() {
        ArrayList<Double> coeffs = new ArrayList<Double>();
        coeffs.add(0.0);
        coeffs.add(0.0);
        coeffs.add(0.0);
        for (int j = 0; j < 2; ++j) {
            for (int i = 0; i < this.scanner.size(); ++i) {
                try {
                    if (this.vars.get(j).equals(this.scanner.get(i))) {
                        if (j == 0) {
                            if (i < this.scanner.indexOf("=")) {
                                if (this.scanner.get(i - 2).equals("-")) {
                                    coeffs.set(0, (Double)coeffs.get(0) + -Double.parseDouble(this.scanner.get(i - 1)));
                                    continue;
                                }
                                if (this.scanner.get(i - 2).equals("-")) continue;
                                coeffs.set(0, (Double)coeffs.get(0) + Double.parseDouble(this.scanner.get(i - 1)));
                                continue;
                            }
                            if (i <= this.scanner.indexOf("=")) continue;
                            if (this.scanner.get(i - 2).equals("-")) {
                                coeffs.set(0, (Double)coeffs.get(0) - -Double.parseDouble(this.scanner.get(i - 1)));
                                continue;
                            }
                            if (this.scanner.get(i - 2).equals("-")) continue;
                            coeffs.set(0, (Double)coeffs.get(0) - Double.parseDouble(this.scanner.get(i - 1)));
                            continue;
                        }
                        if (j != 1) continue;
                        if (i < this.scanner.indexOf("=")) {
                            if (this.scanner.get(i - 2).equals("-")) {
                                coeffs.set(1, (Double)coeffs.get(1) + -Double.parseDouble(this.scanner.get(i - 1)));
                                continue;
                            }
                            if (this.scanner.get(i - 2).equals("-")) continue;
                            coeffs.set(1, (Double)coeffs.get(1) + Double.parseDouble(this.scanner.get(i - 1)));
                            continue;
                        }
                        if (i <= this.scanner.indexOf("=")) continue;
                        if (this.scanner.get(i - 2).equals("-")) {
                            coeffs.set(1, (Double)coeffs.get(1) - -Double.parseDouble(this.scanner.get(i - 1)));
                            continue;
                        }
                        if (this.scanner.get(i - 2).equals("-")) continue;
                        coeffs.set(1, (Double)coeffs.get(1) - Double.parseDouble(this.scanner.get(i - 1)));
                        continue;
                    }
                    if (i == this.scanner.size() - 1 && Number.validNumber(this.scanner.get(i))) {
                        if (j != 1) continue;
                        if (this.scanner.get(i - 1).equals("-")) {
                            coeffs.set(2, (Double)coeffs.get(2) - -Double.parseDouble(this.scanner.get(i)));
                            continue;
                        }
                        if (this.scanner.get(i - 1).equals("-")) continue;
                        coeffs.set(2, (Double)coeffs.get(2) - Double.parseDouble(this.scanner.get(i)));
                        continue;
                    }
                    if (!Number.validNumber(this.scanner.get(i)) || this.scanner.get(i + 1).equals(this.vars.get(0)) || this.scanner.get(i + 1).equals(this.vars.get(1)) || j != 1) continue;
                    if (i < this.scanner.indexOf("=")) {
                        if (this.scanner.get(i - 1).equals("-")) {
                            coeffs.set(2, (Double)coeffs.get(2) + -Double.parseDouble(this.scanner.get(i)));
                            continue;
                        }
                        if (this.scanner.get(i - 1).equals("-")) continue;
                        coeffs.set(2, (Double)coeffs.get(2) + Double.parseDouble(this.scanner.get(i)));
                        continue;
                    }
                    if (i <= this.scanner.indexOf("=")) continue;
                    if (this.scanner.get(i - 1).equals("-")) {
                        coeffs.set(2, (Double)coeffs.get(2) - -Double.parseDouble(this.scanner.get(i)));
                        continue;
                    }
                    if (this.scanner.get(i - 1).equals("-")) continue;
                    coeffs.set(2, (Double)coeffs.get(2) - Double.parseDouble(this.scanner.get(i)));
                    continue;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }
        this.coefficients.addAll(coeffs);
    }

    public String interpretedSystem() {
        String eval = "";
        try {
            eval = this.coefficients.get(0) + this.vars.get(0) + "+" + this.coefficients.get(1) + this.vars.get(1) + "+" + this.coefficients.get(2) + " = 0.0";
            eval = eval.replace("+-", "-");
            eval = eval.replace("-+", "-");
            eval = eval.replace("+=", " =");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return eval;
    }

    public static void main(String[] args) {
        TartagliaExpressionParser parser = new TartagliaExpressionParser("3x-5x^3=-9x-9x^3+2");
        System.out.println(parser.interpretedSystem());
        System.out.println(parser.scanner);
    }
}

