/*
 * Decompiled with CFR 0.152.
 */
package math.matrix.expressParser;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Random;
import java.util.Scanner;
import math.matrix.expressParser.MatrixValueParser;
import util.Utils;

public class PrecisionMatrix {
    private String name;
    private BigDecimal[][] array;
    private static BigDecimal det = BigDecimal.ZERO;

    public PrecisionMatrix(int rows, int cols) {
        this("NEW");
        this.array = new BigDecimal[rows][cols];
    }

    public PrecisionMatrix(String name) {
        this.name = name;
        this.array = new BigDecimal[][]{{new BigDecimal("0.0")}};
    }

    public PrecisionMatrix(BigDecimal[][] array) {
        this("NEW");
        this.setArray(array);
    }

    public PrecisionMatrix(PrecisionMatrix matrix) {
        this("NEW");
        BigDecimal[][] arr = new BigDecimal[matrix.getRows()][matrix.getCols()];
        for (int row = 0; row < matrix.getRows(); ++row) {
            for (int col = 0; col < matrix.getCols(); ++col) {
                BigDecimal val;
                arr[row][col] = val = matrix.array[row][col];
            }
        }
        this.array = arr;
    }

    public int getRows() {
        return this.array.length;
    }

    public int getCols() {
        return this.array[0].length;
    }

    public void setArray(BigDecimal[][] array) {
        if (array.length > 0) {
            this.array = new BigDecimal[array.length][array[0].length];
            for (int row = 0; row < array.length; ++row) {
                for (int col = 0; col < array[0].length; ++col) {
                    this.array[row][col] = array[row][col];
                }
            }
        } else {
            this.array = new BigDecimal[][]{{new BigDecimal("0")}, {new BigDecimal("0")}};
        }
    }

    public BigDecimal[][] getArray() {
        return this.array;
    }

    private static void setDet(BigDecimal det) {
        PrecisionMatrix.det = det;
    }

    private static BigDecimal getDet() {
        return det;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void fill() {
        Scanner scanner = new Scanner(System.in);
        for (int row = 0; row < this.getRows(); ++row) {
            for (int column = 0; column < this.getCols(); ++column) {
                this.array[row][column] = scanner.nextBigDecimal();
            }
        }
    }

    public void randomFill() {
        Random ran = new Random();
        for (int row = 0; row < this.getRows(); ++row) {
            for (int col = 0; col < this.getCols(); ++col) {
                this.array[row][col] = new BigDecimal("1.0").add(new BigDecimal(String.valueOf(ran.nextInt(101))));
            }
        }
    }

    public void randomFill(int n) {
        Random ran = new Random();
        for (int row = 0; row < this.getRows(); ++row) {
            for (int col = 0; col < this.getCols(); ++col) {
                this.array[row][col] = BigDecimal.valueOf(1 + ran.nextInt(n));
            }
        }
    }

    public PrecisionMatrix add(PrecisionMatrix matrice) {
        BigDecimal[][] array1 = matrice.array;
        BigDecimal[][] matrix = new BigDecimal[this.getRows()][this.getCols()];
        if (this.getRows() == matrice.getCols() && this.getCols() == matrice.getRows()) {
            for (int row = 0; row < this.getRows(); ++row) {
                for (int column = 0; column < this.getCols(); ++column) {
                    matrix[row][column] = this.array[row][column].add(array1[row][column]);
                }
            }
        } else {
            Utils.logError("ERROR IN MATRIX INPUT!!");
        }
        return new PrecisionMatrix(matrix);
    }

    public PrecisionMatrix subtract(PrecisionMatrix matrice) {
        BigDecimal[][] array1 = matrice.array;
        BigDecimal[][] matrix = new BigDecimal[this.getRows()][this.getCols()];
        if (this.getRows() == matrice.getCols() && this.getCols() == matrice.getRows()) {
            for (int row = 0; row < this.getRows(); ++row) {
                for (int column = 0; column < this.getCols(); ++column) {
                    matrix[row][column] = this.array[row][column].subtract(array1[row][column]);
                }
            }
        } else {
            Utils.logError("ERROR IN MATRIX INPUT!!");
        }
        return new PrecisionMatrix(matrix);
    }

    public PrecisionMatrix scalarMultiply(double scalar) {
        BigDecimal scale = new BigDecimal(String.valueOf(scalar));
        BigDecimal[][] matrix = new BigDecimal[this.getRows()][this.getCols()];
        for (int row = 0; row < this.getRows(); ++row) {
            for (int column = 0; column < this.getCols(); ++column) {
                matrix[row][column] = this.array[row][column].multiply(scale, MathContext.DECIMAL128);
            }
        }
        return new PrecisionMatrix(matrix);
    }

    public PrecisionMatrix scalarDivide(double scalar) {
        BigDecimal scale = new BigDecimal(String.valueOf(scalar));
        BigDecimal[][] matrix = new BigDecimal[this.getRows()][this.getCols()];
        for (int row = 0; row < this.getRows(); ++row) {
            for (int column = 0; column < this.getCols(); ++column) {
                matrix[row][column] = this.array[row][column].divide(scale, MathContext.DECIMAL128);
            }
        }
        return new PrecisionMatrix(matrix);
    }

    public static PrecisionMatrix multiply(PrecisionMatrix matrice1, PrecisionMatrix matrice2) {
        PrecisionMatrix m = new PrecisionMatrix(matrice1.getRows(), matrice2.getCols());
        if (matrice1.getCols() == matrice2.getRows()) {
            for (int i = 0; i < matrice1.getRows(); ++i) {
                for (int row = 0; row < matrice2.getCols(); ++row) {
                    BigDecimal sum = new BigDecimal("0");
                    for (int column = 0; column < matrice1.getCols(); ++column) {
                        sum = sum.add(matrice1.array[i][column].multiply(matrice2.array[column][row], MathContext.DECIMAL128));
                    }
                    m.array[i][row] = sum;
                }
            }
        } else {
            Utils.logError("ERROR IN MATRIX INPUT!!");
        }
        return m;
    }

    public void multiply(PrecisionMatrix matrice) {
        this.setArray(PrecisionMatrix.multiply((PrecisionMatrix)this, (PrecisionMatrix)matrice).array);
    }

    public static PrecisionMatrix pow(PrecisionMatrix mat, int pow) {
        BigDecimal[][] matrix = new BigDecimal[mat.getRows()][mat.getCols()];
        PrecisionMatrix m = new PrecisionMatrix(mat.array);
        for (int i = 0; i < pow - 1; ++i) {
            m = PrecisionMatrix.multiply(m, mat);
        }
        return m;
    }

    public PrecisionMatrix unitMatrix() {
        BigDecimal[][] matrix = new BigDecimal[this.getRows()][this.getCols()];
        for (int row = 0; row < this.getRows(); ++row) {
            for (int column = 0; column < this.getCols(); ++column) {
                matrix[row][column] = column == row ? new BigDecimal("1") : new BigDecimal("0");
            }
        }
        return new PrecisionMatrix(matrix);
    }

    public static PrecisionMatrix unitMatrix(int rowSize, int colSize) {
        BigDecimal[][] matrix = new BigDecimal[rowSize][colSize];
        for (int row = 0; row < rowSize; ++row) {
            for (int column = 0; column < colSize; ++column) {
                matrix[row][column] = column == row ? BigDecimal.ONE : BigDecimal.ZERO;
            }
        }
        return new PrecisionMatrix(matrix);
    }

    public static PrecisionMatrix unitMatrix(PrecisionMatrix mat) {
        int rowSize = mat.getRows();
        int colSize = mat.getCols();
        BigDecimal[][] matrix = new BigDecimal[rowSize][colSize];
        for (int row = 0; row < rowSize; ++row) {
            for (int column = 0; column < colSize; ++column) {
                matrix[row][column] = column == row ? BigDecimal.ONE : BigDecimal.ZERO;
            }
        }
        return new PrecisionMatrix(matrix);
    }

    public static PrecisionMatrix columnJoin(PrecisionMatrix mat1, PrecisionMatrix mat2) {
        PrecisionMatrix join = new PrecisionMatrix(mat1.getRows(), mat1.getCols() + mat2.getCols());
        if (mat1.getRows() == mat2.getRows()) {
            int columnextender = 0;
            for (int row = 0; row < mat1.getRows(); ++row) {
                for (int col = 0; col < join.getCols(); ++col) {
                    if (col < mat1.getCols()) {
                        columnextender = 0;
                        join.array[row][col] = mat1.array[row][col];
                        continue;
                    }
                    if (col < mat1.getCols()) continue;
                    join.array[row][col] = mat2.array[row][columnextender];
                    ++columnextender;
                }
            }
        }
        return join;
    }

    public void update(BigDecimal value, int row, int column) {
        if (row < this.getRows() && column < this.getCols()) {
            this.array[row][column] = value;
        }
    }

    public static PrecisionMatrix rowJoin(PrecisionMatrix mat1, PrecisionMatrix mat2) {
        PrecisionMatrix join = new PrecisionMatrix(mat1.getRows() + mat2.getRows(), mat1.getCols());
        if (mat1.getCols() == mat2.getCols()) {
            int rowextender = 0;
            for (int row = 0; row < join.getRows(); ++row) {
                for (int col = 0; col < join.getCols(); ++col) {
                    if (row < mat1.getRows()) {
                        join.array[row][col] = mat1.array[row][col];
                        continue;
                    }
                    if (row < mat1.getRows()) continue;
                    join.array[row][col] = mat2.array[rowextender][col];
                }
                if (row < mat1.getRows()) continue;
                ++rowextender;
            }
        }
        return join;
    }

    public void columnDeleteFromEnd(int column) {
        if (column >= 0 && column <= this.getCols()) {
            PrecisionMatrix matrix = new PrecisionMatrix(this.getRows(), this.getCols() - column);
            for (int row = 0; row < this.getRows(); ++row) {
                for (int col = 0; col < matrix.getCols(); ++col) {
                    matrix.array[row][col] = this.array[row][col];
                }
            }
            this.setArray(matrix.array);
        } else {
            Utils.logError("COLUMN VALUE SHOULD RANGE FROM ZERO TO THE NUMBER OF COLUMNS IN THIS MATRIX.");
        }
    }

    public void columnDeleteFromStart(int column) {
        if (column >= 0 && column <= this.getCols()) {
            PrecisionMatrix matrix = new PrecisionMatrix(this.getRows(), this.getCols() - column);
            for (int row = 0; row < this.getRows(); ++row) {
                int counter = 0;
                int col = column;
                while (col < this.getCols()) {
                    matrix.array[row][counter] = this.array[row][col];
                    ++col;
                    ++counter;
                }
            }
            this.setArray(matrix.array);
        } else {
            Utils.logError("COLUMN VALUE SHOULD RANGE FROM ZERO TO THE NUMBER OF COLUMNS IN THIS MATRIX.");
        }
    }

    public void rowDeleteFromEnd(int numOfRows) {
        if (numOfRows >= 0 && numOfRows <= this.getRows()) {
            PrecisionMatrix matrix = new PrecisionMatrix(this.getRows() - numOfRows, this.getCols());
            for (int row = 0; row < matrix.getRows(); ++row) {
                for (int col = 0; col < this.getCols(); ++col) {
                    matrix.array[row][col] = this.array[row][col];
                }
            }
            this.setArray(matrix.array);
        } else {
            Utils.logError("NUMBER OF ROWS TO BE DELETED SHOULD RANGE FROM ZERO TO (AND INCLUDING) THE NUMBER OF ROWS IN THIS MATRIX.");
        }
    }

    public void rowDeleteFromStart(int numOfRows) {
        if (numOfRows >= 0 && numOfRows <= this.getRows()) {
            PrecisionMatrix matrix = new PrecisionMatrix(this.getRows() - numOfRows, this.getCols());
            int counter = 0;
            int row = numOfRows;
            while (row < this.getRows()) {
                for (int col = 0; col < this.getCols(); ++col) {
                    matrix.array[counter][col] = this.array[row][col];
                }
                ++row;
                ++counter;
            }
            this.setArray(matrix.array);
        } else {
            Utils.logError("NUMBER OF ROWS TO BE DELETED SHOULD RANGE FROM ZERO TO (AND INCLUDING) THE NUMBER OF ROWS IN THIS MATRIX.");
        }
    }

    public PrecisionMatrix reduceToTriangularMatrix() {
        PrecisionMatrix mat = new PrecisionMatrix(this);
        for (int j = 0; j < mat.getRows(); ++j) {
            for (int row = 0; row < mat.getRows(); ++row) {
                BigDecimal val = mat.array[row][row];
                for (int col = 0; col < mat.getCols(); ++col) {
                    mat.array[row][col] = mat.array[row][col].divide(val, MathContext.DECIMAL128);
                }
                for (int rowed = row + 1; rowed < mat.getRows(); ++rowed) {
                    BigDecimal mul = mat.array[rowed][row];
                    for (int coled = row; coled < mat.getCols(); ++coled) {
                        mat.array[rowed][coled] = mat.array[rowed][coled].subtract(mul.multiply(mat.array[row][coled], MathContext.UNLIMITED), MathContext.UNLIMITED);
                    }
                }
            }
        }
        return mat;
    }

    public PrecisionMatrix solveEquation() {
        return PrecisionMatrix.solveEquation(this);
    }

    public static PrecisionMatrix solveEquation(PrecisionMatrix matrix) {
        PrecisionMatrix solnMatrix = new PrecisionMatrix(matrix.getRows(), 1);
        PrecisionMatrix matrixLoader = matrix.reduceToTriangularMatrix();
        if (matrix.getRows() == matrix.getCols() - 1) {
            BigDecimal sum = BigDecimal.ZERO;
            int counter = 1;
            for (int row = matrixLoader.getRows() - 1; row >= 0; --row) {
                for (int col = row + 1; col < matrixLoader.getCols(); ++col) {
                    if (col < matrixLoader.getCols() - 1) {
                        sum = sum.add(matrixLoader.array[row][col].multiply(solnMatrix.array[col][0], MathContext.DECIMAL128), MathContext.DECIMAL128);
                        continue;
                    }
                    if (col != matrixLoader.getCols() - 1) continue;
                    sum = matrixLoader.array[row][col].subtract(sum, MathContext.DECIMAL128);
                }
                solnMatrix.array[matrixLoader.getRows() - counter][0] = sum.divide(matrixLoader.array[row][row], MathContext.UNLIMITED);
                ++counter;
                sum = BigDecimal.ZERO;
            }
        } else {
            throw new IndexOutOfBoundsException("Invalid System Of Linear Equations");
        }
        return solnMatrix;
    }

    public PrecisionMatrix transpose() {
        BigDecimal[][] matrix = new BigDecimal[this.getRows()][this.getCols()];
        for (int row = 0; row < this.getRows(); ++row) {
            for (int col = 0; col < this.getCols(); ++col) {
                matrix[row][col] = this.array[col][row];
            }
        }
        return new PrecisionMatrix(matrix);
    }

    public PrecisionMatrix minor(int i, int j) {
        BigDecimal[][] matrix = new BigDecimal[this.getRows() - 1][this.getCols() - 1];
        for (int row = 0; row < this.getRows(); ++row) {
            for (int column = 0; column < this.getCols(); ++column) {
                if (row < i && column < j) {
                    matrix[row][column] = this.array[row][column];
                    continue;
                }
                if (row < i && column > j) {
                    matrix[row][column - 1] = this.array[row][column];
                    continue;
                }
                if (row > i && column < j) {
                    matrix[row - 1][column] = this.array[row][column];
                    continue;
                }
                if (row <= i || column <= j) continue;
                matrix[row - 1][column - 1] = this.array[row][column];
            }
        }
        return new PrecisionMatrix(matrix);
    }

    public boolean isSquareMatrix() {
        return this.getRows() == this.getCols();
    }

    public boolean isSystemOfEquations() {
        return this.getRows() == this.getCols() - 1;
    }

    private static BigDecimal $2X2determinant(PrecisionMatrix m) {
        return m.array[0][0].multiply(m.array[1][1], MathContext.DECIMAL128).subtract(m.array[1][0].multiply(m.array[0][1], MathContext.DECIMAL128), MathContext.DECIMAL128);
    }

    private static PrecisionMatrix topRowScalarMultiply(PrecisionMatrix m, BigDecimal scalar) {
        for (int col = 0; col < m.getCols(); ++col) {
            m.array[0][col] = m.array[0][col].multiply(scalar, MathContext.DECIMAL128);
        }
        return new PrecisionMatrix(m.array);
    }

    public static void mdeterm() {
    }

    private static BigDecimal det(PrecisionMatrix m) {
        if (m.getRows() == m.getCols()) {
            if (m.getRows() == 2) {
                return PrecisionMatrix.$2X2determinant(m);
            }
            BigDecimal[] topRow = new BigDecimal[m.getRows()];
            PrecisionMatrix[] matrix = new PrecisionMatrix[m.getRows()];
            for (int col = 0; col < m.getCols(); ++col) {
                PrecisionMatrix mat;
                topRow[col] = m.array[0][col].multiply(BigDecimal.valueOf(Math.pow(-1.0, col)), MathContext.DECIMAL128);
                matrix[col] = mat = PrecisionMatrix.topRowScalarMultiply(m.minor(0, col), topRow[col]);
                if (matrix[col].getRows() > 2) {
                    PrecisionMatrix.det(matrix[col]);
                    continue;
                }
                det = det.add(PrecisionMatrix.$2X2determinant(matrix[col]), MathContext.DECIMAL128);
            }
            return det;
        }
        return BigDecimal.valueOf(Double.POSITIVE_INFINITY);
    }

    public BigDecimal determinant() {
        BigDecimal determinant = PrecisionMatrix.det(this);
        PrecisionMatrix.setDet(BigDecimal.ZERO);
        return determinant;
    }

    public static boolean isMatrixValue(String matrixValue) {
        MatrixValueParser matrixValueParser = new MatrixValueParser(matrixValue);
        boolean isValid = matrixValueParser.isValid();
        return isValid;
    }

    public PrecisionMatrix getRowMatrix(int row) {
        BigDecimal[][] arr = new BigDecimal[1][this.getCols()];
        for (int col = 0; col < this.getCols(); ++col) {
            arr[0][col] = this.array[row][col];
        }
        return new PrecisionMatrix(arr);
    }

    public PrecisionMatrix getColumnMatrix(int column) {
        BigDecimal[][] arr = new BigDecimal[this.getRows()][1];
        for (int row = 0; row < this.getRows(); ++row) {
            arr[row][0] = this.array[row][column];
        }
        return new PrecisionMatrix(arr);
    }

    public PrecisionMatrix inverse() {
        PrecisionMatrix m = new PrecisionMatrix(this);
        PrecisionMatrix unit = m.unitMatrix();
        PrecisionMatrix inverse = new PrecisionMatrix(new BigDecimal[m.getRows()][m.getCols()]);
        if (m.isSquareMatrix()) {
            for (int rows = 0; rows < m.getCols(); ++rows) {
                PrecisionMatrix c = PrecisionMatrix.columnJoin(m, unit.getColumnMatrix(rows));
                inverse = PrecisionMatrix.columnJoin(inverse, c.solveEquation());
            }
        }
        inverse.columnDeleteFromStart(m.getRows());
        return inverse;
    }

    public String toString() {
        String output = "\n";
        String appender = "";
        for (int row = 0; row < this.getRows(); ++row) {
            for (int column = 0; column < this.getCols(); ++column) {
                if (column < this.getCols()) {
                    appender = appender + String.format("%7s%3s", this.array[row][column], ",");
                }
                if (column == this.getCols() - 1) {
                    appender = appender.substring(0, appender.length() - 1);
                    appender = appender + "\n";
                }
                output = output + appender;
                appender = "";
            }
        }
        return output;
    }

    public static void main(String[] arg) {
        PrecisionMatrix m = new PrecisionMatrix(20, 21);
        m.randomFill(220);
        System.out.print(m);
        System.out.print(m.solveEquation());
    }
}

