/*
 * Decompiled with CFR 0.152.
 */
package math.matrix.expressParser;

import java.util.ArrayList;
import java.util.List;
import math.matrix.MatrixVariableManager;
import math.matrix.expressParser.MOperator;
import math.matrix.expressParser.MatrixVariable;
import parser.Number;
import parser.Operator;
import parser.STRING;
import parser.Variable;
import util.VariableManager;

public class MatrixExpressionScanner {
    private ArrayList<String> errorList = new ArrayList();
    private boolean runnable = true;
    private String scannerInput;
    private String delimiter = " ";
    private int firstVarIndex;
    private int firstOpIndex;
    private ArrayList<String> scanner = new ArrayList();

    public MatrixExpressionScanner(String scannerInput) {
        int i;
        for (i = 0; i < scannerInput.length(); ++i) {
            try {
                if ((STRING.isDigit(scannerInput.substring(i, i + 1)) || scannerInput.substring(i, i + 1).equals(".")) && scannerInput.substring(i + 1, i + 2).equals("E") && scannerInput.substring(i + 2, i + 3).equals("+") && STRING.isDigit(scannerInput.substring(i + 3, i + 4))) {
                    scannerInput = STRING.replace(scannerInput, "\u00b1", i + 2, i + 3);
                    continue;
                }
                if (!STRING.isDigit(scannerInput.substring(i, i + 1)) && !scannerInput.substring(i, i + 1).equals(".") || !scannerInput.substring(i + 1, i + 2).equals("E") || !scannerInput.substring(i + 2, i + 3).equals("-") || !STRING.isDigit(scannerInput.substring(i + 3, i + 4))) continue;
                scannerInput = STRING.replace(scannerInput, "\u2013", i + 2, i + 3);
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        for (i = 0; i < scannerInput.length(); ++i) {
            if (!scannerInput.substring(i, i + 1).equals(",") || !scannerInput.substring(i + 1, i + 2).equals("-") || !scannerInput.substring(i + 2, i + 3).equals(".") && !STRING.isDigit(scannerInput.substring(i + 2, i + 3))) continue;
            scannerInput = STRING.replace(scannerInput, "~", i + 1, i + 2);
        }
        this.scannerInput = scannerInput;
    }

    public void setScannerInput(String scannerInput) {
        this.scannerInput = scannerInput;
    }

    public String getScannerInput() {
        return this.scannerInput;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setFirstVarIndex(int firstVarIndex) {
        this.firstVarIndex = firstVarIndex;
    }

    public int getFirstVarIndex() {
        return this.firstVarIndex;
    }

    public void setScanner(ArrayList<String> scanner) {
        this.scanner = scanner;
    }

    public ArrayList<String> getScanner() {
        return this.scanner;
    }

    public void setFirstOpIndex(int firstOpIndex) {
        this.firstOpIndex = firstOpIndex;
    }

    public int getFirstOpIndex() {
        return this.firstOpIndex;
    }

    public void setRunnable(boolean runnable) {
        this.runnable = runnable;
    }

    public boolean isRunnable() {
        return this.runnable;
    }

    public void setErrorList(ArrayList<String> errorList) {
        this.errorList = errorList;
    }

    public ArrayList<String> getErrorList() {
        return this.errorList;
    }

    private void removeCommas() {
        ArrayList<String> commaList = new ArrayList<String>();
        commaList.add(",");
        this.scanner.removeAll(commaList);
    }

    public String getFirstVariableInString(String val) {
        String varString = "";
        int size = val.length();
        boolean found = false;
        for (int i = 0; i < size; ++i) {
            if (Variable.isVariableBeginner(val.substring(i, i + 1)) && !found) {
                varString = val.substring(i, i + 1);
                found = true;
                this.firstVarIndex = i;
                try {
                    if (Variable.isVariableBuilder(val.substring(i + 1, i + 2))) continue;
                    break;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    continue;
                }
            }
            if (!Variable.isVariableBuilder(val.substring(i, i + 1)) || !found) continue;
            varString = varString + val.substring(i, i + 1);
            try {
                if (Variable.isVariableBuilder(val.substring(i + 1, i + 2))) continue;
            }
            catch (IndexOutOfBoundsException indErr) {}
            break;
        }
        if (varString.equals("")) {
            this.firstVarIndex = -1;
        }
        return varString;
    }

    public int getIndexOfFirstVariable() {
        return this.firstVarIndex;
    }

    public ArrayList<String> splitStringOnVariables(String val) {
        ArrayList<String> split = new ArrayList<String>();
        ArrayList filter = new ArrayList();
        int varIndex = 2;
        String vars = "A";
        while (val.length() > 0) {
            try {
                vars = this.getFirstVariableInString(val);
                varIndex = this.getIndexOfFirstVariable();
                if (varIndex == 0) {
                    split.add(vars);
                    val = val.substring(varIndex + vars.length());
                } else {
                    if (varIndex == -1) {
                        split.add(val);
                        val = "";
                        break;
                    }
                    split.add(val.substring(0, varIndex));
                    split.add(vars);
                    val = val.substring(varIndex + vars.length());
                }
                if (!vars.equals("")) continue;
                split.add(val);
            }
            catch (IndexOutOfBoundsException indErr) {
                split.add(val);
                val = "";
                break;
            }
        }
        return split;
    }

    public String getFirstNumberSubstring(String val) throws StringIndexOutOfBoundsException {
        String num1 = "";
        String num2 = "";
        String point = "";
        String exp = "";
        String sign = "";
        String num3 = "";
        int plusCount = 0;
        int minusCount = 0;
        int expCount = 0;
        int pointCount = 0;
        int ind = STRING.getFirstIndexOfDigit(val);
        try {
            if (val.substring(ind - 1, ind).equals(".")) {
                num2 = ".";
                ++pointCount;
            }
        }
        catch (IndexOutOfBoundsException in) {
            num2 = "";
            num1 = "";
        }
        if (num2.equals(".")) {
            try {
                for (int i = ind; i < val.length() && STRING.isNumberComponent(val.substring(i, i + 1)) && !val.substring(i, i + 1).equals("."); ++i) {
                    if (val.substring(i, i + 1).equals("+")) {
                        if (expCount == 0 || plusCount == 1 || minusCount == 1) break;
                        ++plusCount;
                    }
                    if (val.substring(i, i + 1).equals("-")) {
                        if (expCount == 0 || minusCount == 1 || plusCount == 1) break;
                        ++minusCount;
                    }
                    if (val.substring(i, i + 1).equals("E")) {
                        if (expCount == 1) break;
                        exp = "E";
                        ++expCount;
                    }
                    if (STRING.isDigit(val.substring(i, i + 1)) && pointCount == 1 && expCount == 0) {
                        point = point + val.substring(i, i + 1);
                    }
                    if (val.substring(i, i + 1).equals("+") && expCount == 1 && num3.equals("") && sign.equals("")) {
                        sign = sign + val.substring(i, i + 1);
                    }
                    if (val.substring(i, i + 1).equals("-") && expCount == 1 && num3.equals("") && sign.equals("")) {
                        sign = sign + val.substring(i, i + 1);
                    }
                    if (!STRING.isDigit(val.substring(i, i + 1)) || (pointCount != 0 || expCount != 1) && (pointCount != 1 || expCount != 1)) continue;
                    num3 = num3 + val.substring(i, i + 1);
                }
            }
            catch (IndexOutOfBoundsException i) {}
        } else if (num2.equals("")) {
            try {
                for (int i = ind; i < val.length() && STRING.isNumberComponent(val.substring(i, i + 1)); ++i) {
                    if (STRING.isDigit(val.substring(i, i + 1)) && pointCount == 0 && expCount == 0) {
                        num1 = num1 + val.substring(i, i + 1);
                    }
                    if (val.substring(i, i + 1).equals(".")) {
                        if (expCount == 1 || pointCount == 1) break;
                        num2 = ".";
                        ++pointCount;
                    }
                    if (val.substring(i, i + 1).equals("+")) {
                        if (expCount == 0 || plusCount == 1 || minusCount == 1) break;
                        ++plusCount;
                    }
                    if (val.substring(i, i + 1).equals("-")) {
                        if (expCount == 0 || minusCount == 1 || plusCount == 1) break;
                        ++minusCount;
                    }
                    if (val.substring(i, i + 1).equals("E")) {
                        if (expCount == 1) break;
                        exp = "E";
                        ++expCount;
                    }
                    if (STRING.isDigit(val.substring(i, i + 1)) && pointCount == 1 && expCount == 0) {
                        point = point + val.substring(i, i + 1);
                    }
                    if (val.substring(i, i + 1).equals("+") && expCount == 1 && num3.equals("") && sign.equals("")) {
                        sign = sign + val.substring(i, i + 1);
                    }
                    if (val.substring(i, i + 1).equals("-") && expCount == 1 && num3.equals("") && sign.equals("")) {
                        sign = sign + val.substring(i, i + 1);
                    }
                    if (!STRING.isDigit(val.substring(i, i + 1)) || (pointCount != 0 || expCount != 1) && (pointCount != 1 || expCount != 1)) continue;
                    num3 = num3 + val.substring(i, i + 1);
                }
            }
            catch (IndexOutOfBoundsException i) {
                // empty catch block
            }
        }
        String result = num1 + num2 + point + exp + sign + num3;
        try {
            if (STRING.lastElement(result).equals("+") || STRING.lastElement(result).equals("-")) {
                result = result.substring(0, result.length() - 1);
            }
            if (STRING.lastElement(result).equals("+") || STRING.lastElement(result).equals("-")) {
                result = result.substring(0, result.length() - 1);
            }
            if (STRING.lastElement(result).equals("E")) {
                result = result.substring(0, result.length() - 1);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return result;
    }

    public boolean isNumber(String num) {
        return this.getFirstNumberSubstring(num).equals(num);
    }

    public ArrayList<String> splitStringAtFirstNumber(String val) {
        int firstOccDigit = STRING.getFirstIndexOfDigitOrPoint(val);
        if (firstOccDigit > -1) {
            if (firstOccDigit == 0) {
                String getFirstNumber = this.getFirstNumberSubstring(val);
                int firstNumberLen = getFirstNumber.length();
                this.scanner.add(getFirstNumber);
                this.scanner.add(val.substring(firstNumberLen));
            } else if (firstOccDigit > 0) {
                String getFirstNumber = this.getFirstNumberSubstring(val);
                int firstNumberLen = getFirstNumber.length();
                this.scanner.add(val.substring(0, firstOccDigit));
                this.scanner.add(getFirstNumber);
                this.scanner.add(val.substring(firstOccDigit + firstNumberLen));
            }
        }
        return this.scanner;
    }

    public ArrayList<String> splitStringOnNumbers(String val) {
        boolean canSplit;
        ArrayList<String> scan = new ArrayList<String>();
        ArrayList<Object> split = new ArrayList();
        boolean bl = canSplit = STRING.getFirstIndexOfDigitOrPoint(val) > -1;
        if (canSplit) {
            int passes = 0;
            while (canSplit) {
                split.clear();
                split = this.splitStringAtFirstNumber(val);
                int sizeAfterSplit = split.size();
                val = (String)split.get(sizeAfterSplit - 1);
                scan.addAll(split.subList(0, sizeAfterSplit - 1));
                boolean bl2 = canSplit = STRING.getFirstIndexOfDigitOrPoint(val) > -1;
                if (!canSplit) {
                    scan.add(val);
                    break;
                }
                ++passes;
            }
        } else {
            scan.add(val);
        }
        return scan;
    }

    public ArrayList<String> getNumberStrings(String val) {
        ArrayList<String> split = new ArrayList<String>();
        int firstOcc = -1;
        int extent = 0;
        int size = 0;
        val = " " + val;
        while (firstOcc != 0) {
            firstOcc = STRING.getFirstIndexOfDigit(val);
            if (firstOcc > 0 && val.substring(firstOcc - 1, firstOcc).equals(".")) {
                --firstOcc;
            }
            split.add(this.getFirstNumberSubstring(val));
            size = split.get(split.size() - 1).length();
            extent = firstOcc + size;
            val = val.substring(extent);
        }
        ArrayList<String> clearEmptyString = new ArrayList<String>();
        clearEmptyString.add("");
        split.removeAll(clearEmptyString);
        return split;
    }

    public String getFirstOperatorInString() {
        String opString = "";
        for (int i = 0; i < this.scannerInput.length(); ++i) {
            try {
                if (MOperator.isOperatorString(this.scannerInput.substring(i, i + 15)) && i + 15 <= this.scannerInput.length()) {
                    opString = this.scannerInput.substring(i, i + 15);
                    this.setFirstOpIndex(i);
                    break;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            try {
                if (MOperator.isOperatorString(this.scannerInput.substring(i, i + 14)) && i + 14 <= this.scannerInput.length()) {
                    opString = this.scannerInput.substring(i, i + 14);
                    this.setFirstOpIndex(i);
                    break;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            try {
                if (MOperator.isOperatorString(this.scannerInput.substring(i, i + 13)) && i + 13 <= this.scannerInput.length()) {
                    opString = this.scannerInput.substring(i, i + 13);
                    this.setFirstOpIndex(i);
                    break;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            try {
                if (MOperator.isOperatorString(this.scannerInput.substring(i, i + 12)) && i + 12 <= this.scannerInput.length()) {
                    opString = this.scannerInput.substring(i, i + 12);
                    this.setFirstOpIndex(i);
                    break;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            try {
                if (MOperator.isOperatorString(this.scannerInput.substring(i, i + 11)) && i + 11 <= this.scannerInput.length()) {
                    opString = this.scannerInput.substring(i, i + 11);
                    this.setFirstOpIndex(i);
                    break;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            try {
                if (MOperator.isOperatorString(this.scannerInput.substring(i, i + 10)) && i + 10 <= this.scannerInput.length()) {
                    opString = this.scannerInput.substring(i, i + 10);
                    this.setFirstOpIndex(i);
                    break;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            try {
                if (MOperator.isOperatorString(this.scannerInput.substring(i, i + 9)) && i + 9 <= this.scannerInput.length()) {
                    opString = this.scannerInput.substring(i, i + 9);
                    this.setFirstOpIndex(i);
                    break;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            try {
                if (MOperator.isOperatorString(this.scannerInput.substring(i, i + 8)) && i + 8 <= this.scannerInput.length()) {
                    opString = this.scannerInput.substring(i, i + 8);
                    this.setFirstOpIndex(i);
                    break;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            try {
                if (MOperator.isOperatorString(this.scannerInput.substring(i, i + 7)) && i + 7 <= this.scannerInput.length()) {
                    opString = this.scannerInput.substring(i, i + 7);
                    this.setFirstOpIndex(i);
                    break;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            try {
                if (MOperator.isOperatorString(this.scannerInput.substring(i, i + 6)) && i + 6 <= this.scannerInput.length()) {
                    opString = this.scannerInput.substring(i, i + 6);
                    this.setFirstOpIndex(i);
                    break;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            try {
                if (MOperator.isOperatorString(this.scannerInput.substring(i, i + 5)) && i + 5 <= this.scannerInput.length()) {
                    opString = this.scannerInput.substring(i, i + 5);
                    this.setFirstOpIndex(i);
                    break;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            try {
                if (MOperator.isOperatorString(this.scannerInput.substring(i, i + 4)) && i + 4 <= this.scannerInput.length()) {
                    opString = this.scannerInput.substring(i, i + 4);
                    this.setFirstOpIndex(i);
                    break;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            try {
                if (MOperator.isOperatorString(this.scannerInput.substring(i, i + 3)) && i + 3 <= this.scannerInput.length()) {
                    opString = this.scannerInput.substring(i, i + 3);
                    this.setFirstOpIndex(i);
                    break;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            try {
                if (MOperator.isOperatorString(this.scannerInput.substring(i, i + 2)) && i + 2 <= this.scannerInput.length()) {
                    opString = this.scannerInput.substring(i, i + 2);
                    this.setFirstOpIndex(i);
                    break;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            try {
                if (!MOperator.isOperatorString(this.scannerInput.substring(i, i + 1))) continue;
                opString = this.scannerInput.substring(i, i + 1);
                this.setFirstOpIndex(i);
                break;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        return opString;
    }

    public int getFirstIndexOfOperator() {
        return this.firstOpIndex;
    }

    public ArrayList<String> getOperatorStrings() {
        ArrayList<String> split = new ArrayList<String>();
        while (this.scannerInput.length() > 0) {
            String op = this.getFirstOperatorInString();
            if (!op.equals("")) {
                split.add(op);
                this.scannerInput = this.scannerInput.substring(this.scannerInput.indexOf(op) + op.length());
                continue;
            }
            if (!op.equals("")) continue;
            break;
        }
        return split;
    }

    public ArrayList<String> splitStringOnOperators() {
        ArrayList<String> filter = new ArrayList<String>();
        filter.add("");
        filter.add(",");
        int opIndex = 2;
        String op = "<><./?>";
        int pass = 0;
        while (!op.equals("")) {
            op = this.getFirstOperatorInString();
            opIndex = this.getFirstIndexOfOperator();
            if (opIndex == 0) {
                this.scanner.add(op);
                this.scannerInput = this.scannerInput.substring(opIndex + op.length());
            } else {
                this.scanner.add(this.scannerInput.substring(0, opIndex));
                this.scanner.add(op);
                this.scannerInput = this.scannerInput.substring(opIndex + op.length());
            }
            op = this.getFirstOperatorInString();
            if (op.equals("")) {
                this.scanner.add(this.scannerInput);
            }
            ++pass;
        }
        for (int i = 0; i < this.scanner.size(); ++i) {
            int index;
            if (this.scanner.get(i).contains("\u00b1")) {
                index = this.scanner.get(i).indexOf("\u00b1");
                this.scanner.set(i, STRING.replace(this.scanner.get(i), "+", index, index + 1));
                continue;
            }
            if (!this.scanner.get(i).contains("\u2013")) continue;
            index = this.scanner.get(i).indexOf("\u2013");
            this.scanner.set(i, STRING.replace(this.scanner.get(i), "-", index, index + 1));
        }
        this.scanner.removeAll(filter);
        return this.scanner;
    }

    public List<String> splitListOnVariables(List<String> val) {
        if (val.size() == 1) {
            val.addAll(this.splitStringOnVariables(val.get(0)));
            val.remove(0);
        }
        return val;
    }

    public void validateTokens() {
        for (int i = 0; i < this.scanner.size(); ++i) {
            if (Operator.isOperatorString(this.scanner.get(i)) || Variable.isVariableString(this.scanner.get(i)) || Number.validNumber(this.scanner.get(i))) continue;
            this.setRunnable(false);
            this.errorList.add(this.scanner.get(i) + " is a strange math object!");
            this.setRunnable(false);
            this.scanner.clear();
            break;
        }
    }

    public ArrayList<String> scanner() {
        int i;
        ArrayList<Object> split = new ArrayList();
        this.splitStringOnOperators();
        this.removeCommas();
        for (i = 0; i < this.scanner.size(); ++i) {
            split.clear();
            if (MOperator.isOperatorString(this.scanner.get(i)) || this.isNumber(this.scanner.get(i))) continue;
            try {
                split = this.splitStringOnVariables(this.scanner.get(i));
                this.scanner.remove(i);
                this.scanner.addAll(i, split);
                i += split.size();
                continue;
            }
            catch (IndexOutOfBoundsException indErr) {
                break;
            }
        }
        for (i = 0; i < this.scanner.size(); ++i) {
            if (!this.scanner.get(i).substring(0, 1).equals("~")) continue;
            this.scanner.set(i, "-" + this.scanner.get(i).substring(1));
        }
        for (i = 0; i < this.scanner.size(); ++i) {
            try {
                if (!new Number(this.scanner.get(i)).isNegative() || !this.scanner.get(i + 1).equals("E") || !new Number(this.scanner.get(i + 2)).isNumber()) continue;
                this.scanner.set(i, this.scanner.get(i) + this.scanner.get(i + 1) + this.scanner.get(i + 2));
                this.scanner.remove(i + 1);
                this.scanner.remove(i + 1);
                continue;
            }
            catch (IndexOutOfBoundsException indexErr) {
                break;
            }
        }
        return this.scanner;
    }

    public ArrayList<String> scanner(MatrixVariableManager matrixvarman, VariableManager varMan) {
        int i;
        ArrayList<Object> split = new ArrayList();
        this.splitStringOnOperators();
        this.removeCommas();
        for (i = 0; i < this.scanner.size(); ++i) {
            split.clear();
            if (MOperator.isOperatorString(this.scanner.get(i)) || this.isNumber(this.scanner.get(i))) continue;
            try {
                split = this.splitStringOnVariables(this.scanner.get(i));
                this.scanner.remove(i);
                this.scanner.addAll(i, split);
                i += split.size();
                continue;
            }
            catch (IndexOutOfBoundsException indErr) {
                break;
            }
        }
        for (i = 0; i < this.scanner.size(); ++i) {
            if (!this.scanner.get(i).substring(0, 1).equals("~")) continue;
            this.scanner.set(i, "-" + this.scanner.get(i).substring(1));
        }
        for (i = 0; i < this.scanner.size(); ++i) {
            try {
                if (!new Number(this.scanner.get(i)).isNegative() || !this.scanner.get(i + 1).equals("E") || !new Number(this.scanner.get(i + 2)).isNumber()) continue;
                this.scanner.set(i, this.scanner.get(i) + this.scanner.get(i + 1) + this.scanner.get(i + 2));
                this.scanner.remove(i + 1);
                this.scanner.remove(i + 1);
                continue;
            }
            catch (IndexOutOfBoundsException indexErr) {
                break;
            }
        }
        for (i = 0; i < this.scanner.size(); ++i) {
            try {
                if (!this.scanner.get(i).equals("#") || !Variable.isVariableString(this.scanner.get(i + 1))) continue;
                this.scanner.set(i, this.scanner.get(i) + this.scanner.get(i + 1));
                this.scanner.set(i + 1, "");
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        for (i = 0; i < this.scanner.size(); ++i) {
            if (Variable.isVariableString(this.scanner.get(i)) && !varMan.contains(this.scanner.get(i))) {
                this.errorList.add(" Unknown Variable: " + this.scanner.get(i) + "\n Please Declare And Initialize This Variable Before Using It.\nUse The Command, 'var=val' or'vars:var1,var2...=val1,val2,... To Accomplish This.");
                this.setRunnable(false);
            }
            if (MatrixVariable.isMatrixVariableName(this.scanner.get(i)) && !matrixvarman.contains(this.scanner.get(i))) {
                this.errorList.add(" Unknown Variable: " + this.scanner.get(i) + "\n Please Declare And Initialize This Variable Before Using It.\nUse The Command, 'var=val' or'vars:var1,var2...=val1,val2,... To Accomplish This.");
                this.setRunnable(false);
            }
            if (MatrixVariable.isMatrixVariableName(this.scanner.get(i)) || Variable.isVariableString(this.scanner.get(i)) || MOperator.isOperatorString(this.scanner.get(i)) || Number.isNumber(this.scanner.get(i))) continue;
            this.errorList.add("Syntax Error! Strange Object Found: " + this.scanner.get(i));
            this.setRunnable(false);
        }
        this.validateTokens();
        if (!this.runnable) {
            this.errorList.add("\nSorry, Errors Were Found In Your Expression.Please Consult The Help File For Valid Mathematical Syntax.");
            this.scanner.clear();
        } else {
            this.errorList.add("Scan SuccessFul.No Illegal Object Found.\nPutting Scanner On StandBy");
        }
        return this.scanner;
    }
}

