/*
 * Decompiled with CFR 0.152.
 */
package math.differentialcalculus;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import math.differentialcalculus.Formula;
import parser.Number;

public class FormulaManager {
    private final ArrayList<Formula> FORMULAE = new ArrayList();

    public ArrayList<Formula> getFORMULAE() {
        return new ArrayList<Formula>(this.FORMULAE);
    }

    public int count() {
        return this.FORMULAE.size();
    }

    public boolean contains(String name) {
        return this.indexOf(name) != -1;
    }

    public Object[] comparisonData(List<String> data) {
        Object[] info = new Object[]{-1.0, -1.0, -1.0};
        Formula f = new Formula("myForm_1", data);
        for (int i = 0; i < this.FORMULAE.size(); ++i) {
            Formula fj = this.FORMULAE.get(i);
            if (f.isEquivalentTo(fj)) {
                info[0] = 0;
                info[1] = i;
                info[2] = 1;
                return info;
            }
            double factor = f.getFactor(fj);
            if (Double.isNaN(factor)) continue;
            info[0] = 0;
            info[1] = i;
            info[2] = factor;
            return info;
        }
        return info;
    }

    public int indexOf(String name) {
        int sz = this.FORMULAE.size();
        for (int i = 0; i < sz; ++i) {
            if (!name.equals(this.FORMULAE.get(i).getName())) continue;
            return i;
        }
        return -1;
    }

    public Formula getFormula(String name) throws ClassNotFoundException {
        int indexOfnumber = name.indexOf("_") + 1;
        int index = -1;
        if (indexOfnumber != -1) {
            boolean isAutoGenName;
            String numberpart = name.substring(indexOfnumber);
            boolean bl = isAutoGenName = name.startsWith("myForm_") && Number.isNumber(numberpart);
            if (isAutoGenName) {
                index = Integer.parseInt(numberpart);
            }
        } else {
            index = this.indexOf(name);
        }
        if (index != -1) {
            return this.FORMULAE.get(index);
        }
        throw new ClassNotFoundException(" Formula " + name + " Does Not Exist.");
    }

    public Formula getFormula(int index) throws ClassNotFoundException {
        if (index < this.FORMULAE.size() && index >= 0) {
            return this.FORMULAE.get(index);
        }
        throw new ClassNotFoundException(" The Index '" + index + "' Does Not Exist.");
    }

    public Formula lookUp(String name) {
        try {
            return this.getFormula(name);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NullPointerException("Formula " + name + " does not exist!");
        }
    }

    public void add(Formula form) {
        if (!this.contains(form.getName())) {
            this.FORMULAE.add(form);
        } else if (this.contains(form.getName())) {
            this.update(form.getName(), form.getData());
        }
    }

    public void delete(String name) {
        int index = this.indexOf(name);
        if (index != -1) {
            this.FORMULAE.remove(index);
        }
    }

    public Formula firstFormula() {
        int sz = this.FORMULAE.size();
        if (sz > 0) {
            return this.FORMULAE.get(0);
        }
        throw new NullPointerException("Sorry,No Element Defined Yet!");
    }

    public Formula lastFormula() {
        int sz = this.FORMULAE.size();
        if (sz > 0) {
            return this.FORMULAE.get(sz - 1);
        }
        throw new NullPointerException("Sorry,No Element Defined Yet!");
    }

    public int update(String name, String newName) {
        try {
            Formula form = this.getFormula(name);
            form.setName(newName);
            int index = this.indexOf(form.getName());
            this.FORMULAE.set(index, form);
            return index;
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(FormulaManager.class.getName()).log(Level.SEVERE, null, ex);
            return -1;
        }
    }

    public int update(String name, List<String> data) {
        try {
            Formula form = this.getFormula(name);
            form.setData(data);
            int index = this.indexOf(form.getName());
            this.FORMULAE.set(index, form);
            return index;
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(FormulaManager.class.getName()).log(Level.SEVERE, null, ex);
            return -1;
        }
    }

    public void clearAll() {
        this.FORMULAE.clear();
    }
}

