/*
 * Decompiled with CFR 0.152.
 */
package com.github.gabrielbb.cutout;

import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Parcelable;
import android.util.Pair;
import com.github.gabrielbb.cutout.CutOutActivity;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.WeakReference;

class SaveDrawingTask
extends AsyncTask<Bitmap, Void, Pair<File, Exception>> {
    private static final String SAVED_IMAGE_FORMAT = "png";
    private static final String SAVED_IMAGE_NAME = "cutout_tmp";
    private final WeakReference<CutOutActivity> activityWeakReference;

    SaveDrawingTask(CutOutActivity activity) {
        this.activityWeakReference = new WeakReference<CutOutActivity>(activity);
    }

    protected void onPreExecute() {
        super.onPreExecute();
        ((CutOutActivity)((Object)this.activityWeakReference.get())).loadingModal.setVisibility(0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Pair<File, Exception> doInBackground(Bitmap ... bitmaps) {
        try {
            File file = File.createTempFile(SAVED_IMAGE_NAME, SAVED_IMAGE_FORMAT, ((CutOutActivity)((Object)this.activityWeakReference.get())).getApplicationContext().getCacheDir());
            try (FileOutputStream out = new FileOutputStream(file);){
                bitmaps[0].compress(Bitmap.CompressFormat.PNG, 95, (OutputStream)out);
                Pair pair = new Pair((Object)file, null);
                return pair;
            }
        }
        catch (IOException e) {
            return new Pair(null, (Object)e);
        }
    }

    protected void onPostExecute(Pair<File, Exception> result) {
        super.onPostExecute(result);
        Intent resultIntent = new Intent();
        if (result.first != null) {
            Uri uri = Uri.fromFile((File)((File)result.first));
            resultIntent.putExtra("CUTOUT_EXTRA_RESULT", (Parcelable)uri);
            ((CutOutActivity)((Object)this.activityWeakReference.get())).setResult(-1, resultIntent);
            ((CutOutActivity)((Object)this.activityWeakReference.get())).finish();
        } else {
            ((CutOutActivity)((Object)this.activityWeakReference.get())).exitWithError((Exception)result.second);
        }
    }
}

