/*
 * Decompiled with CFR 0.152.
 */
package com.github.gabrielbb.cutout;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.github.gabrielbb.cutout.CutOutActivity;

public class CutOut {
    public static final short CUTOUT_ACTIVITY_REQUEST_CODE = 368;
    public static final short CUTOUT_ACTIVITY_RESULT_ERROR_CODE = 3680;
    static final String CUTOUT_EXTRA_SOURCE = "CUTOUT_EXTRA_SOURCE";
    static final String CUTOUT_EXTRA_RESULT = "CUTOUT_EXTRA_RESULT";
    static final String CUTOUT_EXTRA_BORDER_COLOR = "CUTOUT_EXTRA_BORDER_COLOR";
    static final String CUTOUT_EXTRA_CROP = "CUTOUT_EXTRA_CROP";
    static final String CUTOUT_EXTRA_INTRO = "CUTOUT_EXTRA_INTRO";

    public static ActivityBuilder activity() {
        return new ActivityBuilder();
    }

    public static Uri getUri(@Nullable Intent data) {
        return data != null ? (Uri)data.getParcelableExtra(CUTOUT_EXTRA_RESULT) : null;
    }

    public static Exception getError(@Nullable Intent data) {
        return data != null ? (Exception)data.getSerializableExtra(CUTOUT_EXTRA_RESULT) : null;
    }

    public static final class ActivityBuilder {
        @Nullable
        private Uri source;
        private boolean bordered;
        private boolean crop = true;
        private boolean intro;
        private int borderColor = -1;

        private ActivityBuilder() {
        }

        private Intent getIntent(@NonNull Context context) {
            Intent intent = new Intent();
            intent.setClass(context, CutOutActivity.class);
            if (this.source != null) {
                intent.putExtra(CutOut.CUTOUT_EXTRA_SOURCE, (Parcelable)this.source);
            }
            if (this.bordered) {
                intent.putExtra(CutOut.CUTOUT_EXTRA_BORDER_COLOR, this.borderColor);
            }
            if (this.crop) {
                intent.putExtra(CutOut.CUTOUT_EXTRA_CROP, true);
            }
            if (this.intro) {
                intent.putExtra(CutOut.CUTOUT_EXTRA_INTRO, true);
            }
            return intent;
        }

        public ActivityBuilder src(Uri source) {
            this.source = source;
            return this;
        }

        public ActivityBuilder bordered() {
            this.bordered = true;
            return this;
        }

        public ActivityBuilder bordered(int borderColor) {
            this.borderColor = borderColor;
            return this.bordered();
        }

        public ActivityBuilder noCrop() {
            this.crop = false;
            return this;
        }

        public ActivityBuilder intro() {
            this.intro = true;
            return this;
        }

        public void start(@NonNull Activity activity) {
            activity.startActivityForResult(this.getIntent((Context)activity), 368);
        }
    }
}

