/*
 * Decompiled with CFR 0.152.
 */
package com.github.gabrielbb.cutout;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;

class BitmapUtility {
    BitmapUtility() {
    }

    static Bitmap getResizedBitmap(Bitmap bitmap, int width, int height) {
        Bitmap background = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        float originalWidth = bitmap.getWidth();
        float originalHeight = bitmap.getHeight();
        Canvas canvas = new Canvas(background);
        float scale = (float)width / originalWidth;
        float xTranslation = 0.0f;
        float yTranslation = ((float)height - originalHeight * scale) / 2.0f;
        Matrix transformation = new Matrix();
        transformation.postTranslate(xTranslation, yTranslation);
        transformation.preScale(scale, scale);
        Paint paint = new Paint();
        paint.setFilterBitmap(true);
        canvas.drawBitmap(bitmap, transformation, paint);
        return background;
    }

    static Bitmap getBorderedBitmap(Bitmap image, int borderColor, int borderSize) {
        Bitmap finalImage = Bitmap.createBitmap((int)image.getWidth(), (int)image.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(finalImage);
        Bitmap imageCopy = Bitmap.createScaledBitmap((Bitmap)image, (int)(image.getWidth() - borderSize), (int)(image.getHeight() - borderSize), (boolean)true);
        Paint paint = new Paint();
        paint.setColorFilter((ColorFilter)new PorterDuffColorFilter(borderColor, PorterDuff.Mode.SRC_ATOP));
        canvas.drawBitmap(image, 0.0f, 0.0f, paint);
        int width = image.getWidth();
        int height = image.getHeight();
        float centerX = (float)(width - imageCopy.getWidth()) * 0.5f;
        float centerY = (float)(height - imageCopy.getHeight()) * 0.5f;
        canvas.drawBitmap(imageCopy, centerX, centerY, null);
        return finalImage;
    }
}

