/*
 * Decompiled with CFR 0.152.
 */
package com.fueled.snippety.span;

import android.graphics.LinearGradient;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Shader;
import android.text.TextPaint;
import android.text.style.CharacterStyle;
import android.text.style.UpdateAppearance;

public class ShimmerSpan
extends CharacterStyle
implements UpdateAppearance {
    private final int[] colors;
    private Shader shader = null;
    private Matrix matrix = new Matrix();
    private float translateXPercentage = 0.0f;

    public ShimmerSpan() {
        this.colors = new int[3];
        this.colors[0] = -1;
        this.colors[1] = -3355444;
        this.colors[2] = -12303292;
    }

    public void setTranslateXPercentage(float percentage) {
        this.translateXPercentage = percentage;
    }

    public float getTranslateXPercentage() {
        return this.translateXPercentage;
    }

    public void updateDrawState(TextPaint paint) {
        paint.setStyle(Paint.Style.FILL);
        float width = paint.getTextSize() * (float)this.colors.length;
        if (this.shader == null) {
            this.shader = new LinearGradient(0.0f, 0.0f, 0.0f, width, this.colors, null, Shader.TileMode.MIRROR);
        }
        this.matrix.reset();
        this.matrix.setRotate(90.0f);
        this.matrix.postTranslate(width * this.translateXPercentage, 0.0f);
        this.shader.setLocalMatrix(this.matrix);
        paint.setShader(this.shader);
    }
}

