/*
 * Decompiled with CFR 0.152.
 */
package com.fueled.snippety.span;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.text.style.ReplacementSpan;
import java.lang.ref.WeakReference;

public class HorizontalLineSpan
extends ReplacementSpan {
    private Drawable drawable;
    private WeakReference<Drawable> mDrawableRef;

    public HorizontalLineSpan(Drawable drawable) {
        this.drawable = drawable;
    }

    public int getSize(Paint paint, CharSequence text, int start, int end, Paint.FontMetricsInt fm) {
        return 0;
    }

    public void draw(Canvas canvas, CharSequence text, int start, int end, float x, int top, int y, int bottom, Paint paint) {
        Paint.FontMetricsInt fmi = paint.getFontMetricsInt();
        int height = fmi.descent - fmi.ascent;
        Drawable b = this.getDrawable(canvas.getWidth(), height);
        canvas.save();
        int transY = bottom - b.getBounds().bottom;
        canvas.translate(x, (float)transY);
        b.draw(canvas);
        canvas.restore();
    }

    private Drawable getDrawable(int width, int height) {
        Drawable d = this.getCachedDrawable();
        d.setBounds(0, 0, width, height);
        return d;
    }

    public Drawable getDrawable() {
        return this.drawable;
    }

    private Drawable getCachedDrawable() {
        WeakReference<Drawable> wr = this.mDrawableRef;
        Drawable d = null;
        if (wr != null) {
            d = (Drawable)wr.get();
        }
        if (d == null) {
            d = this.getDrawable();
            this.mDrawableRef = new WeakReference<Drawable>(d);
        }
        return d;
    }
}

