/*
 * Decompiled with CFR 0.152.
 */
package com.fueled.snippety.span;

import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.text.style.ImageSpan;
import java.lang.ref.WeakReference;

public class CenteredImageSpan
extends ImageSpan {
    private int initialDescent = 0;
    private int extraSpace = 0;
    private WeakReference<Drawable> mDrawableRef;

    public CenteredImageSpan(Drawable drawable) {
        this(drawable, 0);
    }

    public CenteredImageSpan(Drawable drawable, int verticalAlignment) {
        super(drawable, verticalAlignment);
    }

    public int getSize(Paint paint, CharSequence text, int start, int end, Paint.FontMetricsInt fm) {
        Drawable d = this.getCachedDrawable();
        Rect rect = d.getBounds();
        if (fm != null) {
            if (rect.bottom - (fm.descent - fm.ascent) >= 0) {
                this.initialDescent = fm.descent;
                this.extraSpace = rect.bottom - (fm.descent - fm.ascent);
            }
            fm.bottom = fm.descent = this.extraSpace / 2 + this.initialDescent;
            fm.top = fm.ascent = -rect.bottom + fm.descent;
        }
        return rect.right;
    }

    private Drawable getCachedDrawable() {
        WeakReference<Drawable> wr = this.mDrawableRef;
        Drawable d = null;
        if (wr != null) {
            d = (Drawable)wr.get();
        }
        if (d == null) {
            d = this.getDrawable();
            this.mDrawableRef = new WeakReference<Drawable>(d);
        }
        return d;
    }
}

