/*
 * Decompiled with CFR 0.152.
 */
package com.fueled.snippety.span;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.text.style.ReplacementSpan;

public class RoundedBackgroundSpan
extends ReplacementSpan {
    public static final int DEFAULT_CORNER_RADIUS = 16;
    private int cornerRadius;
    private int backgroundColor;
    private int textColor;

    public RoundedBackgroundSpan(int backgroundColor, int textColor, int cornerRadius) {
        this.backgroundColor = backgroundColor;
        this.textColor = textColor;
        this.cornerRadius = cornerRadius;
    }

    public RoundedBackgroundSpan(int backgroundColor, int textColor) {
        this(backgroundColor, textColor, 16);
    }

    public void draw(Canvas canvas, CharSequence text, int start, int end, float x, int top, int y, int bottom, Paint paint) {
        RectF rect = new RectF(x, (float)top, x + paint.measureText(text, start, end) + (float)this.cornerRadius, (float)bottom);
        paint.setColor(this.backgroundColor);
        canvas.drawRoundRect(rect, (float)this.cornerRadius, (float)this.cornerRadius, paint);
        paint.setColor(this.textColor);
        canvas.drawText(text, start, end, x + (float)(this.cornerRadius / 2), (float)y, paint);
    }

    public int getSize(Paint paint, CharSequence text, int start, int end, Paint.FontMetricsInt fm) {
        return Math.round(paint.measureText(text, start, end));
    }
}

