/*
 * Decompiled with CFR 0.152.
 */
package com.fueled.snippety.core;

import android.text.SpannableStringBuilder;
import com.fueled.snippety.core.Snippety;
import java.util.ArrayDeque;
import java.util.Deque;

public class Truss {
    private static final String NEW_LINE = "\n";
    private static final String DEFAULT_DELIMITER = "`";
    private final SpannableStringBuilder builder = new SpannableStringBuilder();
    private final Deque<Span> stack = new ArrayDeque<Span>();

    public Truss append(String str) {
        this.builder.append((CharSequence)str);
        return this;
    }

    public Truss append(CharSequence charSequence) {
        this.builder.append(charSequence);
        return this;
    }

    public Truss append(char c) {
        this.builder.append(c);
        return this;
    }

    public Truss append(int number) {
        this.builder.append((CharSequence)String.valueOf(number));
        return this;
    }

    public Truss append(String str, Object spans) {
        Span span = new Span(this.builder.length(), spans);
        this.builder.append((CharSequence)str);
        this.iterateSpans(span);
        return this;
    }

    public Truss appendln() {
        return this.newLine();
    }

    public Truss appendln(String str) {
        return this.append(str + NEW_LINE);
    }

    public Truss appendln(CharSequence charSequence) {
        return this.append(charSequence + NEW_LINE);
    }

    public Truss appendln(char c) {
        return this.append(c + NEW_LINE);
    }

    public Truss appendln(int number) {
        return this.append(String.valueOf(number) + NEW_LINE);
    }

    public Truss appendln(String str, Object span) {
        return this.append(str + NEW_LINE, span);
    }

    public Truss newLine() {
        return this.append(NEW_LINE);
    }

    public Truss newParagraph() {
        return this.newLine().newLine();
    }

    public Truss appendDelimiterized(String fullText, String delimiter, Object span) {
        if (null == delimiter || "".equals(delimiter)) {
            delimiter = DEFAULT_DELIMITER;
        }
        int occurences = fullText.split(delimiter).length - 1;
        if (fullText.contains(delimiter) && occurences % 2 == 0) {
            String subText = fullText.substring(fullText.indexOf(delimiter) + 1, fullText.lastIndexOf(delimiter));
            fullText = fullText.replace(delimiter, "");
            int firstIndexOfSubtext = fullText.indexOf(subText);
            int lastIndexOfSubtext = firstIndexOfSubtext + subText.length();
            this.builder.append((CharSequence)fullText.substring(0, firstIndexOfSubtext));
            this.append(fullText.substring(firstIndexOfSubtext, lastIndexOfSubtext), span);
            this.builder.append((CharSequence)fullText.substring(lastIndexOfSubtext, fullText.length()));
        } else {
            this.append(fullText);
        }
        return this;
    }

    public Truss appendDelimiterizedln(String fullText, String delimiter, Object span) {
        return this.appendDelimiterized(fullText + NEW_LINE, delimiter, span);
    }

    public Truss appendSelective(String fullText, String subText, Object span) {
        this.builder.append((CharSequence)fullText);
        if (fullText.contains(subText)) {
            int startIndex = fullText.indexOf(subText);
            int endIndex = startIndex + subText.length();
            if (span instanceof Snippety) {
                for (Object s : ((Snippety)span).getSpans()) {
                    this.setSpan(s, startIndex, endIndex);
                }
            } else {
                this.setSpan(span, startIndex, endIndex);
            }
        }
        return this;
    }

    public Truss appendSelectiveln(String fullText, String subText, Object span) {
        return this.appendSelective(fullText + NEW_LINE, subText, span);
    }

    public Truss pushSpan(Object span) {
        this.stack.addLast(new Span(this.builder.length(), span));
        return this;
    }

    public Truss popSpan() {
        Span span = this.stack.removeLast();
        this.iterateSpans(span);
        return this;
    }

    private void setSpan(Object span, int start) {
        this.setSpan(span, start, this.builder.length());
    }

    private void setSpan(Object span, int start, int end) {
        this.builder.setSpan(span, start, end, 17);
    }

    public CharSequence build() {
        while (!this.stack.isEmpty()) {
            this.popSpan();
        }
        return this.builder;
    }

    private void iterateSpans(Span span) {
        if (span.span instanceof Snippety) {
            for (Object s : ((Snippety)span.span).getSpans()) {
                this.setSpan(s, span.start);
            }
        } else {
            this.setSpan(span.span, span.start);
        }
    }

    private static final class Span {
        final Object span;
        final int start;

        public Span(int start, Object span) {
            this.start = start;
            this.span = span;
        }
    }
}

