/*
 * Decompiled with CFR 0.152.
 */
package com.fueled.snippety.core;

import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.text.Layout;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.AlignmentSpan;
import android.text.style.BackgroundColorSpan;
import android.text.style.ClickableSpan;
import android.text.style.ForegroundColorSpan;
import android.text.style.ImageSpan;
import android.text.style.QuoteSpan;
import android.text.style.RelativeSizeSpan;
import android.text.style.StrikethroughSpan;
import android.text.style.StyleSpan;
import android.text.style.SubscriptSpan;
import android.text.style.SuperscriptSpan;
import android.text.style.URLSpan;
import android.text.style.UnderlineSpan;
import android.view.View;
import com.fueled.snippety.span.MultiColorSpan;
import com.fueled.snippety.span.RoundedBackgroundSpan;
import com.fueled.snippety.span.TextIndentSpan;
import com.fueled.snippety.span.TextTypefaceSpan;
import java.util.ArrayList;
import java.util.List;

public class Snippety {
    private List<Object> spans = new ArrayList<Object>();

    public List<Object> getSpans() {
        return this.spans;
    }

    public Snippety textColor(int color) {
        this.spans.add(new ForegroundColorSpan(color));
        return this;
    }

    public Snippety textMultiColor(int[] colors) {
        this.spans.add((Object)new MultiColorSpan(colors));
        return this;
    }

    public Snippety textMultiColor(int[] colors, int angle) {
        this.spans.add((Object)new MultiColorSpan(colors, angle));
        return this;
    }

    public Snippety backgroundColor(int color) {
        this.spans.add(new BackgroundColorSpan(color));
        return this;
    }

    public Snippety roundedBackgroundColor(int backgroundColor, int textColor) {
        this.spans.add((Object)new RoundedBackgroundSpan(backgroundColor, textColor));
        return this;
    }

    public Snippety roundedBackgroundColor(int backgroundColor, int textColor, int cornerRadius) {
        this.spans.add((Object)new RoundedBackgroundSpan(backgroundColor, textColor, cornerRadius));
        return this;
    }

    public Snippety align(Indent indent) {
        AlignmentSpan.Standard span;
        switch (indent) {
            case RIGHT: {
                span = new AlignmentSpan.Standard(Layout.Alignment.ALIGN_OPPOSITE);
                break;
            }
            case CENTER: {
                span = new AlignmentSpan.Standard(Layout.Alignment.ALIGN_CENTER);
                break;
            }
            default: {
                span = new AlignmentSpan.Standard(Layout.Alignment.ALIGN_NORMAL);
            }
        }
        this.spans.add(span);
        return this;
    }

    public Snippety underline() {
        this.spans.add(new UnderlineSpan());
        return this;
    }

    public Snippety subscript() {
        this.spans.add(new SubscriptSpan());
        return this;
    }

    public Snippety superscript() {
        this.spans.add(new SuperscriptSpan());
        return this;
    }

    public Snippety strikethrough() {
        this.spans.add(new StrikethroughSpan());
        return this;
    }

    public Snippety url(String url) {
        this.spans.add(new URLSpan(url));
        return this;
    }

    public Snippety quote(int color) {
        this.spans.add(new QuoteSpan(color));
        return this;
    }

    public Snippety fontStyle(FontStyle fontStyle) {
        StyleSpan span;
        switch (fontStyle) {
            case BOLD: {
                span = new StyleSpan(1);
                break;
            }
            case ITALIC: {
                span = new StyleSpan(2);
                break;
            }
            default: {
                span = new StyleSpan(0);
            }
        }
        this.spans.add(span);
        return this;
    }

    public Snippety typeface(Typeface typeface) {
        this.spans.add((Object)new TextTypefaceSpan(typeface));
        return this;
    }

    public Snippety addOnClickListener(final OnClickListener onClickListener) {
        this.spans.add(0, new ClickableSpan(){

            public void onClick(View widget) {
                onClickListener.onClick();
            }
        });
        return this;
    }

    public Snippety textSizeRelative(float proportion) {
        this.spans.add(new RelativeSizeSpan(proportion));
        return this;
    }

    public Snippety testSizeAbsolute(int size) {
        this.spans.add(new AbsoluteSizeSpan(size));
        return this;
    }

    public Snippety bullet(int leadGap, int gapWidth) {
        this.spans.add(new TextIndentSpan(new TextIndentSpan.Options(leadGap, gapWidth)));
        return this;
    }

    public Snippety bullet(TextIndentSpan.Options options) {
        this.spans.add(new TextIndentSpan(options));
        return this;
    }

    public Snippety number(int leadGap, int gapWidth, int number) {
        this.spans.add(new TextIndentSpan(new TextIndentSpan.Options(leadGap, gapWidth), number));
        return this;
    }

    public Snippety number(TextIndentSpan.Options options, int number) {
        this.spans.add(new TextIndentSpan(options, number));
        return this;
    }

    public Snippety image(Drawable drawable) {
        drawable.setBounds(0, 0, drawable.getIntrinsicWidth(), drawable.getIntrinsicHeight());
        this.spans.add(new ImageSpan(drawable, 1));
        return this;
    }

    public static interface OnClickListener {
        public void onClick();
    }

    public static enum FontStyle {
        NORMAL,
        BOLD,
        ITALIC;

    }

    public static enum Indent {
        LEFT,
        CENTER,
        RIGHT;

    }
}

