/*
 * Decompiled with CFR 0.152.
 */
package org.yi.acru.bukkit.Lockette;

import java.io.File;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Sign;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.yi.acru.bukkit.BlockUtil;
import org.yi.acru.bukkit.Lockette.LocketteBlockListener;
import org.yi.acru.bukkit.Lockette.LocketteDoorCloser;
import org.yi.acru.bukkit.Lockette.LocketteEntityListener;
import org.yi.acru.bukkit.Lockette.LocketteInventoryListener;
import org.yi.acru.bukkit.Lockette.LockettePlayerListener;
import org.yi.acru.bukkit.Lockette.LockettePrefixListener;
import org.yi.acru.bukkit.Lockette.LocketteWorldListener;
import org.yi.acru.bukkit.PluginCore;

public class Lockette
extends PluginCore {
    static boolean DEBUG = false;
    private static Lockette plugin;
    private static boolean enabled;
    private static boolean uuidSupport;
    private static boolean registered;
    private final LocketteBlockListener blockListener = new LocketteBlockListener(this);
    private final LocketteEntityListener entityListener = new LocketteEntityListener(this);
    private final LockettePlayerListener playerListener = new LockettePlayerListener(this);
    private final LockettePrefixListener prefixListener = new LockettePrefixListener(this);
    private final LocketteWorldListener worldListener = new LocketteWorldListener(this);
    private final LocketteInventoryListener inventoryListener = new LocketteInventoryListener(this);
    protected final LocketteDoorCloser doorCloser = new LocketteDoorCloser(this);
    protected static boolean explosionProtectionAll;
    protected static boolean rotateChests;
    protected static boolean adminSnoop;
    protected static boolean adminBypass;
    protected static boolean adminBreak;
    protected static boolean protectDoors;
    protected static boolean protectTrapDoors;
    protected static boolean usePermissions;
    protected static boolean directPlacement;
    protected static boolean colorTags;
    protected static boolean debugMode;
    protected static boolean blockHopper;
    protected static int defaultDoorTimer;
    protected static String broadcastSnoopTarget;
    protected static String broadcastBreakTarget;
    protected static String broadcastReloadTarget;
    protected static boolean msgUser;
    protected static boolean msgOwner;
    protected static boolean msgAdmin;
    protected static boolean msgError;
    protected static boolean msgHelp;
    protected static String altPrivate;
    protected static String altMoreUsers;
    protected static String altEveryone;
    protected static String altOperators;
    protected static String altTimer;
    protected static String altFee;
    protected static List<Object> customBlockList;
    protected static List<Object> disabledPluginList;
    protected static FileConfiguration strings;
    protected final HashMap<String, Block> playerList = new HashMap();
    private static final String META_KEY = "LocketteUUIDs";
    private static String NAME_HISTORY_URL;
    private static final JSONParser jsonParser;

    public Lockette() {
        plugin = this;
    }

    public void onLoad() {
    }

    @Override
    public void onEnable() {
        if (enabled) {
            return;
        }
        log.info("[" + this.getDescription().getName() + "] Version " + this.getDescription().getVersion() + " is being enabled!  Yay!  (Core version " + Lockette.getCoreVersion() + ")");
        int recBuild = 2771;
        int minBuild = 2735;
        float build = Lockette.getBuildVersion();
        if (build > 399.0f && build < 400.0f) {
            int printBuild = (int)((build - 399.0f) * 100.0f);
        } else {
            int printBuild = (int)build;
        }
        String bukkitVersion = Bukkit.getServer().getClass().getName().split("\\.")[3];
        float bukkitver = Float.parseFloat(bukkitVersion.substring(1, 4).replace("_", "."));
        float bukkitminver = 1.8f;
        if (bukkitver < bukkitminver) {
            log.severe("[" + this.getDescription().getName() + "] Detected Bukkit build [" + bukkitVersion + "], but requires version [" + bukkitminver + "] or greater!");
            log.severe("[" + this.getDescription().getName() + "] Aborting enable!");
            return;
        }
        log.info("[" + this.getDescription().getName() + "] Detected Bukkit version [" + bukkitVersion + "] ok.");
        this.loadProperties(false);
        super.onEnable();
        if (!registered) {
            this.blockListener.registerEvents();
            this.entityListener.registerEvents();
            this.playerListener.registerEvents();
            this.prefixListener.registerEvents();
            this.worldListener.registerEvents();
            this.inventoryListener.registerEvents();
            registered = true;
        }
        log.info("[" + this.getDescription().getName() + "] Ready to protect your containers.");
        enabled = true;
    }

    @Override
    public void onDisable() {
        if (!enabled) {
            return;
        }
        log.info(this.getDescription().getName() + " is being disabled...  ;.;");
        if (protectDoors || protectTrapDoors) {
            log.info("[" + this.getDescription().getName() + "] Closing all automatic doors.");
            this.doorCloser.cleanup();
        }
        super.onDisable();
        enabled = false;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        if (!cmd.getName().equalsIgnoreCase("lockette")) {
            return false;
        }
        if (sender instanceof Player) {
            return true;
        }
        if (args.length == 1) {
            if (args[0].equalsIgnoreCase("reload")) {
                this.loadProperties(true);
                this.localizedMessage(null, broadcastReloadTarget, "msg-admin-reload");
            } else if (args[0].equalsIgnoreCase("coredump")) {
                this.dumpCoreInfo();
            }
        }
        return true;
    }

    protected void loadProperties(boolean reload) {
        String stringsFileName;
        if (reload) {
            log.info("[" + this.getDescription().getName() + "] Reloading plugin configuration files.");
            this.reloadConfig();
        }
        FileConfiguration properties = this.getConfig();
        boolean propChanged = true;
        uuidSupport = properties.getBoolean("enable-uuid-support", false);
        properties.set("enable-uuid-support", (Object)uuidSupport);
        msgUser = properties.getBoolean("enable-messages-user", true);
        properties.set("enable-messages-user", (Object)msgUser);
        msgOwner = properties.getBoolean("enable-messages-owner", false);
        properties.set("enable-messages-owner", (Object)msgOwner);
        msgAdmin = properties.getBoolean("enable-messages-admin", true);
        properties.set("enable-messages-admin", (Object)msgAdmin);
        msgError = properties.getBoolean("enable-messages-error", true);
        properties.set("enable-messages-error", (Object)msgError);
        msgHelp = properties.getBoolean("enable-messages-help", true);
        properties.set("enable-messages-help", (Object)msgHelp);
        explosionProtectionAll = properties.getBoolean("explosion-protection-all", true);
        properties.set("explosion-protection-all", (Object)explosionProtectionAll);
        rotateChests = properties.getBoolean("enable-chest-rotation", false);
        properties.set("enable-chest-rotation", (Object)rotateChests);
        usePermissions = properties.getBoolean("enable-permissions", false);
        properties.set("enable-permissions", (Object)usePermissions);
        protectDoors = properties.getBoolean("enable-protection-doors", true);
        properties.set("enable-protection-doors", (Object)protectDoors);
        protectTrapDoors = properties.getBoolean("enable-protection-trapdoors", true);
        properties.set("enable-protection-trapdoors", (Object)protectTrapDoors);
        adminSnoop = properties.getBoolean("allow-admin-snoop", false);
        properties.set("allow-admin-snoop", (Object)adminSnoop);
        adminBypass = properties.getBoolean("allow-admin-bypass", true);
        properties.set("allow-admin-bypass", (Object)adminBypass);
        adminBreak = properties.getBoolean("allow-admin-break", true);
        properties.set("allow-admin-break", (Object)adminBreak);
        blockHopper = properties.getBoolean("enable-hopper-blocking", true);
        properties.set("enable-hopper-blocking", (Object)blockHopper);
        if (protectDoors || protectTrapDoors) {
            if (this.doorCloser.start()) {
                log.severe("[" + this.getDescription().getName() + "] Failed to register door closing task!");
            }
        } else {
            this.doorCloser.stop();
        }
        directPlacement = properties.getBoolean("enable-quick-protect", true);
        properties.set("enable-quick-protect", (Object)directPlacement);
        colorTags = properties.getBoolean("enable-color-tags", true);
        properties.set("enable-color-tags", (Object)colorTags);
        debugMode = properties.getBoolean("enable-debug", false);
        if (debugMode) {
            log.warning("[" + this.getDescription().getName() + "] Debug mode is enabled, so Lockette chests are NOT secure.");
        }
        if ((defaultDoorTimer = properties.getInt("default-door-timer", -1)) == -1) {
            defaultDoorTimer = 0;
            properties.set("default-door-timer", (Object)defaultDoorTimer);
            propChanged = true;
        }
        if ((customBlockList = properties.getList("custom-lockable-block-list")) == null) {
            customBlockList = new ArrayList<Object>(3);
            customBlockList.add(Material.ENCHANTMENT_TABLE.getId());
            customBlockList.add(Material.JUKEBOX.getId());
            customBlockList.add(Material.DIAMOND_BLOCK.getId());
            customBlockList.add(Material.ANVIL.getId());
            customBlockList.add(Material.HOPPER.getId());
            properties.set("custom-lockable-block-list", customBlockList);
            propChanged = true;
        }
        if (!customBlockList.isEmpty()) {
            log.info("[" + this.getDescription().getName() + "] Custom lockable block list: " + customBlockList.toString());
        }
        if ((disabledPluginList = properties.getList("linked-plugin-ignore-list")) == null) {
            disabledPluginList = new ArrayList<Object>(1);
            disabledPluginList.add("mcMMO");
            properties.set("linked-plugin-ignore-list", disabledPluginList);
            propChanged = true;
        }
        if (!disabledPluginList.isEmpty()) {
            log.info("[" + this.getDescription().getName() + "] Ignoring linked plugins: " + disabledPluginList.toString());
        }
        if ((broadcastSnoopTarget = properties.getString("broadcast-snoop-target")) == null) {
            broadcastSnoopTarget = "[Everyone]";
            properties.set("broadcast-snoop-target", (Object)broadcastSnoopTarget);
            propChanged = true;
        }
        if ((broadcastBreakTarget = properties.getString("broadcast-break-target")) == null) {
            broadcastBreakTarget = "[Everyone]";
            properties.set("broadcast-break-target", (Object)broadcastBreakTarget);
            propChanged = true;
        }
        if ((broadcastReloadTarget = properties.getString("broadcast-reload-target")) == null) {
            broadcastReloadTarget = "[Operators]";
            properties.set("broadcast-reload-target", (Object)broadcastReloadTarget);
            propChanged = true;
        }
        if ((stringsFileName = properties.getString("strings-file-name")) == null || stringsFileName.isEmpty()) {
            stringsFileName = "strings-en.yml";
            properties.set("strings-file-name", (Object)stringsFileName);
            propChanged = true;
        }
        if (propChanged) {
            this.saveConfig();
        }
        this.loadStrings(reload, stringsFileName);
    }

    protected void loadStrings(boolean reload, String fileName) {
        String tempString;
        boolean stringChanged = false;
        File stringsFile = new File(this.getDataFolder(), fileName);
        if (strings != null) {
            strings = null;
        }
        strings = new YamlConfiguration();
        try {
            strings.load(stringsFile);
        }
        catch (InvalidConfigurationException ex) {
            log.warning("[" + this.getDescription().getName() + "] Error loading " + fileName + ": " + ex.getMessage());
            if (!fileName.equals("strings-en.yml")) {
                this.loadStrings(reload, "strings-en.yml");
                return;
            }
            log.warning("[" + this.getDescription().getName() + "] Returning to default strings.");
        }
        catch (Exception ex) {
            // empty catch block
        }
        boolean original = false;
        if (fileName.equals("strings-en.yml")) {
            original = true;
            strings.set("language", (Object)"English");
            if (original) {
                try {
                    strings.save(stringsFile);
                    strings.load(stringsFile);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            strings.set("author", (Object)"Acru");
            strings.set("editors", (Object)"");
            strings.set("version", (Object)0);
        }
        if ((tempString = strings.getString("language")) == null || tempString.isEmpty()) {
            log.info("[" + this.getDescription().getName() + "] Loading strings file " + fileName);
        } else {
            log.info("[" + this.getDescription().getName() + "] Loading strings file for " + tempString + " by " + strings.getString("author"));
        }
        altPrivate = strings.getString("alternate-private-tag");
        if (altPrivate == null || altPrivate.isEmpty() || original && altPrivate.equals("Priv\u00e9")) {
            altPrivate = "Private";
            strings.set("alternate-private-tag", (Object)altPrivate);
        }
        altPrivate = "[" + altPrivate + "]";
        altMoreUsers = strings.getString("alternate-moreusers-tag");
        if (altMoreUsers == null || altMoreUsers.isEmpty() || original && altMoreUsers.equals("Autre Noms")) {
            altMoreUsers = "More Users";
            strings.set("alternate-moreusers-tag", (Object)altMoreUsers);
            stringChanged = true;
        }
        altMoreUsers = "[" + altMoreUsers + "]";
        altEveryone = strings.getString("alternate-everyone-tag");
        if (altEveryone == null || altEveryone.isEmpty() || original && altEveryone.equals("Tout le Monde")) {
            altEveryone = "Everyone";
            strings.set("alternate-everyone-tag", (Object)altEveryone);
            stringChanged = true;
        }
        altEveryone = "[" + altEveryone + "]";
        altOperators = strings.getString("alternate-operators-tag");
        if (altOperators == null || altOperators.isEmpty() || original && altOperators.equals("Op\u00e9rateurs")) {
            altOperators = "Operators";
            strings.set("alternate-operators-tag", (Object)altOperators);
            stringChanged = true;
        }
        altOperators = "[" + altOperators + "]";
        altTimer = strings.getString("alternate-timer-tag");
        if (altTimer == null || altTimer.isEmpty() || original && altTimer.equals("Minuterie")) {
            altTimer = "Timer";
            strings.set("alternate-timer-tag", (Object)altTimer);
            stringChanged = true;
        }
        if ((altFee = strings.getString("alternate-fee-tag")) == null || altFee.isEmpty()) {
            altFee = "Fee";
            strings.set("alternate-fee-tag", (Object)altFee);
            stringChanged = true;
        }
        if ((tempString = strings.getString("msg-user-conflict-door")) == null) {
            strings.set("msg-user-conflict-door", (Object)"Conflicting door removed!");
            stringChanged = true;
        }
        if ((tempString = strings.getString("msg-user-illegal")) == null) {
            strings.set("msg-user-illegal", (Object)"Illegal chest removed!");
            stringChanged = true;
        }
        if ((tempString = strings.getString("msg-user-resize-owned")) == null) {
            strings.set("msg-user-resize-owned", (Object)"You cannot resize a chest claimed by ***.");
            stringChanged = true;
        }
        if ((tempString = strings.getString("msg-help-chest")) == null) {
            strings.set("msg-help-chest", (Object)"Place a sign headed [Private] next to a chest to lock it.");
            stringChanged = true;
        }
        if ((tempString = strings.getString("msg-owner-release")) == null) {
            strings.set("msg-owner-release", (Object)"You have released a container!");
            stringChanged = true;
        }
        if ((tempString = strings.getString("msg-admin-release")) == null) {
            strings.set("msg-admin-release", (Object)"(Admin) @@@ has broken open a container owned by ***!");
            stringChanged = true;
        }
        if ((tempString = strings.getString("msg-user-release-owned")) == null) {
            strings.set("msg-user-release-owned", (Object)"You cannot release a container claimed by ***.");
            stringChanged = true;
        }
        if ((tempString = strings.getString("msg-owner-remove")) == null) {
            strings.set("msg-owner-remove", (Object)"You have removed users from a container!");
            stringChanged = true;
        }
        if ((tempString = strings.getString("msg-user-remove-owned")) == null) {
            strings.set("msg-user-remove-owned", (Object)"You cannot remove users from a container claimed by ***.");
            stringChanged = true;
        }
        if ((tempString = strings.getString("msg-user-break-owned")) == null) {
            strings.set("msg-user-break-owned", (Object)"You cannot break a container claimed by ***.");
            stringChanged = true;
        }
        if ((tempString = strings.getString("msg-user-denied-door")) == null) {
            strings.set("msg-user-denied-door", (Object)"You don't have permission to use this door.");
            stringChanged = true;
        }
        if ((tempString = strings.getString("msg-user-touch-fee")) == null) {
            strings.set("msg-user-touch-fee", (Object)"A fee of ### will be paid to ***, to open.");
            stringChanged = true;
        }
        if ((tempString = strings.getString("msg-user-touch-owned")) == null) {
            strings.set("msg-user-touch-owned", (Object)"This container has been claimed by ***.");
            stringChanged = true;
        }
        if ((tempString = strings.getString("msg-help-select")) == null) {
            strings.set("msg-help-select", (Object)"Sign selected, use /lockette <line number> <text> to edit.");
            stringChanged = true;
        }
        if ((tempString = strings.getString("msg-admin-bypass")) == null) {
            strings.set("msg-admin-bypass", (Object)"Bypassed a door owned by ***, be sure to close it behind you.");
            stringChanged = true;
        }
        if ((tempString = strings.getString("msg-admin-snoop")) == null) {
            strings.set("msg-admin-snoop", (Object)"(Admin) @@@ has snooped around in a container owned by ***!");
            stringChanged = true;
        }
        if ((tempString = strings.getString("msg-user-denied")) == null) {
            strings.set("msg-user-denied", (Object)"You don't have permission to open this container.");
            stringChanged = true;
        }
        if ((tempString = strings.getString("msg-error-zone")) == null) {
            strings.set("msg-error-zone", (Object)"This zone is protected by ***.");
            stringChanged = true;
        }
        if ((tempString = strings.getString("msg-error-permission")) == null) {
            strings.set("msg-error-permission", (Object)"Permission to lock container denied.");
            stringChanged = true;
        } else if (tempString.equals("Permission to lock containers denied.")) {
            strings.set("msg-error-permission", (Object)"Permission to lock container denied.");
            stringChanged = true;
        }
        tempString = strings.getString("msg-error-claim");
        if (tempString == null) {
            strings.set("msg-error-claim", (Object)"No unclaimed container nearby to make Private!");
            stringChanged = true;
        }
        if ((tempString = strings.getString("msg-error-claim-conflict")) == null) {
            strings.set("msg-error-claim-conflict", (Object)"Conflict with an existing protected door.");
            stringChanged = true;
        }
        if ((tempString = strings.getString("msg-admin-claim-error")) == null) {
            strings.set("msg-admin-claim-error", (Object)"Player *** is not online, be sure you have the correct name.");
            stringChanged = true;
        }
        if ((tempString = strings.getString("msg-admin-claim")) == null) {
            strings.set("msg-admin-claim", (Object)"You have claimed a container for ***.");
            stringChanged = true;
        }
        if ((tempString = strings.getString("msg-owner-claim")) == null) {
            strings.set("msg-owner-claim", (Object)"You have claimed a container!");
            stringChanged = true;
        }
        if ((tempString = strings.getString("msg-error-adduser-owned")) == null) {
            strings.set("msg-error-adduser-owned", (Object)"You cannot add users to a container claimed by ***.");
            stringChanged = true;
        }
        if ((tempString = strings.getString("msg-error-adduser")) == null) {
            strings.set("msg-error-adduser", (Object)"No claimed container nearby to add users to!");
            stringChanged = true;
        }
        if ((tempString = strings.getString("msg-owner-adduser")) == null) {
            strings.set("msg-owner-adduser", (Object)"You have added users to a container!");
            stringChanged = true;
        }
        if (original) {
            strings.set("msg-help-command1", (Object)"&C/lockette <line number> <text> - Edits signs on locked containers. Right click on the sign to edit.");
            strings.set("msg-help-command2", (Object)"&C/lockette fix - Fixes an automatic door that is in the wrong position. Look at the door to edit.");
            strings.set("msg-help-command3", (Object)"&C/lockette reload - Reloads the configuration files. Operators only.");
            strings.set("msg-help-command4", (Object)"&C/lockette version - Reports Lockette version.");
            stringChanged = true;
        }
        if ((tempString = strings.getString("msg-admin-reload")) == null) {
            strings.set("msg-admin-reload", (Object)"Reloading plugin configuration files.");
            stringChanged = true;
        }
        if ((tempString = strings.getString("msg-error-fix")) == null) {
            strings.set("msg-error-fix", (Object)"No owned door found.");
            stringChanged = true;
        }
        if ((tempString = strings.getString("msg-error-edit")) == null) {
            strings.set("msg-error-edit", (Object)"First select a sign by right clicking it.");
            stringChanged = true;
        }
        if ((tempString = strings.getString("msg-owner-edit")) == null) {
            strings.set("msg-owner-edit", (Object)"Sign edited successfully.");
            stringChanged = true;
        }
        if (original && stringChanged) {
            try {
                strings.save(stringsFile);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    public static boolean isProtected(Block block) {
        if (!enabled) {
            return false;
        }
        int type = block.getTypeId();
        if (type == Material.WALL_SIGN.getId()) {
            Block checkBlock;
            Sign sign = (Sign)block.getState();
            String text = sign.getLine(0).replaceAll("(?i)\u00a7[0-F]", "").toLowerCase();
            if (text.equals("[private]") || text.equalsIgnoreCase(altPrivate)) {
                return true;
            }
            if ((text.equals("[more users]") || text.equalsIgnoreCase(altMoreUsers)) && (checkBlock = Lockette.getSignAttachedBlock(block)) != null && Lockette.findBlockOwner(checkBlock) != null) {
                return true;
            }
        } else if (Lockette.findBlockOwner(block) != null) {
            return true;
        }
        return false;
    }

    public static String getProtectedOwner(Block block) {
        return Bukkit.getOfflinePlayer((UUID)Lockette.getProtectedOwnerUUID(block)).getName();
    }

    public static UUID getProtectedOwnerUUID(Block block) {
        if (!enabled) {
            return null;
        }
        int type = block.getTypeId();
        if (type == Material.WALL_SIGN.getId()) {
            Block signBlock;
            Block checkBlock;
            Sign sign = (Sign)block.getState();
            String text = ChatColor.stripColor((String)sign.getLine(0)).toLowerCase();
            if (text.equals("[private]") || text.equalsIgnoreCase(altPrivate)) {
                return Lockette.getUUIDFromMeta(sign, 1);
            }
            if ((text.equals("[more users]") || text.equalsIgnoreCase(altMoreUsers)) && (checkBlock = Lockette.getSignAttachedBlock(block)) != null && (signBlock = Lockette.findBlockOwner(checkBlock)) != null) {
                sign = (Sign)signBlock.getState();
                return Lockette.getUUIDFromMeta(sign, 1);
            }
        } else {
            Block signBlock = Lockette.findBlockOwner(block);
            if (signBlock != null) {
                Sign sign = (Sign)signBlock.getState();
                return Lockette.getUUIDFromMeta(sign, 1);
            }
        }
        return null;
    }

    public static boolean isEveryone(Block block) {
        String line;
        int y;
        if (!enabled) {
            return true;
        }
        Block signBlock = Lockette.findBlockOwner(block);
        if (signBlock == null) {
            return true;
        }
        Sign sign = (Sign)signBlock.getState();
        for (y = 1; y <= 3; ++y) {
            if (sign.getLine(y).isEmpty() || !(line = sign.getLine(y).replaceAll("(?i)\u00a7[0-F]", "")).equalsIgnoreCase("[Everyone]") && !line.equalsIgnoreCase(altEveryone)) continue;
            return true;
        }
        List<Block> list = Lockette.findBlockUsers(block, signBlock);
        int count = list.size();
        for (int x = 0; x < count; ++x) {
            sign = (Sign)list.get(x).getState();
            for (y = 1; y <= 3; ++y) {
                if (sign.getLine(y).isEmpty() || !(line = sign.getLine(y).replaceAll("(?i)\u00a7[0-F]", "")).equalsIgnoreCase("[Everyone]") && !line.equalsIgnoreCase(altEveryone)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean pluginEnableOverride(String pluginName) {
        return Lockette.isInList(pluginName, disabledPluginList);
    }

    @Override
    protected boolean usingExternalPermissions() {
        if (!usePermissions) {
            return false;
        }
        return super.usingExternalPermissions();
    }

    @Override
    protected boolean usingExternalZones() {
        return super.usingExternalZones();
    }

    @Override
    protected String getLocalizedEveryone() {
        return altEveryone;
    }

    @Override
    protected String getLocalizedOperators() {
        return altOperators;
    }

    protected void localizedMessage(Player player, String broadcast, String key) {
        this.localizedMessage(player, broadcast, key, null, null);
    }

    protected void localizedMessage(Player player, String broadcast, String key, String sub) {
        this.localizedMessage(player, broadcast, key, sub, null);
    }

    protected void localizedMessage(Player player, String broadcast, String key, String sub, String num) {
        String color = "";
        if (key.startsWith("msg-user-")) {
            if (broadcast == null && !msgUser) {
                return;
            }
            color = ChatColor.YELLOW.toString();
        } else if (key.startsWith("msg-owner-")) {
            if (broadcast == null && !msgOwner) {
                return;
            }
            color = ChatColor.GOLD.toString();
        } else if (key.startsWith("msg-admin-")) {
            if (broadcast == null && !msgAdmin) {
                return;
            }
            color = ChatColor.RED.toString();
        } else if (key.startsWith("msg-error-")) {
            if (broadcast == null && !msgError) {
                return;
            }
            color = ChatColor.RED.toString();
        } else if (key.startsWith("msg-help-")) {
            if (broadcast == null && !msgHelp) {
                return;
            }
            color = ChatColor.GOLD.toString();
        }
        String message = strings.getString(key);
        if (message == null || message.isEmpty()) {
            return;
        }
        message = message.replaceAll("&([0-9A-Fa-f])", "\u00a7$1");
        if (sub != null) {
            message = message.replaceAll("\\*\\*\\*", sub + color);
        }
        if (num != null) {
            message = message.replaceAll("###", num);
        }
        if (player != null) {
            message = message.replaceAll("@@@", player.getName());
        }
        if (broadcast != null) {
            this.selectiveBroadcast(broadcast, color + "[Lockette] " + message);
        } else if (player != null) {
            player.sendMessage(color + "[Lockette] " + message);
        }
    }

    protected static Block findBlockOwner(Block block) {
        return Lockette.findBlockOwner(block, null, false);
    }

    protected static Block findBlockOwnerBreak(Block block) {
        int type = block.getTypeId();
        if (BlockUtil.isInList(type, BlockUtil.materialListChests)) {
            return Lockette.findBlockOwnerBase(block, null, false, false, false, false, false);
        }
        if (BlockUtil.isInList(type, BlockUtil.materialListTools) || Lockette.isInList(type, customBlockList)) {
            return Lockette.findBlockOwnerBase(block, null, false, false, false, false, false);
        }
        if (protectTrapDoors && BlockUtil.isInList(type, BlockUtil.materialListTrapDoors)) {
            return Lockette.findBlockOwnerBase(block, null, false, false, false, false, false);
        }
        if (protectDoors && BlockUtil.isInList(type, BlockUtil.materialListDoors)) {
            return Lockette.findBlockOwnerBase(block, null, false, true, true, false, false);
        }
        Block checkBlock = Lockette.findBlockOwnerBase(block, null, false, false, false, false, false);
        if (checkBlock != null) {
            return checkBlock;
        }
        if (protectTrapDoors) {
            checkBlock = block.getRelative(BlockFace.NORTH);
            if (BlockUtil.isInList(checkBlock.getTypeId(), BlockUtil.materialListTrapDoors) && (checkBlock.getData() & 3) == 2 && (checkBlock = Lockette.findBlockOwnerBase(checkBlock, null, false, false, false, false, false)) != null) {
                return checkBlock;
            }
            checkBlock = block.getRelative(BlockFace.EAST);
            if (BlockUtil.isInList(checkBlock.getTypeId(), BlockUtil.materialListTrapDoors) && (checkBlock.getData() & 3) == 0 && (checkBlock = Lockette.findBlockOwnerBase(checkBlock, null, false, false, false, false, false)) != null) {
                return checkBlock;
            }
            checkBlock = block.getRelative(BlockFace.SOUTH);
            if (BlockUtil.isInList(checkBlock.getTypeId(), BlockUtil.materialListTrapDoors) && (checkBlock.getData() & 3) == 3 && (checkBlock = Lockette.findBlockOwnerBase(checkBlock, null, false, false, false, false, false)) != null) {
                return checkBlock;
            }
            checkBlock = block.getRelative(BlockFace.WEST);
            if (BlockUtil.isInList(checkBlock.getTypeId(), BlockUtil.materialListTrapDoors) && (checkBlock.getData() & 3) == 1 && (checkBlock = Lockette.findBlockOwnerBase(checkBlock, null, false, false, false, false, false)) != null) {
                return checkBlock;
            }
        }
        if (protectDoors && !BlockUtil.isInList(type = (checkBlock = block.getRelative(BlockFace.UP)).getTypeId(), BlockUtil.materialListDoors)) {
            return Lockette.findBlockOwnerBase(checkBlock, null, false, true, true, false, false);
        }
        return null;
    }

    protected static Block findBlockOwner(Block block, Block ignoreBlock, boolean iterateFurther) {
        Block checkBlock;
        if (block == null) {
            return null;
        }
        int type = block.getTypeId();
        Location ignore = ignoreBlock != null ? ignoreBlock.getLocation() : null;
        if (BlockUtil.isInList(type, BlockUtil.materialListChests)) {
            return Lockette.findBlockOwnerBase(block, ignore, true, false, false, false, false);
        }
        if (BlockUtil.isInList(type, BlockUtil.materialListTools) || Lockette.isInList(type, customBlockList)) {
            return Lockette.findBlockOwnerBase(block, ignore, false, false, false, false, false);
        }
        if (protectTrapDoors && BlockUtil.isInList(type, BlockUtil.materialListTrapDoors)) {
            return Lockette.findBlockOwner(Lockette.getTrapDoorAttachedBlock(block), ignoreBlock, false);
        }
        if (protectDoors && BlockUtil.isInList(type, BlockUtil.materialListDoors)) {
            return Lockette.findBlockOwnerBase(block, ignore, true, true, true, true, iterateFurther);
        }
        if (protectTrapDoors) {
            checkBlock = Lockette.findBlockOwnerBase(block, ignore, false, false, false, false, false);
            if (checkBlock != null) {
                return checkBlock;
            }
            checkBlock = block.getRelative(BlockFace.NORTH);
            if (BlockUtil.isInList(checkBlock.getTypeId(), BlockUtil.materialListTrapDoors) && (checkBlock.getData() & 3) == 2 && (checkBlock = Lockette.findBlockOwnerBase(checkBlock, ignore, false, false, false, false, false)) != null) {
                return checkBlock;
            }
            checkBlock = block.getRelative(BlockFace.EAST);
            if (BlockUtil.isInList(checkBlock.getTypeId(), BlockUtil.materialListTrapDoors) && (checkBlock.getData() & 3) == 0 && (checkBlock = Lockette.findBlockOwnerBase(checkBlock, ignore, false, false, false, false, false)) != null) {
                return checkBlock;
            }
            checkBlock = block.getRelative(BlockFace.SOUTH);
            if (BlockUtil.isInList(checkBlock.getTypeId(), BlockUtil.materialListTrapDoors) && (checkBlock.getData() & 3) == 3 && (checkBlock = Lockette.findBlockOwnerBase(checkBlock, ignore, false, false, false, false, false)) != null) {
                return checkBlock;
            }
            checkBlock = block.getRelative(BlockFace.WEST);
            if (BlockUtil.isInList(checkBlock.getTypeId(), BlockUtil.materialListTrapDoors) && (checkBlock.getData() & 3) == 1 && (checkBlock = Lockette.findBlockOwnerBase(checkBlock, ignore, false, false, false, false, false)) != null) {
                return checkBlock;
            }
        }
        if (protectDoors) {
            Block result;
            checkBlock = block.getRelative(BlockFace.UP);
            type = checkBlock.getTypeId();
            if (BlockUtil.isInList(type, BlockUtil.materialListDoors) && (result = Lockette.findBlockOwnerBase(checkBlock, ignore, true, true, true, true, iterateFurther)) != null) {
                return result;
            }
            checkBlock = block.getRelative(BlockFace.DOWN);
            type = checkBlock.getTypeId();
            if (BlockUtil.isInList(type, BlockUtil.materialListDoors)) {
                Block checkBlock2 = checkBlock.getRelative(BlockFace.DOWN);
                type = checkBlock2.getTypeId();
                if (BlockUtil.isInList(type, BlockUtil.materialListDoors)) {
                    return Lockette.findBlockOwnerBase(checkBlock2, ignore, true, true, false, true, iterateFurther);
                }
                return Lockette.findBlockOwnerBase(checkBlock, ignore, true, true, false, true, iterateFurther);
            }
        }
        return null;
    }

    private static Block findBlockOwnerBase(Block block, Location ignore, boolean iterate, boolean iterateUp, boolean iterateDown, boolean includeEnds, boolean iterateFurther) {
        Sign sign;
        String text;
        boolean doCheck;
        byte face;
        int type;
        Object checkBlock;
        if (iterateUp && (checkBlock = BlockUtil.isInList(type = (checkBlock = block.getRelative(BlockFace.UP)).getTypeId(), BlockUtil.materialListDoors) ? Lockette.findBlockOwnerBase(checkBlock, ignore, false, iterateUp, false, includeEnds, false) : (includeEnds ? Lockette.findBlockOwnerBase(checkBlock, ignore, false, false, false, includeEnds, false) : null)) != null) {
            return checkBlock;
        }
        if (iterateDown && (checkBlock = BlockUtil.isInList(type = (checkBlock = block.getRelative(BlockFace.DOWN)).getTypeId(), BlockUtil.materialListDoors) ? Lockette.findBlockOwnerBase(checkBlock, ignore, false, false, iterateDown, includeEnds, false) : (includeEnds ? Lockette.findBlockOwnerBase(checkBlock, ignore, false, false, false, includeEnds, false) : null)) != null) {
            return checkBlock;
        }
        checkBlock = block.getRelative(BlockFace.NORTH);
        if (checkBlock.getTypeId() == Material.WALL_SIGN.getId() ? (face = checkBlock.getData()) == BlockUtil.faceList[2] && (doCheck = ignore == null ? true : !checkBlock.getLocation().equals((Object)ignore)) && ((text = (sign = (Sign)checkBlock.getState()).getLine(0).replaceAll("(?i)\u00a7[0-F]", "").toLowerCase()).equals("[private]") || text.equalsIgnoreCase(altPrivate)) : iterate && checkBlock.getTypeId() == block.getTypeId() && (checkBlock = Lockette.findBlockOwnerBase(checkBlock, ignore, iterateFurther, iterateUp, iterateDown, includeEnds, false)) != null) {
            return checkBlock;
        }
        checkBlock = block.getRelative(BlockFace.EAST);
        if (checkBlock.getTypeId() == Material.WALL_SIGN.getId() ? (face = checkBlock.getData()) == BlockUtil.faceList[3] && (doCheck = ignore == null ? true : !checkBlock.getLocation().equals((Object)ignore)) && ((text = (sign = (Sign)checkBlock.getState()).getLine(0).replaceAll("(?i)\u00a7[0-F]", "").toLowerCase()).equals("[private]") || text.equalsIgnoreCase(altPrivate)) : iterate && checkBlock.getTypeId() == block.getTypeId() && (checkBlock = Lockette.findBlockOwnerBase(checkBlock, ignore, iterateFurther, iterateUp, iterateDown, includeEnds, false)) != null) {
            return checkBlock;
        }
        checkBlock = block.getRelative(BlockFace.SOUTH);
        if (checkBlock.getTypeId() == Material.WALL_SIGN.getId() ? (face = checkBlock.getData()) == BlockUtil.faceList[0] && (doCheck = ignore == null ? true : !checkBlock.getLocation().equals((Object)ignore)) && ((text = (sign = (Sign)checkBlock.getState()).getLine(0).replaceAll("(?i)\u00a7[0-F]", "").toLowerCase()).equals("[private]") || text.equalsIgnoreCase(altPrivate)) : iterate && checkBlock.getTypeId() == block.getTypeId() && (checkBlock = Lockette.findBlockOwnerBase(checkBlock, ignore, iterateFurther, iterateUp, iterateDown, includeEnds, false)) != null) {
            return checkBlock;
        }
        checkBlock = block.getRelative(BlockFace.WEST);
        if (checkBlock.getTypeId() == Material.WALL_SIGN.getId() ? (face = checkBlock.getData()) == BlockUtil.faceList[1] && (doCheck = ignore == null ? true : !checkBlock.getLocation().equals((Object)ignore)) && ((text = (sign = (Sign)checkBlock.getState()).getLine(0).replaceAll("(?i)\u00a7[0-F]", "").toLowerCase()).equals("[private]") || text.equalsIgnoreCase(altPrivate)) : iterate && checkBlock.getTypeId() == block.getTypeId() && (checkBlock = Lockette.findBlockOwnerBase(checkBlock, ignore, iterateFurther, iterateUp, iterateDown, includeEnds, false)) != null) {
            return checkBlock;
        }
        return null;
    }

    protected static List<Block> findBlockUsers(Block block, Block signBlock) {
        int type = block.getTypeId();
        if (BlockUtil.isInList(type, BlockUtil.materialListChests)) {
            return Lockette.findBlockUsersBase(block, true, false, false, false, 0);
        }
        if (protectTrapDoors && BlockUtil.isInList(type, BlockUtil.materialListTrapDoors)) {
            return Lockette.findBlockUsersBase(Lockette.getTrapDoorAttachedBlock(block), false, false, false, true, 0);
        }
        if (protectDoors && BlockUtil.isInList(type, BlockUtil.materialListDoors)) {
            return Lockette.findBlockUsersBase(block, true, true, true, false, signBlock.getY());
        }
        return Lockette.findBlockUsersBase(block, false, false, false, false, 0);
    }

    private static List<Block> findBlockUsersBase(Block block, boolean iterate, boolean iterateUp, boolean iterateDown, boolean traps, int includeYPos) {
        Sign sign;
        String text;
        byte face;
        int type;
        Block checkBlock;
        ArrayList<Block> list = new ArrayList<Block>();
        if (iterateUp) {
            checkBlock = block.getRelative(BlockFace.UP);
            type = checkBlock.getTypeId();
            if (BlockUtil.isInList(type, BlockUtil.materialListDoors)) {
                list.addAll(Lockette.findBlockUsersBase(checkBlock, false, iterateUp, false, false, includeYPos));
            } else if (checkBlock.getY() == includeYPos) {
                list.addAll(Lockette.findBlockUsersBase(checkBlock, false, false, false, false, includeYPos));
            }
        }
        if (iterateDown) {
            checkBlock = block.getRelative(BlockFace.DOWN);
            type = checkBlock.getTypeId();
            if (BlockUtil.isInList(type, BlockUtil.materialListDoors)) {
                list.addAll(Lockette.findBlockUsersBase(checkBlock, false, false, iterateDown, false, includeYPos));
            } else {
                list.addAll(Lockette.findBlockUsersBase(checkBlock, false, false, false, false, includeYPos));
            }
        }
        if ((type = (checkBlock = block.getRelative(BlockFace.NORTH)).getTypeId()) == Material.WALL_SIGN.getId()) {
            face = checkBlock.getData();
            if (face == BlockUtil.faceList[2] && ((text = (sign = (Sign)checkBlock.getState()).getLine(0).replaceAll("(?i)\u00a7[0-F]", "").toLowerCase()).equals("[more users]") || text.equalsIgnoreCase(altMoreUsers))) {
                list.add(checkBlock);
            }
        } else if (iterate) {
            if (type == block.getTypeId()) {
                list.addAll(Lockette.findBlockUsersBase(checkBlock, false, iterateUp, iterateDown, false, includeYPos));
            }
        } else if (traps && BlockUtil.isInList(type, BlockUtil.materialListTrapDoors) && ((face = checkBlock.getData()) & 3) == 2) {
            list.addAll(Lockette.findBlockUsersBase(checkBlock, false, false, false, false, includeYPos));
        }
        if ((type = (checkBlock = block.getRelative(BlockFace.EAST)).getTypeId()) == Material.WALL_SIGN.getId()) {
            face = checkBlock.getData();
            if (face == BlockUtil.faceList[3] && ((text = (sign = (Sign)checkBlock.getState()).getLine(0).replaceAll("(?i)\u00a7[0-F]", "").toLowerCase()).equals("[more users]") || text.equalsIgnoreCase(altMoreUsers))) {
                list.add(checkBlock);
            }
        } else if (iterate) {
            if (type == block.getTypeId()) {
                list.addAll(Lockette.findBlockUsersBase(checkBlock, false, iterateUp, iterateDown, false, includeYPos));
            }
        } else if (traps && BlockUtil.isInList(type, BlockUtil.materialListTrapDoors) && ((face = checkBlock.getData()) & 3) == 0) {
            list.addAll(Lockette.findBlockUsersBase(checkBlock, false, false, false, false, includeYPos));
        }
        if ((type = (checkBlock = block.getRelative(BlockFace.SOUTH)).getTypeId()) == Material.WALL_SIGN.getId()) {
            face = checkBlock.getData();
            if (face == BlockUtil.faceList[0] && ((text = (sign = (Sign)checkBlock.getState()).getLine(0).replaceAll("(?i)\u00a7[0-F]", "").toLowerCase()).equals("[more users]") || text.equalsIgnoreCase(altMoreUsers))) {
                list.add(checkBlock);
            }
        } else if (iterate) {
            if (type == block.getTypeId()) {
                list.addAll(Lockette.findBlockUsersBase(checkBlock, false, iterateUp, iterateDown, false, includeYPos));
            }
        } else if (traps && BlockUtil.isInList(type, BlockUtil.materialListTrapDoors) && ((face = checkBlock.getData()) & 3) == 3) {
            list.addAll(Lockette.findBlockUsersBase(checkBlock, false, false, false, false, includeYPos));
        }
        if ((type = (checkBlock = block.getRelative(BlockFace.WEST)).getTypeId()) == Material.WALL_SIGN.getId()) {
            face = checkBlock.getData();
            if (face == BlockUtil.faceList[1] && ((text = (sign = (Sign)checkBlock.getState()).getLine(0).replaceAll("(?i)\u00a7[0-F]", "").toLowerCase()).equals("[more users]") || text.equalsIgnoreCase(altMoreUsers))) {
                list.add(checkBlock);
            }
        } else if (iterate) {
            if (type == block.getTypeId()) {
                list.addAll(Lockette.findBlockUsersBase(checkBlock, false, iterateUp, iterateDown, false, includeYPos));
            }
        } else if (traps && BlockUtil.isInList(type, BlockUtil.materialListTrapDoors) && ((face = checkBlock.getData()) & 3) == 1) {
            list.addAll(Lockette.findBlockUsersBase(checkBlock, false, false, false, false, includeYPos));
        }
        return list;
    }

    protected static int findChestCountNear(Block block) {
        return Lockette.findChestCountNearBase(block, (byte)0);
    }

    private static int findChestCountNearBase(Block block, byte face) {
        Block checkBlock;
        int count = 0;
        if (face != 2 && BlockUtil.isInList((checkBlock = block.getRelative(BlockFace.NORTH)).getTypeId(), BlockUtil.materialListChests) && checkBlock.getTypeId() == block.getTypeId()) {
            ++count;
            if (face == 0) {
                count += Lockette.findChestCountNearBase(checkBlock, (byte)3);
            }
        }
        if (face != 5 && BlockUtil.isInList((checkBlock = block.getRelative(BlockFace.EAST)).getTypeId(), BlockUtil.materialListChests) && checkBlock.getTypeId() == block.getTypeId()) {
            ++count;
            if (face == 0) {
                count += Lockette.findChestCountNearBase(checkBlock, (byte)4);
            }
        }
        if (face != 3 && BlockUtil.isInList((checkBlock = block.getRelative(BlockFace.SOUTH)).getTypeId(), BlockUtil.materialListChests) && checkBlock.getTypeId() == block.getTypeId()) {
            ++count;
            if (face == 0) {
                count += Lockette.findChestCountNearBase(checkBlock, (byte)2);
            }
        }
        if (face != 4 && BlockUtil.isInList((checkBlock = block.getRelative(BlockFace.WEST)).getTypeId(), BlockUtil.materialListChests) && checkBlock.getTypeId() == block.getTypeId()) {
            ++count;
            if (face == 0) {
                count += Lockette.findChestCountNearBase(checkBlock, (byte)5);
            }
        }
        return count;
    }

    protected static void rotateChestOrientation(Block block, BlockFace blockFace) {
        byte face;
        if (!BlockUtil.isInList(block.getTypeId(), BlockUtil.materialListChests)) {
            return;
        }
        if (!rotateChests && block.getData() != 0) {
            return;
        }
        if (blockFace == BlockFace.NORTH) {
            face = BlockUtil.faceList[2];
        } else if (blockFace == BlockFace.EAST) {
            face = BlockUtil.faceList[3];
        } else if (blockFace == BlockFace.SOUTH) {
            face = BlockUtil.faceList[0];
        } else if (blockFace == BlockFace.WEST) {
            face = BlockUtil.faceList[1];
        } else {
            return;
        }
        Block checkBlock = block.getRelative(BlockFace.NORTH);
        if (BlockUtil.isInList(checkBlock.getTypeId(), BlockUtil.materialListChests) && checkBlock.getTypeId() == block.getTypeId()) {
            if (face == BlockUtil.faceList[1] || face == BlockUtil.faceList[3]) {
                block.setData(face);
                checkBlock.setData(face);
            }
            return;
        }
        checkBlock = block.getRelative(BlockFace.EAST);
        if (BlockUtil.isInList(checkBlock.getTypeId(), BlockUtil.materialListChests) && checkBlock.getTypeId() == block.getTypeId()) {
            if (face == BlockUtil.faceList[2] || face == BlockUtil.faceList[0]) {
                block.setData(face);
                checkBlock.setData(face);
            }
            return;
        }
        checkBlock = block.getRelative(BlockFace.SOUTH);
        if (BlockUtil.isInList(checkBlock.getTypeId(), BlockUtil.materialListChests) && checkBlock.getTypeId() == block.getTypeId()) {
            if (face == BlockUtil.faceList[1] || face == BlockUtil.faceList[3]) {
                block.setData(face);
                checkBlock.setData(face);
            }
            return;
        }
        checkBlock = block.getRelative(BlockFace.WEST);
        if (BlockUtil.isInList(checkBlock.getTypeId(), BlockUtil.materialListChests) && checkBlock.getTypeId() == block.getTypeId()) {
            if (face == BlockUtil.faceList[2] || face == BlockUtil.faceList[0]) {
                block.setData(face);
                checkBlock.setData(face);
            }
            return;
        }
        block.setData(face);
    }

    protected static List<Block> toggleDoors(Block block, Block keyBlock, boolean wooden, boolean trap) {
        ArrayList<Block> list = new ArrayList<Block>();
        Lockette.toggleDoorBase(block, keyBlock, !trap, wooden, list);
        try {
            if (!wooden) {
                block.getWorld().playEffect(block.getLocation(), Effect.DOOR_TOGGLE, 0);
            }
        }
        catch (NoSuchFieldError ex) {
        }
        catch (NoSuchMethodError ex) {
        }
        catch (NoClassDefFoundError ex) {
            // empty catch block
        }
        return list;
    }

    protected static void toggleSingleDoor(Block block) {
        int type = block.getTypeId();
        if (BlockUtil.isInList(type, BlockUtil.materialListJustDoors)) {
            Lockette.toggleDoorBase(block, null, true, false, null);
        } else if (BlockUtil.isInList(type, BlockUtil.materialListTrapDoors) || BlockUtil.isInList(type, BlockUtil.materialListGates)) {
            Lockette.toggleDoorBase(block, null, false, false, null);
        }
    }

    protected static void toggleHalfDoor(Block block, boolean effect) {
        int type = block.getTypeId();
        if (BlockUtil.isInList(type, BlockUtil.materialListDoors)) {
            block.setData((byte)(block.getData() ^ 4));
            try {
                if (effect) {
                    block.getWorld().playEffect(block.getLocation(), Effect.DOOR_TOGGLE, 0);
                }
            }
            catch (NoSuchFieldError ex) {
            }
            catch (NoSuchMethodError ex) {
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
    }

    private static void toggleDoorBase(Block block, Block keyBlock, boolean iterateUpDown, boolean skipDoor, List<Block> list) {
        Block checkBlock;
        if (list != null) {
            list.add(block);
        }
        if (!skipDoor) {
            block.setData((byte)(block.getData() ^ 4));
        }
        if (iterateUpDown) {
            checkBlock = block.getRelative(BlockFace.UP);
            if (checkBlock.getTypeId() == block.getTypeId()) {
                Lockette.toggleDoorBase(checkBlock, null, false, skipDoor, list);
            }
            if ((checkBlock = block.getRelative(BlockFace.DOWN)).getTypeId() == block.getTypeId()) {
                Lockette.toggleDoorBase(checkBlock, null, false, skipDoor, list);
            }
        }
        if (keyBlock != null) {
            checkBlock = block.getRelative(BlockFace.NORTH);
            if (checkBlock.getTypeId() == block.getTypeId() && (checkBlock.getX() == keyBlock.getX() && checkBlock.getZ() == keyBlock.getZ() || block.getX() == keyBlock.getX() && block.getZ() == keyBlock.getZ())) {
                Lockette.toggleDoorBase(checkBlock, null, true, false, list);
            }
            if ((checkBlock = block.getRelative(BlockFace.EAST)).getTypeId() == block.getTypeId() && (checkBlock.getX() == keyBlock.getX() && checkBlock.getZ() == keyBlock.getZ() || block.getX() == keyBlock.getX() && block.getZ() == keyBlock.getZ())) {
                Lockette.toggleDoorBase(checkBlock, null, true, false, list);
            }
            if ((checkBlock = block.getRelative(BlockFace.SOUTH)).getTypeId() == block.getTypeId() && (checkBlock.getX() == keyBlock.getX() && checkBlock.getZ() == keyBlock.getZ() || block.getX() == keyBlock.getX() && block.getZ() == keyBlock.getZ())) {
                Lockette.toggleDoorBase(checkBlock, null, true, false, list);
            }
            if ((checkBlock = block.getRelative(BlockFace.WEST)).getTypeId() == block.getTypeId() && (checkBlock.getX() == keyBlock.getX() && checkBlock.getZ() == keyBlock.getZ() || block.getX() == keyBlock.getX() && block.getZ() == keyBlock.getZ())) {
                Lockette.toggleDoorBase(checkBlock, null, true, false, list);
            }
        }
    }

    protected static int getSignOption(Block signBlock, String tag, String altTag, int defaultValue) {
        Sign sign = (Sign)signBlock.getState();
        for (int y = 2; y <= 3; ++y) {
            int x;
            String line;
            int end;
            if (sign.getLine(y).isEmpty() || (end = (line = sign.getLine(y).replaceAll("(?i)\u00a7[0-F]", "")).length() - 1) < 2 || line.charAt(0) != '[' || line.charAt(end) != ']') continue;
            int index = line.indexOf(":");
            if (index == -1) {
                if (!line.substring(1, end).equalsIgnoreCase(tag) && !line.substring(1, end).equalsIgnoreCase(altTag)) continue;
                return defaultValue;
            }
            if (!line.substring(1, index).equalsIgnoreCase(tag) && !line.substring(1, index).equalsIgnoreCase(altTag)) continue;
            for (x = index; x < end; ++x) {
                if (!Character.isDigit(line.charAt(x))) continue;
                index = x;
                break;
            }
            for (x = index + 1; x < end; ++x) {
                if (Character.isDigit(line.charAt(x))) continue;
                end = x;
                break;
            }
            try {
                int value = Integer.parseInt(line.substring(index, end));
                return value;
            }
            catch (NumberFormatException ex) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    protected static boolean isInList(Object target, List<Object> list) {
        if (list == null) {
            return false;
        }
        for (int x = 0; x < list.size(); ++x) {
            if (!list.get(x).equals(target)) continue;
            return true;
        }
        return false;
    }

    private static boolean isHackFormat(String line) {
        String[] strs = line.split(":");
        return line.indexOf(":") > 1 && strs[1].length() == 36;
    }

    private static String trim(String str) {
        return str == null ? null : str.trim();
    }

    private static String getPlayerName(String str) {
        return Lockette.trim(str.indexOf(":") > 0 ? str.split(":")[0] : str);
    }

    private static String getPlayerUUIDString(String str) {
        return Lockette.trim(str.indexOf(":") > 0 ? str.split(":")[1] : str);
    }

    private static UUID getPlayerUUID(String str) {
        return UUID.fromString(Lockette.getPlayerUUIDString(str));
    }

    static void setLine(Sign sign, int index, String typed) {
        OfflinePlayer player = null;
        if (!typed.isEmpty() && typed.indexOf("[") != 0) {
            String id = ChatColor.stripColor((String)typed.replaceAll("&([0-9A-Fa-f])", ""));
            player = Bukkit.getOfflinePlayer((String)id);
        }
        Lockette.setLine(sign, index, typed, player);
    }

    static void setLine(Sign sign, int index, String typed, OfflinePlayer player) {
        String cline = typed.replaceAll("&([0-9A-Fa-f])", "\u00a7$1");
        sign.setLine(index, cline);
        sign.update(true);
        UUID[] uuids = null;
        if (!sign.hasMetadata(META_KEY)) {
            uuids = new UUID[3];
            sign.setMetadata(META_KEY, (MetadataValue)new FixedMetadataValue((Plugin)plugin, (Object)uuids));
        } else {
            List list = sign.getMetadata(META_KEY);
            uuids = (UUID[])((MetadataValue)list.get(0)).value();
        }
        UUID uUID = uuids[index - 1] = player != null ? player.getUniqueId() : null;
        if (DEBUG) {
            log.info("[Lockette] setting the line " + index + " to " + cline);
            log.info("[Lockette] corresponding player is " + player);
            log.info("[Lockette] uuid has been attached: " + uuids[index - 1]);
        }
    }

    private static UUID getUUIDFromMeta(Sign sign, int index) {
        if (sign.hasMetadata(META_KEY)) {
            List list = sign.getMetadata(META_KEY);
            return ((UUID[])((MetadataValue)list.get(0)).value())[index - 1];
        }
        return null;
    }

    static void removeUUIDMetadata(Sign sign) {
        if (sign.hasMetadata(META_KEY)) {
            sign.removeMetadata(META_KEY, (Plugin)plugin);
        }
    }

    private static boolean oldFormatCheck(String signname, String pname) {
        signname = ChatColor.stripColor((String)signname);
        int length = (pname = ChatColor.stripColor((String)pname)).length();
        if (length > 15) {
            length = 15;
        }
        return signname.equalsIgnoreCase(pname.substring(0, length));
    }

    private static boolean matchUserUUID(Sign sign, int index, OfflinePlayer player, boolean update) {
        try {
            OfflinePlayer oplayer;
            String line = sign.getLine(index);
            String checkline = ChatColor.stripColor((String)line);
            if (checkline.indexOf("[") == 0 && checkline.indexOf("]") > 1 || line.isEmpty()) {
                return false;
            }
            if (!uuidSupport) {
                if (DEBUG) {
                    log.info("[Lockette] NO UUID support, doing old name checking.");
                }
                String pname = player.getName();
                String against = checkline.split(":")[0].trim();
                return Lockette.oldFormatCheck(against, pname);
            }
            UUID uuid = null;
            String name = Lockette.getPlayerName(line);
            if (DEBUG) {
                log.info("[Lockette] Name on the sign is : " + name);
            }
            if (Lockette.isHackFormat(line)) {
                try {
                    uuid = Lockette.getPlayerUUID(line);
                }
                catch (IllegalArgumentException e) {
                    log.info("[" + plugin.getDescription().getName() + "] Invalid Player UUID!");
                    return false;
                }
                if (uuid != null && update) {
                    OfflinePlayer p = Bukkit.getOfflinePlayer((UUID)uuid);
                    if (DEBUG) {
                        log.info("[Lockette] updating the old hacked format for " + p);
                    }
                    Lockette.setLine(sign, index, name, p);
                }
                sign.update();
            }
            if (!sign.hasMetadata(META_KEY) || Lockette.getUUIDFromMeta(sign, index) == null) {
                if (DEBUG) {
                    log.info("[Lockette] Checking for original format for " + checkline);
                }
                if ((oplayer = Bukkit.getOfflinePlayer((String)checkline)) != null && oplayer.hasPlayedBefore()) {
                    if (DEBUG) {
                        log.info("[Lockette] converting original format for " + oplayer + " name = " + checkline);
                    }
                    Lockette.setLine(sign, index, line, oplayer);
                } else {
                    String pname = player.getName();
                    String against = checkline.split(":")[0].trim();
                    if (Lockette.oldFormatCheck(against, pname)) {
                        if (DEBUG) {
                            log.info("[Lockette] Partial match! Converting original format for " + player.getName() + " name = " + checkline);
                        }
                        Lockette.setLine(sign, index, player.getName(), player);
                    }
                }
                sign.update();
            }
            uuid = Lockette.getUUIDFromMeta(sign, index);
            if (DEBUG) {
                log.info("[Lockette] uuid on the sign = " + uuid);
                log.info("[Lockette] player's uuid    = " + player.getUniqueId());
            }
            if (uuid != null) {
                if (uuid.equals(player.getUniqueId())) {
                    if (!ChatColor.stripColor((String)ChatColor.stripColor((String)name)).equals(player.getName())) {
                        sign.setLine(index, player.getName());
                        sign.update();
                    }
                    return true;
                }
                oplayer = Bukkit.getOfflinePlayer((UUID)uuid);
                if (!oplayer.hasPlayedBefore()) {
                    if (DEBUG) {
                        log.info("[Lockette] removing bad UUID");
                    }
                    Lockette.removeUUIDMetadata(sign);
                }
            } else {
                List<String> names = Lockette.getPreviousNames(player.getUniqueId());
                for (String n : names) {
                    if (!n.equalsIgnoreCase(name)) continue;
                    if (DEBUG) {
                        log.info("[Lockette] Found the match in the name history!");
                    }
                    Lockette.setLine(sign, index, player.getName(), player);
                    return true;
                }
            }
        }
        catch (Exception e) {
            log.info("[Lockette] Something bad happened returning match = false");
            e.printStackTrace();
        }
        return false;
    }

    public static boolean isOwner(Block block, String name) {
        return Lockette.isOwner(block, Bukkit.getOfflinePlayer((String)name));
    }

    public static boolean isUser(Block block, String name, boolean withGroups) {
        return Lockette.isUser(block, Bukkit.getOfflinePlayer((String)name), withGroups);
    }

    public static boolean isOwner(Block block, OfflinePlayer player) {
        if (!enabled) {
            return true;
        }
        Block checkBlock = Lockette.findBlockOwner(block);
        if (checkBlock == null) {
            return true;
        }
        Sign sign = (Sign)checkBlock.getState();
        return Lockette.matchUserUUID(sign, 1, player, true);
    }

    public static boolean isOwner(Sign sign, OfflinePlayer player) {
        return Lockette.matchUserUUID(sign, 1, player, true);
    }

    public static boolean isUser(Block block, OfflinePlayer player, boolean withGroups) {
        if (!enabled) {
            return true;
        }
        Block signBlock = Lockette.findBlockOwner(block);
        if (signBlock == null) {
            return true;
        }
        Sign sign = (Sign)signBlock.getState();
        for (int y = 1; y <= 3; ++y) {
            String line = sign.getLine(y);
            if (Lockette.matchUserUUID(sign, y, player, true)) {
                return true;
            }
            if (!withGroups || !plugin.inGroup(block.getWorld(), player.getName(), line)) continue;
            return true;
        }
        List<Block> list = Lockette.findBlockUsers(block, signBlock);
        for (Block blk : list) {
            sign = (Sign)blk.getState();
            for (int y = 1; y <= 3; ++y) {
                String line = sign.getLine(y);
                if (Lockette.matchUserUUID(sign, y, player, true)) {
                    return true;
                }
                if (!withGroups || !plugin.inGroup(block.getWorld(), player.getName(), line)) continue;
                return true;
            }
        }
        return false;
    }

    private static List<String> getPreviousNames(UUID uuid) {
        Object name = null;
        ArrayList<String> list = new ArrayList<String>();
        try {
            if (name == null) {
                HttpURLConnection connection = (HttpURLConnection)new URL(NAME_HISTORY_URL + uuid.toString().replace("-", "") + "/names").openConnection();
                JSONArray array = (JSONArray)jsonParser.parse((Reader)new InputStreamReader(connection.getInputStream()));
                for (JSONObject obj : array) {
                    list.add((String)obj.get((Object)"name"));
                }
            }
        }
        catch (Exception ioe) {
            log.info("[Lockette] Failed to get Name history!");
        }
        return list;
    }

    static {
        enabled = false;
        uuidSupport = false;
        registered = false;
        blockHopper = false;
        customBlockList = null;
        disabledPluginList = null;
        strings = null;
        NAME_HISTORY_URL = "https://api.mojang.com/user/profiles/";
        jsonParser = new JSONParser();
    }
}

