/*
 * Decompiled with CFR 0.152.
 */
package com.github.fridujo.rabbitmq.mock.exchange;

import com.github.fridujo.rabbitmq.mock.AmqArguments;
import com.github.fridujo.rabbitmq.mock.ReceiverRegistry;
import com.github.fridujo.rabbitmq.mock.configuration.Configuration;
import com.github.fridujo.rabbitmq.mock.exchange.BindableMockExchange;
import com.github.fridujo.rabbitmq.mock.exchange.MockDirectExchange;
import com.github.fridujo.rabbitmq.mock.exchange.MockFanoutExchange;
import com.github.fridujo.rabbitmq.mock.exchange.MockHeadersExchange;
import com.github.fridujo.rabbitmq.mock.exchange.MockTopicExchange;

public class MockExchangeFactory {
    private final Configuration configuration;

    public MockExchangeFactory(Configuration configuration) {
        this.configuration = configuration;
    }

    public BindableMockExchange build(String exchangeName, String type, AmqArguments arguments, ReceiverRegistry receiverRegistry) {
        if ("topic".equals(type)) {
            return new MockTopicExchange(exchangeName, arguments, receiverRegistry);
        }
        if ("direct".equals(type)) {
            return new MockDirectExchange(exchangeName, arguments, receiverRegistry);
        }
        if ("fanout".equals(type)) {
            return new MockFanoutExchange(exchangeName, arguments, receiverRegistry);
        }
        if ("headers".equals(type)) {
            return new MockHeadersExchange(exchangeName, arguments, receiverRegistry);
        }
        if (this.configuration.isAdditionalExchangeRegisteredFor(type)) {
            return this.configuration.getAdditionalExchangeByType(type).createMockExchange(exchangeName, arguments, receiverRegistry);
        }
        throw new IllegalArgumentException("No exchange type " + type);
    }
}

