/*
 * Decompiled with CFR 0.152.
 */
package com.github.fridujo.rabbitmq.mock;

import com.github.fridujo.rabbitmq.mock.MockNode;
import com.github.fridujo.rabbitmq.mock.TransactionalOperations;
import com.rabbitmq.client.AMQP;
import java.util.ArrayList;
import java.util.List;

public class Transaction
implements TransactionalOperations {
    private final MockNode mockNode;
    private final List<PublishedMessage> publishedMessages = new ArrayList<PublishedMessage>();
    private final List<Reject> rejects = new ArrayList<Reject>();
    private final List<Nack> nacks = new ArrayList<Nack>();
    private final List<Ack> acks = new ArrayList<Ack>();

    public Transaction(MockNode mockNode) {
        this.mockNode = mockNode;
    }

    public void commit() {
        this.publishedMessages.forEach(publishedMessage -> this.mockNode.basicPublish(((PublishedMessage)publishedMessage).exchange, ((PublishedMessage)publishedMessage).routingKey, ((PublishedMessage)publishedMessage).mandatory, ((PublishedMessage)publishedMessage).immediate, ((PublishedMessage)publishedMessage).props, ((PublishedMessage)publishedMessage).body));
        this.publishedMessages.clear();
        this.rejects.forEach(reject -> this.mockNode.basicReject(((Reject)reject).deliveryTag, ((Reject)reject).requeue));
        this.rejects.clear();
        this.nacks.forEach(nack -> this.mockNode.basicNack(((Nack)nack).deliveryTag, ((Nack)nack).multiple, ((Nack)nack).requeue));
        this.nacks.clear();
        this.acks.forEach(ack -> this.mockNode.basicAck(((Ack)ack).deliveryTag, ((Ack)ack).multiple));
        this.acks.clear();
    }

    @Override
    public boolean basicPublish(String exchange, String routingKey, boolean mandatory, boolean immediate, AMQP.BasicProperties props, byte[] body) {
        this.publishedMessages.add(new PublishedMessage(exchange, routingKey, mandatory, immediate, props, body));
        return true;
    }

    @Override
    public void basicReject(long deliveryTag, boolean requeue) {
        this.rejects.add(new Reject(deliveryTag, requeue));
    }

    @Override
    public void basicNack(long deliveryTag, boolean multiple, boolean requeue) {
        this.nacks.add(new Nack(deliveryTag, multiple, requeue));
    }

    @Override
    public void basicAck(long deliveryTag, boolean multiple) {
        this.acks.add(new Ack(deliveryTag, multiple));
    }

    private static class Ack {
        private final long deliveryTag;
        private final boolean multiple;

        private Ack(long deliveryTag, boolean multiple) {
            this.deliveryTag = deliveryTag;
            this.multiple = multiple;
        }
    }

    private static class Nack {
        private final long deliveryTag;
        private final boolean multiple;
        private final boolean requeue;

        private Nack(long deliveryTag, boolean multiple, boolean requeue) {
            this.deliveryTag = deliveryTag;
            this.multiple = multiple;
            this.requeue = requeue;
        }
    }

    private static class Reject {
        private final long deliveryTag;
        private final boolean requeue;

        private Reject(long deliveryTag, boolean requeue) {
            this.deliveryTag = deliveryTag;
            this.requeue = requeue;
        }
    }

    private static class PublishedMessage {
        private final String exchange;
        private final String routingKey;
        private final boolean mandatory;
        private final boolean immediate;
        private final AMQP.BasicProperties props;
        private final byte[] body;

        private PublishedMessage(String exchange, String routingKey, boolean mandatory, boolean immediate, AMQP.BasicProperties props, byte[] body) {
            this.exchange = exchange;
            this.routingKey = routingKey;
            this.mandatory = mandatory;
            this.immediate = immediate;
            this.props = props;
            this.body = body;
        }
    }
}

