/*
 * Decompiled with CFR 0.152.
 */
package com.github.fridujo.rabbitmq.mock;

import com.rabbitmq.client.AMQP;
import java.time.Instant;
import java.util.Optional;

public class Message {
    public final int id;
    public final String exchangeName;
    public final String routingKey;
    public final AMQP.BasicProperties props;
    public final byte[] body;
    public final long expiryTime;
    public final boolean redelivered;

    public Message(int id, String exchangeName, String routingKey, AMQP.BasicProperties props, byte[] body, long expiryTime) {
        this(id, exchangeName, routingKey, props, body, expiryTime, false);
    }

    private Message(int id, String exchangeName, String routingKey, AMQP.BasicProperties props, byte[] body, long expiryTime, boolean redelivered) {
        this.id = id;
        this.exchangeName = exchangeName;
        this.routingKey = routingKey;
        this.props = props;
        this.body = body;
        this.expiryTime = expiryTime;
        this.redelivered = redelivered;
    }

    public Message asRedelivered() {
        return new Message(this.id, this.exchangeName, this.routingKey, this.props, this.body, this.expiryTime, true);
    }

    public boolean isExpired() {
        return this.expiryTime > -1L && System.currentTimeMillis() > this.expiryTime;
    }

    public int priority() {
        return Optional.ofNullable(this.props.getPriority()).orElse(0);
    }

    public String toString() {
        return "Message{exchangeName='" + this.exchangeName + '\'' + ", routingKey='" + this.routingKey + '\'' + ", body=" + new String(this.body) + ", expiryTime=" + Instant.ofEpochMilli(this.expiryTime) + '}';
    }
}

