/*
 * Decompiled with CFR 0.152.
 */
package com.github.fridujo.rabbitmq.mock;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.CancelCallback;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.ConsumerShutdownSignalCallback;
import com.rabbitmq.client.DeliverCallback;
import com.rabbitmq.client.Delivery;
import com.rabbitmq.client.Envelope;
import com.rabbitmq.client.ShutdownSignalException;
import java.io.IOException;

public class ConsumerWrapper
implements Consumer {
    private final DeliverCallback deliverCallback;
    private final CancelCallback cancelCallback;
    private final ConsumerShutdownSignalCallback shutdownSignalCallback;

    public ConsumerWrapper(DeliverCallback deliverCallback, CancelCallback cancelCallback, ConsumerShutdownSignalCallback shutdownSignalCallback) {
        this.deliverCallback = deliverCallback;
        this.cancelCallback = cancelCallback;
        this.shutdownSignalCallback = shutdownSignalCallback;
    }

    public void handleConsumeOk(String consumerTag) {
    }

    public void handleCancelOk(String consumerTag) {
    }

    public void handleCancel(String consumerTag) throws IOException {
        if (this.cancelCallback != null) {
            this.cancelCallback.handle(consumerTag);
        }
    }

    public void handleShutdownSignal(String consumerTag, ShutdownSignalException sig) {
        if (this.shutdownSignalCallback != null) {
            this.shutdownSignalCallback.handleShutdownSignal(consumerTag, sig);
        }
    }

    public void handleRecoverOk(String consumerTag) {
    }

    public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
        this.deliverCallback.handle(consumerTag, new Delivery(envelope, properties, body));
    }
}

