/*
 * Decompiled with CFR 0.152.
 */
package com.github.fridujo.rabbitmq.mock;

import com.github.fridujo.rabbitmq.mock.MockChannel;
import com.github.fridujo.rabbitmq.mock.Receiver;
import com.github.fridujo.rabbitmq.mock.ReceiverPointer;
import com.github.fridujo.rabbitmq.mock.ReceiverRegistry;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Envelope;
import com.rabbitmq.client.GetResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockQueue
implements Receiver {
    private static final Logger LOGGER = LoggerFactory.getLogger(MockQueue.class);
    private final String name;
    private final ReceiverPointer pointer;
    private final Map<String, Object> arguments;
    private final ReceiverRegistry receiverRegistry;
    private final MockChannel mockChannel;
    private final Map<String, ConsumerAndTag> consumersByTag = new LinkedHashMap<String, ConsumerAndTag>();
    private final AtomicInteger sequence = new AtomicInteger();
    private final Queue<Message> messages = new LinkedList<Message>();
    private final Map<Long, Message> unackedMessagesByDeliveryTag = new LinkedHashMap<Long, Message>();
    private final ExecutorService executorService = Executors.newFixedThreadPool(1);

    public MockQueue(String name, Map<String, Object> arguments, ReceiverRegistry receiverRegistry, MockChannel mockChannel) {
        this.name = name;
        this.pointer = new ReceiverPointer(ReceiverPointer.Type.QUEUE, name);
        this.arguments = arguments;
        this.receiverRegistry = receiverRegistry;
        this.mockChannel = mockChannel;
        this.start();
    }

    private void start() {
        this.executorService.submit(() -> {
            while (true) {
                if (this.deliverToConsumerIfPossible()) {
                    continue;
                }
                TimeUnit.MILLISECONDS.sleep(30L);
            }
        });
    }

    private boolean deliverToConsumerIfPossible() {
        Message message;
        boolean delivered = false;
        if (this.consumersByTag.size() > 0 && (message = this.messages.poll()) != null) {
            int index = this.sequence.incrementAndGet() % this.consumersByTag.size();
            ConsumerAndTag nextConsumer = new ArrayList<ConsumerAndTag>(this.consumersByTag.values()).get(index);
            long deliveryTag = (Long)nextConsumer.deliveryTagSupplier.get();
            this.unackedMessagesByDeliveryTag.put(deliveryTag, message);
            Envelope envelope = new Envelope(deliveryTag, false, message.exchangeName, message.routingKey);
            try {
                nextConsumer.consumer.handleDelivery(nextConsumer.tag, envelope, message.props, message.body);
                this.mockChannel.getMetricsCollector().consumedMessage((Channel)this.mockChannel, deliveryTag, nextConsumer.tag);
                if (nextConsumer.autoAck) {
                    this.unackedMessagesByDeliveryTag.remove(deliveryTag);
                }
                delivered = true;
            }
            catch (IOException e) {
                LOGGER.warn("Unable to deliver message to consumer [" + nextConsumer.tag + "]");
                this.basicReject(deliveryTag, true);
            }
        }
        return delivered;
    }

    @Override
    public void publish(String exchangeName, String routingKey, AMQP.BasicProperties props, byte[] body) {
        this.messages.offer(new Message(exchangeName, routingKey, props, body));
    }

    @Override
    public ReceiverPointer pointer() {
        return this.pointer;
    }

    public void basicConsume(String consumerTag, com.rabbitmq.client.Consumer consumer, boolean autoAck, Supplier<Long> deliveryTagSupplier) {
        this.consumersByTag.put(consumerTag, new ConsumerAndTag(consumerTag, consumer, autoAck, deliveryTagSupplier));
        consumer.handleConsumeOk(consumerTag);
    }

    public GetResponse basicGet(boolean autoAck, Supplier<Long> deliveryTagSupplier) {
        long deliveryTag = deliveryTagSupplier.get();
        Message message = this.messages.poll();
        if (message != null) {
            if (!autoAck) {
                this.unackedMessagesByDeliveryTag.put(deliveryTag, message);
            }
            Envelope envelope = new Envelope(deliveryTag, false, message.exchangeName, message.routingKey);
            return new GetResponse(envelope, message.props, message.body, this.messages.size());
        }
        return null;
    }

    public void basicAck(long deliveryTag, boolean multiple) {
        if (multiple) {
            this.doWithUnackedUntil(deliveryTag, this.unackedMessagesByDeliveryTag::remove);
        } else {
            this.unackedMessagesByDeliveryTag.remove(deliveryTag);
        }
    }

    public void basicNack(long deliveryTag, boolean multiple, boolean requeue) {
        if (multiple) {
            this.doWithUnackedUntil(deliveryTag, relevantDeliveryTag -> this.basicReject((long)relevantDeliveryTag, requeue));
        } else {
            this.basicReject(deliveryTag, requeue);
        }
    }

    public void basicReject(long deliveryTag, boolean requeue) {
        Message nacked = this.unackedMessagesByDeliveryTag.remove(deliveryTag);
        if (nacked != null) {
            if (requeue) {
                this.messages.offer(nacked);
            } else {
                this.getDeadLetterExchange().ifPresent(deadLetterExchange -> deadLetterExchange.publish(nacked.exchangeName, nacked.routingKey, nacked.props, nacked.body));
            }
        }
    }

    private Optional<Receiver> getDeadLetterExchange() {
        return Optional.ofNullable(this.arguments.get("x-dead-letter-exchange")).filter(aeObject -> aeObject instanceof String).map(String.class::cast).map(aeName -> new ReceiverPointer(ReceiverPointer.Type.EXCHANGE, (String)aeName)).flatMap(this.receiverRegistry::getReceiver);
    }

    public void basicCancel(String consumerTag) {
        if (this.consumersByTag.containsKey(consumerTag)) {
            com.rabbitmq.client.Consumer consumer = this.consumersByTag.remove(consumerTag).consumer;
            consumer.handleCancelOk(consumerTag);
        }
    }

    public void notifyDeleted() {
        for (ConsumerAndTag consumerAndTag : this.consumersByTag.values()) {
            try {
                consumerAndTag.consumer.handleCancel(consumerAndTag.tag);
            }
            catch (IOException e) {
                LOGGER.warn("Consumer threw an exception when notified about cancellation", (Throwable)e);
            }
        }
    }

    public void basicRecover(boolean requeue) {
        LinkedHashSet<Long> unackedDeliveryTags = new LinkedHashSet<Long>(this.unackedMessagesByDeliveryTag.keySet());
        unackedDeliveryTags.forEach(unackedDeliveryTag -> this.messages.offer(this.unackedMessagesByDeliveryTag.remove(unackedDeliveryTag)));
        this.consumersByTag.values().forEach(consumerAndTag -> ((ConsumerAndTag)consumerAndTag).consumer.handleRecoverOk(((ConsumerAndTag)consumerAndTag).tag));
    }

    public int messageCount() {
        return this.messages.size();
    }

    public int consumerCount() {
        return this.consumersByTag.size();
    }

    public int purge() {
        int messageCount = this.messageCount();
        this.messages.clear();
        return messageCount;
    }

    private void doWithUnackedUntil(long maxDeliveryTag, Consumer<Long> doWithRelevantDeliveryTag) {
        if (this.unackedMessagesByDeliveryTag.containsKey(maxDeliveryTag)) {
            LinkedHashSet<Long> storedDeliveryTagsToRemove = new LinkedHashSet<Long>();
            for (Long storedDeliveryTag : this.unackedMessagesByDeliveryTag.keySet()) {
                storedDeliveryTagsToRemove.add(storedDeliveryTag);
                if (!Long.valueOf(maxDeliveryTag).equals(storedDeliveryTag)) continue;
                break;
            }
            storedDeliveryTagsToRemove.forEach(doWithRelevantDeliveryTag);
        }
    }

    static class Message {
        final String exchangeName;
        final String routingKey;
        final AMQP.BasicProperties props;
        final byte[] body;

        Message(String exchangeName, String routingKey, AMQP.BasicProperties props, byte[] body) {
            this.exchangeName = exchangeName;
            this.routingKey = routingKey;
            this.props = props;
            this.body = body;
        }
    }

    static class ConsumerAndTag {
        private final String tag;
        private final com.rabbitmq.client.Consumer consumer;
        private final boolean autoAck;
        private final Supplier<Long> deliveryTagSupplier;

        ConsumerAndTag(String tag, com.rabbitmq.client.Consumer consumer, boolean autoAck, Supplier<Long> deliveryTagSupplier) {
            this.tag = tag;
            this.consumer = consumer;
            this.autoAck = autoAck;
            this.deliveryTagSupplier = deliveryTagSupplier;
        }
    }
}

