/*
 * Decompiled with CFR 0.152.
 */
package com.github.fridujo.rabbitmq.mock;

import com.github.fridujo.rabbitmq.mock.BindableMockExchange;
import com.github.fridujo.rabbitmq.mock.ReceiverRegistry;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class MockHeadersExchange
extends BindableMockExchange {
    private static final String MATCH_ALL = "all";
    private static final Set<String> X_MATCH_VALID_VALUES = new HashSet<String>(Arrays.asList("any", "all"));

    public MockHeadersExchange(String exchangeName, Map<String, Object> arguments, ReceiverRegistry receiverRegistry) {
        super(exchangeName, arguments, receiverRegistry);
    }

    @Override
    protected boolean match(String bindingKey, Map<String, Object> bindArguments, String routingKey, Map<String, Object> headers) {
        String xMatch = Optional.ofNullable(bindArguments.get("x-match")).filter(xMatchObject -> xMatchObject instanceof String).map(String.class::cast).filter(X_MATCH_VALID_VALUES::contains).orElse(MATCH_ALL);
        Predicate<Map.Entry> argumentPredicate = e -> Objects.equals(e.getValue(), headers.get(e.getKey()));
        Stream<Map.Entry> argumentsToMatch = bindArguments.entrySet().stream().filter(e -> !"x-match".equals(e.getKey()));
        boolean match = MATCH_ALL.equals(xMatch) ? argumentsToMatch.allMatch(argumentPredicate) : argumentsToMatch.anyMatch(argumentPredicate);
        return match;
    }
}

