/*
 * Decompiled with CFR 0.152.
 */
package com.github.fridujo.rabbitmq.mock;

import com.github.fridujo.rabbitmq.mock.MockChannel;
import com.github.fridujo.rabbitmq.mock.MockNode;
import com.github.fridujo.rabbitmq.mock.metrics.MetricsCollectorWrapper;
import com.rabbitmq.client.AlreadyClosedException;
import com.rabbitmq.client.BlockedCallback;
import com.rabbitmq.client.BlockedListener;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ExceptionHandler;
import com.rabbitmq.client.ShutdownListener;
import com.rabbitmq.client.ShutdownSignalException;
import com.rabbitmq.client.UnblockedCallback;
import com.rabbitmq.client.impl.AMQConnection;
import com.rabbitmq.client.impl.DefaultExceptionHandler;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class MockConnection
implements Connection {
    private final AtomicBoolean opened = new AtomicBoolean(true);
    private final AtomicInteger channelSequence = new AtomicInteger();
    private final MockNode mockNode;
    private final MetricsCollectorWrapper metricsCollectorWrapper;
    private final InetAddress address;
    private final DefaultExceptionHandler exceptionHandler = new DefaultExceptionHandler();
    private String id;

    public MockConnection(MockNode mockNode, MetricsCollectorWrapper metricsCollectorWrapper) {
        this.mockNode = mockNode;
        this.metricsCollectorWrapper = metricsCollectorWrapper;
        this.address = new InetSocketAddress("127.0.0.1", 0).getAddress();
        this.metricsCollectorWrapper.newConnection(this);
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public int getPort() {
        return 5672;
    }

    public int getChannelMax() {
        return 0;
    }

    public int getFrameMax() {
        return 0;
    }

    public int getHeartbeat() {
        return 0;
    }

    public Map<String, Object> getClientProperties() {
        return AMQConnection.defaultClientProperties();
    }

    public String getClientProvidedName() {
        return null;
    }

    public Map<String, Object> getServerProperties() {
        return Collections.emptyMap();
    }

    public Channel createChannel() throws AlreadyClosedException {
        return this.createChannel(this.channelSequence.incrementAndGet());
    }

    public Channel createChannel(int channelNumber) throws AlreadyClosedException {
        if (!this.isOpen()) {
            throw new AlreadyClosedException(new ShutdownSignalException(false, true, null, (Object)this));
        }
        return new MockChannel(channelNumber, this.mockNode, this, this.metricsCollectorWrapper);
    }

    public void close() {
        this.close(200, "OK");
    }

    public void close(int closeCode, String closeMessage) {
        this.close(closeCode, closeMessage, -1);
    }

    public void close(int timeout) {
        this.close(200, "OK", timeout);
    }

    public void close(int closeCode, String closeMessage, int timeout) {
        this.metricsCollectorWrapper.closeConnection(this);
        this.opened.set(false);
    }

    public void abort() {
        this.abort(200, "OK");
    }

    public void abort(int closeCode, String closeMessage) {
        this.abort(closeCode, closeMessage, -1);
    }

    public void abort(int timeout) {
        this.abort(200, "OK", timeout);
    }

    public void abort(int closeCode, String closeMessage, int timeout) {
        this.close(closeCode, closeMessage, timeout);
    }

    public void addBlockedListener(BlockedListener listener) {
    }

    public BlockedListener addBlockedListener(BlockedCallback blockedCallback, UnblockedCallback unblockedCallback) {
        return null;
    }

    public boolean removeBlockedListener(BlockedListener listener) {
        return true;
    }

    public void clearBlockedListeners() {
    }

    public ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void addShutdownListener(ShutdownListener listener) {
    }

    public void removeShutdownListener(ShutdownListener listener) {
    }

    public ShutdownSignalException getCloseReason() {
        return null;
    }

    public void notifyListeners() {
        throw new UnsupportedOperationException();
    }

    public boolean isOpen() {
        return this.opened.get();
    }
}

