/*
 * Decompiled with CFR 0.152.
 */
package com.github.fridujo.glacio.parsing.parser;

import com.github.fridujo.glacio.ast.Background;
import com.github.fridujo.glacio.ast.DataTable;
import com.github.fridujo.glacio.ast.DocString;
import com.github.fridujo.glacio.ast.Examples;
import com.github.fridujo.glacio.ast.Feature;
import com.github.fridujo.glacio.ast.Keyword;
import com.github.fridujo.glacio.ast.KeywordType;
import com.github.fridujo.glacio.ast.Position;
import com.github.fridujo.glacio.ast.PositionedString;
import com.github.fridujo.glacio.ast.RootStep;
import com.github.fridujo.glacio.ast.Scenario;
import com.github.fridujo.glacio.ast.ScenarioOutline;
import com.github.fridujo.glacio.ast.Step;
import com.github.fridujo.glacio.ast.TableCell;
import com.github.fridujo.glacio.ast.TableRow;
import com.github.fridujo.glacio.ast.Tag;
import com.github.fridujo.glacio.parsing.ParsingException;
import com.github.fridujo.glacio.parsing.charstream.CharStream;
import com.github.fridujo.glacio.parsing.i18n.Languages;
import com.github.fridujo.glacio.parsing.lexer.FixedTokenDefinition;
import com.github.fridujo.glacio.parsing.lexer.Lexer;
import com.github.fridujo.glacio.parsing.lexer.Token;
import com.github.fridujo.glacio.parsing.lexer.TokenSequence;
import com.github.fridujo.glacio.parsing.lexer.TokenType;
import com.github.fridujo.glacio.parsing.parser.DynamicTokenDefinition;
import com.github.fridujo.glacio.parsing.parser.MissingTokenException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class AstParser {
    private final Pattern languageHintPattern = Pattern.compile("^language\\s*:\\s*(?<language>[^\\s]+)$");
    private final Lexer lexer;
    private final Languages languages;

    public AstParser(Lexer lexer, Languages languages) {
        this.lexer = lexer;
        this.languages = languages;
        this.lexer.setLanguageKeywords(languages.defaultLanguage());
    }

    public Feature parseFeature() {
        Optional<PositionedString> language = this.consumeComments(true);
        List<Tag> tags = this.parseTags();
        Token potentialFeature = this.lexer.next();
        if (potentialFeature.isOfType(TokenType.FEATURE)) {
            this.lexer.skipBlanks();
            Token potentialColon = this.lexer.next();
            if (potentialColon.isOfType(TokenType.COLON)) {
                String name = this.lexer.consumeUntilNextLine().toLiteral().trim();
                Optional<String> description = this.parseDescription();
                Optional<Background> background = this.parseBackground();
                List<Scenario> scenarios = this.parseScenarios();
                return new Feature(potentialFeature.getPosition().asModelPosition(), name, language, tags, description, background, scenarios);
            }
            throw new MissingTokenException(FixedTokenDefinition.COLON, potentialColon);
        }
        throw new MissingTokenException(potentialFeature, DynamicTokenDefinition.dynamicToken(TokenType.FEATURE, this.lexer.getLanguageKeywords().getFeature()));
    }

    private Optional<Background> parseBackground() {
        this.lexer.skipBlanksAndEOL();
        Token potentialBackgroundToken = this.lexer.peek();
        if (potentialBackgroundToken.isOfType(TokenType.BACKGROUND)) {
            this.lexer.next();
            this.lexer.skipBlanks();
            Token potentialColon = this.lexer.next();
            if (potentialColon.isOfType(TokenType.COLON)) {
                this.lexer.consumeUntilNextLine();
                Optional<String> description = this.parseDescription();
                List<RootStep> steps = this.parseRootSteps();
                return Optional.of(new Background(potentialBackgroundToken.getPosition().asModelPosition(), description, steps));
            }
            throw new MissingTokenException(FixedTokenDefinition.COLON, potentialColon);
        }
        return Optional.empty();
    }

    private List<Scenario> parseScenarios() {
        ArrayList<Scenario> scenarios = new ArrayList<Scenario>();
        while (!this.lexer.peekNextNonBlankToken().isOfType(TokenType.EOF)) {
            scenarios.add(this.parseScenario());
        }
        return scenarios;
    }

    public Scenario parseScenario() {
        this.consumeComments(false);
        List<Tag> tags = this.parseTags();
        Token potentialScenario = this.lexer.next();
        if (potentialScenario.isOfType(TokenType.SCENARIO)) {
            this.lexer.skipBlanks();
            Token potentialColon = this.lexer.next();
            if (potentialColon.isOfType(TokenType.COLON)) {
                Position position = potentialScenario.getPosition().asModelPosition();
                String name = this.lexer.consumeUntilNextLine().toLiteral().trim();
                Optional<String> description = this.parseDescription();
                List<RootStep> steps = this.parseRootSteps();
                return new Scenario(position, name, tags, description, steps);
            }
            throw new MissingTokenException(FixedTokenDefinition.COLON, potentialColon);
        }
        if (potentialScenario.isOfType(TokenType.SCENARIO_OUTLINE)) {
            this.lexer.skipBlanks();
            Token potentialColon = this.lexer.next();
            if (potentialColon.isOfType(TokenType.COLON)) {
                Position position = potentialScenario.getPosition().asModelPosition();
                String name = this.lexer.consumeUntilNextLine().toLiteral().trim();
                Optional<String> description = this.parseDescription();
                List<RootStep> steps = this.parseRootSteps();
                Examples examples = this.parseExamples();
                return new ScenarioOutline(position, name, tags, description, steps, examples);
            }
            throw new MissingTokenException(FixedTokenDefinition.COLON, potentialColon);
        }
        throw new MissingTokenException(potentialScenario, DynamicTokenDefinition.dynamicToken(TokenType.SCENARIO, this.lexer.getLanguageKeywords().getScenario()), DynamicTokenDefinition.dynamicToken(TokenType.SCENARIO_OUTLINE, this.lexer.getLanguageKeywords().getScenarioOutline()));
    }

    private List<RootStep> parseRootSteps() {
        this.lexer.skipBlanksAndEOL();
        this.consumeComments(false);
        ArrayList<RootStep> rootSteps = new ArrayList<RootStep>();
        KeywordType previousKeywordType = null;
        while (this.lexer.peek().isOfAnyType(TokenType.GIVEN, TokenType.WHEN, TokenType.THEN, TokenType.AND)) {
            Token keywordToken = this.lexer.next();
            Position position = keywordToken.getPosition().asModelPosition();
            Keyword keyword = this.mapKeyword(keywordToken, previousKeywordType);
            previousKeywordType = keyword.getType();
            String text = this.lexer.consumeUntilNextLine().toLiteral();
            Optional<DocString> docString = this.parseDocString();
            Optional<DataTable> dataTable = this.parseDataTable();
            List<Step> substeps = this.parseSubsteps();
            rootSteps.add(new RootStep(position, keyword, text, substeps, docString, dataTable));
            this.consumeComments(false);
        }
        return rootSteps;
    }

    private List<Step> parseSubsteps() {
        ArrayList<Step> steps = new ArrayList<Step>();
        if (this.lexer.peek().isOfType(TokenType.INDENT)) {
            this.lexer.next();
            while (!this.lexer.peek().isOfAnyType(TokenType.DEDENT, TokenType.EOF)) {
                Position position = this.lexer.peek().getPosition().asModelPosition();
                String text = this.lexer.consumeUntilNextLine().toLiteral();
                Optional<DocString> docString = this.parseDocString();
                Optional<DataTable> dataTable = this.parseDataTable();
                List<Step> substeps = this.parseSubsteps();
                steps.add(new Step(position, text, substeps, docString, dataTable));
            }
            this.lexer.next();
        }
        return steps;
    }

    private List<Tag> parseTags() {
        this.lexer.skipBlanksAndEOL();
        ArrayList<Tag> tags = new ArrayList<Tag>();
        while (this.lexer.peek().isOfType(TokenType.TAG_DELIMITER)) {
            this.lexer.next();
            TokenSequence tagName = this.lexer.consumeUntil(TokenType.SPACE, TokenType.TAG_DELIMITER, TokenType.EOL);
            tags.add(new Tag(tagName.toLiteral()));
            this.lexer.skipBlanksAndEOL();
        }
        this.lexer.skipBlanksAndEOL();
        return tags;
    }

    private Optional<String> parseDescription() {
        TokenSequence descriptionTokenSequence = this.lexer.consumeUntil(TokenType.BACKGROUND, TokenType.SCENARIO, TokenType.SCENARIO_OUTLINE, TokenType.EXAMPLES, TokenType.GIVEN, TokenType.WHEN, TokenType.THEN, TokenType.AND, TokenType.EOF);
        String unformattedDescription = descriptionTokenSequence.toLiteral();
        Optional<String> description = unformattedDescription.trim().length() > 0 ? Optional.of(this.formatTextBloc(unformattedDescription)) : Optional.empty();
        return description;
    }

    private Examples parseExamples() {
        this.lexer.skipBlanksAndEOL();
        Token potentialExamples = this.lexer.next();
        if (potentialExamples.isOfType(TokenType.EXAMPLES)) {
            this.lexer.skipBlanks();
            Token potentialColon = this.lexer.next();
            if (potentialColon.isOfType(TokenType.COLON)) {
                this.lexer.skipBlanksAndEOL();
                TableRow header = this.parseTableRow();
                ArrayList<TableRow> body = new ArrayList<TableRow>();
                while (this.lexer.peek().isOfType(TokenType.TABLE_DELIMITER)) {
                    body.add(this.parseTableRow());
                }
                return new Examples(potentialExamples.getPosition().asModelPosition(), header, body);
            }
            throw new MissingTokenException(FixedTokenDefinition.COLON, potentialColon);
        }
        throw new MissingTokenException(potentialExamples, DynamicTokenDefinition.dynamicToken(TokenType.EXAMPLES, this.lexer.getLanguageKeywords().getExamples()));
    }

    private Optional<DocString> parseDocString() {
        Optional<DocString> docString;
        Token potentialDocStringDelimiter = this.lexer.peekNextNonBlankToken();
        if (potentialDocStringDelimiter.isOfType(TokenType.DOC_STRING_DELIMITER)) {
            this.lexer.skipBlanksAndEOL();
            this.lexer.next();
            Optional<String> contentType = this.optional(this.lexer.consumeUntilNextLine().toLiteral().trim());
            TokenSequence contentTokenSequence = this.lexer.consumeUntil(TokenType.DOC_STRING_DELIMITER);
            this.lexer.next();
            this.lexer.skipTokensOfType(TokenType.SPACE, TokenType.EOL, TokenType.INDENT);
            String content = this.formatTextBloc(contentTokenSequence.toLiteral());
            docString = Optional.of(new DocString(potentialDocStringDelimiter.getPosition().asModelPosition(), contentType, content));
        } else {
            docString = Optional.empty();
        }
        return docString;
    }

    private Optional<DataTable> parseDataTable() {
        Token potentialFirstTableDelimiter = this.lexer.peekNextNonBlankToken();
        if (potentialFirstTableDelimiter.isOfType(TokenType.TABLE_DELIMITER)) {
            this.lexer.skipBlanksAndEOL();
            ArrayList<TableRow> rows = new ArrayList<TableRow>();
            while (this.lexer.peekNextNonBlankToken().isOfType(TokenType.TABLE_DELIMITER)) {
                rows.add(this.parseTableRow());
            }
            return Optional.of(new DataTable(potentialFirstTableDelimiter.getPosition().asModelPosition(), rows));
        }
        Optional<DataTable> docString = Optional.empty();
        return docString;
    }

    private TableRow parseTableRow() {
        Token potentialTableDelimiter = this.lexer.next();
        if (potentialTableDelimiter.isOfType(TokenType.TABLE_DELIMITER)) {
            ArrayList<TableCell> cells = new ArrayList<TableCell>();
            while (!this.lexer.peek().isOfAnyType(TokenType.EOL, TokenType.EOF)) {
                TokenSequence tokenSequence = this.lexer.consumeUntil(TokenType.TABLE_DELIMITER, TokenType.EOL, TokenType.EOF);
                cells.add(new TableCell(tokenSequence.toLiteral().trim()));
                Token potentialEndCellDelimiter = this.lexer.next();
                if (!potentialEndCellDelimiter.isOfType(TokenType.TABLE_DELIMITER)) {
                    throw new MissingTokenException(FixedTokenDefinition.TABLE_DELIMITER, potentialEndCellDelimiter);
                }
                this.lexer.skipBlanks();
            }
            this.lexer.consumeUntilNextLine();
            return new TableRow(potentialTableDelimiter.getPosition().asModelPosition(), cells);
        }
        throw new MissingTokenException(FixedTokenDefinition.TABLE_DELIMITER, potentialTableDelimiter);
    }

    private Optional<PositionedString> consumeComments(boolean interpretLanguageHint) {
        PositionedString explicitLanguage = null;
        while (this.lexer.peekNextNonBlankToken().isOfType(TokenType.COMMENT_DELIMITER)) {
            this.lexer.skipBlanksAndEOL();
            this.lexer.next();
            TokenSequence tokenSequence = this.lexer.consumeUntilNextLine();
            String comment = tokenSequence.toLiteral().trim();
            Matcher languageMatcher = this.languageHintPattern.matcher(comment);
            if (interpretLanguageHint && languageMatcher.matches()) {
                String language = languageMatcher.group("language");
                Position languagePosition = tokenSequence.getPosition().asModelPosition();
                this.lexer.setLanguageKeywords(this.languages.get(languagePosition, language));
                explicitLanguage = new PositionedString(languagePosition, language);
            }
            this.lexer.skipBlanksAndEOL();
        }
        return Optional.ofNullable(explicitLanguage);
    }

    private String formatTextBloc(String unformattedText) {
        String trimmedOfFirstEmptyLines = this.trimLeftEmptyLines(unformattedText);
        String firstIndent = new CharStream(trimmedOfFirstEmptyLines).peekUntil(Lexer.IS_NOT_A_SPACE);
        String[] lines = trimmedOfFirstEmptyLines.split("\n");
        for (int lineIndex = 0; lineIndex < lines.length; ++lineIndex) {
            if (!lines[lineIndex].startsWith(firstIndent)) continue;
            lines[lineIndex] = lines[lineIndex].substring(firstIndent.length());
        }
        return Arrays.stream(lines).collect(Collectors.joining("\n")).trim();
    }

    private String trimLeftEmptyLines(String text) {
        String[] lines = text.split("\n");
        int firstNonBlankLineIndex = -1;
        for (int lineIndex = 0; lineIndex < lines.length; ++lineIndex) {
            if (lines[lineIndex].trim().length() <= 0) continue;
            firstNonBlankLineIndex = lineIndex;
            break;
        }
        String[] linesWithFirstOneNonEmpty = Arrays.copyOfRange(lines, firstNonBlankLineIndex, lines.length);
        return Arrays.stream(linesWithFirstOneNonEmpty).collect(Collectors.joining("\n"));
    }

    private Keyword mapKeyword(Token keywordToken, KeywordType previousKeywordType) {
        KeywordType keywordType;
        if (keywordToken.isOfType(TokenType.AND)) {
            if (previousKeywordType == null) {
                throw new ParsingException(keywordToken.getPosition(), "Found AND keyword before any GIVEN, WHEN or THEN one");
            }
            keywordType = previousKeywordType;
        } else if (keywordToken.isOfType(TokenType.GIVEN)) {
            keywordType = KeywordType.GIVEN;
        } else if (keywordToken.isOfType(TokenType.WHEN)) {
            keywordType = KeywordType.WHEN;
        } else if (keywordToken.isOfType(TokenType.THEN)) {
            keywordType = KeywordType.THEN;
        } else {
            throw new IllegalStateException("Not a Keyword token");
        }
        return new Keyword(keywordType, keywordToken.getLiteral());
    }

    private Optional<String> optional(String s) {
        Optional<String> os = s == null || s.trim().length() == 0 ? Optional.empty() : Optional.of(s.trim());
        return os;
    }
}

