/*
 * Decompiled with CFR 0.152.
 */
package com.github.fridujo.glacio.parsing.i18n;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonObject;
import com.github.fridujo.glacio.ast.Position;
import com.github.fridujo.glacio.parsing.i18n.GherkinJsonMapper;
import com.github.fridujo.glacio.parsing.i18n.LanguageKeywords;
import com.github.fridujo.glacio.parsing.i18n.LanguageNotFoundException;
import com.github.fridujo.glacio.parsing.i18n.Languages;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Map;

public class GherkinLanguages
implements Languages {
    private final Map<String, LanguageKeywords> languageKeywordsByLanguages;

    private GherkinLanguages(Map<String, LanguageKeywords> languageKeywordsByLanguages) {
        this.languageKeywordsByLanguages = languageKeywordsByLanguages;
    }

    public static Languages load() throws IllegalStateException {
        GherkinLanguages gherkinLanguages;
        block8: {
            InputStream inputStream = GherkinLanguages.class.getClassLoader().getResourceAsStream("gherkin-languages.json");
            try {
                JsonObject jsonObject = Json.parse((Reader)new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8))).asObject();
                gherkinLanguages = new GherkinLanguages(new GherkinJsonMapper().map(jsonObject));
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Cannot read Gherkin languages file");
                }
            }
            inputStream.close();
        }
        return gherkinLanguages;
    }

    @Override
    public LanguageKeywords get(Position position, String language) throws LanguageNotFoundException {
        if (!this.languageKeywordsByLanguages.containsKey(language)) {
            throw new LanguageNotFoundException(position.asParsingPosition(), language, this.languageKeywordsByLanguages.keySet());
        }
        return this.languageKeywordsByLanguages.get(language);
    }
}

