/*
 * Decompiled with CFR 0.152.
 */
package com.github.freva.asciitable;

import com.github.freva.asciitable.Column;
import com.github.freva.asciitable.ColumnData;
import com.github.freva.asciitable.HorizontalAlign;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class AsciiTable {
    private static final int MIN_PADDING = 1;
    public static final Character[] NO_BORDERS = new Character[29];
    public static final Character[] BASIC_ASCII = new Character[]{Character.valueOf('+'), Character.valueOf('-'), Character.valueOf('+'), Character.valueOf('+'), Character.valueOf('|'), Character.valueOf('|'), Character.valueOf('|'), Character.valueOf('+'), Character.valueOf('-'), Character.valueOf('+'), Character.valueOf('+'), Character.valueOf('|'), Character.valueOf('|'), Character.valueOf('|'), Character.valueOf('+'), Character.valueOf('-'), Character.valueOf('+'), Character.valueOf('+'), Character.valueOf('+'), Character.valueOf('-'), Character.valueOf('+'), Character.valueOf('+'), Character.valueOf('|'), Character.valueOf('|'), Character.valueOf('|'), Character.valueOf('+'), Character.valueOf('-'), Character.valueOf('+'), Character.valueOf('+')};
    public static final Character[] BASIC_ASCII_NO_DATA_SEPARATORS = new Character[]{Character.valueOf('+'), Character.valueOf('-'), Character.valueOf('+'), Character.valueOf('+'), Character.valueOf('|'), Character.valueOf('|'), Character.valueOf('|'), Character.valueOf('+'), Character.valueOf('-'), Character.valueOf('+'), Character.valueOf('+'), Character.valueOf('|'), Character.valueOf('|'), Character.valueOf('|'), null, null, null, null, Character.valueOf('+'), Character.valueOf('-'), Character.valueOf('+'), Character.valueOf('+'), Character.valueOf('|'), Character.valueOf('|'), Character.valueOf('|'), Character.valueOf('+'), Character.valueOf('-'), Character.valueOf('+'), Character.valueOf('+')};
    public static final Character[] BASIC_ASCII_NO_DATA_SEPARATORS_NO_OUTSIDE_BORDER = new Character[]{null, null, null, null, null, Character.valueOf('|'), null, null, Character.valueOf('-'), Character.valueOf('+'), null, null, Character.valueOf('|'), null, null, null, null, null, null, Character.valueOf('-'), Character.valueOf('+'), null, null, Character.valueOf('|'), null, null, null, null, null};
    public static final Character[] BASIC_ASCII_NO_OUTSIDE_BORDER = new Character[]{null, null, null, null, null, Character.valueOf('|'), null, null, Character.valueOf('-'), Character.valueOf('+'), null, null, Character.valueOf('|'), null, null, Character.valueOf('-'), Character.valueOf('+'), null, null, Character.valueOf('-'), Character.valueOf('+'), null, null, Character.valueOf('|'), null, null, null, null, null};
    public static final Character[] FANCY_ASCII = new Character[]{Character.valueOf('\u2554'), Character.valueOf('\u2550'), Character.valueOf('\u2564'), Character.valueOf('\u2557'), Character.valueOf('\u2551'), Character.valueOf('\u2502'), Character.valueOf('\u2551'), Character.valueOf('\u2560'), Character.valueOf('\u2550'), Character.valueOf('\u256a'), Character.valueOf('\u2563'), Character.valueOf('\u2551'), Character.valueOf('\u2502'), Character.valueOf('\u2551'), Character.valueOf('\u255f'), Character.valueOf('\u2500'), Character.valueOf('\u253c'), Character.valueOf('\u2562'), Character.valueOf('\u2560'), Character.valueOf('\u2550'), Character.valueOf('\u256a'), Character.valueOf('\u2563'), Character.valueOf('\u2551'), Character.valueOf('\u2502'), Character.valueOf('\u2551'), Character.valueOf('\u255a'), Character.valueOf('\u2550'), Character.valueOf('\u2567'), Character.valueOf('\u255d')};

    public static <T> String getTable(Collection<T> objects, List<ColumnData<T>> columns) {
        return AsciiTable.getTable(BASIC_ASCII, objects, columns);
    }

    public static <T> String getTable(Character[] borderChars, Collection<T> objects, List<ColumnData<T>> columns) {
        Column[] rawColumns = columns.toArray(new Column[columns.size()]);
        String[][] data = (String[][])objects.stream().map(object -> (String[])columns.stream().map(dataColumn -> dataColumn.getCellValue(object)).toArray(String[]::new)).toArray(x$0 -> new String[x$0][]);
        return AsciiTable.getTable(borderChars, rawColumns, data);
    }

    public static String getTable(String[][] data) {
        return AsciiTable.getTable((String[])null, data);
    }

    public static String getTable(String[] header, String[][] data) {
        return AsciiTable.getTable(BASIC_ASCII, header, null, data);
    }

    public static String getTable(String[] header, String[] footer, String[][] data) {
        return AsciiTable.getTable(BASIC_ASCII, header, footer, data);
    }

    public static String getTable(Character[] borderChars, String[] header, String[] footer, String[][] data) {
        String[] nonNullHeader = header != null ? header : new String[]{};
        String[] nonNullFooter = footer != null ? footer : new String[]{};
        Column[] headerCol = (Column[])IntStream.range(0, Math.max(nonNullHeader.length, nonNullFooter.length)).mapToObj(index -> new Column().header(index < nonNullHeader.length ? nonNullHeader[index] : null).footer(index < nonNullFooter.length ? nonNullFooter[index] : null)).toArray(Column[]::new);
        return AsciiTable.getTable(borderChars, headerCol, data);
    }

    public static String getTable(Column[] columns, String[][] data) {
        return AsciiTable.getTable(BASIC_ASCII, columns, data);
    }

    public static String getTable(Character[] borderChars, Column[] rawColumns, String[][] data) {
        if (borderChars.length != NO_BORDERS.length) {
            throw new IllegalArgumentException("Border characters array must be exactly " + NO_BORDERS.length + " elements long");
        }
        int numColumns = AsciiTable.getNumColumns(rawColumns, data);
        Column[] columns = (Column[])IntStream.range(0, numColumns).mapToObj(index -> index < rawColumns.length ? rawColumns[index] : new Column()).toArray(Column[]::new);
        int[] colWidths = AsciiTable.getColWidths(columns, data);
        HorizontalAlign[] headerAligns = (HorizontalAlign[])Arrays.stream(columns).map(Column::getHeaderAlign).toArray(HorizontalAlign[]::new);
        HorizontalAlign[] dataAligns = (HorizontalAlign[])Arrays.stream(columns).map(Column::getDataAlign).toArray(HorizontalAlign[]::new);
        HorizontalAlign[] footerAligns = (HorizontalAlign[])Arrays.stream(columns).map(Column::getFooterAlign).toArray(HorizontalAlign[]::new);
        String[] header = (String[])Arrays.stream(columns).map(Column::getHeader).toArray(String[]::new);
        String[] footer = (String[])Arrays.stream(columns).map(Column::getFooter).toArray(String[]::new);
        List<String> tableRows = AsciiTable.getTableRows(colWidths, headerAligns, dataAligns, footerAligns, borderChars, header, data, footer);
        return tableRows.stream().filter(line -> !line.isEmpty()).collect(Collectors.joining(System.lineSeparator()));
    }

    private static List<String> getTableRows(int[] colWidths, HorizontalAlign[] headerAligns, HorizontalAlign[] dataAligns, HorizontalAlign[] footerAligns, Character[] borderChars, String[] header, String[][] data, String[] footer) {
        LinkedList<String> lines = new LinkedList<String>();
        lines.add(AsciiTable.lineRow(colWidths, borderChars[0], borderChars[1], borderChars[2], borderChars[3]));
        if (!Arrays.stream(header).allMatch(Objects::isNull)) {
            lines.addAll(AsciiTable.dataRow(colWidths, headerAligns, header, borderChars[4], borderChars[5], borderChars[6]));
            lines.add(AsciiTable.lineRow(colWidths, borderChars[7], borderChars[8], borderChars[9], borderChars[10]));
        }
        String contentRowBorder = AsciiTable.lineRow(colWidths, borderChars[14], borderChars[15], borderChars[16], borderChars[17]);
        for (String[] dataRow : data) {
            lines.addAll(AsciiTable.dataRow(colWidths, dataAligns, dataRow, borderChars[11], borderChars[12], borderChars[13]));
            lines.add(contentRowBorder);
        }
        if (data.length > 0) {
            lines.removeLast();
        }
        if (!Arrays.stream(footer).allMatch(Objects::isNull)) {
            lines.add(AsciiTable.lineRow(colWidths, borderChars[18], borderChars[19], borderChars[20], borderChars[21]));
            lines.addAll(AsciiTable.dataRow(colWidths, footerAligns, footer, borderChars[22], borderChars[23], borderChars[24]));
        }
        lines.add(AsciiTable.lineRow(colWidths, borderChars[25], borderChars[26], borderChars[27], borderChars[28]));
        return lines;
    }

    private static String lineRow(int[] colWidths, Character left, Character middle, Character columnSeparator, Character right) {
        StringBuilder row = new StringBuilder(AsciiTable.getTableWidth(colWidths));
        if (left != null) {
            row.append(left.charValue());
        }
        for (int col = 0; col < colWidths.length; ++col) {
            if (middle != null) {
                row.append(AsciiTable.repeat(middle.charValue(), colWidths[col]));
            }
            if (columnSeparator == null || col == colWidths.length - 1) continue;
            row.append(columnSeparator.charValue());
        }
        if (right != null) {
            row.append(right.charValue());
        }
        return row.toString();
    }

    private static List<String> dataRow(int[] colWidths, HorizontalAlign[] horizontalAligns, String[] contents, Character left, Character columnSeparator, Character right) {
        List linesContents = IntStream.range(0, colWidths.length).mapToObj(i -> {
            String text = i < contents.length && contents[i] != null ? contents[i] : "";
            String[] paragraphs = text.split(System.lineSeparator());
            return Arrays.stream(paragraphs).flatMap(paragraph -> AsciiTable.splitTextIntoLinesOfMaxLength(paragraph, colWidths[i] - 2).stream()).collect(Collectors.toList());
        }).collect(Collectors.toList());
        int numLines = linesContents.stream().mapToInt(List::size).max().orElse(0);
        StringBuilder row = new StringBuilder(AsciiTable.getTableWidth(colWidths));
        LinkedList<String> lines = new LinkedList<String>();
        for (int line = 0; line < numLines; ++line) {
            if (left != null) {
                row.append(left.charValue());
            }
            for (int col = 0; col < colWidths.length; ++col) {
                String item = ((List)linesContents.get(col)).size() <= line ? "" : (String)((List)linesContents.get(col)).get(line);
                row.append(AsciiTable.justify(item, horizontalAligns[col], colWidths[col], 1));
                if (columnSeparator == null || col == colWidths.length - 1) continue;
                row.append(columnSeparator.charValue());
            }
            if (right != null) {
                row.append(right.charValue());
            }
            lines.add(row.toString());
            row.setLength(0);
        }
        return lines;
    }

    private static int[] getColWidths(Column[] columns, String[][] data) {
        int[] result = new int[columns.length];
        for (String[] dataRow : data) {
            for (int col = 0; col < dataRow.length; ++col) {
                result[col] = Math.max(result[col], dataRow[col] == null ? 0 : dataRow[col].length());
            }
        }
        for (int col = 0; col < columns.length; ++col) {
            int length = Math.max(Math.max(columns[col].getHeaderWidth(), columns[col].getFooterWidth()), result[col]);
            result[col] = Math.min(columns[col].getMaxColumnWidth(), length + 2);
        }
        return result;
    }

    private static int getNumColumns(Column[] columns, String[][] data) {
        int maxDataColumns = Arrays.stream(data).mapToInt(cols -> ((String[])cols).length).max().orElse(0);
        return Math.max(columns.length, maxDataColumns);
    }

    private static int getTableWidth(int[] colWidths) {
        return Arrays.stream(colWidths).sum() + 1 * (colWidths.length + 1) - 1;
    }

    static List<String> splitTextIntoLinesOfMaxLength(String str, int maxCharInLine) {
        LinkedList<String> lines = new LinkedList<String>();
        StringBuilder line = new StringBuilder(maxCharInLine);
        int offset = 0;
        while (offset < str.length() && maxCharInLine < str.length() - offset) {
            int spaceToWrapAt = str.lastIndexOf(32, offset + maxCharInLine);
            if (offset < spaceToWrapAt) {
                line.append(str.substring(offset, spaceToWrapAt));
                offset = spaceToWrapAt + 1;
            } else {
                line.append(str.substring(offset, offset + maxCharInLine));
                offset += maxCharInLine;
            }
            lines.add(line.toString());
            line.setLength(0);
        }
        line.append(str.substring(offset));
        lines.add(line.toString());
        return lines;
    }

    static char[] justify(String str, HorizontalAlign align, int length, int minPadding) {
        if (str.length() < length) {
            char[] justified = new char[length];
            Arrays.fill(justified, ' ');
            switch (align) {
                case LEFT: {
                    System.arraycopy(str.toCharArray(), 0, justified, minPadding, str.length());
                    break;
                }
                case CENTER: {
                    System.arraycopy(str.toCharArray(), 0, justified, (length - str.length()) / 2, str.length());
                    break;
                }
                case RIGHT: {
                    System.arraycopy(str.toCharArray(), 0, justified, length - str.length() - minPadding, str.length());
                }
            }
            return justified;
        }
        return str.toCharArray();
    }

    private static char[] repeat(char c, int num) {
        char[] repeat = new char[num];
        Arrays.fill(repeat, c);
        return repeat;
    }
}

