/*
 * Decompiled with CFR 0.152.
 */
package com.freelib.multiitem.helper;

import android.graphics.Bitmap;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.ImageView;

public class DragFloatViewHelper {
    private View currTouchedView;
    private WindowManager manager;
    private WindowManager.LayoutParams params;
    private int offsetX;
    private int offsetY;

    public void createView(View coverView, float touchRawX, float touchRawY, float scale) {
        this.currTouchedView = this.createFloatView(coverView);
        this.manager = (WindowManager)this.currTouchedView.getContext().getSystemService("window");
        this.params = this.initParams(this.currTouchedView);
        this.params.width = (int)((float)coverView.getWidth() * scale);
        this.params.height = (int)((float)coverView.getHeight() * scale);
        int[] location = this.getLocation(coverView);
        this.params.x = location[0];
        this.params.y = location[1];
        this.manager.addView(this.currTouchedView, (ViewGroup.LayoutParams)this.params);
        this.offsetX = (int)(touchRawX - (float)location[0]);
        this.offsetY = (int)(touchRawY - (float)location[1]);
    }

    protected View createFloatView(View coverView) {
        ImageView floatView = new ImageView(coverView.getContext());
        coverView.destroyDrawingCache();
        coverView.setDrawingCacheEnabled(true);
        Bitmap bitmap = coverView.getDrawingCache();
        if (bitmap != null && !bitmap.isRecycled()) {
            floatView.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
            floatView.setImageBitmap(bitmap);
        }
        return floatView;
    }

    public View getFloatView() {
        return this.currTouchedView;
    }

    protected int[] getLocation(View coverView) {
        int[] result = new int[2];
        coverView.getLocationOnScreen(result);
        return result;
    }

    private WindowManager.LayoutParams initParams(View floatView) {
        WindowManager.LayoutParams layoutParams = new WindowManager.LayoutParams();
        layoutParams.token = floatView.getWindowToken();
        layoutParams.type = 2;
        layoutParams.format = -3;
        layoutParams.flags = 262944;
        layoutParams.gravity = 51;
        return layoutParams;
    }

    public void updateView(int x, int y) {
        if (this.currTouchedView != null) {
            this.params.x = x - this.offsetX;
            this.params.y = y - this.offsetY;
            this.manager.updateViewLayout(this.currTouchedView, (ViewGroup.LayoutParams)this.params);
        }
    }

    public void removeView() {
        if (this.currTouchedView != null && this.manager != null) {
            this.manager.removeView(this.currTouchedView);
        }
    }
}

