/*
 * Decompiled with CFR 0.152.
 */
package com.freelib.multiitem.animation;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.support.annotation.NonNull;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import com.freelib.multiitem.adapter.holder.BaseViewHolder;
import com.freelib.multiitem.animation.BaseAnimation;
import com.freelib.multiitem.animation.SlideInLeftAnimation;

public class AnimationLoader {
    protected int lastAnimIndex = -1;
    protected boolean isAnimEnable;
    protected boolean isShowAnimWhenFirst;
    protected BaseAnimation animation;
    protected long animDuration = 400L;
    protected Interpolator interpolator = new LinearInterpolator();

    public void clear() {
        this.lastAnimIndex = -1;
    }

    public void enableLoadAnimation(@NonNull BaseAnimation animation, boolean isShowAnimWhenFirstLoad) {
        this.isAnimEnable = true;
        this.isShowAnimWhenFirst = isShowAnimWhenFirstLoad;
        this.animation = animation == null ? new SlideInLeftAnimation() : animation;
    }

    public void startAnimation(@NonNull BaseViewHolder holder) {
        if (!this.isAnimEnable) {
            return;
        }
        if (!this.isShowAnimWhenFirst || holder.getItemPosition() > this.lastAnimIndex) {
            for (Animator anim : this.animation.getAnimators(holder.itemView)) {
                this.startAnim(anim);
            }
            this.lastAnimIndex = holder.getItemPosition();
        }
    }

    protected void startAnim(Animator anim) {
        anim.setDuration(this.animDuration).start();
        anim.setInterpolator((TimeInterpolator)this.interpolator);
    }

    public boolean isAnimEnable() {
        return this.isAnimEnable;
    }

    public void setAnimEnable(boolean animEnable) {
        this.isAnimEnable = animEnable;
    }

    public boolean isShowAnimWhenFirst() {
        return this.isShowAnimWhenFirst;
    }

    public void setShowAnimWhenFirst(boolean showAnimWhenFirst) {
        this.isShowAnimWhenFirst = showAnimWhenFirst;
    }

    public BaseAnimation getAnimation() {
        return this.animation;
    }

    public void setAnimation(@NonNull BaseAnimation animation) {
        this.animation = animation;
    }

    public long getAnimDuration() {
        return this.animDuration;
    }

    public void setAnimDuration(long animDuration) {
        this.animDuration = animDuration;
    }

    public Interpolator getInterpolator() {
        return this.interpolator;
    }

    public void setInterpolator(@NonNull Interpolator interpolator) {
        this.interpolator = interpolator;
    }
}

