/*
 * Decompiled with CFR 0.152.
 */
package com.freelib.multiitem.adapter.holder;

import android.support.annotation.NonNull;
import com.freelib.multiitem.adapter.holder.BaseViewHolder;
import com.freelib.multiitem.adapter.holder.BaseViewHolderManager;
import com.freelib.multiitem.adapter.holder.ViewHolderParams;
import com.freelib.multiitem.item.ItemInput;
import java.util.Collections;
import java.util.Map;

public abstract class InputHolderManager<T extends ItemInput>
extends BaseViewHolderManager<T> {
    protected Object originalValue;
    protected BaseViewHolder viewHolder;

    public abstract String getKey();

    public abstract Object getValue();

    @Override
    protected void onCreateViewHolder(@NonNull BaseViewHolder holder) {
        super.onCreateViewHolder(holder);
        this.initInputView(holder);
        this.originalValue = this.getValue();
        this.viewHolder = holder;
    }

    protected abstract void initInputView(BaseViewHolder var1);

    @Override
    @Deprecated
    public void onBindViewHolder(BaseViewHolder holder, T t) {
    }

    @Override
    @Deprecated
    public void onBindViewHolder(@NonNull BaseViewHolder holder, @NonNull T t, @NonNull ViewHolderParams params) {
        super.onBindViewHolder(holder, t, params);
    }

    public Map<String, Object> getValueMap() {
        String key = this.getKey();
        Object value = this.getValue();
        if (key == null || value == null) {
            return null;
        }
        return Collections.singletonMap(key, value);
    }

    public boolean isValueChange() {
        Object value = this.getValue();
        return value == null ? null != this.originalValue : !value.equals(this.originalValue);
    }

    public boolean isValueValid() {
        return true;
    }

    @Override
    public boolean isClickable() {
        return false;
    }
}

