/*
 * Decompiled with CFR 0.152.
 */
package com.freelib.multiitem.adapter;

import android.support.annotation.NonNull;
import android.view.ViewGroup;
import com.freelib.multiitem.adapter.BaseItemAdapter;
import com.freelib.multiitem.adapter.holder.BaseViewHolder;
import com.freelib.multiitem.adapter.holder.InputHolderManager;
import com.freelib.multiitem.item.HiddenItemInput;
import com.freelib.multiitem.item.ItemInput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public class InputItemAdapter
extends BaseItemAdapter {
    protected List<InputHolderManager> inputHolderManagers = new ArrayList<InputHolderManager>();
    protected List<HiddenItemInput> hiddenItemInputs = new ArrayList<HiddenItemInput>();

    public void addHiddenItem(@NonNull String key, Object value) {
        this.addHiddenItem(new HiddenItemInput(key, value));
    }

    public void addHiddenItem(HiddenItemInput ... hiddenItems) {
        if (hiddenItems.length == 0) {
            return;
        }
        this.hiddenItemInputs.addAll(Arrays.asList(hiddenItems));
    }

    public JSONObject getInputJson() {
        return new JSONObject(this.getInputValueMap());
    }

    public Map<String, Object> getInputValueMap() {
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        for (InputHolderManager inputHolderManager : this.inputHolderManagers) {
            Map<String, Object> itemValueMap = inputHolderManager.getValueMap();
            if (itemValueMap == null) continue;
            valueMap.putAll(itemValueMap);
        }
        for (HiddenItemInput hiddenItem : this.hiddenItemInputs) {
            valueMap.putAll(hiddenItem.getValueMap());
        }
        return valueMap;
    }

    @Override
    public void clearData() {
        super.clearData();
        this.inputHolderManagers.clear();
    }

    @Override
    protected void setItem(@NonNull List<? extends Object> dataItems) {
        super.setItem(dataItems);
        this.inputHolderManagers.clear();
        this.fillInputHolderManagers(0, dataItems);
    }

    @Override
    protected void addItem(int position, @NonNull List<? extends Object> items) {
        super.addItem(position, items);
        this.fillInputHolderManagers(position, items);
    }

    protected void fillInputHolderManagers(int position, @NonNull List<? extends Object> items) {
        for (Object object : items) {
            if (!(object instanceof ItemInput)) continue;
            this.inputHolderManagers.add(position++, ((ItemInput)object).getViewHolderManager());
        }
    }

    @Override
    public BaseViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        BaseViewHolder viewHolder = super.onCreateViewHolder(parent, viewType);
        if (viewHolder.viewHolderManager instanceof InputHolderManager) {
            this.inputHolderManagers.add((InputHolderManager)viewHolder.viewHolderManager);
        }
        return viewHolder;
    }

    public boolean isValueChange() {
        for (InputHolderManager inputHolderManager : this.inputHolderManagers) {
            if (!inputHolderManager.isValueChange()) continue;
            return true;
        }
        return false;
    }

    public boolean isValueValid() {
        for (InputHolderManager inputHolderManager : this.inputHolderManagers) {
            if (inputHolderManager.isValueValid()) continue;
            return false;
        }
        return true;
    }
}

