/*
 * Decompiled with CFR 0.152.
 */
package com.freelib.multiitem.adapter;

import android.support.annotation.NonNull;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Interpolator;
import com.freelib.multiitem.adapter.holder.BaseViewHolder;
import com.freelib.multiitem.adapter.holder.HeadFootHolderManager;
import com.freelib.multiitem.adapter.holder.ViewHolderManager;
import com.freelib.multiitem.adapter.holder.ViewHolderManagerGroup;
import com.freelib.multiitem.adapter.holder.ViewHolderParams;
import com.freelib.multiitem.adapter.type.ItemTypeManager;
import com.freelib.multiitem.animation.AnimationLoader;
import com.freelib.multiitem.animation.BaseAnimation;
import com.freelib.multiitem.item.LoadMoreManager;
import com.freelib.multiitem.item.UniqueItemManager;
import com.freelib.multiitem.listener.OnItemClickListener;
import com.freelib.multiitem.listener.OnItemLongClickListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BaseItemAdapter
extends RecyclerView.Adapter<BaseViewHolder> {
    private List<Object> dataItems = new ArrayList<Object>();
    private List<Object> headItems = new ArrayList<Object>();
    private List<Object> footItems = new ArrayList<Object>();
    private ItemTypeManager itemTypeManager;
    private LoadMoreManager loadMoreManager;
    private OnItemClickListener onItemClickListener;
    private OnItemLongClickListener onItemLongClickListener;
    private ViewHolderParams params = new ViewHolderParams();
    protected AnimationLoader animationLoader = new AnimationLoader();

    public BaseItemAdapter() {
        this.itemTypeManager = new ItemTypeManager();
    }

    public <T, V extends BaseViewHolder> void register(@NonNull Class<T> cls, @NonNull ViewHolderManager<T, V> manager) {
        this.itemTypeManager.register(cls, manager);
    }

    public <T, V extends BaseViewHolder> void register(@NonNull Class<T> cls, @NonNull ViewHolderManagerGroup<T> group) {
        this.itemTypeManager.register(cls, group);
    }

    public void setOnItemClickListener(@NonNull OnItemClickListener onItemClickListener) {
        this.onItemClickListener = onItemClickListener;
    }

    public void setOnItemLongClickListener(@NonNull OnItemLongClickListener onItemLongClickListener) {
        this.onItemLongClickListener = onItemLongClickListener;
    }

    public void setDataItems(@NonNull List<? extends Object> dataItems) {
        this.setItem(dataItems);
    }

    public void addDataItem(@NonNull Object item) {
        this.addDataItem(this.dataItems.size(), item);
    }

    public void addDataItem(int position, @NonNull Object item) {
        this.addDataItems(position, Collections.singletonList(item));
    }

    public void addDataItems(@NonNull List<? extends Object> items) {
        this.addDataItems(this.dataItems.size(), items);
    }

    public void addDataItems(int position, @NonNull List<? extends Object> items) {
        this.addItem(position, items);
    }

    protected void addItem(int position, @NonNull List<? extends Object> items) {
        this.dataItems.addAll(position, items);
        this.notifyItemRangeInserted(position + this.getHeadCount(), items.size());
    }

    protected void setItem(@NonNull List<? extends Object> dataItems) {
        this.dataItems = dataItems;
        this.notifyDataSetChanged();
    }

    public void moveDataItem(int fromPosition, int toPosition) {
        this.dataItems.add(toPosition, this.dataItems.remove(fromPosition));
        this.notifyItemMoved(fromPosition + this.getHeadCount(), toPosition + this.getHeadCount());
    }

    public void removeDataItem(int position) {
        this.removeDataItem(position, 1);
    }

    public void removeDataItem(int position, int itemCount) {
        for (int i = 0; i < itemCount; ++i) {
            this.dataItems.remove(position);
        }
        this.notifyItemRangeRemoved(position + this.getHeadCount(), itemCount);
    }

    public void addFootView(@NonNull View footView) {
        this.addFootItem(new UniqueItemManager(new HeadFootHolderManager(footView)));
    }

    public void addFootItem(@NonNull Object footItem) {
        this.footItems.add(footItem);
    }

    public void addHeadView(@NonNull View headView) {
        this.addHeadItem(new UniqueItemManager(new HeadFootHolderManager(headView)));
    }

    public void addHeadItem(@NonNull Object headItem) {
        this.headItems.add(headItem);
    }

    public void enableLoadMore(@NonNull LoadMoreManager loadMoreManager) {
        this.loadMoreManager = loadMoreManager;
        loadMoreManager.setAdapter(this);
        this.addFootItem(loadMoreManager);
    }

    public void setLoadCompleted(boolean isLoadAll) {
        if (this.loadMoreManager != null) {
            this.loadMoreManager.loadCompleted(isLoadAll);
        }
    }

    public void setLoadFailed() {
        if (this.loadMoreManager != null) {
            this.loadMoreManager.loadFailed();
        }
    }

    public void enableAnimation(BaseAnimation animation) {
        this.animationLoader.enableLoadAnimation(animation, true);
    }

    public void enableAnimation(BaseAnimation animation, boolean isShowAnimWhenFirstLoad) {
        this.animationLoader.enableLoadAnimation(animation, isShowAnimWhenFirstLoad);
    }

    public void setInterpolator(@NonNull Interpolator interpolator) {
        this.animationLoader.setInterpolator(interpolator);
    }

    public void setAnimDuration(long animDuration) {
        this.animationLoader.setAnimDuration(animDuration);
    }

    public List<Object> getDataList() {
        return this.dataItems;
    }

    public Object getItem(int position) {
        if (position < this.headItems.size()) {
            return this.headItems.get(position);
        }
        if ((position -= this.headItems.size()) < this.dataItems.size()) {
            return this.dataItems.get(position);
        }
        if ((position -= this.dataItems.size()) < this.footItems.size()) {
            return this.footItems.get(position);
        }
        return null;
    }

    public void clearAllData() {
        this.clearData();
        this.headItems.clear();
        this.footItems.clear();
    }

    public void clearData() {
        this.dataItems.clear();
        this.animationLoader.clear();
    }

    public BaseViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        ViewHolderManager provider = this.itemTypeManager.getViewHolderManager(viewType);
        Object viewHolder = provider.onCreateViewHolder(parent);
        ((BaseViewHolder)((Object)viewHolder)).viewHolderManager = provider;
        return viewHolder;
    }

    public void onBindViewHolder(BaseViewHolder holder, int position) {
        Object item = this.getItem(position);
        ViewHolderManager manager = holder.viewHolderManager;
        this.params.setItemCount(this.getItemCount()).setClickListener(this.onItemClickListener).setLongClickListener(this.onItemLongClickListener);
        manager.onBindViewHolder(holder, item, this.params);
        holder.itemView.setTag(-121, (Object)holder);
        holder.itemData = item;
    }

    public int getItemViewType(int position) {
        int type = this.itemTypeManager.getItemType(this.getItem(position));
        if (type < 0) {
            throw new RuntimeException("\u6ca1\u6709\u4e3a" + this.getItem(position).getClass() + "\u627e\u5230\u5bf9\u5e94\u7684item itemView manager\uff0c\u662f\u5426\u6ce8\u518c\u4e86\uff1f");
        }
        return type;
    }

    public int getItemCount() {
        return this.dataItems.size() + this.getHeadCount() + this.getFootCount();
    }

    public void onViewAttachedToWindow(BaseViewHolder holder) {
        super.onViewAttachedToWindow((RecyclerView.ViewHolder)holder);
        if (holder.getViewHolderManager().isFullSpan() && holder.itemView.getLayoutParams() instanceof StaggeredGridLayoutManager.LayoutParams) {
            StaggeredGridLayoutManager.LayoutParams params = (StaggeredGridLayoutManager.LayoutParams)holder.itemView.getLayoutParams();
            params.setFullSpan(true);
        }
        this.animationLoader.startAnimation(holder);
    }

    public void onAttachedToRecyclerView(RecyclerView recyclerView) {
        super.onAttachedToRecyclerView(recyclerView);
        RecyclerView.LayoutManager manager = recyclerView.getLayoutManager();
        if (manager instanceof GridLayoutManager) {
            final GridLayoutManager gridManager = (GridLayoutManager)manager;
            gridManager.setSpanSizeLookup(new GridLayoutManager.SpanSizeLookup(){
                ViewHolderManager holderManager;

                public int getSpanSize(int position) {
                    this.holderManager = BaseItemAdapter.this.itemTypeManager.getViewHolderManager(BaseItemAdapter.this.getItemViewType(position));
                    return this.holderManager.getSpanSize(gridManager.getSpanCount());
                }
            });
        }
    }

    public int getHeadCount() {
        return this.headItems.size();
    }

    public int getFootCount() {
        return this.footItems.size();
    }
}

