/*
 * Decompiled with CFR 0.152.
 */
package com.freelib.multiitem.helper;

import android.support.annotation.NonNull;
import android.support.v4.view.ViewCompat;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.OrientationHelper;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.helper.ItemTouchHelper;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import com.freelib.multiitem.adapter.holder.BaseViewHolder;
import com.freelib.multiitem.helper.DragFloatViewHelper;
import com.freelib.multiitem.listener.OnItemDragListener;

public class ItemDragHelper {
    public static final int NONE = -1;
    private OnItemDragListener dragListener = new EmptyDragListener();
    private RecyclerView horizontalRecycler;
    private DragFloatViewHelper floatViewHelper;
    private boolean isDrag;
    private int lastRecyclerPos = -1;
    private RecyclerView lastRecyclerView;
    private int lastItemPos = -1;
    private float lastTouchRawX;
    private float lastTouchRawY;
    private int itemViewHeight;
    private final Runnable scrollRunnable = new Runnable(){

        @Override
        public void run() {
            float[] horLocation = ItemDragHelper.this.getInsideLocation(ItemDragHelper.this.horizontalRecycler, ItemDragHelper.this.lastTouchRawX, ItemDragHelper.this.lastTouchRawY);
            float[] verLocation = ItemDragHelper.this.getInsideLocation(ItemDragHelper.this.lastRecyclerView, ItemDragHelper.this.lastTouchRawX, ItemDragHelper.this.lastTouchRawY);
            boolean isHorizontalScroll = ItemDragHelper.this.scrollIfNecessary(ItemDragHelper.this.horizontalRecycler, (int)horLocation[0], (int)horLocation[1]);
            boolean isVerticalScroll = ItemDragHelper.this.scrollIfNecessary(ItemDragHelper.this.lastRecyclerView, (int)verLocation[0], (int)verLocation[1]);
            if (ItemDragHelper.this.isDrag && (isHorizontalScroll || isVerticalScroll)) {
                ItemDragHelper.this.moveIfNecessary(ItemDragHelper.this.lastTouchRawX, ItemDragHelper.this.lastTouchRawY);
                ItemDragHelper.this.lastRecyclerView.removeCallbacks(ItemDragHelper.this.scrollRunnable);
                ViewCompat.postOnAnimation((View)ItemDragHelper.this.lastRecyclerView, (Runnable)this);
            }
        }
    };

    public ItemDragHelper(@NonNull RecyclerView horizontalRecycler) {
        this.horizontalRecycler = horizontalRecycler;
        this.floatViewHelper = new DragFloatViewHelper();
    }

    public void startDrag(@NonNull BaseViewHolder viewHolder) {
        View itemView = viewHolder.itemView;
        int itemPosition = viewHolder.getItemPosition();
        this.dragListener.setItemViewHolder(viewHolder);
        if (!this.dragListener.onItemSelected(itemView, itemPosition)) {
            return;
        }
        this.isDrag = true;
        this.initParams();
        this.lastItemPos = itemPosition;
        this.dragListener.onDragStart();
        this.floatViewHelper.createView(itemView, this.lastTouchRawX, this.lastTouchRawY, this.dragListener.getScale());
        this.dragListener.onDrawFloatView(this.floatViewHelper.getFloatView());
        RecyclerView.LayoutParams params = (RecyclerView.LayoutParams)itemView.getLayoutParams();
        this.itemViewHeight = itemView.getHeight() + params.topMargin + params.bottomMargin;
    }

    private void initParams() {
        this.lastRecyclerPos = -1;
        this.lastRecyclerView = null;
    }

    public void setOnItemDragListener(@NonNull OnItemDragListener onItemDragListener) {
        this.dragListener = onItemDragListener;
    }

    public RecyclerView getHorizontalRecycler() {
        return this.horizontalRecycler;
    }

    public boolean onTouch(@NonNull MotionEvent event) {
        this.lastTouchRawX = event.getRawX();
        this.lastTouchRawY = event.getRawY();
        if (!this.isDrag) {
            return false;
        }
        this.floatViewHelper.updateView((int)this.lastTouchRawX, (int)this.lastTouchRawY);
        this.moveIfNecessary(this.lastTouchRawX, this.lastTouchRawY);
        this.scrollRunnableStart();
        if (event.getActionMasked() == 1 || event.getActionMasked() == 3 || event.getActionMasked() == 4) {
            this.stopDrag();
        }
        return true;
    }

    private void scrollRunnableStart() {
        if (this.lastRecyclerView != null) {
            this.lastRecyclerView.removeCallbacks(this.scrollRunnable);
            this.scrollRunnable.run();
            this.lastRecyclerView.invalidate();
        }
    }

    private void stopDrag() {
        if (this.isDrag) {
            this.dragListener.onDragFinish(this.lastRecyclerView, this.lastRecyclerPos, this.lastItemPos);
            this.floatViewHelper.removeView();
        }
        this.isDrag = false;
    }

    private boolean moveIfNecessary(float touchRawX, float touchRawY) {
        boolean isChanged;
        boolean result = true;
        float[] location = this.getInsideLocation(this.horizontalRecycler, touchRawX, touchRawY);
        View view = this.horizontalRecycler.findChildViewUnder(location[0], location[1]);
        int recyclerPos = this.getPositionByChildView(view);
        RecyclerView recyclerView = this.findRecyclerView(view);
        if (recyclerPos == -1 || recyclerView == null) {
            return false;
        }
        location = this.getInsideLocation(recyclerView, touchRawX, touchRawY);
        float itemX = location[0];
        float itemY = location[1];
        View itemView = recyclerView.findChildViewUnder(itemX, itemY);
        int itemPos = this.getTargetItemPos(itemView, itemY, this.lastRecyclerPos, recyclerPos);
        if (this.isSelectedRecyclerView(this.lastRecyclerPos, recyclerPos)) {
            this.dragListener.onRecyclerSelected(recyclerView, recyclerPos);
            this.lastRecyclerPos = recyclerPos;
            this.lastRecyclerView = recyclerView;
        } else if (this.isChangeRecyclerView(this.lastRecyclerPos, recyclerPos) && (itemPos = this.calcItemPositionWhenChangeRecycler(recyclerView, itemView, itemPos, itemX, itemY)) != -1) {
            isChanged = this.dragListener.onRecyclerChanged(this.lastRecyclerView, recyclerView, this.lastItemPos, itemPos = this.dragListener.onRecyclerChangedItemPosition(this.lastRecyclerView, recyclerView, this.lastItemPos, itemPos, this.lastRecyclerPos, recyclerPos = this.dragListener.onRecyclerChangedRecyclerPosition(this.lastRecyclerView, recyclerView, this.lastItemPos, itemPos, this.lastRecyclerPos, recyclerPos)), this.lastRecyclerPos, recyclerPos);
            if (!isChanged) {
                return result;
            }
            this.lastRecyclerPos = recyclerPos;
            this.lastRecyclerView = recyclerView;
            this.lastItemPos = itemPos;
        }
        if (itemPos == -1) {
            return result;
        }
        if (this.isItemNeedChange(itemView, this.lastItemPos, itemPos, itemY)) {
            isChanged = this.dragListener.onItemChanged(recyclerView, this.lastItemPos, itemPos = this.dragListener.onItemChangedPosition(recyclerView, this.lastItemPos, itemPos, this.lastRecyclerPos), this.lastRecyclerPos);
            if (!isChanged) {
                return result;
            }
            this.scrollToRightPositionWhenItemChanged(recyclerView, itemView, itemPos);
            this.lastItemPos = itemPos;
        }
        return result;
    }

    private void scrollToRightPositionWhenItemChanged(RecyclerView recyclerView, View itemView, int itemPos) {
        RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
        if (layoutManager instanceof ItemTouchHelper.ViewDropHandler) {
            OrientationHelper helper = OrientationHelper.createVerticalHelper((RecyclerView.LayoutManager)layoutManager);
            int start = helper.getDecoratedStart(itemView);
            int end = helper.getDecoratedEnd(itemView);
            ((LinearLayoutManager)layoutManager).scrollToPositionWithOffset(itemPos, this.lastItemPos > itemPos ? start : end - this.itemViewHeight);
        }
        if (this.lastItemPos == 0 || itemPos == 0) {
            recyclerView.scrollToPosition(0);
        }
    }

    private float[] getInsideLocation(RecyclerView recyclerView, float touchRawX, float touchRawY) {
        float[] result = new float[2];
        int[] location = new int[2];
        recyclerView.getLocationOnScreen(location);
        result[0] = touchRawX - (float)location[0];
        result[1] = touchRawY - (float)location[1];
        result[0] = result[0] / this.dragListener.getScale();
        result[1] = result[1] / this.dragListener.getScale();
        int minY = recyclerView.getPaddingTop();
        int maxY = recyclerView.getHeight() - recyclerView.getPaddingBottom();
        result[1] = Math.min(Math.max(result[1], (float)minY), (float)maxY);
        return result;
    }

    private int calcItemPositionWhenChangeRecycler(RecyclerView verticalRecycler, View itemView, int itemPos, float childX, float childY) {
        int top;
        if (itemPos == -1 && verticalRecycler.getAdapter().getItemCount() == 0) {
            itemPos = 0;
        } else if (itemView != null && (float)(top = itemView.getTop()) + (float)itemView.getHeight() * this.dragListener.getMoveLimit() < childY) {
            ++itemPos;
        }
        return itemPos;
    }

    protected RecyclerView findRecyclerView(View view) {
        if (view == null) {
            return null;
        }
        if (view instanceof RecyclerView) {
            return (RecyclerView)view;
        }
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            int count = viewGroup.getChildCount();
            for (int i = 0; i < count; ++i) {
                RecyclerView recyclerView = this.findRecyclerView(viewGroup.getChildAt(i));
                if (recyclerView == null) continue;
                return recyclerView;
            }
        }
        return null;
    }

    private boolean scrollIfNecessary(RecyclerView recyclerView, int curX, int curY) {
        if (!this.isDrag) {
            return false;
        }
        RecyclerView.LayoutManager lm = recyclerView.getLayoutManager();
        int scrollX = 0;
        int scrollY = 0;
        if (lm.canScrollHorizontally()) {
            scrollX = this.dragListener.calcHorizontalScrollDistance((View)recyclerView, curX, curY);
        }
        if (lm.canScrollVertically()) {
            scrollY = this.dragListener.calcVerticalScrollDistance((View)recyclerView, curX, curY);
        }
        if (scrollX != 0 || scrollY != 0) {
            recyclerView.scrollBy(scrollX, scrollY);
        }
        return scrollX != 0 || scrollY != 0;
    }

    private int getTargetItemPos(View itemTargetView, float childY, int lastRecyclerPos, int currRecyclerPos) {
        int itemPos = this.getPositionByChildView(itemTargetView);
        if (itemPos == -1) {
            return itemPos;
        }
        if (itemPos != this.lastItemPos || lastRecyclerPos != currRecyclerPos) {
            return itemPos;
        }
        return -1;
    }

    private boolean isItemNeedChange(View itemView, int lastItemPos, int itemPos, float itemY) {
        if (itemView == null || lastItemPos == -1 || itemPos == -1 || lastItemPos == itemPos) {
            return false;
        }
        int top = itemView.getTop();
        int moveLimit = (int)((float)top + (float)itemView.getHeight() * this.dragListener.getMoveLimit());
        if (lastItemPos > itemPos) {
            return itemY < (float)moveLimit;
        }
        return itemY > (float)moveLimit;
    }

    private boolean isCurrPosition(float childY, View itemView) {
        return childY >= (float)itemView.getTop() && childY <= (float)itemView.getBottom();
    }

    private int getPositionByChildView(View itemView) {
        if (itemView == null) {
            return -1;
        }
        try {
            return ((RecyclerView.LayoutParams)itemView.getLayoutParams()).getViewAdapterPosition();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    private boolean isChangeRecyclerView(int lastRecyclerPos, int currRecyclerPos) {
        return lastRecyclerPos != currRecyclerPos && lastRecyclerPos != -1 && currRecyclerPos != -1;
    }

    private boolean isSelectedRecyclerView(int lastRecyclerPos, int currRecyclerPos) {
        return lastRecyclerPos == -1 && currRecyclerPos != -1;
    }

    private boolean isSelectedChildView(int lastChildPos, int currChildPos) {
        return lastChildPos == -1 && currChildPos != -1;
    }

    static class EmptyDragListener
    extends OnItemDragListener {
        EmptyDragListener() {
        }
    }
}

