/*
 * Decompiled with CFR 0.152.
 */
package com.freelib.multiitem.helper;

import android.graphics.Bitmap;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.ImageView;

public class DragFloatViewHelper {
    private View currTouchedView;
    private WindowManager wManager;
    private WindowManager.LayoutParams mParams;
    private int offsetX;
    private int offsetY;

    public void createView(View coverView, float touchRawX, float touchRawY, float scale) {
        this.currTouchedView = this.createFloatView(coverView);
        this.wManager = (WindowManager)this.currTouchedView.getContext().getSystemService("window");
        this.mParams = this.initParams(this.currTouchedView);
        this.mParams.width = (int)((float)coverView.getWidth() * scale);
        this.mParams.height = (int)((float)coverView.getHeight() * scale);
        int[] location = this.getLocation(coverView);
        this.mParams.x = location[0];
        this.mParams.y = location[1];
        this.wManager.addView(this.currTouchedView, (ViewGroup.LayoutParams)this.mParams);
        this.offsetX = (int)(touchRawX - (float)location[0]);
        this.offsetY = (int)(touchRawY - (float)location[1]);
    }

    protected View createFloatView(View coverView) {
        ImageView floatView = new ImageView(coverView.getContext());
        coverView.destroyDrawingCache();
        coverView.setDrawingCacheEnabled(true);
        Bitmap bitmap = coverView.getDrawingCache();
        if (bitmap != null && !bitmap.isRecycled()) {
            floatView.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
            floatView.setImageBitmap(bitmap);
        }
        return floatView;
    }

    public View getFloatView() {
        return this.currTouchedView;
    }

    protected int[] getLocation(View coverView) {
        int[] result = new int[2];
        coverView.getLocationOnScreen(result);
        return result;
    }

    private WindowManager.LayoutParams initParams(View floatView) {
        WindowManager.LayoutParams mParams = new WindowManager.LayoutParams();
        mParams.token = floatView.getWindowToken();
        mParams.type = 2;
        mParams.format = -3;
        mParams.flags = 262944;
        mParams.gravity = 51;
        return mParams;
    }

    public void updateView(int x, int y) {
        if (this.currTouchedView != null) {
            this.mParams.x = x - this.offsetX;
            this.mParams.y = y - this.offsetY;
            this.wManager.updateViewLayout(this.currTouchedView, (ViewGroup.LayoutParams)this.mParams);
        }
    }

    public void removeView() {
        if (this.currTouchedView != null && this.wManager != null) {
            this.wManager.removeView(this.currTouchedView);
        }
    }
}

