/*
 * Decompiled with CFR 0.152.
 */
package com.freelib.multiitem.adapter.type;

import android.support.annotation.NonNull;
import com.freelib.multiitem.adapter.holder.ViewHolderManager;
import com.freelib.multiitem.adapter.holder.ViewHolderManagerGroup;
import com.freelib.multiitem.item.ItemManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ItemTypeManager {
    protected Map<String, ViewHolderManagerGroup> itemTypeNameGroupMap = new HashMap<String, ViewHolderManagerGroup>();
    protected List<String> itemTypeNames = new ArrayList<String>();
    protected List<ViewHolderManager> viewHolderManagers = new ArrayList<ViewHolderManager>();

    public void register(Class<?> cls, ViewHolderManager manager) {
        this.register(this.getTypeName(cls), manager);
    }

    public void register(Class<?> cls, ViewHolderManagerGroup group) {
        ViewHolderManager[] managers = group.getViewHolderManagers();
        int length = managers.length;
        for (int i = 0; i < length; ++i) {
            this.register(this.getClassNameFromGroup(cls, group, managers[i]), managers[i]);
        }
        this.itemTypeNameGroupMap.put(this.getTypeName(cls), group);
    }

    private void register(String typeName, ViewHolderManager manager) {
        if (this.itemTypeNames.contains(typeName)) {
            this.viewHolderManagers.set(this.itemTypeNames.indexOf(typeName), manager);
        } else {
            this.itemTypeNames.add(typeName);
            this.viewHolderManagers.add(manager);
        }
    }

    public int getItemType(@NonNull Object itemData) {
        int type;
        if (itemData instanceof ItemManager && (type = this.getItemTypeFromItemManager((ItemManager)itemData)) >= 0) {
            return type;
        }
        String typeName = this.getTypeName(itemData.getClass());
        if (this.itemTypeNameGroupMap.containsKey(typeName)) {
            ViewHolderManager manager = this.itemTypeNameGroupMap.get(typeName).getViewHolderManager(itemData);
            typeName = this.getClassNameFromGroup(itemData.getClass(), this.itemTypeNameGroupMap.get(typeName), manager);
        }
        return this.itemTypeNames.indexOf(typeName);
    }

    private int getItemTypeFromItemManager(ItemManager itemManager) {
        ViewHolderManager holderManager;
        String typeName = itemManager.getItemTypeName();
        int itemType = this.itemTypeNames.indexOf(typeName);
        if (itemType < 0 && (holderManager = itemManager.getViewHolderManager()) != null) {
            this.register(typeName, holderManager);
            itemType = this.itemTypeNames.size() - 1;
        }
        return itemType;
    }

    public ViewHolderManager getViewHolderManager(int type) {
        if (type < 0 || type > this.viewHolderManagers.size() - 1) {
            return null;
        }
        return this.viewHolderManagers.get(type);
    }

    public ViewHolderManager getViewHolderManager(Object itemData) {
        return this.getViewHolderManager(this.getItemType(itemData));
    }

    public List<ViewHolderManager> getViewHolderManagers() {
        return this.viewHolderManagers;
    }

    public List<String> getItemTypeNames() {
        return this.itemTypeNames;
    }

    private String getTypeName(Class<?> cls) {
        return cls.getName();
    }

    private String getClassNameFromGroup(Class<?> cls, ViewHolderManagerGroup group, ViewHolderManager manager) {
        return this.getTypeName(cls) + group.getViewHolderManagerTag(manager);
    }
}

