/*
 * Decompiled with CFR 0.152.
 */
package com.freelib.multiitem.listener;

import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import com.freelib.multiitem.adapter.BaseItemAdapter;
import com.freelib.multiitem.adapter.holder.BaseViewHolder;
import com.freelib.multiitem.item.ItemData;
import com.freelib.multiitem.item.ItemDrag;

public abstract class OnItemDragListener {
    protected ItemData dragItemData;
    protected int originalRecyclerPosition;
    protected int originalItemPosition;
    protected int horizontalScrollMaxSpeed = 15;
    protected int verticalScrollMaxSpeed = 10;
    protected float horizontalLimit = 100.0f;
    protected float verticalLimit = 200.0f;

    public void onDragFinish(RecyclerView recyclerView, int recyclerPos, int itemPos) {
        this.dragItemData.setVisibility(0);
        recyclerView.findViewHolderForAdapterPosition((int)itemPos).itemView.setVisibility(0);
    }

    public void onDragStart() {
    }

    public void setItemViewHolder(@NonNull BaseViewHolder viewHolder) {
        Object itemData = viewHolder.getItemData();
        if (!(itemData instanceof ItemData)) {
            throw new IllegalArgumentException("\u6570\u636e\u6e90\u5fc5\u987b\u5b9e\u73b0ItemData\u63a5\u53e3");
        }
        this.dragItemData = (ItemData)itemData;
    }

    public boolean onRecyclerSelected(RecyclerView selectedView, int selectedPos) {
        this.originalRecyclerPosition = selectedPos;
        return true;
    }

    public boolean onRecyclerChanged(RecyclerView fromView, RecyclerView toView, int itemFromPos, int itemToPos, int recyclerViewFromPos, int recyclerViewToPos) {
        if (!this.isItemCanChangeRecycler(this.dragItemData)) {
            return false;
        }
        BaseItemAdapter adapter = (BaseItemAdapter)toView.getAdapter();
        Object itemData = adapter.getItem(itemToPos);
        if (itemData != null && !this.isItemCanMove(itemData)) {
            return false;
        }
        adapter.addDataItem(itemToPos, this.dragItemData);
        adapter = (BaseItemAdapter)fromView.getAdapter();
        adapter.removeDataItem(itemFromPos);
        return true;
    }

    public boolean onItemSelected(View selectedView, int selectedPos) {
        boolean isItemCanDrag = this.isItemCanDrag(this.dragItemData);
        if (isItemCanDrag) {
            this.originalItemPosition = selectedPos;
            this.dragItemData.setVisibility(4);
            selectedView.setVisibility(4);
        }
        return this.isItemCanDrag(this.dragItemData);
    }

    public boolean onItemChanged(RecyclerView recyclerView, int fromPos, int toPos, int recyclerViewPos) {
        BaseItemAdapter adapter = (BaseItemAdapter)recyclerView.getAdapter();
        if (!this.isItemCanMove(adapter.getItem(toPos))) {
            return false;
        }
        adapter.moveDataItem(fromPos, toPos);
        return true;
    }

    private boolean isItemCanChangeRecycler(Object itemData) {
        ItemDrag itemDrag = this.getItemDrag(itemData);
        return itemDrag == null || itemDrag.isCanChangeRecycler();
    }

    private boolean isItemCanMove(Object itemData) {
        ItemDrag itemDrag = this.getItemDrag(itemData);
        return itemDrag == null || itemDrag.isCanMove();
    }

    private boolean isItemCanDrag(Object itemData) {
        ItemDrag itemDrag = this.getItemDrag(itemData);
        return itemDrag == null || itemDrag.isCanDrag();
    }

    private ItemDrag getItemDrag(Object itemData) {
        if (itemData instanceof ItemDrag) {
            return (ItemDrag)itemData;
        }
        return null;
    }

    public float getScale() {
        return 1.0f;
    }

    public int onRecyclerChangedRecyclerPosition(RecyclerView fromView, RecyclerView toView, int itemFromPos, int itemToPos, int recyclerViewFromPos, int recyclerViewToPos) {
        return recyclerViewToPos;
    }

    public int onRecyclerChangedItemPosition(RecyclerView fromView, RecyclerView toView, int itemFromPos, int itemToPos, int recyclerViewFromPos, int recyclerViewToPos) {
        return itemToPos;
    }

    public int onItemChangedPosition(RecyclerView recyclerView, int fromPos, int toPos, int recyclerViewPos) {
        return toPos;
    }

    public int getHorizontalScrollMaxSpeed() {
        return (int)((float)this.horizontalScrollMaxSpeed / this.getScale());
    }

    public int getVerticalScrollMaxSpeed() {
        return (int)((float)this.verticalScrollMaxSpeed / this.getScale());
    }

    public float getHorizontalLimit() {
        return this.horizontalLimit / this.getScale();
    }

    public float getVerticalLimit() {
        return this.verticalLimit / this.getScale();
    }

    public int calcHorizontalScrollDistance(View view, int touchX, int touchY) {
        int direct = this.calcScrollHorizontalDirect(touchX, view.getWidth());
        int scrollDistance = 0;
        if (direct < 0) {
            float level = (this.getHorizontalLimit() - (float)touchX) / this.getHorizontalLimit();
            scrollDistance = -this.calcScrollDistance(level, this.getHorizontalScrollMaxSpeed());
        } else if (direct > 0) {
            float level = ((float)(touchX - view.getWidth()) + this.getHorizontalLimit()) / this.getHorizontalLimit();
            scrollDistance = this.calcScrollDistance(level, this.getHorizontalScrollMaxSpeed());
        }
        return scrollDistance;
    }

    public int calcVerticalScrollDistance(View view, int touchX, int touchY) {
        int direct = this.calcScrollVerticalDirect(touchY, view.getHeight());
        int scrollDistance = 0;
        if (direct < 0) {
            float level = (this.getVerticalLimit() - (float)touchY) / this.getVerticalLimit();
            scrollDistance = -this.calcScrollDistance(level, this.getVerticalScrollMaxSpeed());
        } else if (direct > 0) {
            float level = ((float)(touchY - view.getHeight()) + this.getVerticalLimit()) / this.getVerticalLimit();
            scrollDistance = this.calcScrollDistance(level, this.getVerticalScrollMaxSpeed());
        }
        return scrollDistance;
    }

    protected int calcScrollDistance(float touchLevel, int maxSpeed) {
        touchLevel = touchLevel > 1.0f ? 1.0f : touchLevel;
        return (int)(touchLevel * (float)maxSpeed);
    }

    protected int calcScrollHorizontalDirect(int touchX, int viewWidth) {
        if ((float)touchX < this.getHorizontalLimit()) {
            return -1;
        }
        if ((float)touchX > (float)viewWidth - this.getHorizontalLimit()) {
            return 1;
        }
        return 0;
    }

    protected int calcScrollVerticalDirect(int touchY, int viewHeight) {
        if ((float)touchY < this.getVerticalLimit()) {
            return -1;
        }
        if ((float)touchY > (float)viewHeight - this.getVerticalLimit()) {
            return 1;
        }
        return 0;
    }

    public void onDrawFloatView(View floatView) {
        floatView.setScaleX(0.95f);
        floatView.setScaleY(0.95f);
        floatView.setRotation(0.9f);
        floatView.setAlpha(0.8f);
    }

    public float getMoveLimit() {
        return 0.5f;
    }
}

