/*
 * Decompiled with CFR 0.152.
 */
package com.freelib.multiitem.helper;

import android.view.View;
import java.util.ArrayList;
import java.util.List;

public class ViewScaleHelper {
    public static final int VIEW_WIDTH_KEY = -21681;
    public static final int VIEW_HEIGHT_KEY = -21682;
    private List<View> verticalViewList = new ArrayList<View>();
    private View contentView;
    private View horizontalView;
    private boolean isInScaleMode;
    private int verticalWidth;
    private float scale = 0.5f;

    public synchronized boolean isInScaleMode() {
        return this.isInScaleMode;
    }

    public float getScale() {
        return this.scale;
    }

    public void toggleScaleModel() {
        if (this.isInScaleMode) {
            this.stopScaleModel();
        } else {
            this.startScaleModel();
        }
    }

    public synchronized void startScaleModel() {
        if (this.isInScaleMode) {
            return;
        }
        this.isInScaleMode = true;
        this.scaleContentView(this.contentView);
        this.scaleContentView(this.horizontalView);
        this.horizontalView.setScaleX(this.scale);
        this.horizontalView.setScaleY(this.scale);
        this.horizontalView.setPivotX(0.0f);
        this.horizontalView.setPivotY(0.0f);
        for (View view : this.verticalViewList) {
            this.verticalWidth = view.getWidth();
            this.scaleVerticalView(view, this.verticalWidth);
            view.requestLayout();
        }
    }

    public synchronized void stopScaleModel() {
        if (!this.isInScaleMode) {
            return;
        }
        this.isInScaleMode = false;
        this.restoreView(this.contentView);
        this.restoreView(this.horizontalView);
        for (View view : this.verticalViewList) {
            this.restoreView(view);
            view.requestLayout();
        }
        this.horizontalView.setScaleX(1.0f);
        this.horizontalView.setScaleY(1.0f);
    }

    public void addVerticalView(View view) {
        this.verticalViewList.add(view);
        if (this.isInScaleMode) {
            this.scaleVerticalView(view, this.verticalWidth);
        }
    }

    private void scaleVerticalView(View view, int width) {
        this.recordViewWidth(view);
        view.getLayoutParams().width = width;
    }

    private void scaleContentView(View view) {
        this.recordViewWidth(view);
        this.recordViewHeight(view);
        view.getLayoutParams().width = (int)((float)view.getWidth() / this.scale);
        view.getLayoutParams().height = (int)((float)view.getHeight() / this.scale);
    }

    private void recordViewWidth(View view) {
        view.setTag(-21681, (Object)view.getLayoutParams().width);
    }

    private void recordViewHeight(View view) {
        view.setTag(-21682, (Object)view.getLayoutParams().height);
    }

    private void restoreView(View view) {
        Object tag = null;
        tag = view.getTag(-21681);
        if (tag != null) {
            view.getLayoutParams().width = (Integer)tag;
        }
        if ((tag = view.getTag(-21682)) != null) {
            view.getLayoutParams().height = (Integer)tag;
        }
    }

    public View getContentView() {
        return this.contentView;
    }

    public void setContentView(View contentView) {
        this.contentView = contentView;
    }

    public View getHorizontalView() {
        return this.horizontalView;
    }

    public void setHorizontalView(View horizontalView) {
        this.horizontalView = horizontalView;
    }
}

