/*
 * Decompiled with CFR 0.152.
 */
package com.freelib.multiitem.adapter;

import android.support.annotation.NonNull;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.view.View;
import android.view.ViewGroup;
import com.freelib.multiitem.adapter.holder.BaseViewHolder;
import com.freelib.multiitem.adapter.holder.HeadFootHolderManager;
import com.freelib.multiitem.adapter.holder.ViewHolderManager;
import com.freelib.multiitem.adapter.holder.ViewHolderManagerGroup;
import com.freelib.multiitem.adapter.holder.ViewHolderParams;
import com.freelib.multiitem.adapter.type.ItemTypeManager;
import com.freelib.multiitem.item.ItemUnique;
import com.freelib.multiitem.item.LoadMoreManager;
import com.freelib.multiitem.listener.OnItemClickListener;
import com.freelib.multiitem.listener.OnItemLongClickListener;
import java.util.ArrayList;
import java.util.List;

public class BaseItemAdapter
extends RecyclerView.Adapter<BaseViewHolder> {
    private List<Object> dataItems = new ArrayList<Object>();
    private List<Object> headItems = new ArrayList<Object>();
    private List<Object> footItems = new ArrayList<Object>();
    private ItemTypeManager itemTypeManager = new ItemTypeManager();
    private LoadMoreManager loadMoreManager;
    private OnItemClickListener onItemClickListener;
    private OnItemLongClickListener onItemLongClickListener;

    public <T, V extends BaseViewHolder> void register(@NonNull Class<T> cls, @NonNull ViewHolderManager<T, V> manager) {
        this.itemTypeManager.register(cls, manager);
    }

    public <T, V extends BaseViewHolder> void register(@NonNull Class<T> cls, @NonNull ViewHolderManagerGroup<T> group) {
        this.itemTypeManager.register(cls, group);
    }

    public void setOnItemClickListener(@NonNull OnItemClickListener onItemClickListener) {
        this.onItemClickListener = onItemClickListener;
    }

    public void setOnItemLongClickListener(@NonNull OnItemLongClickListener onItemLongClickListener) {
        this.onItemLongClickListener = onItemLongClickListener;
    }

    public void setDataItems(@NonNull List<Object> dataItems) {
        this.dataItems = dataItems;
        this.notifyDataSetChanged();
    }

    public void addDataItem(Object ... items) {
        this.addDataItem(this.dataItems.size(), items);
    }

    public void addDataItem(int position, Object ... items) {
        if (items != null && items.length > 0) {
            for (Object item : items) {
                this.dataItems.add(position, item);
            }
            this.notifyItemRangeInserted(position + this.getHeadCount(), items.length);
        }
    }

    public void moveDataItem(int fromPosition, int toPosition) {
        toPosition = fromPosition < toPosition ? toPosition - 1 : toPosition;
        this.dataItems.add(toPosition, this.dataItems.remove(fromPosition));
        this.notifyItemMoved(fromPosition + this.getHeadCount(), toPosition + this.getHeadCount());
    }

    public void removeDataItem(int position) {
        this.removeDataItem(position, 1);
    }

    public void removeDataItem(int position, int itemCount) {
        for (int i = 0; i < itemCount; ++i) {
            this.dataItems.remove(position);
        }
        this.notifyItemRangeRemoved(position + this.getHeadCount(), itemCount);
    }

    public void addFootView(View footView) {
        this.addFootItem(new ItemUnique(new HeadFootHolderManager(footView)));
    }

    public void addFootItem(Object footItem) {
        this.footItems.add(footItem);
    }

    public void addHeadView(View headView) {
        this.addHeadItem(new ItemUnique(new HeadFootHolderManager(headView)));
    }

    public void addHeadItem(Object headItem) {
        this.headItems.add(headItem);
    }

    public void enableLoadMore(LoadMoreManager loadMoreManager) {
        this.loadMoreManager = loadMoreManager;
        loadMoreManager.setAdapter(this);
        this.addFootItem(loadMoreManager);
    }

    public void setLoadCompleted(boolean isLoadAll) {
        if (this.loadMoreManager != null) {
            this.loadMoreManager.loadCompleted(isLoadAll);
        }
    }

    public void setLoadFailed() {
        if (this.loadMoreManager != null) {
            this.loadMoreManager.loadFailed();
        }
    }

    public List<Object> getDataList() {
        return this.dataItems;
    }

    public Object getItem(int position) {
        if (position < this.headItems.size()) {
            return this.headItems.get(position);
        }
        if ((position -= this.headItems.size()) < this.dataItems.size()) {
            return this.dataItems.get(position);
        }
        return this.footItems.get(position -= this.dataItems.size());
    }

    public void clearAllData() {
        this.dataItems.clear();
        this.headItems.clear();
        this.footItems.clear();
    }

    public void clearData() {
        this.dataItems.clear();
    }

    public BaseViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        ViewHolderManager provider = this.itemTypeManager.getViewHolderManager(viewType);
        Object viewHolder = provider.onCreateViewHolder(parent);
        ((BaseViewHolder)((Object)viewHolder)).viewHolderManager = provider;
        return viewHolder;
    }

    public void onBindViewHolder(BaseViewHolder holder, int position) {
        Object item = this.getItem(position);
        ViewHolderManager manager = holder.viewHolderManager;
        ViewHolderParams params = new ViewHolderParams().setItemCount(this.getItemCount()).setClickListener(this.onItemClickListener).setLongClickListener(this.onItemLongClickListener);
        manager.onBindViewHolder(holder, item, params);
        holder.itemView.setTag(-121, (Object)holder);
        holder.itemData = item;
    }

    public int getItemViewType(int position) {
        int type = this.itemTypeManager.getItemType(this.getItem(position));
        if (type < 0) {
            throw new RuntimeException("\u6ca1\u6709\u4e3a" + this.getItem(position).getClass() + "\u627e\u5230\u5bf9\u5e94\u7684item view provider\uff0c\u662f\u5426\u6ce8\u518c\u4e86\uff1f");
        }
        return type;
    }

    public int getItemCount() {
        return this.dataItems.size() + this.getHeadCount() + this.getFootCount();
    }

    public void onViewAttachedToWindow(BaseViewHolder holder) {
        super.onViewAttachedToWindow((RecyclerView.ViewHolder)holder);
        if (holder.getViewHolderManager().isFullSpan() && holder.itemView.getLayoutParams() instanceof StaggeredGridLayoutManager.LayoutParams) {
            StaggeredGridLayoutManager.LayoutParams params = (StaggeredGridLayoutManager.LayoutParams)holder.itemView.getLayoutParams();
            params.setFullSpan(true);
        }
    }

    public void onAttachedToRecyclerView(RecyclerView recyclerView) {
        super.onAttachedToRecyclerView(recyclerView);
        RecyclerView.LayoutManager manager = recyclerView.getLayoutManager();
        if (manager instanceof GridLayoutManager) {
            final GridLayoutManager gridManager = (GridLayoutManager)manager;
            gridManager.setSpanSizeLookup(new GridLayoutManager.SpanSizeLookup(){
                ViewHolderManager holderManager;

                public int getSpanSize(int position) {
                    this.holderManager = BaseItemAdapter.this.itemTypeManager.getViewHolderManager(BaseItemAdapter.this.getItemViewType(position));
                    return this.holderManager.getSpanSize(gridManager.getSpanCount());
                }
            });
        }
    }

    public int getHeadCount() {
        return this.headItems.size();
    }

    public int getFootCount() {
        return this.footItems.size();
    }
}

