/*
 * Decompiled with CFR 0.152.
 */
package com.freelib.multiitem.adapter;

import android.support.annotation.NonNull;
import com.freelib.multiitem.adapter.ViewHolderManager;
import java.util.ArrayList;
import java.util.List;

public class ItemTypeManager {
    protected List<String> itemClassNames = new ArrayList<String>();
    protected List<ViewHolderManager> viewHolderManagers = new ArrayList<ViewHolderManager>();

    public void register(@NonNull Class<?> cls, @NonNull ViewHolderManager provider) {
        String className = this.getClassName(cls);
        if (this.itemClassNames.contains(className)) {
            this.viewHolderManagers.set(this.itemClassNames.indexOf(className), provider);
        } else {
            this.itemClassNames.add(className);
            this.viewHolderManagers.add(provider);
        }
    }

    public int getItemType(@NonNull Class<?> cls) {
        return this.itemClassNames.indexOf(this.getClassName(cls));
    }

    public List<ViewHolderManager> getViewHolderManagers() {
        return this.viewHolderManagers;
    }

    public List<String> getItemClassNames() {
        return this.itemClassNames;
    }

    public ViewHolderManager getProvider(int type) {
        if (type < 0 || type > this.viewHolderManagers.size() - 1) {
            return null;
        }
        return this.viewHolderManagers.get(type);
    }

    public ViewHolderManager getProvider(@NonNull Class<?> cls) {
        return this.getProvider(this.getItemType(cls));
    }

    private String getClassName(Class<?> cls) {
        return cls.getName();
    }
}

