/*
 * Decompiled with CFR 0.152.
 */
package com.freelib.multiitem.adapter;

import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.view.ViewGroup;
import com.freelib.multiitem.adapter.BaseViewHolder;
import com.freelib.multiitem.adapter.ItemTypeManager;
import com.freelib.multiitem.adapter.ViewHolderManager;
import com.freelib.multiitem.listener.OnItemClickListener;
import com.freelib.multiitem.listener.OnItemLongClickListener;
import java.util.ArrayList;
import java.util.List;

public class BaseItemAdapter
extends RecyclerView.Adapter<BaseViewHolder> {
    private List<Object> dataItems = new ArrayList<Object>();
    private List<Object> headItems = new ArrayList<Object>();
    private List<Object> footItems = new ArrayList<Object>();
    private ItemTypeManager itemTypeManager = new ItemTypeManager();
    private OnItemClickListener onItemClickListener;
    private OnItemLongClickListener onItemLongClickListener;

    public <T, V extends BaseViewHolder> void register(@NonNull Class<T> cls, @NonNull ViewHolderManager<T, V> manager) {
        this.itemTypeManager.register(cls, manager);
    }

    public void setOnItemClickListener(@NonNull OnItemClickListener onItemClickListener) {
        this.onItemClickListener = onItemClickListener;
    }

    public void setOnItemLongClickListener(@NonNull OnItemLongClickListener onItemLongClickListener) {
        this.onItemLongClickListener = onItemLongClickListener;
    }

    public void setDataItems(@NonNull List<Object> dataItems) {
        this.dataItems = dataItems;
        this.notifyDataSetChanged();
    }

    public void addDataItem(Object item) {
        this.addDataItem(this.dataItems.size(), item);
    }

    public void addDataItem(int position, Object item) {
        this.dataItems.add(position, item);
        this.notifyItemRangeInserted(position, 1);
    }

    public void moveDataItem(int fromPosition, int toPosition) {
        toPosition = fromPosition < toPosition ? toPosition - 1 : toPosition;
        this.dataItems.add(toPosition, this.dataItems.remove(fromPosition));
        this.notifyItemMoved(fromPosition, toPosition);
    }

    public void removeDataItem(int position) {
        this.dataItems.remove(position);
        this.notifyItemRemoved(position);
    }

    public List<Object> getDataList() {
        return this.dataItems;
    }

    public Object getItem(int position) {
        if (position < this.headItems.size()) {
            return this.headItems.get(position);
        }
        int footPosition = position - this.getHeadCount() - this.dataItems.size();
        if (footPosition >= 0) {
            return this.footItems.get(footPosition);
        }
        return this.dataItems.get(position - this.headItems.size());
    }

    public void clearData() {
        this.dataItems.clear();
        this.headItems.clear();
        this.footItems.clear();
    }

    public BaseViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        ViewHolderManager provider = this.itemTypeManager.getProvider(viewType);
        return provider.onCreateViewHolder(parent);
    }

    public void onBindViewHolder(BaseViewHolder holder, int position) {
        Object item = this.getItem(position);
        ViewHolderManager provider = this.itemTypeManager.getProvider(item.getClass());
        ViewHolderManager.ViewHolderParams params = new ViewHolderManager.ViewHolderParams().setItemCount(this.getItemCount()).setClickListener(this.onItemClickListener).setLongClickListener(this.onItemLongClickListener);
        provider.onBindViewHolder(holder, item, params);
        holder.itemView.setTag(-121, (Object)holder);
        holder.viewHolderManager = provider;
        holder.itemData = item;
    }

    public int getItemViewType(int position) {
        int type = this.itemTypeManager.getItemType(this.getItem(position).getClass());
        if (type < 0) {
            throw new RuntimeException("\u6ca1\u6709\u4e3a" + this.getItem(position).getClass() + "\u627e\u5230\u5bf9\u5e94\u7684item view provider\uff0c\u662f\u5426\u6ce8\u518c\u4e86\uff1f");
        }
        return type;
    }

    public int getItemCount() {
        return this.dataItems.size() + this.getHeadCount() + this.getFootCount();
    }

    public int getHeadCount() {
        return this.headItems.size();
    }

    public int getFootCount() {
        return this.footItems.size();
    }
}

