/*
 * Decompiled with CFR 0.152.
 */
package com.franriadigos.view;

import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.AttrRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.StyleRes;
import com.franriadigos.view.CircularProgressContract;
import com.franriadigos.view.R;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
public class AttributesHelper {
    @NonNull
    private final CircularProgressContract mView;

    public AttributesHelper(@NonNull CircularProgressContract view) {
        this.mView = view;
    }

    public void loadFromAttributes(@Nullable AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        TypedArray a;
        block14: {
            a = ((View)this.mView).getContext().obtainStyledAttributes(attrs, R.styleable.CircularProgress, defStyleAttr, defStyleRes);
            this.mView.setMax(a.getFloat(R.styleable.CircularProgress_max, this.mView.getMax()));
            this.mView.setProgress(a.getFloat(R.styleable.CircularProgress_progress, this.mView.getProgress()));
            if (!a.hasValue(R.styleable.CircularProgress_backgroundRingSize)) {
                if (a.hasValue(R.styleable.CircularProgress_progressRingSize)) {
                    this.mView.setProgressRingSize(a.getDimension(R.styleable.CircularProgress_progressRingSize, this.mView.getProgressRingSize()));
                    this.mView.setBackgroundRingSize(this.mView.getProgressRingSize());
                }
            } else {
                this.mView.setBackgroundRingSize(a.getDimension(R.styleable.CircularProgress_backgroundRingSize, this.mView.getBackgroundRingSize()));
                this.mView.setProgressRingSize(a.getDimension(R.styleable.CircularProgress_progressRingSize, this.mView.getProgressRingSize()));
            }
            this.mView.setProgressRingOutline(a.getBoolean(R.styleable.CircularProgress_progressRingOutline, false));
            this.mView.setBackgroundRingColor(a.getColor(R.styleable.CircularProgress_backgroundRingColor, this.mView.getBackgroundRingColor()));
            this.mView.setProgressRingColor(a.getColor(R.styleable.CircularProgress_progressRingColor, -16738680));
            try {
                int[] gradient;
                if (!a.hasValue(R.styleable.CircularProgress_progressGradient)) break block14;
                int i = -1;
                try {
                    int resourceId = a.getResourceId(R.styleable.CircularProgress_progressGradient, 0);
                    if (((View)this.mView).isInEditMode()) {
                        String[] gradientRes = ((View)this.mView).getResources().getStringArray(resourceId);
                        gradient = new int[gradientRes.length];
                        i = 0;
                        for (String color : gradientRes) {
                            gradient[i] = Color.parseColor((String)color);
                            ++i;
                        }
                    } else {
                        if (!a.getResources().getResourceTypeName(resourceId).equals("array")) {
                            throw new IllegalArgumentException("Resource is not an array");
                        }
                        TypedArray ta = a.getResources().obtainTypedArray(resourceId);
                        int len = ta.length();
                        gradient = new int[len];
                        i = 0;
                        for (int c = 0; c < len; ++c) {
                            String colorString = ta.getString(c);
                            if (colorString != null) {
                                gradient[i] = Color.parseColor((String)colorString);
                                ++i;
                                continue;
                            }
                            throw new IllegalArgumentException();
                        }
                        ta.recycle();
                    }
                }
                catch (IllegalArgumentException e) {
                    if (i == -1) {
                        throw e;
                    }
                    throw new IllegalArgumentException("Unknown Color at position " + i);
                }
                this.mView.setProgressGradient(gradient);
                this.mView.setJoinGradient(a.getBoolean(R.styleable.CircularProgress_joinGradient, false));
                this.mView.setGradientFactor(a.getFloat(R.styleable.CircularProgress_gradientFactor, 1.0f));
            }
            catch (Exception e) {
                if (((View)this.mView).isInEditMode()) break block14;
                throw e;
            }
        }
        this.mView.setProgressRingCorner(a.getInt(R.styleable.CircularProgress_progressRingCorner, Paint.Cap.BUTT.ordinal()));
        a.recycle();
    }
}

