/*
 * Decompiled with CFR 0.152.
 */
package com.franmontiel.persistentcookiejar.cache;

import com.franmontiel.persistentcookiejar.cache.CookieCache;
import com.franmontiel.persistentcookiejar.cache.IdentifiableCookie;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import okhttp3.Cookie;

public class SetCookieCache
implements CookieCache {
    private Set<IdentifiableCookie> cookies = new HashSet<IdentifiableCookie>();

    @Override
    public void addAll(Collection<Cookie> newCookies) {
        this.updateCookies(IdentifiableCookie.decorateAll(newCookies));
    }

    private void updateCookies(Collection<IdentifiableCookie> cookies) {
        this.cookies.removeAll(cookies);
        this.cookies.addAll(cookies);
    }

    @Override
    public void clear() {
        this.cookies.clear();
    }

    @Override
    public Iterator<Cookie> iterator() {
        return new SetCookieCacheIterator();
    }

    private class SetCookieCacheIterator
    implements Iterator<Cookie> {
        private Iterator<IdentifiableCookie> iterator;

        public SetCookieCacheIterator() {
            this.iterator = SetCookieCache.this.cookies.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Cookie next() {
            return this.iterator.next().getCookie();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

